<%@ page language="java" contentType="text/html; charset=utf-8"
         pageEncoding="utf-8" %>
<!DOCTYPE html />
<html>
<head>
    <title>商铺资料变更</title>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-layout" config="areachangelayout"
     beforeload="beforeload" borderStyle="border:0px;"
     style="width: 100%; height: 100%;"></div>

<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
<script src="/ocp-ui-res/js/base/base.js" type="text/javascript"></script>
<script src="/mall-business-ui/pages/common/method.js" type="text/javascript"></script>
<script type="text/javascript">
    var billmoduleid = getUrlParam("billmoduleid");
    if (billmoduleid == "" || billmoduleid == null) {
        billmoduleid = getUrlParam("modulecode");
    }
    var billtype = getBilltype(billmoduleid);

    var billsylx = getUrlParam("SYLX");
    if (billsylx == "" || billsylx == null) {
        billsylx = getUrlParam("sylx");
    }

    // 字典数据初始化
    var dictData = getDict("SYSTEM_BILLSTATUS,SHOP_SPSTATUS,SHOP_SPTYPE,SHOP_MEDIA,SHOP_SPMODE,SHOP_SPCFHB,SHOP_SPSOURCE,SHOP_GGTYPE,SHOP_SYLX", "dcode,dname,pro1,ddvalue") || {};
    var SHOP_SYLX = [];
    var tempsylx = dictData.SHOP_SYLX;
    for (var i = 0; i < tempsylx.length; i++) {
        if (tempsylx[i].code == '02' || tempsylx[i].code == '03') {
            SHOP_SYLX.push(tempsylx[i]);
        }
    }
    var SPGGTYPE = [{code: "S", name: "商铺"}, {code: "G", name: "广告位"}, {code: "X", name: "写字楼"}];
    app.repaint.init("bshopinfochange.jsp", "bshopchgdet,bshopchghead", billmoduleid, null);
</script>
<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
<script type="text/javascript">
    dictData.SPFLAG = [{code: "Y", name: "有效"}, {code: "N", name: "无效"}];
    var SHOP_SPTYPE = [];
    var SPTYPE2 = [];
    if (dictData.SHOP_SPTYPE) {
        var sptypedata = dictData.SHOP_SPTYPE;
        for (var i = 0; i < sptypedata.length; i++) {
            if (sptypedata[i].pro1 == "Y") {
                SHOP_SPTYPE.push(sptypedata[i]);
            } else {
                SPTYPE2.push(sptypedata[i]);
            }
        }
    }

    // 页面布局配置
    var toolbar1 = {
        rule: { // 按钮可用规则 Y:已审核, N:录入, C:已取消
            'billstatus': {
                'Y': ['addData', 'cancelData', 'searchData', 'printData'],
                'N': ['addData', 'editData', 'auditData', 'delData', 'searchData', 'printData', 'submitData'],
                'C': ['addData', 'searchData', 'printData'],
                'A': ['showPic', 'revokeData', 'approveData'],
                'S': ['showPic'],
                'R': ['showPic']
            }
        },
        status: { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
            'N': ['addData', 'saveData', 'searchData'],
            'V': ['addData', 'editData', 'auditData', 'delData', 'searchData'],
            'E': ['addData', 'saveData', 'delData', 'searchData', 'printData'],
            'S': ['addData', 'editData', 'auditData', 'delData', 'searchData', 'printData'],
            'A': ['addData', 'cancelData', 'searchData', 'printData'],
            'C': ['addData', 'searchData', 'printData'],
            'D': ['addData', 'searchData'],
        },
        items: [[{
            'text': '新增',
            'iconCls': 'icon-add',
            'name': 'addData'
        }, {
            'text': '修改',
            'iconCls': 'icon-edit',
            'name': 'editData'
        }, {
            'text': '保存',
            'iconCls': 'icon-save',
            'name': 'saveData'
        }], [{
            'text': '审核',
            'iconCls': 'icon-ok',
            'name': 'auditData'
        },], [{
            'text': '删除',
            'iconCls': 'icon-remove',
            'name': 'delData'
        }, {
            'text': '查询',
            'iconCls': 'icon-search',
            'name': 'searchData'
        }], [{
            'text': '打印',
            'iconCls': 'icon-print',
            'name': 'printData'
        }]]
    };

    var initlist = null
    if (billtype == '10') {
        initlist = [{field: "spid", enabledSearch: false}, {field: "bshopchgdet:spid", enabledSearch: true}]
        if ((billsylx != "" && billsylx != null)) {
            initlist = [{field: "spid", enabledSearch: false}, {field: "bshopchgdet:spid", enabledSearch: true},
                {field: "memo", visible: true, width: "250"}]
        }
    }
    var listItems = Future.Table.List.getConfig("bshopchghead2", initlist);
    listItems = app.repaint.initList("bshopchghead2", listItems);
    app.repaint.initDict(listItems, dictData);
    //单据列表
    if (billsylx != "" && billsylx != null) {
        var areachangeheadList = {
            "type": "gridbox",
            "resources": OmdUrl.mss,
            "method": "mall.work.bshopchg.search",
            "response": "bshopchghead",
            "bindform": "layouttabs", // 绑定切换的TabsBox.name
            "bindSearchParam": ["ph_key"], // 明细页面查询条件字段
            "searchParam": {
                "billtype": billtype,
                "sylx": billsylx,
                "order_field": "billno",
                "order_direction": "desc",
            },
            "properties": {
                "id": "areachangehead",
                "columns": listItems,
            },
        };
    } else {
        var areachangeheadList = {
            "type": "gridbox",
            "resources": OmdUrl.mss,
            "method": "mall.work.bshopchg.search",
            "response": "bshopchghead",
            "bindform": "layouttabs", // 绑定切换的TabsBox.name
            "bindSearchParam": ["ph_key"], // 明细页面查询条件字段
            "searchParam": {
                "billtype": billtype,
                "order_field": "billno",
                "order_direction": "desc",
            },
            "properties": {
                "id": "areachangehead",
                "columns": listItems,
            },
        };
    }

    var initmainhead = null;
    if (billtype == '10' && (billsylx != "" && billsylx != null)) {
        initmainhead = [{name: "sylx", defaultValue: billsylx, readOnly: true, enabled: false},
            {name: "spggtype", visible: false, required: true, defaultValue: "S"},
            {name: "oik", visible: false}]
    }
    var bshopchgheadItems = Future.Table.Head.getConfig("bshopchghead2", initmainhead);
    ;
    bshopchgheadItems = app.repaint.initHead("bshopchghead2", bshopchgheadItems);
    app.repaint.initDict(bshopchgheadItems, dictData);

    //单据头
    var areachangeheader = {
        "type": "formgrid",
        "properties": {
            "id": "areachangeheader",
        },
        items: bshopchgheadItems
    };

    //------------------以下为单据明细的tab页面----------------------
    var bshopchgdetitems = Future.Table.Detail.getConfig("bshopchgdet2", null);
    bshopchgdetitems = app.repaint.initDetail("bshopchgdet2", bshopchgdetitems);
    app.repaint.initDict(bshopchgdetitems, dictData);
    if (billtype == "15" || billtype == "42") {
        if (bshopchgdetitems.length > 2) {
            bshopchgdetitems[1] = {
                field: "spid",
                name: "spid",
                headerAlign: "center",
                header: billtype === '14' ? "广告位编码" : (billtype === '17' ? "广告位编码" : (billtype === '42' ? "广告位编码" : "商铺编码")),
                width: 120,
                required: true,
                visible: true,
            };
        }
    }
    //条件grid
    var bshopchgdet = {
        "type": "gridbox",
        "properties": {
            "id": "bshopchgdet",
            "multiSelect": true,
            "allowCellEdit": true,
            "allowCellSelect": true,
            "editNextOnEnterKey": true,
            "editNextRowCell": true,
            "allowSortColumn": false,
            "showColumnsMenu": true,
            "showSummaryRow": true,
            "oncellbeginedit": "OcmControl.checkboxEditor",
            "columns": bshopchgdetitems
        }
    };

    //单据明细
    var detailtabs = {
        properties: {
            id: "detailtabs",
        },
        items: [{
            "title": "商铺明细",
            "name": "bshopchgdet",
            "control": bshopchgdet
        }]
    };

    //单据明细组成：单据头+单据明细tab
    var formdetail = {
        "type": "formgrid",
        "initHeight": billtype === '14' ? 0.3 : (billtype === '13' ? 0.3 : 0.5),
        "resources": OmdUrl.mss,
        "method": "mall.work.bshopchg.get",
        "response": "bshopchghead",
        "properties": {
            "id": "formdetail",
        },
        "items": areachangeheader.items,  //绑定到具体的项
        "tabs": detailtabs,  //直接绑定tab

    };

    //单据列表和单据明细
    var layouttabs = {
        properties: {
            "id": "layouttabs"
        },
        items: [{
            "title": "单据列表",
            "name": "ListGrid",
            "control": areachangeheadList,
        }, {
            "title": "单据明细",
            "name": "formDetail",
            "control": formdetail,
        }]
    };

    var areachangelayout = {
        "properties": {
            "id": "areachangelayout",
        },
        "toolbar": toolbar1,
        "tabs": layouttabs,

    };
</script>
<script src="bshopinfochange.js" type="text/javascript"></script>
</body>
</html>