/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	   
	// 活动命名空间
	var ns = Future.ns('shopindex.view');

	// 定义一个对象用来配置界面
	var bill = {};

	// 把定义对象放到命名空间下
	ns.bill = bill;
//	ns.Shopindex = Shopindex;

	// 查询列表
	bill.billlist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		name:"shopindex",
		"method": "mss.work.shopindex.search",
		"response": "shopindex",
		"searchParam": {
			"order_field": "spid",
			"order_direction": "asc",
		},
		"properties": {
			"id": utils.createid('shopindex'),
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				readOnly : true,
				width: 50,
			}, {
				field: "ph_key",
				type: "TextBox",
				headerAlign: "center",
				header: "ph_key",
				readOnly : true,
				visible : false,
				width: 80,
			},{
				field : "muid",
				name : "muid",
				header : "门店",  
				displayField : "muid_name",
				editor : OcmControl.newControl('fut_popselectgrid'),
				editorSet: {
					selectkey:"muid",
					textName :"mucname",
					}, 	
				cdEdtCfg : {
					compnentType : 'fut_popselect',selectkey : "muid",
				},
				headerAlign : "center",
				width : 110,
				enabledSearch : true,
			},{
				field: "muid_name",
				name : "muid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "门店名称",
				enabledSearch : false,
				visible:false,
			}, {
				field: "sbid",
				displayField : "sbid_name",
				headerAlign: "center",
				header: "商户",
				enabledSearch : true,
				editor:OcmControl.newControl('fut_popselect'),
				editorSet: {
					selectkey:"sbid",
					}, 
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"sbid"},
				required : true,
				width: 80,
			}, {
				field: "sbid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "商户名称",
				readOnly : true,
				visible : false,
				width: 80,
			}, {
				field: "spid",
				displayField : "spid_name",
				headerAlign: "center",
				header: "商铺",
				enabledSearch : true,
				editor:OcmControl.newControl('fut_popselect'),
				editorSet: {
					selectkey:"spid",
					}, 
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"spid"},
				required : true,
				width: 150,
			}, {
				field: "spid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "商铺名称",
				readOnly : true,
				visible : false,
				width: 80,
			},{
				field: "syearmonth",
				headerAlign: "center",
				header: "年月",
				editor : OcmControl.newControl('MonthPicker'),
				dataType : "date",
				dateFormat : "yyyy-MM",
				readOnly : false,
				visible : true,
				enabledSearch : false,
			}, {
				field: "sindex",
				type: "TextBox",
				headerAlign: "center",
				header: "指标",
				readOnly : false,
				visible : true,
				enabledSearch : false,
				numberFormat : "#,0.00",
				defaultValue:"0.00",
			},{
				field: "sreward_index",
				type: "TextBox",
				headerAlign: "center",
				header: "奖励指标",
				readOnly : false,
				visible : true,
				enabledSearch : false,
				numberFormat : "#,0.00",
				defaultValue:"0.00",
			}]
		}
	};
    var  toolsbaritems = $.extend(true, [], Future.pub.BaseSingleGrid.default_toolsbar);
    

    //添加导入功能
    var item = {
    		'text': '导入','iconCls': 'icon-download','name': 'import',ibediting: 'N',tabindex: '1',status: 'E'
	};
    
    toolsbaritems.push(item);
//    
//    var item1 = {
//    		'text': '上传导入模版','iconCls': 'icon-upload','name': 'upTemplate',ibediting: 'N',tabindex: '1',status: 'E'
//	};
//    
//    var item2 = {
//    		'text': '下载导入模版','iconCls': 'icon-download','name': 'downTemplate',ibediting: 'N',tabindex: '1',status: 'E'
//	};
//    
//    toolsbaritems.push(item1);
//    
//    toolsbaritems.push(item2);
//    
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items:toolsbaritems
	};

	// 单据配置
	bill.billconfig = {
		control: bill.billlist, // 单据主表
	};
	
	// 创建标准单据配置
	utils.create_standardgrid_config(bill);

})()
