/**
 * 商铺管理--公用方法
 */
(function () {
    // 要引用的包
    var utils = Future.ns('Future.utils');
    // 商铺修改命名空间
    var ns = Future.ns('shop.pub');
    ns.checkspexist = function (spid, muid) {
        var searchParam = {
            spid: spid
        };
        var isexist = false;
        var method = "mall.work.shop.search";
        itemLoader.doRequest(OmdUrl.mall, method, searchParam, null, null,
            function (data) {
                var data = data.shoplist;
                if (data.length > 0) {
                    mini.alert("商铺[" + spid + "]编号已存在!");
                    isexist = true
                }
            }, null, null, false);
        return isexist;

    }
    /**
     * 计算公摊率
     */
    ns.calcpoolrate = function (buildarea, lettarea) {
        if (!buildarea || !lettarea) {
            return {
                value: 0,
                text: 0
            }
        }
        var a = (buildarea / lettarea - 1).toFixed(4);

        var num = 0;
        var poolrate = (a * 100 + '%');
        if (poolrate == "Infinity%") {
            poolrate = (num.toFixed(0) + '%');
        }
        return {
            value: a,
            text: poolrate
        }
    }

    /**
     * 计算公摊率
     * 公摊率＝（建筑面积-套内面积）/建筑面积
     */

    ns.calcpoolrate1 = function (buildarea, lettarea) {
        var num = 0;
        if (!buildarea || !lettarea) {
            return {
                value: 0,
                text: 0
            }
        }

        var a = ((buildarea - lettarea) / buildarea).toFixed(4);
        if (a == "Infinity" || a == "NaN") {
            a = (num.toFixed(4));
        }

        var poolrate = (a * 100 + '%');
        if (poolrate == "Infinity%") {
            poolrate = (num.toFixed(4) + '%');
        }
        return {
            value: a,
            text: poolrate
        };
    };
    /**
     * 计算公摊系数
     * 公摊系数＝（建筑面积-套内面积）/套内面积
     */
    ns.calcpoolrate2 = function (buildarea, lettarea) {
        var num = 0;
        if (!buildarea || !lettarea) {
            return {
                value: 0,
                text: 0
            }
        }
        var a = ((buildarea - lettarea) / lettarea).toFixed(4);
        if (a == "Infinity" || a == "NaN") {
            a = (num.toFixed(4));
        }

        var poolrate = (a * 100 + '%');
        if (poolrate == "Infinity%") {
            poolrate = (num.toFixed(4) + '%');
        }
        return {
            value: a,
            text: poolrate
        };
    };
})();
