<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>商品退厂单</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">

	<div class="ocm-layout" config="config1" borderStyle="border:0px;"style="width: 100%; height: 100%;"></div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"type="text/javascript"></script>
	<script src="/ocp-ui-res/js/base/doattachmentdual.js"type="text/javascript"></script>
	<script src="/ocp-ui-res/js/base/base.js" type="text/javascript"></script>
	<script type="text/javascript">
		var dictData = OcmControl.getDict("BILLMODULEID,BILLSTATUS,CD,STOCKMD,WMID,JXTAXRATE",
				"code,name")
				|| {};
		var billmoduleid = getUrlParam("billmoduleid");
		if (billmoduleid == "" || billmoduleid == null) {
			billmoduleid = getUrlParam("modulecode");
		}
		
		var billno =getUrlParam("billno");
		var wph_key = getUrlParam("ph_key"); //通过[M10602]按订单号直接收货打开入库单时会传入库单的ph_key

		//结算依据，默认2
		var bihsupjsyj = [ {
			code : '1',
			name : '按单结'
		}, {
			code : '2',
			name : '按销售'
		} ];

		var sample = [ {
			code : 'N',
			name : '否'
		}, {
			code : 'Y',
			name : '是'
		} ];
		
		var backtype = [{
			code : '1',
			name : '指定批次',
		},{
			code : '2',
			name : '不指定批次,指定进价',
		},{
			code : '3',
			name : '不指定批次,按批次进价',
		}]

		/* var WMID = [ {
			code : '1',
			name : '经销',
		}, {
			code : '2',
			name : '成本代销',
		}, {
			code : '3',
			name : '扣率代销',
		}] */

		var billtype = getBilltype(billmoduleid);

		// 页面布局配置

		var toolbar1 = {
			rule : { // 按钮可用规则 Y:已审核, N:录入, C:已取消 ,S:提交
				'billstatus' : {
					'Y' : [ 'addData', 'searchData', 'printData', 'cancelData',
							'upTemplate', 'downTemplate' ],
					'N' : [ 'addData', 'editData', 'auditData', 'delData',
							'copyData', 'searchData', 'firstData',
							'billImport', 'recallData', 'upTemplate',
							'downTemplate' ],
					'C' : [ 'addData', 'copyData', 'searchData', 'upTemplate',
							'downTemplate', 'delData' ],
					'S' : [ 'addData', 'searchData', 'firstData', 'fallData',
							'upTemplate', 'downTemplate' ],
					'Q' : [ 'addData', 'searchData', 'upTemplate',
							'downTemplate' ],
					'D' : [ 'addData', 'searchData', 'upTemplate',
							'downTemplate' ],
					'A' : [ 'addData', 'searchData', 'recallData', 'auditData',
							'upTemplate', 'downTemplate' ],
				}
			},
			status : { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
				'N' : [ 'addData', 'saveData', 'searchData', ],
				'V' : [ 'addData', 'editData', 'auditData', 'delData','searchData' ],
				'E' : [ 'addData', 'saveData', 'delData','searchData' ],
				'S' : [ 'addData', 'editData', 'auditData', 'delData', 'searchData' ],
				'A' : [ 'addData', 'searchData' ],
				'C' : [ 'addData', 'searchData' ],
				'D' : [ 'addData', 'searchData'],
			},
			items : [ [ {
				'text' : '新增',
				'iconCls' : 'icon-add',
				'name' : 'addData'
			}, {
				'text' : '修改',
				'iconCls' : 'icon-edit',
				'name' : 'editData'
			}, {
				'text' : '保存',
				'iconCls' : 'icon-save',
				'name' : 'saveData'
			} ], [ {
				'text' : '审核',
				'iconCls' : 'icon-ok',
				'name' : 'auditData'
			}], [ {
				'text' : '删除',
				'iconCls' : 'icon-remove',
				'name' : 'delData'
			}, {
				'text' : '查询',
				'iconCls' : 'icon-search',
				'name' : 'searchData'
			} ] ,/* [ {
				'text' : '下载导入模版',
				'iconCls' : 'icon-download',
				'name' : 'downTemplate'
			}, {
				'text' : '导入',
				'iconCls' : 'icon-upload',
				'name' : 'billImport',
				'onclick' : 'OnImportClick'
			} ] */]
		};

		//单据列表
		var gridbox2 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.base.goodsinstock.search",
			"response" : "binstrhead",
			"bindform" : "tabs1", // 绑定切换的TabsBox.name
			"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段 
			"searchParam" : {
				/* "billmoduleid" : billmoduleid, */
				"billtype" : billtype,
				"order_field" : "billno",
				"order_direction" : "desc",
			},
			"properties" : {
				"id" : "goodsinstock",
				"columns" : [ {
					type : "indexcolumn",
					headerAlign : "center",
					header : "行号",
					width : 80,
				}, {
					field : "billno",
					headerAlign : "center",
					header : "单据编号",
					allowSort : true,
					width : 150,
				},{
					field : "billsgno",
					headerAlign : "center",
					header : "手工单号",
					allowSort : true,
					width : 150,
				}, {
					field : "billstatus",
					headerAlign : "center",
					header : "单据状态",
					width : 100,
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : dictData.BILLSTATUS,
				}, {
					field : "supid",
					type : "TextBox",
					headerAlign : "center",
					width : 200,
					header : "供应商",
					editor : OcmControl.newControl('fut_popselect'),
					displayField : "sup_name",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "supid"
					},
					enabledSearch : true,
				},{
					field : "contno",
					headerAlign : "center",
					header : "合同号",
					allowSort : true,
					width : 140,
				},{
					field : "wmid",
					headerAlign : "center",
					header : "经营方式",
					type : "comboboxcolumn",
					textField : "name",
		        	valueField : "code",
					data : dictData.WMID,
					renderer : "OcmControl.dictRendererWithCode",
					width : 100,
				}, {
					field : "dhmfid",
					type : "TextBox",
					headerAlign : "center",
					width : 150,
					header : "采购部",
					editor : OcmControl.newControl('fut_popselect'),
					displayField : "dhmfid_name",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "treeManaorgno"
					},
					enabledSearch : true,
				}, {
					field : "shmkt",
					type : "TextBox",
					headerAlign : "center",
					width : 200,
					header : "收货门店",
					editor : OcmControl.newControl('fut_popselect'),
					displayField : "shmkt_name",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "muid"
					},
					enabledSearch : true,
				}, {
					field : "shmfid",
					type : "TextBox",
					headerAlign : "center",
					width : 240,
					header : "收货柜组",
					editor : OcmControl.newControl('fut_popselect'),
					displayField : "shmfid_name",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "shmfid_name"
					},
					enabledSearch : true,
				}, {
					field : "md",
					headerAlign : "center",
					header : "子库存",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					data : dictData.STOCKMD,
					width : 100,
				},{
					field : "ybillno",
					headerAlign : "center",
					header : "原入库单号",
					allowSort : true,
					width : 150,
					/* readOnly : true, */
				},{
					field : "memo",
					type : "TextBox",
					headerAlign : "center",
					header : "备注",
					width : "180",
				}, {
					field : "inputer_name",
					header : "录入人",
					headerAlign : "center",
					readOnly : true,
					enabledSearch : false,
					width : 110,
				}, {
					field : "inputdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd HH:mm:ss",
					header : "录入日期",
					width : 140,
					headerAlign : "center",
				}, {
					field : "auditor",
					header : "审核人",
					width : 100,
					headerAlign : "center",
					enabledSearch : true,
					visible : false,
				}, {
					field : "auditor_name",
					header : "审核人",
					width : 110,
					headerAlign : "center",
					enabledSearch : false,
				}, {
					field : "auditdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd HH:mm:ss",
					header : "审核日期",
					headerAlign : "center",
					width : 140,
				},{
					field : "backtype",
					type : "comboboxcolumn",
					headerAlign : "center",
					header : "退厂方式",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					data : backtype,
					width : 180,
					visible : false,
				},],
			},
		};

		//单据头
		var formheader1 = {
			"type" : "formgrid",
			/* "resources" : OmdUrl.mss,
			"method" : "mss.work.goodsinstock.search",
			"response" : "goodsinstock",
			"properties" : {
				"id" : "goodsinstock",
			}, */
			items : [ {
				"label" : "ph_key：",
				"type" : "TextBox",
				"name" : "ph_key",
				"readOnly" : "true",
				"visible" : false,
			}, {
				"label" : "单据编号：",
				"id" : "billno",
				"name" : "billno",
				"type" : "TextBox",
				"readOnly" : true,
			},{
				"label" : "手工单号：",
				"name" : "billsgno",
				"type" : "TextBox",
				"readOnly" : false,
			}, {
				"label" : "单据类型：",
				"name" : "billmoduleid",
				"type" : "ComboBox",
				"data" : dictData.BILLMODULEID,
				"defaultValue" : billmoduleid,
				"readOnly" : true,
				visible : false,
			}, {
				"label" : "单据状态：",
				"name" : "billstatus",
				"type" : "ComboBox",
				"data" : dictData.BILLSTATUS,
				"defaultValue" : "N",
				"readOnly" : true,
				"style" : "display:block;float:none"
			}, {
				"label" : "单据类型：",
				"name" : "billtype",
				"type" : "TextBox",
				"defaultValue" : billtype,
				"visible" : false,
			},{
				"label" : "供应商：",
				"name" : "supid",
				"type" : "ButtonEdit",
				/* "enabled" : true, */
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "selfsbid2",//弹框类型 
				//textName : "sbname", //文本显示字段
				textName : "sup_name",
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged",
				"required" : true,
				"style" : "width:30%",
			},{
				"label" : "合同号：",
				"name" : "contno",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey : "supcontno",//弹框类型
				textName : "contno", //文本显示字段 
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged",
				"required" : true,
				"style" : "width:30%",
			},{
				"label" : "供应商名：",
				"name" : "sup_name",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : false
			},{
				"label" : "经营方式：",
				"name" : "wmid",
				"type" : "ComboBox",
				"data" : dictData.WMID,
				"valueField" : "code",
				"textField" : "name",
				"required" : true,
				/* "onvaluechanged" : "head_valuechanged", */
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged",
				"renderer" : "OcmControl.dictRendererWithCode",
				"readOnly" : true,
			},  {
				"label" : "采购部：",
				"name" : "dhmfid",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "buyManaorgno",//弹框类型
				textName : "dhmfid_name", //文本显示字段
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged",
				/* "enabled" : true, */
				required : true,			
			}, {
				"label" : "采购部门名：",
				"name" : "dhmfid_name",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : false
			}, {
				"label" : "结算依据：",
				"name" : "bihsupjsyj",
				"type" : "ComboBox",
				"data" : bihsupjsyj,
				"valueField" : "code",
				"textField" : "name",
				"defaultValue" : "1",
				"readOnly" : true,
				"visible" : false
			},{
				"label" : "结算依据：",
				"name" : "supjsyj",
				"type" : "ComboBox",
				"data" : bihsupjsyj,
				"valueField" : "code",
				"textField" : "name",
				"defaultValue" : "1",
				"readOnly" : true,
				"visible" : false
			}, {
				"label" : "结算依据：",
				"name" : "intjsyj",
				"type" : "ComboBox",
				"data" : bihsupjsyj,
				"valueField" : "code",
				"textField" : "name",
				"defaultValue" : "1",
				"readOnly" : true,
				"visible" : false
			},{
				"label" : "收货门店：",
				"name" : "shmkt",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "muid",//弹框类型
				textName : "shmkt_name", //文本显示字段
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged",
				/* "enabled" : true, */
				required : true,
				/* "readOnly" : true, */
			}, {
				"label" : "收货门店名：",
				"name" : "shmkt_name",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : false
			}, {
				"label" : "收货柜组：",
				"name" : "shmfid",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "selfspid",//弹框类型
				textName : "shmfid_name", //文本显示字段
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged",
				/* "enabled" : true, */
				required : true,
			}, {
				"label" : "子库存：",
				"type" : "ComboBox",
				"name" : "md",
				/* "enabled" : true, */
				"data" : dictData.STOCKMD,
				beforefunc : "head_beforefunc",
				"onvaluechanged" : "head_ComboBox_changed",
				"showNullItem" : true,
				required : true,
				"defaultValue" : "1",
			},{
				"label" : "原入库单号：",
				"id" : "ybillno",
				"name" : "ybillno",
				"type" : "TextBox",
				/* itemchangedfunc : "head_itemchanged", */
				"onvaluechanged" : "head_ybillno_changed",
				/* readOnly : true, */
			},{
				"label" : "退厂方式：",
				"type" : "ComboBox",
				"name" : "backtype",
				/* "enabled" : true, */
				"data" : backtype,
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged",
				"showNullItem" : false,
				"defaultValue" : "3",
				"onvaluechanged" : "head_ComboBox_changed",
			},{
				"label" : "备注：",
				"name" : "memo",
				"type" : "TextBox",
				"style" : "display:block;float:none;width:90%",
				"onvaluechanged" : "onMemoChanged",
			}, {
				"label" : "录入人：",
				"name" : "inputer_name",
				"type" : "TextBox",
				"readOnly" : true,
			}, {
				"label" : "录入人",
				"name" : "inputer",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : false,
			}, {
				"label" : "审核人：",
				"name" : "auditor_name",
				"type" : "TextBox",
				"readOnly" : true,
				"style" : "display:block;float:none;",
			}, {
				"label" : "录入日期：",
				"name" : "inputdate",
				"type" : "DatePicker",
				"readOnly" : true,
				"format" : "yyyy-MM-dd HH:mm:ss",
			}, {
				"label" : "审核日期：",
				"name" : "auditdate",
				"type" : "DatePicker",
				"readOnly" : true,
				"format" : "yyyy-MM-dd HH:mm:ss",
			},{
				"label" : "数据来源",
				"name" : "source",
				"type" : "TextBox",
				"defaultValue" : "2",//1:自动生成,2:手工录入
				"readOnly" : true,
				"visible" : false,
			}, ]
		};

		//条件grid
		var binstrdetail = {
			"type" : "gridbox",
			"properties" : {
				"id" : "v_binstrdetail",
				"multiSelect" : true,
				"allowCellEdit" : true,
				"allowCellSelect" : true,
				"editNextOnEnterKey" : true,
				"editNextRowCell" : true,
				"allowSortColumn" : false,
				"showColumnsMenu" : true,
				"showSummaryRow" : true,
				"oncellbeginedit" : "OcmControl.checkboxEditor",
				"oncellendedit" : 'OcmControl.datetimeFormate',
				"ondrawsummarycell" : onDrawSummaryCell,
				"columns" : [ {
					type : "checkcolumn",
					headerAlign : "center",
					readOnly : true,
					width : 30,
				}, {
					type : "indexcolumn",
					field : "rowno",
					header : "行号",
					headerAlign : "center",
					readOnly: true,
				}, {
					field : "gdid",
					name : "gdid",
					header : "商品编码",
					width : 130,
					headerAlign : "center",
					allowSort : true,
					/* required : true, */
					editor : OcmControl.newControl('fut_popselectgrid'),
					displayField : "gdid",
					editorSet: {
	                    selectkey: 'selfoutstock',
	                    /*textName :"barcode",*/
	                    beforefunc:"det_beforefunc_gdid",
						itemchangedfunc:"det_itemchanged_gdid"
	                },
	                cdEdtCfg:{compnentType:'fut_popselect',selectkey:"selfoutstock"},
					readOnly: true,
				}, {
					field: "barcode",
					name: "barcode",
					header: "商品条码",
					headerAlign: "center",
					allowSort: true,
					required: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
					displayField: "barcode",
					width: "200",
					editorSet: {
						/*selectkey: 'selfsupgoods2',*/
							selectkey: 'selfoutstock',
                            /*textName :"barcode",*/
						beforefunc:"det_beforefunc_gdid",
						itemchangedfunc:"det_itemchanged_gdid"
					},
					/*cdEdtCfg:{compnentType:'fut_popselect',selectkey:"selfsupgoods2"},*/
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"selfoutstock"},
            }, {
                field : "name",
                header : "商品名称",
                headerAlign : "center",
                align : "left",
                readOnly : true,
                width : 200,
            }, {
                field : "gbspcm",
                header : "尺码",
                width : 130,
                headerAlign : "center",
                readOnly : true,
                align : "left",
                visible : false,
            }, {
                field : "gbspcm_name",
                header : "尺码",
                width : 130,
                headerAlign : "center",
                readOnly : true,
                align : "left",
            }, {
                field : "gbsphs",
                header : "花色",
                width : 130,
                headerAlign : "center",
                readOnly : true,
                align : "left",
                visible : false,
            }, {
                field : "gbsphs_name",
                header : "花色",
                width : 130,
                headerAlign : "center",
                readOnly : true,
                align : "left",
            },{
                field : "sample",
                header : "是否样品",
                headerAlign : "center",
                type : "comboboxcolumn",
                valueField : "code",
                textField : "name",
                editor : OcmControl.newControl('ComboBox'),
                renderer : "OcmControl.dictRendererWithCode",
                data : sample,
                required : true,
                defaultValue : "N",
            }, {
                field : "spec",
                header : "规格",
                headerAlign : "center",
                align : "left",
                readOnly : true,
            }, {
                field : "unit",
                header : "单位",
                align : "left",
                editor: OcmControl.newControl('fut_popselectgrid'),
                editorSet : {
                    selectkey : "units",
                    multiSelect: false,
                    beforefunc : "det_beforefunc_units",
                    itemchangedfunc:"det_itemchanged_units",
                },
                cdEdtCfg:{compnentType:'fut_popselect',selectkey:"units"},
                /* readOnly : true, */
				},{
					field : "hl",
					header : "含量",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "n0",
					defaultValue : "1",
					align : "right",
					readOnly : true,
				}, {
					field : "ssjs",
					header : "交货件数",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n4",
					},
					numberFormat : "n4",
					defaultValue : "1",
					align : "right",
					required : true,
				}, {
					field : "sssl",
					header : "交货数量",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n4",
					},
					numberFormat : "n4",
					defaultValue : "1",
					align : "right",
					readOnly : true,
				},{
					field : "dqkcsl",
					header : "当前库存数量",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n4",
					},
					numberFormat : "n4",
					defaultValue : "1",
					align : "right",
					readOnly : true,
				}, {
					field : "batchseq",
					displayField : "batchseq",
					header : "批次",
					headerAlign : "center",
					width : 90,
					editor : OcmControl.newControl('fut_popselectgrid'),
					editorSet: {
						selectkey:"selfbatch2",
				        multiSelect: false,
						beforefunc : "det_beforefunc_batch",
						itemchangedfunc:"det_itemchanged_batch",
					}, 
				},{
					field : "jxtax",
					header : "进项税率",
					headerAlign : "center",				    
				    /* align : "right", */
				    type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					editorSet:{
						showNullItem:false,
					},
					renderer : "OcmControl.dictRendererWithCode",
					data : dictData.JXTAXRATE,
					/* allowSort: true, */
					width : 100,
					readOnly : true,
				}, {
					field : "hsjj",
					header : "含税进价",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : false,
				}, {
					field : "bhsjj",
					header : "不含税进价",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c4",
					},
					numberFormat : "c4",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "hsjjje",
					header : "含税进价金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "bhsjjje",
					header : "不含税进价金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c4",
					},
					numberFormat : "c4",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "se",
					header : "税额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c4",
					},
					numberFormat : "c4",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "sj",
					header : "售价",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "sjje",
					header : "售价金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "iszp",
					header : "是否赠品",
					headerAlign : "center",
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : sample,
					defaultValue : "N",
					visible : false,
				},{
					field : "cshh",
					header : "厂商货号",
					headerAlign : "center",
					align : "left",
					readOnly : true,
				},  {
					field : "catcode",
					header : "商品类别",
					headerAlign : "center",
					readOnly : true,
					align : "left",
					visible : false,
				}, {
					field : "catname",
					header : "商品类别",
					width : 130,
					headerAlign : "center",
					readOnly : true,
					align : "left",
				}, {
					field : "ppcode",
					header : "品牌",
					headerAlign : "center",
					readOnly : true,
					visible : false,
				}, {
					field : "ppname",
					header : "品牌",
					width : 130,
					readOnly : true,
					align : "left",
				},{
					field: "cdcode",
					name: "gbcdcode",
					header: "产地",
					headerAlign: "center",
					editor: OcmControl.newControl('fut_popselectgrid'),
	                displayField: "gbcdcode_name",
	                width: 200,
	                editorSet: {
	                    selectkey: 'coderegion',
	                    /* allowInput: false, */
	                    beforefunc:"det_beforefunc_cdcode",
	                },
	                cdEdtCfg:{compnentType:'fut_popselect',selectkey:"coderegion",},
	                /* readOnly : true, */
				},{
					field : "sshsjjje",
					header : "实收含税进价金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
					visible : false,
				}, {
					field : "ssbhsjjje",
					header : "实收不含税进价金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c4",
					},
					numberFormat : "c4",
					defaultValue : "0",
					align : "right",
					readOnly : true,
					visible : false,
				},{
					field : "gbcdcode_name",
					header : "产地",
					align : "left",
					visible : false,
				},{
					field : "manamode",
					header : "管理方法",
					align : "left",
					visible : false,
				},{
					field : "flag",
					align : "left",
					visible : false,
				},]
			}
		};

		var binstrdetailzp = {
			"type" : "gridbox",
			"properties" : {
				"id" : "v_binstrdetailzp",
				"multiSelect" : true,
				"allowCellEdit" : true,
				"allowCellSelect" : true,
				"editNextOnEnterKey" : true,
				"editNextRowCell" : true,
				"allowSortColumn" : false,
				"showColumnsMenu" : true,
				"showSummaryRow" : true,
				"oncellbeginedit" : "OcmControl.checkboxEditor",
				"oncellendedit" : 'OcmControl.datetimeFormate',
				"ondrawsummarycell" : onDrawSummaryCellZp,
				"columns" : [ {
					type : "checkcolumn",
					headerAlign : "center",
					readOnly : true,
					width : 30,
				}, {
					type : "indexcolumn",
					field : "rowno",
					header : "行号",
					headerAlign : "center",
					readOnly: true,
				}, {
					field : "gdid",
					name : "gdid",
					header : "赠品商品编码",
					headerAlign : "center",
					allowSort : true,
					/* required : true, */
					editor : OcmControl.newControl('fut_popselectgrid'),
					displayField : "gdid",
					width : "150",
	                editorSet: {
	                    // selectkey: 'selfsupgoods2',
                        selectkey: 'selfoutstock',
	                    /*textName :"barcode",*/
	                    beforefunc:"det_beforefunc_gdidzp",
						itemchangedfunc:"det_itemchanged_gdidzp"
	                },
	                cdEdtCfg:{compnentType:'fut_popselect',selectkey:"selfoutstock"},
	                readOnly: true,
				}, {
					field : "barcode",
					name : "barcode",
					header : "赠品商品条码",
					headerAlign: "center",
					allowSort: true,
					required: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                displayField: "barcode",
	                width: "200",
	                editorSet: {
						/*selectkey: 'selfsupgoods2',*/
                       selectkey: 'selfoutstock',
	                    /*textName :"barcode",*/
	                    beforefunc:"det_beforefunc_gdidzp",
						itemchangedfunc:"det_itemchanged_gdidzp"
	                },
					/*cdEdtCfg:{compnentType:'fut_popselect',selectkey:"selfsupgoods2"},*/
                   cdEdtCfg:{compnentType:'fut_popselect',selectkey:"selfoutstock"},
				}, {
					field : "name",
					header : "商品名称",
					headerAlign : "center",
					align : "left",
					readOnly : true,
					width : 200,
				}, {
					field : "sample",
					header : "是否样品",
					headerAlign : "center",
					type : "comboboxcolumn",
					valueField : "code",
					textField : "name",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					data : sample,
					required : true,
					defaultValue : "N",
					visible : false,
				}, {
					field : "spec",
					header : "规格",
					headerAlign : "center",
					align : "left",
					readOnly : true,
				}, {
					field : "gbspcm",
					header : "尺码",
					width : 130,
					headerAlign : "center",
					readOnly : true,
					align : "left",
					visible : false,
				}, {
					field : "gbspcm_name",
					header : "尺码",
					width : 130,
					headerAlign : "center",
					readOnly : true,
					align : "left",
				}, {
					field : "gbsphs",
					header : "花色",
					width : 130,
					headerAlign : "center",
					readOnly : true,
					align : "left",
					visible : false,
				}, {
					field : "gbsphs_name",
					header : "花色",
					width : 130,
					headerAlign : "center",
					readOnly : true,
					align : "left",
				},{
					field : "unit",
					header : "单位",
					align : "left",
					editor: OcmControl.newControl('fut_popselectgrid'),
					editorSet : {
						selectkey : "units",
						multiSelect: false,
						beforefunc : "det_beforefunc_units",
						itemchangedfunc:"det_itemchanged_units_zp",
					},
					cdEdtCfg:{compnentType:'fut_popselect',selectkey:"units"},
					/* readOnly : true, */
				},  {
					field : "hl",
					header : "含量",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "n0",
					defaultValue : "1",
					align : "right",
					readOnly : true,
				}, {
					field : "ssjs",
					header : "交货件数",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n4",
					},
					numberFormat : "n4",
					defaultValue : "1",
					align : "right",
					required : true,
				}, {
					field : "sssl",
					header : "交货数量",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n4",
					},
					numberFormat : "n4",
					defaultValue : "1",
					align : "right",
					readOnly : true,
				},{
					field : "dqkcsl",
					header : "当前库存数量",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n4",
					},
					numberFormat : "n4",
					defaultValue : "1",
					align : "right",
					readOnly : true,
				}, {
					field : "batchseq",
					displayField : "batchseq",
					header : "批次",
					headerAlign : "center",
					width : 90,
					editor : OcmControl.newControl('fut_popselectgrid'),
					editorSet: {
						selectkey:"selfbatch2",
				        multiSelect: false,
						beforefunc : "det_beforefunc_batch",
						itemchangedfunc:"det_itemchangedzp_batch",
					}, 
				},{
					field : "sj",
					header : "售价",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "sjje",
					header : "售价金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "iszp",
					header : "是否赠品",
					headerAlign : "center",
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : sample,
					defaultValue : "Y",
					visible : false,
				}, {
					field : "cshh",
					header : "厂商货号",
					headerAlign : "center",
					align : "left",
					readOnly : true,
				}, {
					field : "catcode",
					header : "商品类别",
					width : 130,
					headerAlign : "center",
					readOnly : true,
					align : "left",
					visible : false,
				}, {
					field : "catname",
					header : "商品类别",
					headerAlign : "center",
					width : 150,
					readOnly : true,
					align : "left",
				}, {
					field : "ppcode",
					header : "品牌",
					width : 130,
					headerAlign : "center",
					readOnly : true,
					visible : false,
				}, {
					field : "ppname",
					header : "品牌",
					readOnly : true,
					align : "left",
				},{
					field: "cdcode",
					name: "gbcdcode",
					header: "产地",
					headerAlign: "center",
					allowSort: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                displayField: "gbcdcode_name",
	                width: 200,
	                editorSet: {
	                    selectkey: 'coderegion',
	                    /* allowInput: false, */
	                    beforefunc:"det_beforefunc_cdcode",
	                },
	                cdEdtCfg:{compnentType:'fut_popselect',selectkey:"coderegion",allowInput: false,},
	                allowInput: false,
	                
					/* readOnly : true, */
				},{
					field : "sshsjjje",
					header : "实收含税进价金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
					visible : false,
				}, {
					field : "ssbhsjjje",
					header : "实收不含税进价金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c4",
					},
					numberFormat : "c4",
					defaultValue : "0",
					align : "right",
					readOnly : true,
					visible : false,
				},{
					field : "gbcdcode_name",
					header : "产地",
					align : "left",
					visible : false,
				},{
					field : "manamode",
					header : "管理方法",
					align : "left",
					visible : false,
				},{
					field : "flag",
					align : "left",
					visible : false,
				},]
			},
		};

		//单据明细
		var tabs2 = {
			properties : {
				id : "tabs2",
			},
			items : [ {
				"title" : "商品信息",
				"name" : "binstrdetail",
				"control" : binstrdetail
			}, {
				"title" : "赠品信息",
				"name" : "binstrdetailzp",
				"control" : binstrdetailzp
			} ]
		};

		//单据明细组成：单据头+单据明细tab
		var details1 = {
			"type" : "formgrid",
			"initHeight" : 0.36,
			"resources" : OmdUrl.mss,
			"method" : "mss.base.goodsinstock.get",
			"response" : "binstrhead",
			"properties" : {
				"id" : "details1",
			},
			"items" : formheader1.items, //绑定到具体的项
			"tabs" : tabs2, //直接绑定tab

		};

		//单据列表和单据明细
		var tabs1 = {
			properties : {
				"id" : "tabs1"
			},
			items : [ {
				"title" : "单据列表",
				"name" : "ListGrid",
				"control" : gridbox2,
				"visible" : billno||wph_key?false:true,
			}, {
				"title" : "单据明细",
				"name" : "details1",
				"control" : details1,
			} ]
		};

		var config1 = {
			"properties" : {
				"id" : "config1",
			},
			"toolbar" : toolbar1,
			"tabs" : tabs1,

		};
		
		function head_itemchanged(e, data) {
			var colname = e.sender.name;
			if (colname == 'shmkt') {
				mini.getbyName("shmfid").setValue("");
				mini.getbyName("shmfid").setText("");
			}
			
			if(colname == 'shmkt' && data.length >0){
				mini.getbyName("supid").setValue("");
				mini.getbyName("supid").setText("");
				mini.getbyName("sup_name").setValue("");
				mini.getbyName("contno").setValue("");
				mini.getbyName("contno").setText("");
				mini.getbyName("shmfid").setValue("");
				mini.getbyName("shmfid").setText("");
			}

			if (colname == 'supid' && data.length >0) {
				var muid = mini.getbyName("shmkt").getValue();
				if(!muid){
					mini.getbyName("shmkt").setValue(data[0].muid);
					mini.getbyName("shmkt").setText(data[0].muid_name);
				}
				mini.getbyName("sup_name").setValue(data[0].sbid_name);
				mini.getbyName("contno").setValue("");
				mini.getbyName("contno").setText("");
				mini.getbyName("shmfid").setValue("");
				mini.getbyName("shmfid").setText("");
			}
			
			if (colname == 'contno'){
				if(data.length>0){
					if (data[0].wmid){
						mini.getbyName("wmid").setValue(data[0].wmid);
						mini.getbyName("wmid").setText(data[0].wmid_name);
						mini.getbyName("shmkt").setValue(data[0].muid);
						mini.getbyName("shmkt").setText(data[0].muid_name);
						mini.getbyName("shmkt_name").setValue(data[0].muid_name);
					}
					mini.getbyName("supid").setValue(data[0].sbid);
					mini.getbyName("supid").setText(data[0].sbid_name);
					mini.getbyName("sup_name").setValue(data[0].sbid_name);
					mini.getbyName("shmfid").setValue("");
					mini.getbyName("shmfid").setText("");
					
					if(data[0].wmid == '1'){
						mini.getbyName("supjsyj").setValue('1');
						mini.getbyName("intjsyj").setValue('1');
					}else{
						mini.getbyName("supjsyj").setValue('2');
						mini.getbyName("intjsyj").setValue('2');
					}
				}
			}
			/* if(colname == 'backtype'){
				if(data[0].backtype == '1'){
					
				}else if(data[0].backtype == '2' || data[0].backtype == '3'){
					var det = mini.get("v_binstrdetail");
					var detzp = mini.get("v_binstrdetailzp");
					var newrow = {
							batchseq : '',
					}
					for(var i=0;i<det.data.length;i++){
						var row = det.data[i];
						det.updateRow(row, newrow);  	
					}
				}
			} */
			return 1;
		};
		
		function det_itemchanged_jxtax(e,data){
			if (data.length > 0) {
				var binstrdetail = mini.get("v_binstrdetail");
				var jxtax = data[0].jxtax;
			}
			return 1;
		};
		
		function det_itemchanged_units(e, data) {
			if (data.length > 0) {
				var binstrdetail = mini.get("v_binstrdetail");
				var row = binstrdetail.getSelected();
				var ohl = row.hl;
				var hl = data[0].hl;
				var js = row.ssjs;
				var jxtax = row.jxtax;
				var sl = Math.round(parseFloat(js)*parseFloat(data[0].hl) * 10000) / 10000;
				var hsjj = Math.round(parseFloat(row.hsjj)*parseFloat(hl)/parseFloat(ohl) * 10000) / 10000;
				/* var bhsjj = Math.round(parseFloat(row.bhsjj)*parseFloat(hl)/parseFloat(ohl) * 10000) / 10000; */
				var bhsjj = Math.round(parseFloat(hsjj)/(1+parseFloat(jxtax))*10000)/10000;
				var sj = Math.round(parseFloat(row.sj)*parseFloat(hl)/parseFloat(ohl) * 10000) / 10000;
				var newrow = {
					    unit : data[0].gbunit,
						hl : hl,
						barcode : data[0].gbbarcode,
						sssl : sl,
						hsjjje : Math.round(parseFloat(hsjj)*parseFloat(js) * 10000) / 10000,
					    bhsjjje : Math.round(parseFloat(bhsjj)*parseFloat(js) * 10000) / 10000,
					    sshsjjje : Math.round(parseFloat(hsjj)*parseFloat(js) * 10000) / 10000,
					    ssbhsjjje : Math.round(parseFloat(bhsjj)*parseFloat(js) * 10000) / 10000,
					    se : Math.round(parseFloat(js)*(parseFloat(hsjj)-parseFloat(bhsjj)) * 10000) / 10000,
					    
					    hsjj : hsjj,
					    bhsjj : bhsjj,
					    sj   :  sj,
					    
					    sjje : Math.round(parseFloat(sj)*parseFloat(js) * 10000) / 10000, 
					}; 
					binstrdetail.updateRow(row, newrow);  		
			}	
		    return 1;
		};
		
		function det_itemchanged_units_zp(e, data) {
			if (data.length > 0) {
				var binstrdetailzp = mini.get("v_binstrdetailzp");
				var row = binstrdetailzp.getSelected();
				var ohl = row.hl;
				var hl = data[0].hl;
				var js = row.ssjs;
				var jxtax = row.jxtax;
				var sl = Math.round(parseFloat(js)*parseFloat(data[0].hl) * 10000) / 10000;
				var hsjj = Math.round(parseFloat(row.hsjj)*parseFloat(hl)/parseFloat(ohl) * 10000) / 10000;
				/* var bhsjj = Math.round(parseFloat(row.bhsjj)*parseFloat(hl)/parseFloat(ohl) * 10000) / 10000; */
				var bhsjj = Math.round(parseFloat(hsjj)/(1+parseFloat(jxtax))*10000)/10000;
				var sj = Math.round(parseFloat(row.sj)*parseFloat(hl)/parseFloat(ohl) * 10000) / 10000;
				var newrow = {
					    unit : data[0].gbunit,
						hl : hl,
						barcode : data[0].gbbarcode,
						sssl : sl,
						/* hsjjje : Math.round(parseFloat(hsjj)*parseFloat(js) * 10000) / 10000,
					    bhsjjje : Math.round(parseFloat(bhsjj)*parseFloat(js) * 10000) / 10000,
					    sshsjjje : Math.round(parseFloat(hsjj)*parseFloat(js) * 10000) / 10000,
					    ssbhsjjje : Math.round(parseFloat(bhsjj)*parseFloat(js) * 10000) / 10000,
					    se : Math.round(parseFloat(js)*(parseFloat(hsjj)-parseFloat(bhsjj)) * 10000) / 10000, */
					    
					    /* hsjj : hsjj,
					    bhsjj : bhsjj, */
					    sj   :  sj,
					    
					    sjje : Math.round(parseFloat(sj)*parseFloat(js) * 10000) / 10000, 
					}; 
					binstrdetailzp.updateRow(row, newrow);  		
			}	
		    
		    return 1;
		};
		
		function det_itemchanged_batch(e,data){
			if(data && data[0].seq != '0'){
				var row = binstrdetail.getSelected();
				var newrow = {
						hsjj : Number(data[0].suphsjj),
						bhsjj : Number(data[0].supbhsjj),
						hsjjje : Number(data[0].suphsjj) * Number(row.ssjs),
						bhsjjje : Number(data[0].supbhsjj) * Number(row.ssjs),
						batchseq : Number(data[0].seq),
						jxtax : data[0].hsjxtax,
						se : (Number(data[0].suphsjj) * Number(row.ssjs) * 10000 - Number(data[0].supbhsjj) * Number(row.ssjs) * 10000)/10000,
						dqkcsl : Number(data[0].hssl),
				};
				var button = e.sender;
				button.setValue(newrow.batchseq);
				button.setText(newrow.batchseq);
				binstrdetail.updateRow(row, newrow);
			}
			/* return 1; */
			/* return; */
			/* return 0; */
			/* return -1; */
		}
		function det_itemchangedzp_batch(e,data){
			if(data && data[0].seq != '0'){
				var row = binstrdetailzp.getSelected();
				var newrow = {
						/* hsjj : data[0].suphsjj,
						bhsjj : data[0].supbhsjj,
						hsjjje : data[0].suphsjj * row.ssjs,
						bhsjjje : data[0].supbhsjj * row.ssjs, */
						batchseq : data[0].seq,
						dqkcsl : Number(data[0].hssl),
				};
				var button = e.sender;
				button.setValue(newrow.batchseq);
				button.setText(newrow.batchseq);
				binstrdetailzp.updateRow(row, newrow);
			}
			/* return 1; */
		}

		
		function onDrawSummaryCell(e) {
	    	var rows = e.data;
			var sumssjs = 0.0000;    var sumsssl = 0.0000;      /* var sumhsjj = 0.00; */
			/* var sumbhsjj = 0.0000; */   var sumhsjjje = 0.00;	var sumbhsjjje = 0.0000;
			var sumse = 0.0000;  /* var sumsj = 0.00; */    	  sumsjje = 0.00;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.ssjs) == false) {
						sumssjs += parseFloat(row.ssjs);
					}
					if (isNaN(row.sssl) == false) {
						sumsssl += parseFloat(row.sssl);
					}
					/* if (isNaN(row.hsjj) == false) {
						sumhsjj += parseFloat(row.hsjj);
					} */
					/* if (isNaN(row.bhsjj) == false) {
						sumbhsjj += parseFloat(row.bhsjj);
					} */
					if (isNaN(row.hsjjje) == false) {
						sumhsjjje += parseFloat(row.hsjjje);
					}
					if (isNaN(row.bhsjjje) == false) {
						sumbhsjjje += parseFloat(row.bhsjjje);
					}
					if (isNaN(row.se) == false) {
						sumse += parseFloat(row.se);
					}
					/* if (isNaN(row.sj) == false) {
						sumsj += parseFloat(row.sj);
					} */
					if (isNaN(row.sjje) == false) {
						sumsjje += parseFloat(row.sjje);
					}
				}
			}
			if (e.field == "hl") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "ssjs") {
				e.cellHtml ="<b>"+ sumssjs.toFixed(4)+"</b>";
			}
			if (e.field == "sssl") {
				e.cellHtml ="<b>"+ sumsssl.toFixed(4)+"</b>";
			}
			/* if (e.field == "hsjj") {
				e.cellHtml ="<b>"+ sumhsjj.toFixed(2)+"</b>";
			} */
			/* if (e.field == "bhsjj") {
				e.cellHtml ="<b>"+ sumbhsjj.toFixed(4)+"</b>";
			} */
			if (e.field == "hsjjje") {
				e.cellHtml ="<b>"+ sumhsjjje.toFixed(2)+"</b>";
			}
			if (e.field == "bhsjjje") {
				e.cellHtml ="<b>"+ sumbhsjjje.toFixed(4)+"</b>";
			}
			if (e.field == "se") {
				e.cellHtml ="<b>"+ sumse.toFixed(2)+"</b>";
			}
			/* if (e.field == "sj") {
				e.cellHtml ="<b>"+ sumsj.toFixed(2)+"</b>";
			} */
			if (e.field == "sjje") {
				e.cellHtml ="<b>"+ sumsjje.toFixed(2)+"</b>";
			}
			e.cellStyle = "text-align:right";
	    };
		
	    function onDrawSummaryCellZp(e) {
	    	var rows = e.data;
			var sumssjs = 0.0000;    var sumsssl = 0.0000;   /* var sumsj = 0.00; */   var sumsjje = 0.00;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.ssjs) == false) {
						sumssjs += parseFloat(row.ssjs);
					}
					if (isNaN(row.sssl) == false) {
						sumsssl += parseFloat(row.sssl);
					}	
					/* if (isNaN(row.sj) == false) {
						sumsj += parseFloat(row.sj);
					} */
					if (isNaN(row.sjje) == false) {
						sumsjje += parseFloat(row.sjje);
					}
				}
			}
			if (e.field == "hl") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "ssjs") {
				e.cellHtml ="<b>"+ sumssjs.toFixed(4)+"</b>";
			}
			if (e.field == "sssl") {
				e.cellHtml ="<b>"+ sumsssl.toFixed(4)+"</b>";
			}
			/* if (e.field == "sj") {
				e.cellHtml ="<b>"+ sumsj.toFixed(2)+"</b>";
			} */
			if (e.field == "sjje") {
				e.cellHtml ="<b>"+ sumsjje.toFixed(2)+"</b>";
			}
			e.cellStyle = "text-align:right";
	    };
		
		/* mini.parse(); */
		 if ( wph_key){
		
               var tempform = mini.get("details1")
               if (tempform) {
            	   
            	   tempform.getResources(
		           {
		              "ph_key": wph_key
		             });
        		   tempform.phkeyflag = true;
				   setTimeout("setBillData()", 300); 
               }	  	   
		}
		
		 if ( wph_key){
		
               var tempform = mini.get("details1")
               if (tempform) {
            	   
            	   tempform.getResources(
		           {
		              "ph_key": wph_key
		             });
        		   tempform.phkeyflag = true;
				   setTimeout("setBillData()", 300); 
               }	  	   
		}
		
	</script>
	<script src="goodsOutStock.js" type="text/javascript"></script>

</body>
</html>