<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>商品报损单</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-layout" config="config1" borderStyle="border:0px;"
		style="width: 100%; height: 100%;"></div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"
		type="text/javascript"></script>
	<script src="/ocp-ui-res/js/base/doattachmentdual.js"
		type="text/javascript"></script>
	<script src="/ocp-ui-res/js/base/base.js" type="text/javascript"></script>
	<script type="text/javascript">
		var dictData = OcmControl.getDict(
				"BILLMODULEID,BILLFLAG,STOCKMD,JXTAXRATE,WMID", "code,name")
				|| {};
		var billmoduleid = getUrlParam("billmoduleid");
		if (billmoduleid == "" || billmoduleid == null) {
			billmoduleid = getUrlParam("modulecode");
		}

		var sampleList = [ {
			code : 'N',
			name : '否'
		}, {
			code : 'Y',
			name : '是'
		} ]

		var wmid = [ {
			code : '1',
			name : '经销',
		}, {
			code : '2',
			name : '成本代销',
		}, {
			code : '3',
			name : '扣率代销',
		} ]

		var billtype = getBilltype(billmoduleid);

		// 页面布局配置

		var toolbar1 = {
			rule : { // 按钮可用规则 Y:已审核, N:录入, C:已取消 ,S:提交
				'billstatus' : {
					'Y' : [ 'addData', 'searchData', 'printData', 'cancelData',
							'upTemplate', 'downTemplate' ],
					'N' : [ 'addData', 'editData', 'auditData', 'delData',
							'copyData', 'searchData', 'firstData',
							'billImport', 'recallData', 'upTemplate',
							'downTemplate' ],
					'C' : [ 'addData', 'copyData', 'searchData', 'upTemplate',
							'downTemplate', 'delData' ],
					'S' : [ 'addData', 'searchData', 'firstData', 'fallData',
							'upTemplate', 'downTemplate' ],
					'Q' : [ 'addData', 'searchData', 'upTemplate',
							'downTemplate' ],
					'D' : [ 'addData', 'searchData', 'upTemplate',
							'downTemplate' ],
					'A' : [ 'addData', 'searchData', 'recallData', 'auditData',
							'upTemplate', 'downTemplate' ],
				}
			},
			status : { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
				'N' : [ 'addData', 'saveData', 'searchData', ],
				'V' : [ 'addData', 'editData', 'auditData', 'delData',
						'searchData' ],
				'E' : [ 'addData', 'saveData', 'delData', 'searchData' ],
				'S' : [ 'addData', 'editData', 'auditData', 'delData',
						'searchData' ],
				'A' : [ 'addData', 'searchData' ],
				'C' : [ 'addData', 'searchData' ],
				'D' : [ 'addData', 'searchData' ],
			},
			items : [ [ {
				'text' : '新增',
				'iconCls' : 'icon-add',
				'name' : 'addData'
			}, {
				'text' : '修改',
				'iconCls' : 'icon-edit',
				'name' : 'editData'
			}, {
				'text' : '保存',
				'iconCls' : 'icon-save',
				'name' : 'saveData'
			} ], [ {
				'text' : '审核',
				'iconCls' : 'icon-ok',
				'name' : 'auditData'
			} ], [ {
				'text' : '删除',
				'iconCls' : 'icon-remove',
				'name' : 'delData'
			}, {
				'text' : '查询',
				'iconCls' : 'icon-search',
				'name' : 'searchData'
			} ] ]
		};

		//单据列表
		var gridbox2 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.base.goodsstockloss.search",
			"response" : "dbusrmkt.bpalhead",
			"bindform" : "tabs1", // 绑定切换的TabsBox.name
			"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段 
			"searchParam" : {
				"billtype" : billtype,
				"order_field" : "billno",
				"order_direction" : "desc",
			},
			"properties" : {
				"id" : "goodsstockloss",
				"columns" : [ {
					type : "indexcolumn",
					headerAlign : "center",
					header : "行号",
					width : 80,
				}, {
					field : "billno",
					headerAlign : "center",
					header : "单据编号",
					allowSort : true,
					width : 150,
				}, {
					field : "billsgno",
					headerAlign : "center",
					header : "手工单号",
					allowSort : true,
					width : 140,
				}, {
					field : "billstatus",
					headerAlign : "center",
					header : "单据状态",
					width : 100,
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : dictData.BILLFLAG,
				}, {
					field : "muid",
					type : "TextBox",
					headerAlign : "center",
					width : 150,
					header : "收货门店",
					editor : OcmControl.newControl('fut_popselect'),
					displayField : "muid_name",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "muid"
					},
					enabledSearch : true,
				}, {
					field : "mfid",
					type : "TextBox",
					headerAlign : "center",
					width : 150,
					header : "柜组",
					editor : OcmControl.newControl('fut_popselect'),
					displayField : "mfid_name",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "selfspid",
					},
					enabledSearch : true,
				}, {
					field : "stockmd",
					headerAlign : "center",
					header : "子库存",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					data : dictData.STOCKMD,
					width : 100,
				}, {
					field : "chkdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "检查日期",
					headerAlign : "center",
					width : 140,
				}, {
					field : "memo",
					type : "TextBox",
					headerAlign : "center",
					header : "备注",
					width : "180",
				}, {
					field : "inputer_name",
					header : "录入人",
					headerAlign : "center",
					readOnly : true,
					enabledSearch : false,
					width : 110,
				}, {
					field : "inputdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "录入日期",
					width : 140,
					headerAlign : "center",
				}, {
					field : "auditor",
					header : "审核人",
					width : 100,
					headerAlign : "center",
					enabledSearch : true,
					visible : false,
				}, {
					field : "auditor_name",
					header : "审核人",
					width : 110,
					headerAlign : "center",
					enabledSearch : false,
				}, {
					field : "auditdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "审核日期",
					headerAlign : "center",
					width : 140,
				} ],
			},
		};

		//单据头
		var formheader1 = {
			"type" : "formgrid",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.goodsstockloss.search",
			"response" : "goodsstockloss",
			"properties" : {
				"id" : "goodsstockloss",
			},
			items : [ {
				"label" : "ph_key：",
				"type" : "TextBox",
				"name" : "ph_key",
				"readOnly" : "true",
				"visible" : false,
			}, {
				"label" : "单据编号：",
				"id" : "billno",
				"name" : "billno",
				"type" : "TextBox",
				"readOnly" : true,
			}, {
				"label" : "手工单号：",
				"name" : "billsgno",
				"type" : "TextBox",
				"readOnly" : false,
			}, {
				"label" : "单据类型：",
				"name" : "billmoduleid",
				"type" : "ComboBox",
				"data" : dictData.BILLMODULEID,
				"defaultValue" : billmoduleid,
				"readOnly" : true,
				visible : false,
			}, {
				"label" : "单据状态：",
				"name" : "billstatus",
				"type" : "ComboBox",
				"data" : dictData.BILLFLAG,
				"defaultValue" : "N",
				"readOnly" : true,
				"style" : "display:block;float:none"
			}, {
				"label" : "单据类型：",
				"name" : "billtype",
				"type" : "TextBox",
				"defaultValue" : billtype,
				"visible" : false,
			}, {
				"label" : "门店：",
				"name" : "muid",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "muid",//弹框类型
				textName : "muid_name", //文本显示字段
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged",
				required : true,
			}, {
				"label" : "门店名：",
				"name" : "muid_name",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : false
			}, {
				"label" : "柜组：",
				"name" : "mfid",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "selfspid",//弹框类型
				textName : "mfid_name", //文本显示字段
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged",
				required : true,
			}, {
				"label" : "柜组名：",
				"name" : "mfid_name",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : false
			}, {
				"label" : "子库存：",
				"type" : "ComboBox",
				"name" : "stockmd",
				"data" : dictData.STOCKMD,
				beforefunc : "head_beforefunc",
				"showNullItem" : true,
				required : true,
			}, {
				"label" : "检查日期：",
				"name" : "chkdate",
				"type" : "DatePicker",
				"readOnly" : false,
				"format" : "yyyy-MM-dd",
				required : true,
			}, {
				"label" : "备注：",
				"name" : "memo",
				"type" : "TextBox",
				"style" : "display:block;float:none;width:60%",
			}, {
				"label" : "录入人：",
				"name" : "inputer_name",
				"type" : "TextBox",
				"readOnly" : true,
			}, {
				"label" : "录入人",
				"name" : "inputer",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : false,
			}, {
				"label" : "审核人：",
				"name" : "auditor_name",
				"type" : "TextBox",
				"readOnly" : true,
				"style" : "display:block;float:none;",
			}, {
				"label" : "录入日期：",
				"name" : "inputdate",
				"type" : "DatePicker",
				"readOnly" : true,
				"format" : "yyyy-MM-dd HH:mm:ss",
			}, {
				"label" : "审核日期：",
				"name" : "auditdate",
				"type" : "DatePicker",
				"readOnly" : true,
				"format" : "yyyy-MM-dd HH:mm:ss",
			} ]
		};

		var bpaldetail = {
			"type" : "gridbox",
			"properties" : {
				"id" : "bpaldetail",
				"multiSelect" : true,
				"allowCellEdit" : true,
				"allowCellSelect" : true,
				"editNextOnEnterKey" : true,
				"editNextRowCell" : true,
				"allowSortColumn" : false,
				"showColumnsMenu" : true,
				"showSummaryRow" : true,
				"oncellbeginedit" : "OcmControl.checkboxEditor",
				"oncellendedit" : 'OcmControl.datetimeFormate',
				"columns" : [ {
					type : "checkcolumn",
					headerAlign : "center",
					readOnly : true,
					width : 30,
				}, {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
					readOnly : true,
				}, {
					headerAlign : "center",
					header : "行号",
					displayField : "rowno",
					readOnly : true,
					width : 50,
					align : "center",
					visible : false
				}, {
					field : "gdid",
					name : "gdid",
					header : "商品编码",
					width : 120,
					headerAlign : "center",
					readOnly : true,
				}, {
					field : "barcode",
					name : "barcode",
					header : "商品条码",
					headerAlign : "center",
					allowSort : true,
					required : true,
					editor : OcmControl.newControl('fut_popselectgrid'),
					displayField : "barcode",
					width : "130",
					editorSet : {
						selectkey :billtype == "145" ? "selfgbasewithsample" : "selfgbasegain" ,
						beforefunc : "det_beforefunc_gdid",
						itemchangedfunc : "det_itemchanged_gdid"
					},
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey :billtype == "145" ? "selfgbasewithsample" : "selfgbasegain" ,
					},
				}, {
					field : "name",
					header : "商品名称",
					headerAlign : "center",
					align : "left",
					readOnly : true,
					width : 160,
				}, {
					field : "sample",
					header : "是否样品",
					headerAlign : "center",
					type : "comboboxcolumn",
					valueField : "code",
					textField : "name",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					data : sampleList,
					defaultValue : "N",
					width : 80,
				}, {
					field : "spec",
					header : "规格",
					headerAlign : "center",
					align : "left",
					readOnly : true,
					width : 60,
				}, {
					field : "catid",
					header : "商品类别",
					width : 130,
					headerAlign : "center",
					readOnly : true,
					align : "left",
					visible : false,
				}, {
					field : "catname",
					header : "商品类别",
					headerAlign : "center",
					width : 140,
					readOnly : true,
					align : "left",
				}, {
					field : "ppcode",
					header : "品牌",
					width : 130,
					headerAlign : "center",
					readOnly : true,
					visible : false,
				}, {
					field : "ppname",
					header : "品牌",
					readOnly : true,
					align : "left",
					width : 140,
				}, {
					field : "gbsphs",
					header : "花色",
					width : 130,
					headerAlign : "center",
					readOnly : true,
					align : "left",
					visible : false,
				}, {
					field : "gbsphs_name",
					header : "花色",
					width : 130,
					headerAlign : "center",
					readOnly : true,
					align : "left",
				}, {
					field : "gbspcm",
					header : "尺码",
					width : 130,
					headerAlign : "center",
					readOnly : true,
					align : "left",
					visible : false,
				}, {
					field : "gbspcm_name",
					header : "尺码",
					width : 130,
					headerAlign : "center",
					readOnly : true,
					align : "left",
				}, {
					field : "unit",
					header : "单位",
					align : "left",
					editor : OcmControl.newControl('fut_popselectgrid'),
					editorSet : {
						selectkey : "units",
						multiSelect : false,
						beforefunc : "det_beforefunc_units",
						itemchangedfunc : "det_itemchanged_units"
					},
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "units"
					},
					readOnly : false,
					width : 80,
				}, {
					field : "hl",
					header : "含量",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "n0",
					defaultValue : "1",
					align : "right",
					readOnly : true,
					width : 70,
				}, {
					field : "js",
					header : "损溢件数",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n4",
					},
					numberFormat : "n4",
					defaultValue : "1",
					align : "right",
					required : true,
					minValue : "0"
				}, {
					field : "sl",
					header : "损溢数量",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n4",
					},
					numberFormat : "n4",
					defaultValue : "1",
					align : "right",
					readOnly : true,
				}, {
					field : "jxtax",
					header : "进项税率",
					headerAlign : "center",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					editorSet : {
						showNullItem : false
					},
					renderer : "OcmControl.dictRendererWithCode",
					data : dictData.JXTAXRATE,
					width : 85,
					align : "center",
					readOnly : true,
				}, {
					field : "kl",
					header : "毛利率",
					headerAlign : "center",
					editor : OcmControl.newControl('TextBox'),
					width : "110",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "p2",
					},
					numberFormat : "p2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
					width : 80,
				}, {
					field : "hsjj",
					header : "含税进价",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
					width : 90,
				}, {
					field : "hsjjje",
					header : "含税进价金额",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
					width : 110,
				}, {
					field : "sj",
					header : "售价",
					headerAlign : "center",
					width : 90,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "sjje",
					header : "售价金额",
					headerAlign : "center",
					width : 110,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "wmid",
					headerAlign : "center",
					header : "经营方式",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					data : wmid,
					width : 100,
					visible : billtype == "145" ? false : true,
					width : 90,
				},{
					field : "supid",
					displayField : "supname",
					header : "供应商",
					headerAlign : "center",
					readOnly : billtype == "145" ? true : false,
					width : 160,
					editor : OcmControl.newControl('fut_popselectgrid'),
					editorSet : {
						selectkey : "selfsbid",
						textName : "supname",
						beforefunc : "det_beforefunc_supid",
					},
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "selfsbid"
					},
				}, {
					field : "supname",
					name : "supname",
					header : "供应商",
					readOnly : true,
					align : "left",
					width : 120,
					visible : false,
				}, {
					field : "batchseq",
					displayField : "batchseq",
					header : "批次",
					headerAlign : "center",
					width : 90,
					editor : OcmControl.newControl('fut_popselectgrid'),
					editorSet : {
						selectkey : "selfbatch",
						multiSelect : false,
						beforefunc : "det_beforefunc_batch",
						itemchangedfunc : "det_itemchanged_batch"
					},
					visible : billtype == "145" ? true : false
				},  {
					field : "shelfcode",
					name : "shelfcode",
					header : "货位",
					readOnly : true,
					width : 180,
					visible : false,
				} ]
			},
		};
		//单据明细
		var tabs2 = {
			properties : {
				id : "tabs2",
			},
			items : [ {
				"title" : "商品信息",
				"name" : "bpaldetail",
				"control" : bpaldetail
			} ]
		};

		//单据明细组成：单据头+单据明细tab
		var details1 = {
			"type" : "formgrid",
			"initHeight" : 0.30,
			"resources" : OmdUrl.mss,
			"method" : "mss.base.goodsstockloss.get",
			"response" : "dbusrmkt.bpalhead",
			"properties" : {
				"id" : "details1",
			},
			"items" : formheader1.items, //绑定到具体的项
			"tabs" : tabs2, //直接绑定tab

		};

		//单据列表和单据明细
		var tabs1 = {
			properties : {
				"id" : "tabs1"
			},
			items : [ {
				"title" : "单据列表",
				"name" : "ListGrid",
				"control" : gridbox2,
			}, {
				"title" : "单据明细",
				"name" : "details1",
				"control" : details1,
			} ]
		};

		var config1 = {
			"properties" : {
				"id" : "config1",
			},
			"toolbar" : toolbar1,
			"tabs" : tabs1,

		};
	</script>
	<script src="goodsstockloss.js" type="text/javascript"></script>

</body>
</html>