/**
 * 进价调整单-页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('selfbadjustnew.view');
	
	function getBilltype (billmoduleid) {
		 var billtype = "";
		 var searchParam = {"modeid":billmoduleid};
		 var method = "mss.base.billmain.search";
		 itemLoader.doRequest(OmdUrl.mall, method,searchParam, null, null, function(data) {
			 	var data = data.billmain;
				if(data.length >0){
					billtype =data[0].billtype;
				}
		 },null,null,false);
		 return billtype;
	}

	// 定义一个对象用来配置界面
	var bill = {};
	var moduleid = app.modulecode;
	var billtype=getBilltype(moduleid);
	
	var dicData = OcmControl.getDict("JXTAXRATE","code,name,ddvalue") ||{};
	//数据来源  1电脑生成2手工录入
	var bdhsource = [ {
		code : '1',
		name : '电脑生成'
	}, {
		code : '2',
		name : '手工录入'
	} ];
	
	//调整项目
	var bdhtztype = [ {
		code : '1',
		name : '调进价'
	}, {
		code : '2',
		name : '调进项税率'
	}, {
		code : '3',
		name : '同时调进价、进项税率'
	} ];
	
	var bdhmode =[{code :'9',name :'未来进价调整单'}]		
	
	// 把定义对象放到命名空间下
	ns.bill = bill;

	utils.billtype=billtype;
	// 查询列表
	bill.selfbadjustlist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.base.selfbadjusthead.search",
		"response": "dbusrmkt.selfbadjusthead",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
			"billtype" : billtype,
			"order_field": "inputdate",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('selfbadjustlist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 140,
			}, {
				field : "billsgno",
				header : "手工单号",
				allowSort : true,
				headerAlign : "center",
				width : 150,
				visible:false,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
				width : 90,
			}, {
				field: "bdhmuid",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "bdhmuname",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
				visible:false,
				enabledSearch : true,
			},{
				field: "bdhmuname",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				enabledSearch : false,
				width: 150,
			},{
				field: "bdhtztype",
				type:"TextBox",
				headerAlign:"center",
				header:"调整项目",
				allowSort : true,
				renderer: "OcmControl.dictRendererWithCode",
				data: bdhtztype,
				width: 140,
			},{
				field : "bdhfsdate",
				header : "生效日期",
				type: "DatePicker",
				headerAlign: "center",
				dataType: "date",
				dateFormat: "yyyy-MM-dd",
				width: 100,
			},{
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			},{
				field : "inputer_name",
				header : "录入人",
				width : 120,
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 130,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 120,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 130,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 130,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "bdhmemo",
				header : "备注",
				width : 250,
				allowSort : true,
				headerAlign : "center",
				visible : false,
				enabledSearch : false,
			},{
				field : "selfbadjustdetail:bddbarcode",
				header : '商品编码',
				width : 120,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : true, 
				visible : false,
				editor:OcmControl.newControl('fut_popselectgrid'),
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"selfgbase"},
			},]
		}
	};
	
	// 单据主表
	bill.selfbadjusthead = {
		"type": "formgrid",
		"initHeight" : 0.3,
		"resources": OmdUrl.mss,
		"name": 'badjusthead',
		"method": "mss.base.selfbadjusthead.get",
		"response": "dbusrmkt.selfbadjusthead",
		"properties": {
			"id": utils.createid('selfbadjusthead')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"visible": true,
			}, {
				"label" : "手工单号：",
				"name" : "billsgno",
				"type" : "TextBox",
				"defaultValue" : "",
			}, {
				"label": "模块编号：",
				"name": "billmoduleid",
				"type": "TextBox",
				"defaultValue": moduleid,
				"visible": false
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "TextBox",
				"defaultValue": billtype,
				"visible": false
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
			}, {
				"label": "门店：",
				"name": "bdhmuid",
				"type": "fut_popselect",
				selectkey: "muid",
				textName: "bdhmuname",
				allowInput: true,
				"required" : true,
				beforefunc : "page.head_beforefunc_bdhmuid",
			}, {
				"label": "门店：",
				"name": "bdhmucode",
				"type": "TextBox",
				"readOnly": true,
				"visible": false
			}, {
				"label": "门店：",
				"name": "bdhmuname",
				"type": "TextBox",
				 "readOnly": true,
				"visible": false
			},{
				"label" : "调整项目：",
				"name" : "bdhtztype",
				"type" : "ComboBox",
				"data" : bdhtztype,
				"valueField" : "code",
				"textField" : "name",
				"required" : true,
				"defaultValue" : "1",
				"onvaluechanged" : "page.head_valuechanged_bdhtztype",
			}, {
				"label" : "生效日期：",
				"type" : "DatePicker",
				"name" : "bdhfsdate",
				"required" : "true",
				"format" : "yyyy-MM-dd",
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"onValuechanged" : "page.head_valuechanged_fsdate",
			}, {
				"label" : "备注：",
				"name" : "bdhmemo",
				"type" : "TextBox",
				"defaultValue" : "",
				"style" : "width:60%;display:block;float:none",
			}, {
				"label": "录入人编码",
				"type": "TextBox",
				"name": "inputer",
				"defaultValue" : app.usercode,
				"visible": false,
			},{
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"defaultValue" : app.username,
				"readOnly": "true",
			}, {
				"label": "审核人编码",
				"type": "TextBox",
				"name": "auditor",
				"visible": false,
			},{
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
				"style" : "display:block;float:none",
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
				"defaultValue" : new Date(),
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label" : "数据来源：",
				"name" : "bdhsource",
				"type" : "ComboBox",
				"data" : bdhsource,
				"valueField" : "code",
				"textField" : "name",
				"defaultValue" : "2",
				"visible": false,
			}, {
				"label" : "调整方式：",
				"type" : "ComboBox",
				"name" : "bdhmode",
				"readOnly" : false,
				"data" : bdhmode,
				"valueField" : "code",
				"textField" : "name",
				"defaultValue" : "9",
				 "visible": false
			},{
				"label" : "制单日期：",
				"type" : "DatePicker",
				"name" : "bdhzddate",
				"enabled" : "true",
				"format" : "yyyy-MM-dd",
				"required" : true,
				"defaultValue" : new Date(),
				 "visible": false
			}
		]
	}
	// 单据明细
	bill.selfbadjustdetail= {
			title: '单据明细',
			"type": "gridbox",
			name: 'selfbadjustdetail',
			"properties": {
				"id": utils.createid('selfbadjustdetail'),
				"multiSelect": "true",
				"allowCellEdit": "true",
				"allowCellSelect": "true",
				"editNextOnEnterKey": "true",
				"editNextRowCell": "true",
				"allowSortColumn": "false",
				"allowCellValid": true,
				"sortMode": "client",
				//"showPager": true,
				"showSummaryRow": true,
				"oncellbeginedit": "OcmControl.checkboxEditor",
				"columns": [{
					type: "checkcolumn",
					name: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
					width: "40",
				}, {
					type: "indexcolumn",
					name: "indexcolumn",
					header: "行号",
					headerAlign: "center",
					readOnly: true,
					width: "40",
				}, {
					field: "bddrowno",
					headerAlign: "center",
					align: "center",
					header: "导入行号",
					dataType: "int",
					allowSort: true,
					readOnly: true,
					visible: false,
				}, {
					field: "bddgdid",
					name: "bddgdid",
					/*header: "商品编码",
					headerAlign: "center",
					allowSort: true,
					required: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                width: 110,
	                editorSet: {
	                selectkey: 'gbaseid',
	                multiSelect: true,
	                beforefunc:"page.det_beforefunc_gbid",
	                itemchangedfunc:"page.det_itemchanged_gbid",
	                readOnly : true,*/
					header : "商品编码",
					headerAlign : "center",				    
				    width : 110,
				    align : "left",
				    readOnly: true,
				},{
					field : "bddbarcode",
					name : "bddbarcode",
					header : "商品条码",
					editor: OcmControl.newControl('fut_popselectgrid'),
					width : 120,
					headerAlign : "center",
					required : true,
					editorSet: {
		                selectkey: 'selfgbase',
		                multiSelect: true,
		                beforefunc:"page.det_beforefunc_gbid",
		                itemchangedfunc:"page.det_itemchanged_gbid",
					},
				},{
					field : "bddname",
					header : "商品名称",
					headerAlign : "center",				    
				    width : 130,
				    align : "left",
				    readOnly: true,
				},{
					field : "bddwmid",
					headerAlign : "center",
					header : "经营方式",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'WMID',
					/*value : "1",*/
					width : 100,
					readOnly: true,
				},{
					field: "bddoldmfid",
					name: "bddoldmfid",
					type: "TextBox",
					header: "柜组",
					displayField : "bddoldmfname",
					editor: OcmControl.newControl('fut_popselectgrid'),
					width : 170,
					headerAlign : "center",
					required : true,
					editorSet : {
						selectkey : "selfallspid",
						multiSelect: false,
						beforefunc : "page.det_beforefunc_mfid",
						itemchangedfunc : "page.det_itemchanged_mfid",
					},
				}, {
					field: "bddoldmfcode",
					name: "bddoldmfcode",
					header: "柜组编码",
					headerAlign : "center",				    
				    width : 140,
				    align : "left",
				    visible :false,
				},{
					field: "bddoldmfname",
					name: "bddoldmfname",
					header: "柜组",
					headerAlign: "center",
					width: "170",
					visible :false,
				}, {
					field : "bddppname",
					name : "bddppname",
					header : "品牌",
					readOnly : true,
					align : "left",
					width : 130,
				}, {
					field : "bddppcode",
					header : "品牌",
					headerAlign : "center",				    
				    width : 130,
				    readOnly: true,
				    visible: false,
				}, {
					field : "bddcatid",
					header : "商品类别",
					headerAlign : "center",				    
				    width : 80,
				    readOnly: true,
				    visible: false,
				    align : "left",
				},{
					field : "bddcatname",
					header : "商品类别",
					headerAlign : "center",				    
				    width : 140,
				    readOnly: true,
				    align : "left",
				}, {
					field : "bddspec",
					header : "规格",
					headerAlign : "center",				    
				    width : 80,
				    align : "left",
				    readOnly: true,
				    visible : false,
				}, {
					field: "bddunit",
					name: "bddunit",
					header: "单位",
					editor: OcmControl.newControl('fut_popselectgrid'),
					width : 90,
					headerAlign : "center",
					/*required : true,*/
					align : "left",
					editorSet : {
						selectkey : "units",
						multiSelect: false,
						beforefunc : "page.det_beforefunc_units",
						itemchangedfunc:"page.det_itemchanged_units"
					},
					readOnly : true,
				},{
					field : "bddbzhl",
					header : "含量",
					headerAlign : "center",				    
				    width : 80,
				    editor : OcmControl.newControl('NumButtonEdit'),
				    numberFormat:"#,##0.0000",
					defaultValue : "1",
					align : "right",
					readOnly : true,
					visible : false,
				},{
					field : "bddnewjxtax",
					header : "新进项税率",
					headerAlign : "center",				    
				    width : 100,
				    align : "right",
				    type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'JXTAXRATE',
/*					editorSet:{format: "p2",},
					numberFormat:"p2",*/
				   /* readOnly: true,*/
					allowSort: true,
					required : true,
				}, {
					field : "bddnewhsjj",
					header : "新含税进价",
					headerAlign : "center",				    
				    width : 120,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					/*readOnly : true,*/
					required : true,
				}, {
					field : "bddnewbhsjj",
					header : "新不含税进价",
					headerAlign : "center",				    
				    width : 120,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c4",},
					numberFormat:"c4",
					defaultValue : "0",
					align : "right",
					readOnly : true,
					/*required : true,*/
				},{
					field : "bddoldjxtax",
					header : "当前进项税率",
					headerAlign : "center",				    
				    width : 100,
				    align : "right",
				    readOnly: true,
				    type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'JXTAXRATE',
					/*editorSet:{format: "p2",},
					numberFormat:"p2",*/
					align : "right",
				}, {
					field : "bddoldhsjj",
					header : "当前含税进价",
					headerAlign : "center",				    
				    width : 120,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "bddoldbhsjj",
					header : "当前不含税进价",
					headerAlign : "center",				    
				    width : 120,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c4",},
					numberFormat:"c4",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "bddsj",
					header : "售价",
					headerAlign : "center",				    
				    width : 120,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly: true,
				}]
			},
		};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
			btn.separator,btn.auditData/*, btn.cancelData*/, btn.separator, btn.searchData
		]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.selfbadjusthead, // 单据主表
		billdetail: [bill.selfbadjustdetail], // 单据明细表
		billquerylist: bill.selfbadjustlist, // 查询列表
		dettabpages: [bill.selfbadjustdetail], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
