/**
 * 柜间调拨 --- 界面定义
 */
(function() {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	
	var col = Future.ns('default.col');
	// 命名空间
	var ns = Future.ns('bmovetwomfid.view');
	
	function getBilltype (billmoduleid) {
		 var billtype = "";
		 var searchParam = {"modeid":billmoduleid};
		 var method = "mss.base.billmain.search";
		 itemLoader.doRequest(OmdUrl.mall, method,searchParam, null, null, function(data) {
			 	var data = data.billmain;
				if(data.length >0){
					billtype =data[0].billtype;
				}
		 },null,null,false);
		 return billtype;
	}

	// 定义一个对象用来配置界面
	var bill = {};

	var moduleid = app.modulecode;
	var billtype=getBilltype(moduleid);
	
	var dicData = OcmControl.getDict("JXTAXRATE,WMID","code,name,ddvalue") ||{};
	//数据来源  1电脑生成2手工录入
	var billsource = [ {code : '1',name : '电脑生成'}, {code : '2',name : '手工录入'} ];	
	var isnot = [ {code : 'Y',name : '是'}, {code : 'N',name : '否'} ];	
	
	// 把定义对象放到命名空间下
	ns.bill = bill;
	utils.billtype=billtype;
	
	// 查询列表
	bill.bmovelist = {
				"type": "gridbox",
				"resources": OmdUrl.mss,
				"method": "mss.base.bmovehead.search",
				"response": "dbusrmkt.bmovehead",
				"bindform": "layouttabs",
				"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
				"searchParam": {
					"billtype" : billtype,
					"order_field": "inputdate",
					"order_direction": "desc",
				},
				"properties": {
					"id": utils.createid('bmovelist'),
					"columns": [{
						type: "indexcolumn",
						headerAlign: "center",
						header: "行号",
						width: 60,
					}, {
						field: "billno",
						type: "TextBox",
						headerAlign: "center",
						header: "单据编号",
						width: 150,
					}, {
						field : "billsgno",
						header : "手工单号",
						allowSort : true,
						headerAlign : "center",
						width : 150,
						visible:false,
					}, {
						field: "billstatus",
						type: "TextBox",
						headerAlign: "center",
						header: "单据状态",
						renderer: "OcmControl.dictRendererWithCode",
						dictkey: 'BILLSTATUS',
					},{
						field : "fhmkt",
						header : "调出门店",
						width : 160,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "fhmkt_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
						visible : true,
						enabledSearch : true,
					},{
						field : "fhmfid",
						header : "调出柜组",
						width : 190,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "fhmfid_name",
						cdEdtCfg:{compnentType:'fut_popselect',
							      selectkey:"selfspid",
							      beforefunc : "page.list_beforefunc_mfid",},
						visible : true,
						enabledSearch : true,
					},{
						field : "fhmd",
						header : "调出子库存",
					    type : "comboboxcolumn",
						editor : OcmControl.newControl('ComboBox'),
						renderer : "OcmControl.dictRendererWithCode",
						dictkey : 'STOCKMD',
						width: 90,
					},{
						field : "shmkt",
						header : "调入门店",
						width : 160,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "shmkt_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
						visible : false,
						enabledSearch : true,
					},{
						field : "shmfid",
						header : "调入柜组",
						width : 190,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "shmfid_name",
						cdEdtCfg:{compnentType:'fut_popselect',
							      selectkey:"selfspid",
							      beforefunc : "page.list_beforefunc_mfid",},
						visible : true,
						enabledSearch : true,
					},{
						field : "shmd",
						header : "调入子库存",
					    type : "comboboxcolumn",
						editor : OcmControl.newControl('ComboBox'),
						renderer : "OcmControl.dictRendererWithCode",
						dictkey : 'STOCKMD',
						width: 90,
					},{
						field : "memo",
						header : "备注",
						width : 130,
						allowSort : true,
						headerAlign : "center",
					},{
						field : "inputer",
						header : "录入人",
						width : 120,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "inputer_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					},{
						field : "inputer_name",
						header : "录入人",
						width : 120,
						allowSort : true,
						headerAlign : "center",	
						visible : false,
						enabledSearch : false,
					}, {
						field : "inputdate",
						type : "date",
						dataType : "date",
						format : "yyyy-MM-dd",
						header : "录入日期",
						width : 140,
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					},{
						field : "auditor",
						header : "审核人",
						width : 120,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "auditor_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					}, {
						field : "auditor_name",
						header : "审核人",
						width : 120,
						allowSort : true,
						headerAlign : "center",
						visible : false,
						enabledSearch : false,
					}, {
						field : "auditdate",
						type : "date",
						format : "yyyy-MM-dd",
						header : "审核日期",
						width : 140,
						dataType : "date",
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					}]
		}
	};
	
	// 表头 自定义名称
	bill.bmovehead = {
		"name" : 'bmovehead',
		"initHeight" : 0.3,
		"type" : "formgrid",
		"resources" : OmdUrl.mall,
		"method" : "mss.base.bmovehead.get",
		"response" : "dbusrmkt.bmovehead",
		"properties" : {
			"id" : utils.createid('bmovehead'),
		},
		items : [{
			"label": "ph_key：",
			"name": "ph_key",
			"type": "TextBox",
			"visible": false,
		}, {
			"label": "单据编号：",
			"name": "billno",
			"type": "TextBox",
			"readOnly": true,
			"visible": true,
		},{
			"label": "手工编号：",
			"name": "billsgno",
			"type": "TextBox",
			/*"visible": false,*/
		}, {
			"label": "模块编号：",
			"name": "billmoduleid",
			"type": "TextBox",
			"defaultValue": app.modulecode,
			"visible": false
		}, {
			"label": "单据类型：",
			"name": "billtype",
			"type": "TextBox",
			"defaultValue": getBilltype(app.modulecode),
			"visible": false
		}, {
			"label": "单据状态：",
			"name": "billstatus",
			"type": "ComboBox",
			dictkey: 'BILLSTATUS',
			"readOnly": true,
			"defaultValue": "N",
			/*"style" : "display:block;float:none"*/
		}, {
			"label": "调出门店：",
			"name": "fhmkt",
			"type": "fut_popselect",
			selectkey: "muid",
			textName: "fhmkt_name",
			allowInput: true,
			"required" : true,
			beforefunc : "page.head_beforefunc",
			itemchangedfunc : "page.head_itemchanged",
		}, {
			"label": "调出门店：",
			"name": "fhmkt_code",
			"type": "TextBox",
			"readOnly": true,
			"visible": false
		}, {
			"label": "调出门店：",
			"name": "fhmkt_name",
			"type": "TextBox",
			 "readOnly": true,
			"visible": false
		},{
			"label" : "调出柜组：",
			"name" : "fhmfid",
			"type" : "ButtonEdit",
			"defaultValue" : "",
			"required" : true,
			type : "fut_popselect",//类型
			selectkey : "selfspid",//弹框类型
			textName : "fhmfid_name", //文本显示字段
			beforefunc : "page.head_beforefunc",
			itemchangedfunc : "page.head_itemchanged",
			"enabled" : true,
		},{
			"label": "调出柜组：",
			"name": "fhmfid_code",
			"type": "TextBox",
			 "readOnly": true,
			"visible": false
		},{
			"label": "调出柜组：",
			"name": "fhmfid_name",
			"type": "TextBox",
			 "readOnly": true,
			"visible": false,
		},{
			"label" : "调出子库存：",
			"name" : "fhmd",
			"type": "ComboBox",
			"defaultValue": "1",
			dictkey: 'STOCKMD',
			"visible": true,
			"required" : true,
			"onvaluechanged" : "page.head_valuechanged",
		},{
			"label": "调入门店：",
			"name": "shmkt",
			"type": "fut_popselect",
			selectkey: "muid",
			textName: "shmkt_name",
			allowInput: true,
			"required" : true,
			beforefunc : "page.head_beforefunc",
			itemchangedfunc : "page.head_itemchanged",
			"readOnly": true,
		}, {
			"label": "调入门店：",
			"name": "shmkt_code",
			"type": "TextBox",
			"readOnly": true,
			"visible": false
		}, {
			"label": "调入门店：",
			"name": "shmkt_name",
			"type": "TextBox",
			 "readOnly": true,
			"visible": false
		},{
			"label" : "调入柜组：",
			"name" : "shmfid",
			"type" : "ButtonEdit",
			"defaultValue" : "",
			"required" : true,
			type : "fut_popselect",//类型
			selectkey : "selfspid",//弹框类型
			textName : "shmfid_name", //文本显示字段
			beforefunc : "page.head_beforefunc",
			itemchangedfunc : "page.head_itemchanged",
			"enabled" : true,
		},{
			"label": "调入柜组：",
			"name": "shmfid_code",
			"type": "TextBox",
			 "readOnly": true,
			"visible": false
		},{
			"label": "调入柜组：",
			"name": "shmfid_name",
			"type": "TextBox",
			 "readOnly": true,
			"visible": false,
		},{
			"label" : "调入子库存：",
			"name" : "shmd",
			"type": "ComboBox",
			"defaultValue": "1",
			dictkey: 'STOCKMD',
			"required" : true,
			"visible": true,
			"onvaluechanged": "onShmdchanged"
		},{
			"text" : "是否管库存商品：",
			"name" : "iskc",
			"type" : "ComboBox",
			"data" : isnot,
			"valueField" : "code",
			"textField" : "name",
			"defaultValue" : "Y",
			"visible": false,
		},{
			"label": "备注：",
			"name": "memo",
			"type" : "TextBox",
			"defaultValue" : "",
			"style" : "width:60%;display:block;float:none",
		},{
			"label" : "录入人：",
			"name" : "inputer_name",
			"type" : "TextBox",
			"defaultValue" : app.username,
			"readOnly" : true,
		}, {
			"label" : "录入人",
			"name" : "inputer",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
			"label" : "审核人：",
			"name" : "auditor_name",
			"type" : "TextBox",
			"readOnly" : true,
			"style" : "display:block;float:none",
		},{
			"label" : "审核人姓名",
			"name" : "auditor",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
	        "label" : "录入日期：",
	        "type" : "DatePicker",
	        "name" : "inputdate",
	        "format" : "yyyy-MM-dd HH:mm:ss",
	        "defaultValue" : new Date(),
	        "readOnly" : "true",
	    },{
            "label": "审核日期：",
            "type": "DatePicker",
            "name": "auditdate",
            "format": "yyyy-MM-dd HH:mm:ss",
            "readOnly": "true",
	    },{
			"label" : "数据来源：",
			"name" : "billsource",
			"type" : "ComboBox",
			"data" : billsource,
			"valueField" : "code",
			"textField" : "name",
			"defaultValue" : "2",
			"visible": false,
		} ]
	};

	// 单据明细
	bill.bmovedetail= {
			title: '单据明细',
			"type": "gridbox",
			name: 'bmovedetail',
			"properties": {
				"id": utils.createid('bmovedetail'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"showPager" : false,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			},{
				field: "gbid",
				name: "gbid",
				header: "商品编码",
				headerAlign: "center",			    
			    width : 110,
			    align : "left",
			    readOnly: true,
			}, {
				field: "barcode",
				name: "barcode",
				header: "商品条码",
				headerAlign: "center",
				allowSort: true,
				required: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "barcode",
                width: "110",
                editorSet: {
                    /*selectkey: 'selfgbasestock3',*/
					selectkey: 'selfmovetwomfid',
                    multiSelect: true,
                    /*textName :"barcode",*/
                    beforefunc:"page.det_beforefunc_gbid",
					itemchangedfunc:"page.det_itemchanged_gbid"
                },
			},  {
				field : "gbname",
				header : "商品名称",
				headerAlign : "center",				    
			    width : 160,
			    align : "left",
			    readOnly: true,
			}, {
				field : "spec",
				header : "规格",
				headerAlign : "center",				    
			    width : 70,
			    align : "left",
			    readOnly: true,
			    visible : false,
			},{
				field : "ppcode",
				header : "品牌",
				headerAlign : "center",				    
			    width : 130,
			    readOnly: true,
			    visible: false,
			}, {
				field : "ppname",
				name : "ppname",
				header : "品牌",
				readOnly : true,
				align : "left",
				width : 130,
			},{
				field : "catid",
				header : "商品类别",
				headerAlign : "center",				    
			    width : 130,
			    readOnly: true,
			    visible: false,
			    align : "left",
			}, {
				field : "catname",
				header : "商品类别",
				headerAlign : "center",				    
			    width : 130,
			    readOnly: true,
			    align : "left",
			}, {
				field : "unit",
				name : "unit",
				header : "单位",
				editor: OcmControl.newControl('fut_popselectgrid'),
				width : 75,
				headerAlign : "center",
				align : "left",
				editorSet : {
					selectkey : "units",
					multiSelect: false,
					beforefunc : "page.det_beforefunc_units",
					itemchangedfunc:"page.det_itemchanged_units"
				},
				required: true,
			}, {
				field : "hl",
				header : "含量",
				headerAlign : "center",				    
			    width : 70,
			    editor : OcmControl.newControl('NumButtonEdit'),
			    numberFormat:"#,##0.0000",
				defaultValue : "1",
				align : "right",
				readOnly : true,
			},{
				field : "fhjs",
				header : "件数",
				headerAlign : "center",				    
			    width : 100,
			    editor : OcmControl.newControl('NumButtonEdit'),
				/*editorSet:{format: "n4",},*/
				numberFormat:"#,##0.0000",
				defaultValue : "0",
				align : "right",
				required: true,
			},{
				field : "fhsl",
				header : "数量",
				headerAlign : "center",				    
			    width : 100,
			    editor : OcmControl.newControl('NumButtonEdit'),
				numberFormat:"#,##0.0000",
				align : "right",
				readOnly : true,
			},{
				field : "jxtax",
				header : "进项税率",
				headerAlign : "center",				    
			    width : 100,
			    align : "right",
			    type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'JXTAXRATE',
				allowSort: true,
				readOnly : true,
			}, {
				field : "hsjj",
				header : "含税进价",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			}, {
				field : "bhsjj",
				header : "不含税进价",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c4",},
				numberFormat:"c4",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			}, {
				field : "fhhsjjje",
				header : "含税进价金额",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			}, {
				field : "fhbhsjjje",
				header : "不含税进价金额",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c4",},
				numberFormat:"c4",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			},{
				field : "kl",
				header : "倒扣毛利率",
				headerAlign : "center",
				editor : OcmControl.newControl('TextBox'),
				width : "110",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "p2",},
				numberFormat:"p2",
				defaultValue : "0",
				align : "right",
				readOnly : true,		
			},/*{
				field : "skl",
				header : " 顺加毛利率",
				headerAlign : "center",
				editor : OcmControl.newControl('TextBox'),
				width : 110,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "p2",},
				numberFormat:"p2",
				defaultValue : "0",
				align : "right",
				readOnly : true,		
			},*/{
				field : "sj",
				header : "售价",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			},{
				field : "sjje",
				header : "售价金额",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			},{
				field : "batchseq",
				displayField : "batchseq",
				header : "批次",
				headerAlign : "center",
				width : 90,
				editor : OcmControl.newControl('fut_popselectgrid'),
				editorSet: {selectkey:"selfbatch",
					        multiSelect: false,
							beforefunc : "page.det_beforefunc_batch",
							itemchangedfunc:"page.det_itemchanged_batch"}, 
				required: true,
			},{
				field : "supid",
				displayField : "supname",
				header : "供应商",
				headerAlign : "center",
				readOnly : true,
				width : 160,
				editor : OcmControl.newControl('fut_popselectgrid'),
				editorSet: {selectkey:"selfsbid",textName :"supname",}, 
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"selfsbid" },
				visible : false,
			},{
				field : "supcode",
				name : "supcode",
				header : "供应商",
				readOnly : true,
				align : "left",
				width : 120,
				visible : false,
			},{
				field : "supname",
				name : "supname",
				header : "供应商",
				readOnly : true,
				align : "left",
				width : 160,
			},{
				field : "wmid",
				headerAlign : "center",
				header : "经营方式",
				type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'WMID',
				/*value : "1",*/
				width : 100,
				readOnly : true,
			},{
				field : "kcsl",
				name : "kcsl",
				header : "库存数量",
				headerAlign : "center",				    
			    width : 100,
			    editor : OcmControl.newControl('NumButtonEdit'),
				/*editorSet:{format: "c0",},*/
				/*numberFormat:"c0",*/
			    numberFormat:"0",
			    defaultValue : "0",
				align : "right",
				readOnly : true,
				visible : false,
			},{
				field : "kchsjjje",
				name : "kchsjjje",
				header : "库存金额",
				headerAlign : "center",				    
			    width : 120,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				defaultValue : "0",
				align : "right",
				readOnly : true,
				visible : false,
			}]
		}
	};	

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		/*items: [btn.addData,btn.editData, btn.saveData, btn.delData,btn.separator,
		       {'text': '发货审核','iconCls': 'icon-ok','name': 'auditFhData', billstatus: 'Y',ibediting: 'N',tabindex: '1'},
		       btn.separator,{'text': '收货审核','iconCls': 'icon-ok','name': 'auditShData',	billstatus: 'Y',ibediting: 'N',tabindex: '1'},
		       btn.separator,btn.searchData]*/
		items: [btn.addData,btn.editData, btn.saveData, btn.delData,btn.separator,btn.auditData,btn.searchData]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.bmovehead, // 单据主表
		billdetail: [bill.bmovedetail], // 单据明细表
		billquerylist: bill.bmovelist, // 查询列表
		dettabpages: [bill.bmovedetail], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})();
