/**
 * 商品采购订单 --- 界面定义
 */
(function() {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	
	var col = Future.ns('default.col');
	// 命名空间
	var ns = Future.ns('bordernew.view');
	
	function getBilltype (billmoduleid) {
		 var billtype = "";
		 var searchParam = {"modeid":billmoduleid};
		 var method = "mss.base.billmain.search";
		 itemLoader.doRequest(OmdUrl.mall, method,searchParam, null, null, function(data) {
			 	var data = data.billmain;
				if(data.length >0){
					billtype =data[0].billtype;
				}
		 },null,null,false);
		 return billtype;
	}

	// 定义一个对象用来配置界面
	var bill = {};

	var moduleid = app.modulecode;
	var billtype=getBilltype(moduleid);
	
    var dicData = {};
	var wmid = [{code: '1',name: '经销',ddvalue: '[1]经销'},{code: '2',	name: '成本代销',ddvalue: '[2]成本代销'},
	           {code: '3',name: '扣率代销',ddvalue: '[3]扣率代销'}] 
	
	//数据来源  1电脑生成2手工录入
	var billsource = [ {code : '1',name : '电脑生成'}, {code : '2',name : '手工录入'} ];	
	//结算依据，默认2
	var supjsyj = [ {code : '1',	name : '按单结'}, {code : '2',	name : '按销售'} ];
	
	var shmode =[{code :'1',name :'一次到货'},{code :'2',name :'多次到货'},{code :'3',name :'永续到货'}]	
	
	var istype =[{code :'N',name :'否'},{code :'Y',name :'是'}]
	
	
	// 把定义对象放到命名空间下
	ns.bill = bill;
	utils.billtype=billtype;
	
	// 查询列表
	bill.borderlist = {
				"type": "gridbox",
				"resources": OmdUrl.mss,
				"method": "mss.base.borderhead.search",
				"response": "dbusrmkt.borderhead",
				"bindform": "layouttabs",
				"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
				"searchParam": {
					"billtype" : billtype,
					"order_field": "inputdate",
					"order_direction": "desc",
				},
				"properties": {
					"id": utils.createid('borderlist'),
					"columns": [{
						type: "indexcolumn",
						headerAlign: "center",
						header: "行号",
						width: 60,
					}, {
						field: "billno",
						type: "TextBox",
						headerAlign: "center",
						header: "单据编号",
						width: 150,
					}, {
						field : "billsgno",
						header : "手工单号",
						allowSort : true,
						headerAlign : "center",
						width : 150,
						visible:false,
					}, {
						field: "billstatus",
						type: "TextBox",
						headerAlign: "center",
						header: "单据状态",
						renderer: "OcmControl.dictRendererWithCode",
						dictkey: 'BILLSTATUS',
					},{
						field : "contno",
						header : "合同编号",
						allowSort : true,
						headerAlign : "center",
						width : 100,
						enabledSearch : true,
						visible : true
					},{
						field : "supid",
						type : "TextBox",
						headerAlign : "center",
						header : "供应商",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "supname",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "selfsbid",
							beforefunc : "page.list_beforefunc_sbid",
						},
						visible : true,
						enabledSearch : true,
						width : 180,
					},{
						field: "wmid",
						type:"TextBox",
						headerAlign:"center",
						header:"经营方式",
						allowSort : true,
						renderer: "OcmControl.dictRendererWithCode",
						data: wmid,
						width: 90,
					},{
						field: "supjsyj",
						type:"TextBox",
						headerAlign:"center",
						header:"结算依据",
						allowSort : true,
						renderer: "OcmControl.dictRendererWithCode",
						data: supjsyj,
						width: 90,
					},{
						field: "shmode",
						type:"TextBox",
						headerAlign:"center",
						header:"到货方式",
						allowSort : true,
						renderer: "OcmControl.dictRendererWithCode",
						data: shmode,
						width: 100,
					},{
						field : "dhmfid",
						header : "采购部门",
						width : 160,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "dhmfid_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"buyManaorgno"},
						visible : true,
						enabledSearch : true,
					},{
						field : "shmkt",
						header : "收货门店",
						width : 160,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "shmkt_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
						visible : true,
						enabledSearch : true,
					},{
						field : "shmfid",
						header : "收货部门",
						width : 190,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "shmfid_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"selfspid"},
						visible : true,
						enabledSearch : true,
					},{
						field : "dhdate",
						type : "date",
						dataType : "date",
						dateFormat : "yyyy-MM-dd",
						header : "订货日期",
						width : 100,
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					},{
						field : "jhdate",
						type : "date",
						dataType : "date",
						dateFormat : "yyyy-MM-dd",
						header : "交货日期",
						width : 100,
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					},{
						field : "jhdd",
						header : "交货地点",
						allowSort : true,
						headerAlign : "center",
						width : 150,
						enabledSearch : true,
						visible : true
					},{
						field : "inputer",
						header : "录入人",
						width : 120,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "inputer_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					},{
						field : "inputer_name",
						header : "录入人",
						width : 120,
						allowSort : true,
						headerAlign : "center",	
						visible : false,
						enabledSearch : false,
					}, {
						field : "inputdate",
						type : "date",
						dataType : "date",
						format : "yyyy-MM-dd",
						header : "录入日期",
						width : 140,
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					}, {
						field : "auditor",
						header : "审核人",
						width : 120,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "auditor_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					}, {
						field : "auditor_name",
						header : "审核人",
						width : 120,
						allowSort : true,
						headerAlign : "center",
						visible : false,
						enabledSearch : false,
					}, {
						field : "auditdate",
						type : "date",
						format : "yyyy-MM-dd",
						header : "审核日期",
						width : 140,
						dataType : "date",
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					}, {
						field : "canceler",
						header : "取消人",
						width : 140,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "canceler_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					}, {
						field : "canceler_name",
						header : "取消人",
						width : 120,
						allowSort : true,
						headerAlign : "center",
						visible : false,
						enabledSearch : false,
					}, {
						field : "canceldate",
						type : "date",
						format : "yyyy-MM-dd",
						header : "取消日期",
						width : 140,
						dataType : "date",
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					} ]
		}
	};
	
	// 表头 自定义名称
	bill.borderhead = {
		"name" : 'borderhead',
		"initHeight" : 0.4,
		"type" : "formgrid",
		"resources" : OmdUrl.mall,
		"method" : "mss.base.borderhead.get",
		"response" : "dbusrmkt.borderhead",
		"properties" : {
			"id" : utils.createid('borderhead'),
		},
		items : [{
			"label": "ph_key：",
			"name": "ph_key",
			"type": "TextBox",
			"visible": false,
		}, {
			"label": "单据编号：",
			"name": "billno",
			"type": "TextBox",
			"readOnly": true,
			"visible": true,
		},{
			"label": "手工单号：",
			"name": "billsgno",
			"type": "TextBox",
			/*"visible": false,*/
		}, {
			"label": "模块编号：",
			"name": "billmoduleid",
			"type": "TextBox",
			"defaultValue": app.modulecode,
			"visible": false
		}, {
			"label": "单据类型：",
			"name": "billtype",
			"type": "TextBox",
			"defaultValue": getBilltype(app.modulecode),
			"visible": false
		}, {
			"label": "单据状态：",
			"name": "billstatus",
			"type": "ComboBox",
			dictkey: 'BILLSTATUS',
			"readOnly": true,
			"defaultValue": "N",
			/*"style" : "display:block;float:none"*/
		}, {
			"label" : "合同编号：",
			"name" : "contno",
			 type : "fut_popselect",
			 selectkey : "supcontno",
			 textName : "contno",
			 beforefunc : "page.head_beforefunc",
			 itemchangedfunc : "page.head_itemchanged",
			 "allowInput" : true,
			 "required" : "true",
		},{
			"label": "供应商：",
			"name": "supid",
			"type": "fut_popselect",
			selectkey: "selfsbid2",
			textName: "supname",
			allowInput: true,
			"required" : true,
			beforefunc : "page.head_beforefunc",
			itemchangedfunc:"page.head_itemchanged"
		}, {
			"label": "供应商：",
			"name": "supcode",
			"type": "TextBox",
			"visible": false
		}, {
			"label": "供应商：",
			"name": "supname",
			"type": "TextBox",
			 "readOnly": true,
			"visible": false
		},{
			"label" : "经营方式：",
			"type" : "ComboBox",
			"name" : "wmid",
			"data" : wmid,
			"valueField" : "code",
			"textField" : "name",
			"required" : true,
			/*"defaultValue" : "1",*/
			"onvaluechanged" : "page.head_valuechanged",
		},{
			"label" : "到货方式：",
			"name" : "shmode",
			"type" : "ComboBox",
			"data" : shmode,
			"valueField" : "code",
			"textField" : "name",
			"required" : true,
			"defaultValue" : "1",
		},{
			"label" : "采购部门：",
			"name" : "dhmfid",
			"type" : "ButtonEdit",
			"defaultValue" : "",
			"required" : true,
			type : "fut_popselect",//类型
			selectkey : "buyManaorgno",//弹框类型
			textName : "dhmfid_name", //文本显示字段
			"enabled" : true,
			beforefunc : "page.head_beforefunc",
		},{
			"label": "采购部门：",
			"name": "dhmfid_code",
			"type": "TextBox",
			"visible": false
		},{
			"label": "采购部门：",
			"name": "dhmfid_name",
			"type": "TextBox",
			 "readOnly": true,
			"visible": false
		},{
			"label" : "结算依据：",
			"name" : "supjsyj",
			"type" : "ComboBox",
			"data" : supjsyj,
			"valueField" : "code",
			"textField" : "name",
			"defaultValue" : "1",
			"readOnly" : true,
		},{
			"label" : "订货日期：",
			"type" : "DatePicker",
			"name" : "dhdate",
			"enabled" : "true",
			"format" : "yyyy-MM-dd",
			 "required" : true,
			 "defaultValue" : new Date(),
			 "onvaluechanged" : "page.head_valuechanged",
		},{
			"label": "收货门店：",
			"name": "shmkt",
			"type": "fut_popselect",
			selectkey: "muid",
			textName: "shmkt_name",
			allowInput: true,
			"required" : true,
			beforefunc : "page.head_beforefunc",
			itemchangedfunc : "page.head_itemchanged",
		},{
			"label": "收货门店：",
			"name": "shmkt_code",
			"type": "TextBox",
			"visible": false,
		},{
			"label": "收货门店：",
			"name": "shmkt_name",
			"type": "TextBox",
			 "readOnly": true,
			"visible": false
		},{
			"label" : "收货部门：",
			"name" : "shmfid",
			"type" : "ButtonEdit",
			"defaultValue" : "",
			"required" : true,
			type : "fut_popselect",//类型
			selectkey : "selfspid",//弹框类型
			textName : "shmfid_name", //文本显示字段
			beforefunc : "page.head_beforefunc",
			itemchangedfunc : "page.head_itemchanged",
			"enabled" : true,
		},{
			"label": "收货部门：",
			"name": "shmfid_code",
			"type": "TextBox",
			 "readOnly": true,
			"visible": false
		},{
			"label": "收货部门：",
			"name": "shmfid_name",
			"type": "TextBox",
			 "readOnly": true,
			"visible": false,
		},{
			"label" : "交货日期：",
			"type" : "DatePicker",
			"name" : "jhdate",
			"enabled" : "true",
			"format" : "yyyy-MM-dd",
			"required" : true,
			"defaultValue" : new Date(),
			"onvaluechanged" : "page.head_valuechanged",
		},{
			"label" : "交货地点：",
			"name" : "jhdd",
			"type" : "TextBox",
			"defaultValue" : "",
		},{
			"label" : "备注：",
			"name" : "memo",
			"type" : "TextBox",
			"defaultValue" : "",
			/*"style" : "width:60%;display:block;float:none",*/
		}, {
			"label" : "录入人：",
			"name" : "inputer_name",
			"type" : "TextBox",
			"defaultValue" : app.username,
			"readOnly" : true,
		}, {
			"label" : "录入人",
			"name" : "inputer",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
			"label" : "审核人：",
			"name" : "auditor_name",
			"type" : "TextBox",
			"readOnly" : true,
		},{
			"label" : "审核人姓名",
			"name" : "auditor",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
			"label" : "取消人：",
			"name" : "canceler_name",
			"type" : "TextBox",
			"readOnly" : true,
			"style" : "display:block;float:none",
		}, {
			"label" : "取消人姓名",
			"name" : "canceler",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
	        "label" : "录入日期：",
	        "type" : "DatePicker",
	        "name" : "inputdate",
	        "format" : "yyyy-MM-dd HH:mm:ss",
	        "defaultValue" : new Date(),
	        "readOnly" : "true",
	    },{
            "label": "审核日期：",
            "type": "DatePicker",
            "name": "auditdate",
            "format": "yyyy-MM-dd HH:mm:ss",
            "readOnly": "true",
	    },{
            "label": "取消日期：",
            "type": "DatePicker",
            "name": "canceldate",
            "format": "yyyy-MM-dd HH:mm:ss",
            "readOnly": "true",
            "style" : "display:block;float:none",
	    },{
			"label" : "数据来源：",
			"name" : "billsource",
			"type" : "ComboBox",
			"data" : billsource,
			"valueField" : "code",
			"textField" : "name",
			"defaultValue" : "2",
			"visible": false,
		} ]
	};

	// 明细 自定义名称
	bill.borderdetail = {
		"title" : '商品信息',// tab页面标题
		"name" : 'borderdetail',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('borderdetail'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"showPager" : false,
			"showSummaryRow" : true,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"ondrawsummarycell" : onDrawSummaryCell,
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			},{
				headerAlign : "center",
				header : "行号",
				displayField:"drowno",
				readOnly : true,
				width:50,
				align: "center",
				visible : false
			},{
				field: "gbid",
				name: "gbid",
				header: "商品编码",
				headerAlign: "center",
				/*allowSort: true,
				required: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "gbid",
                width: "130",
                editorSet: {
                    selectkey: 'goodsid',
                    textName :"gbid",
                    beforefunc:"page.det_beforefunc_gbid",
					itemchangedfunc:"page.det_itemchanged_gbid"
                },*/			    
			    width : 110,
			    align : "left",
			    readOnly: true,
			}, {
				field: "barcode",
				name: "barcode",
				header: "商品条码",
				headerAlign: "center",
				allowSort: true,
				required: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "barcode",
                width: "130",
                editorSet: {
                    selectkey: 'selfsupgoods',
                    multiSelect: true,
                    /*textName :"barcode",*/
                    beforefunc:"page.det_beforefunc_gbid",
					itemchangedfunc:"page.det_itemchanged_gbid"
                },
			},  {
				field : "gbname",
				header : "商品名称",
				headerAlign : "center",				    
			    width : 130,
			    align : "left",
			    readOnly: true,
			},{
				field : "issample",
				header : "是否样品",
				headerAlign : "center",
				width : 70,
				allowSort : true,
				type : "comboboxcolumn",
				textField : "name",
			  	valueField : "code",
				editor : OcmControl.newControl('ComboBox'),
				renderer: "OcmControl.dictRendererWithCode",
				data: istype,
				required: true,
				defaultValue : "N",				
			    align : "center",
			}, {
				field : "spec",
				header : "规格",
				headerAlign : "center",				    
			    width : 70,
			    align : "left",
			    readOnly: true,
			    visible : false,
			},{
				field : "bodppcode",
				header : "品牌",
				headerAlign : "center",				    
			    width : 120,
			    readOnly: true,
			    visible: false,
			}, {
				field : "ppname",
				name : "ppname",
				header : "品牌",
				readOnly : true,
				align : "left",
				width : 120,
			},{
				field : "catid",
				header : "商品类别",
				headerAlign : "center",				    
			    width : 120,
			    readOnly: true,
			    visible: false,
			    align : "left",
			}, {
				field : "catname",
				header : "商品类别",
				headerAlign : "center",				    
			    width : 120,
			    readOnly: true,
			    align : "left",
			},  {
				field : "gbsphs",
				header : "花色",
				width : 120,
				headerAlign : "center",
				readOnly : true,
				align : "left",
				visible : false,
			}, {
				field : "gbsphs_name",
				header : "花色",
				width : 120,
				headerAlign : "center",
				readOnly : true,
				align : "left",
			},{
				field : "gbspcm",
				header : "尺码",
				width : 120,
				headerAlign : "center",
				readOnly : true,
				align : "left",
				visible : false,
			}, {
				field : "gbspcm_name",
				header : "尺码",
				width : 120,
				headerAlign : "center",
				readOnly : true,
				align : "left",
			}, {
				field : "unit",
				name : "unit",
				header : "单位",
				editor: OcmControl.newControl('fut_popselectgrid'),
				width : 90,
				headerAlign : "center",
				align : "left",
				editorSet : {
					selectkey : "units",
					multiSelect: false,
					beforefunc : "page.det_beforefunc_units",
					itemchangedfunc:"page.det_itemchanged_units"
				},
				/*required: true,*/
			}, {
				field : "hl",
				header : "订货含量",
				headerAlign : "center",				    
			    width : 100,
			    editor : OcmControl.newControl('NumButtonEdit'),
				/*editorSet:{format: "c4",},
				numberFormat:"c4",*/
			    numberFormat:"#,##0.0000",
				defaultValue : "1",
				align : "right",
				readOnly : true,
			},  {
				field : "ysjs",
				header : "订货件数",
				headerAlign : "center",				    
			    width : 100,
			    editor : OcmControl.newControl('NumButtonEdit'),
				/*editorSet:{format: "c4",},
				numberFormat:"c4",*/
			    numberFormat:"#,##0.0000",
				defaultValue : "0",
				align : "right",
				required: true,
			}, {
				field : "yssl",
				header : "订货数量",
				headerAlign : "center",				    
			    width : 100,
			    editor : OcmControl.newControl('NumButtonEdit'),
				/*editorSet:{format: "c4",},
				numberFormat:"c4",*/
			    numberFormat:"#,##0.0000",
				align : "right",
				readOnly : true,
			},{
				field : "jxtax",
				header : "进项税率",
				headerAlign : "center",				    
			    width : 100,
			    align : "right",
			    type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'JXTAXRATE',
				allowSort: true,
				readOnly : true,
			}, {
				field : "hsjj",
				header : "含税进价",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				defaultValue : "0",
				align : "right",
				required: true,
			}, {
				field : "bhsjj",
				header : "不含税进价",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c4",},
				numberFormat:"c4",
				defaultValue : "0",
				align : "right",
				required: true,
			}, {
				field : "yshsjjje",
				header : "含税进价金额",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			}, {
				field : "ysbhsjjje",
				header : "不含税进价金额",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c4",},
				numberFormat:"c4",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			},{
				field : "ysjxse",
				header : "进项税额",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c4",},
				numberFormat:"c4",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			},{
				field : "kl",
				header : "倒扣毛利率",
				headerAlign : "center",
				editor : OcmControl.newControl('TextBox'),
				width : "110",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "p2",},
				numberFormat:"p2",
				defaultValue : "0",
				align : "right",
				readOnly : true,		
			},{
				field : "skl",
				header : " 顺加毛利率",
				headerAlign : "center",
				editor : OcmControl.newControl('TextBox'),
				width : 110,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "p2",},
				numberFormat:"p2",
				defaultValue : "0",
				align : "right",
				readOnly : true,		
			},{
				field : "sj",
				header : "售价",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			}, {
				field : "yssjje",
				header : "售价金额",
				headerAlign : "center",				    
			    width : 120,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			}, {
				field : "iszp",
				header : "是否赠品",
				headerAlign : "center",
				width : 80,
				allowSort : true,
				renderer: "OcmControl.dictRendererWithCode",
				data: istype,
				defaultValue : "N",
				visible: false,
			}]
		}
	};

	// 明细 自定义名称
	bill.borderdetailzp = {
		"title" : '赠品信息',// tab页面标题
		"name" : 'borderdetailzp',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('borderdetailzp'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"showPager" : false,
			"showSummaryRow" : true,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"ondrawsummarycell" : onDrawSummaryCellZp,
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			}, {
				field: "gbid",
				name: "gbid",
				header: "赠品商品编码",
				headerAlign: "center",
				allowSort: true,
				/*required: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "gbid",
                width: "130",
                editorSet: {
                    selectkey: 'goodsid',
                    textName :"gbid",
                    beforefunc:"page.det_beforefunc_gbid",
					itemchangedfunc:"page.det_itemchanged_gbidzp"
                },*/
				width : 110,
			    align : "left",
			    readOnly: true,
			}, {
				field: "barcode",
				name: "barcode",
				header: "赠品商品条码",
				headerAlign: "center",
				allowSort: true,
				required: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "barcode",
                width: "130",
                editorSet: {
                	selectkey: 'selfsupgoods',
                    multiSelect: true,
                    /*textName :"barcode",*/
                    beforefunc:"page.det_beforefunc_gbidzp",
					itemchangedfunc:"page.det_itemchanged_gbidzp"
                },
			},  {
				field : "gbname",
				header : "商品名称",
				headerAlign : "center",				    
			    width : 130,
			    align : "left",
			    readOnly: true,
			}, {
				field : "spec",
				header : "规格",
				headerAlign : "center",				    
			    width : 70,
			    align : "left",
			    readOnly: true,
			    visible :false,
			},{
				field : "ppcode",
				header : "品牌",
				headerAlign : "center",				    
			    width : 120,
			    readOnly: true,
			    visible: false,
			}, {
				field : "ppname",
				name : "bodppname",
				header : "品牌",
				readOnly : true,
				align : "left",
				width : 120,
			}, {
				field : "catid",
				header : "商品类别",
				headerAlign : "center",				    
			    width : 120,
			    readOnly: true,
			    visible: false,
			    align : "left",
			}, {
				field : "catname",
				header : "商品类别",
				headerAlign : "center",				    
			    width : 120,
			    readOnly: true,
			    align : "left",
			}, {
				field : "gbsphs",
				header : "花色",
				width : 120,
				headerAlign : "center",
				readOnly : true,
				align : "left",
				visible : false,
			}, {
				field : "gbsphs_name",
				header : "花色",
				width : 120,
				headerAlign : "center",
				readOnly : true,
				align : "left",
			},{
				field : "gbspcm",
				header : "尺码",
				width : 120,
				headerAlign : "center",
				readOnly : true,
				align : "left",
				visible : false,
			}, {
				field : "gbspcm_name",
				header : "尺码",
				width : 120,
				headerAlign : "center",
				readOnly : true,
				align : "left",
			}, {
				field : "unit",
				name : "unit",
				header : "单位",
				editor: OcmControl.newControl('fut_popselectgrid'),
				width : 90,
				headerAlign : "center",
				align : "left",
				editorSet : {
					selectkey : "units",
					multiSelect: false,
					beforefunc : "page.det_beforefunc_units",
					itemchangedfunc:"page.det_itemchanged_unitszp"
				},
				/*required: true,*/
			}, {
				field : "hl",
				header : "订货含量",
				headerAlign : "center",				    
			    width : 100,
			    editor : OcmControl.newControl('NumButtonEdit'),
//				editorSet:{format: "c4",},
//				numberFormat:"c4",
			    numberFormat:"#,##0.0000",
				defaultValue : "0",
				defaultValue : "1",
				align : "right",
				readOnly : true,
			},  {
				field : "ysjs",
				header : "订货件数",
				headerAlign : "center",				    
			    width : 100,
			    editor : OcmControl.newControl('NumButtonEdit'),
				/*editorSet:{format: "c4",},
				numberFormat:"c4",*/
			    numberFormat:"#,##0.0000",
				defaultValue : "0",
				defaultValue : "0",
				align : "right",
				required: true,
			}, {
				field : "yssl",
				header : "订货数量",
				headerAlign : "center",				    
			    width : 100,
			    editor : OcmControl.newControl('NumButtonEdit'),
				/*editorSet:{format: "c4",},
				numberFormat:"c4",*/
			    numberFormat:"#,##0.0000",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			},{
				field : "sj",
				header : "售价",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			}, {
				field : "yssjje",
				header : "售价金额",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			},{
				field : "jxtax",
				header : "进项税率",
				headerAlign : "center",				    
			    width : 100,
			    align : "right",
			    type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'JXTAXRATE',
				allowSort: true,
				readOnly : true,
			}, {
				field : "hsjj",
				header : "含税进价",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c4",},
				numberFormat:"c4",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			}, {
				field : "bhsjj",
				header : "不含税进价",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c4",},
				numberFormat:"c4",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			}, {
				field : "yshsjjje",
				header : "含税进价金额",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c4",},
				numberFormat:"c4",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			}, {
				field : "ysbhsjjje",
				header : "不含税进价金额",
				headerAlign : "center",				    
			    width : 110,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c4",},
				numberFormat:"c4",
				defaultValue : "0",
				align : "right",
				readOnly : true,
			},{
				field : "kl",
				header : "毛利率",
				headerAlign : "center",
				editor : OcmControl.newControl('TextBox'),
				width : "120",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "p2",},
				numberFormat:"p2",
				defaultValue : "0",
				align : "right",
				readOnly : true,		
			}, {
				field : "iszp",
				header : "是否赠品",
				headerAlign : "center",
				width : 80,
				allowSort : true,
				renderer: "OcmControl.dictRendererWithCode",
				data: istype,
				defaultValue : "Y",
				visible: false,
			}]
		}
	};

	// 明细 自定义名称
	bill.bordersettle = {
		"title" : '账期',// tab页面标题
		"name" : 'bordersettle',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"visible" : false,
		"properties" : {
			"id" : utils.createid('bordersettle'),
			"multiSelect" : "true",
			"allowCellEdit" : "false",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "false",
			"editNextRowCell" : "false",
			"allowSortColumn" : "false",
			"allowCellValid" : false,
			"showPager" : false,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ /*{
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			},*/ {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			}, {
				field : "bostype",
				header : "类别",
				width : 30,
				headerAlign : "center",
				readOnly : true,
				/*visible : false,*/
				Value : "1",
			},{
				field : "bossetseq",
				header : "结算序号",
				width : 30,
				headerAlign : "center",
				readOnly : true,
				/*visible : false,*/
				Value : "1",
			},{
				field : "bossetid",
				header : "结算方式",
				headerAlign : "center",				    
			    width : 40,
			    align : "left",
			    readOnly: true,
			},{
				field : "boszqts",
				header : "账期天数",
				headerAlign : "center",				    
			    width : 40,
			    editor : OcmControl.newControl('NumButtonEdit'),
			    numberFormat:"#,##0",
				defaultValue : "0",
				align : "right",
				readOnly: true,
			}, {
                field: "bosrate",
                header: "结算比率",
                headerAlign: "center",
				width: 60,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "p2",},
				numberFormat:"p2",
				value : "0",
				align : "right",
				vtype :"range:0,1",
				readOnly: true,
            },{
				field : "bosmoney",
				header : "结算金额",
				headerAlign : "center",				    
			    width : 60,
			    editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				value : "0",
				align : "right",
				readOnly : true,
				/*visible : false,*/
			}]
		}
	};
	
	function onDrawSummaryCell(e) {
    	var rows = e.data;
		var sumysjs = 0.0000;    var sumyssl = 0.0000;      var sumhsjj = 0.00;
		var sumbhsjj = 0.0000;   var sumyshsjjje = 0.00;	var sumysbhsjjje = 0.0000;
		var sumysjxse = 0.0000;  var sumsj = 0.00;    	    var sumyssjje = 0.00;
		if (rows.length > 0) {
			for ( var i = 0; i < rows.length; i++) {
				var row = rows[i];
				if (isNaN(row.ysjs) == false) {
					sumysjs += parseFloat(row.ysjs);
				}
				if (isNaN(row.yssl) == false) {
					sumyssl += parseFloat(row.yssl);
				}
				if (isNaN(row.hsjj) == false) {
					sumhsjj += parseFloat(row.hsjj);
				}
				if (isNaN(row.bhsjj) == false) {
					sumbhsjj += parseFloat(row.bhsjj);
				}
				if (isNaN(row.yshsjjje) == false) {
					sumyshsjjje += parseFloat(row.yshsjjje);
				}
				if (isNaN(row.ysbhsjjje) == false) {
					sumysbhsjjje += parseFloat(row.ysbhsjjje);
				}
				if (isNaN(row.ysjxse) == false) {
					sumysjxse += parseFloat(row.ysjxse);
				}
				if (isNaN(row.sj) == false) {
					sumsj += parseFloat(row.sj);
				}
				if (isNaN(row.yssjje) == false) {
					sumyssjje += parseFloat(row.yssjje);
				}
			}
		}
		if (e.field == "hl") {
			e.cellHtml = "<b>"+"合计: "+"</b>";
		}
		if (e.field == "ysjs") {
			e.cellHtml ="<b>"+ sumysjs.toFixed(4)+"</b>";
		}
		if (e.field == "yssl") {
			e.cellHtml ="<b>"+ sumyssl.toFixed(4)+"</b>";
		}
		/*if (e.field == "hsjj") {
			e.cellHtml ="<b>"+ sumhsjj.toFixed(2)+"</b>";
		}
		if (e.field == "bhsjj") {
			e.cellHtml ="<b>"+ sumbhsjj.toFixed(4)+"</b>";
		}*/
		if (e.field == "yshsjjje") {
			e.cellHtml ="<b>"+ sumyshsjjje.toFixed(2)+"</b>";
		}
		if (e.field == "ysbhsjjje") {
			e.cellHtml ="<b>"+ sumysbhsjjje.toFixed(4)+"</b>";
		}
		if (e.field == "ysjxse") {
			e.cellHtml ="<b>"+ sumysjxse.toFixed(2)+"</b>";
		}
		if (e.field == "sj") {
			e.cellHtml ="<b>"+ sumsj.toFixed(2)+"</b>";
		}
		if (e.field == "yssjje") {
			e.cellHtml ="<b>"+ sumyssjje.toFixed(2)+"</b>";
		}
		e.cellStyle = "text-align:right";
    };
	
    function onDrawSummaryCellZp(e) {
    	var rows = e.data;
		var sumysjs = 0.0000;    var sumyssl = 0.0000;   var sumsj = 0.00;   var sumyssjje = 0.00;
		if (rows.length > 0) {
			for ( var i = 0; i < rows.length; i++) {
				var row = rows[i];
				if (isNaN(row.ysjs) == false) {
					sumysjs += parseFloat(row.ysjs);
				}
				if (isNaN(row.yssl) == false) {
					sumyssl += parseFloat(row.yssl);
				}	
				if (isNaN(row.sj) == false) {
					sumsj += parseFloat(row.sj);
				}
				if (isNaN(row.yssjje) == false) {
					sumyssjje += parseFloat(row.yssjje);
				}
			}
		}
		if (e.field == "hl") {
			e.cellHtml = "<b>"+"合计: "+"</b>";
		}
		if (e.field == "ysjs") {
			e.cellHtml ="<b>"+ sumysjs.toFixed(4)+"</b>";
		}
		if (e.field == "yssl") {
			e.cellHtml ="<b>"+ sumyssl.toFixed(4)+"</b>";
		}
		if (e.field == "sj") {
			e.cellHtml ="<b>"+ sumsj.toFixed(2)+"</b>";
		}
		if (e.field == "yssjje") {
			e.cellHtml ="<b>"+ sumyssjje.toFixed(2)+"</b>";
		}
		e.cellStyle = "text-align:right";
    };
    
	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData,btn.editData, btn.saveData, btn.delData,btn.separator,btn.auditData,btn.cancelData,btn.searchData,
			    btn.separator,{'text': '打印商品条码','iconCls': 'icon-print','name': 'printGoods',billstatus: 'Y,O',ibediting: 'N',tabindex: '1'},
			   {'text': '打印物价标签','iconCls': 'icon-print','name': 'printPrice',billstatus: 'Y,O',ibediting: 'N',tabindex: '1'}]
	}

	var borderdet = [ bill.borderdetail,bill.borderdetailzp,bill.bordersettle];
	
	// 单据配置
	bill.billconfig = {
		billhead : bill.borderhead, // 单据主表
		billdetail : borderdet, // 单据明细表
		billquerylist : bill.borderlist,// 查询列表
		dettabpages : borderdet,// 要放入明细TAB列表的组件
		defaultmoduleid : app.modulecode,// 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})();
