mini.parse();
var gridbox1 = mini.get("gridbox1");// 单据列表
var details1 = mini.get("details1");// 单据明细
var tabs1 = mini.get("tabs1");
var tabs2 = mini.get("tabs2");
var bsupmkt = mini.get("bsupmkt");// 门店
var bsuplinkman = mini.get("bsuplinkman");// 联系人
var bsupplierqc = mini.get("bsupplierqc");// 资质证明
var bsupplierpp = mini.get("bsupplierpp");// 品牌
var photoPanel = mini.get("photoPanel");
var appendix = new mini['appendixcontrol'];
var token = getUrlParam("token");// token值

//tab页面切换的时候，需要绑定自定义控件的数据集
if (tabs1) {
	tabs1.on('activechanged', function(e) {
		// 重写了父类的按钮，必须根据规则来控制选择商品按钮的状态。如果页面不存在会自动查找基类中定义的规则
		var _toolbar = mini.get("config1_toolbar");
		var status = _toolbar.configStatus;
		_toolbar.changedStatus(status);

		if (e.tab.name == "details") {
			setBillData();
		}
	});
}



//带入条件查询
function head_beforefunc(e) {
	var buttonEdit = e.sender;
	if (!e.searchParam) {
		e.searchParam = {};
	}
	var buttonEdit = e.sender;
	
	if (e.value != "undefined" && e.value != ""){
		e.searchParam.code = e.value;
	}
	// 根据品牌过滤经营种类
	if (buttonEdit.name == "mcid") {
		var ppcode = mini.getbyName("ppcode"); // 获取品牌
		if (ppcode.value == "") {
			mini.alert("请先选择品牌");
			return -1;
		}
		e.searchParam.ppcode = ppcode.value;
	} else if (buttonEdit.name == "province") {
		e.searchParam.crclass = "1";
		
	} else if (buttonEdit.name == "city") {
		var province = mini.getbyName("province");
		if (province.getValue() == "") {
			mini.alert("请先选择省份");
			return -1;
		}
		e.searchParam.crpcode = province.getValue();
	}	
	return 0;
}

//单头品牌回填值
function head_itemchanged_ppcode(e, data) {
	if (data != null) {
		// 查询出原单明细
		var oldppcode = e.sender.value;
		supplierpp(data,oldppcode);
		if (mini.getbyName("mcid") && data[0].mcid && data[0].mcid != "") {
			mini.getbyName("mcid").setValue(data[0].mcid);
			mini.getbyName("mcid").setText(data[0].mcid_name);
		}
	}
	return 0;
}

//查询出原单明细
function supplierpp(data,oldppcode) {
	var bsupplierpp = mini.get("bsupplierpp");
	var form = details1.form;
	var tempsbid = form.getField("sbid").getValue();
	if (data.length > 0) {
		// 不允许添加重复费用项目
		var boolean = false;
		var exitGood = "";
		var maxrow = 0;
		var exitDatas = bsupplierpp.getData();
		for (var j = 0; j < data.length; j++) {
			for (var i = 0; i < exitDatas.length; i++) {
				if (exitDatas[i].ppcode == data[j].ppcode) {
					exitGood = exitGood + "["
							+ data[j].ppcode + "],";
					boolean = true;
					break;
				}
			}
			if (!boolean) {
				if (exitDatas.length >= 1) {
					for (var l = 0; l < exitDatas.length; l++) {
						if (exitDatas[l].ppcode == oldppcode) {
							var oldrow = {
									sbid:tempsbid,
									ppcode : data[j].ppcode,
									ppcode_name : "[" + data[j].ppcode + "]" + data[j].ppcname,
									lastmoder : getUserCode(),
									lastmoddate : mini.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss"),
									modflag : "M",
							}
							bsupplierpp.updateRow(exitDatas[l], oldrow);
						}
						
					}
				}
				else {
				var newrow = {
					sbid:tempsbid,
					ppcode : data[j].ppcode,
					ppcode_name : "[" + data[j].ppcode + "]" + data[j].ppcname,
					lastmoder : getUserCode(),
					lastmoddate : mini.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss"),
					modflag : "I",
				};
				bsupplierpp.addRow(newrow);
				}
			} else {
				/* supsetdepositdet.rejectRecord(row); */
				var uptdaterow = {
						modflag : "M",
				}
				bsupplierpp.updateRow(exitDatas[i], uptdaterow);
				boolean = false;
			}

		}
		if (exitGood != "" && exitGood.length > 1) {
			mini.alert("明细中已有相同主营品牌:"
					+ exitGood.substring(0,
							exitGood.length - 1));
		}
	}
}



//单头主营业种回填值
function head_itemchanged_mcid(e, data) {
	if (data != null) {
		// 查询出原单明细
	}
	return 0;
}

//自定义页面数据回填
function setBillData(flag) {
	var _details = mini.get("details1");
	var _datas = {};
	if (_details) {
		_datas = _details.config.data;
	}
	if (_datas && jQuery.isEmptyObject(_datas) == false) {
		var form = details1.form;
		
		//供应商编码
		form.getField("supid").setText("[" + _datas["sbid"] + "]" + _datas["sbcname"]);
		
		//商户编码
		form.getField("sbid").setText( _datas["sbid"]);
		
		//主营品牌
		if(_datas["ppcode"]){
			form.getField("ppcode").setText( _datas["ppcode_name"]);
		}
		//主营业种
		if(_datas["mcid"]){
			form.getField("mcid").setText( _datas["mcid_name"]);
		}
		//省
		if(_datas["province"]){
			form.getField("province").setText( _datas["province_name"]);
		}
		//市
		if(_datas["city"]){
			form.getField("city").setText( _datas["city_name"]);
		}
		
		if (_datas["fplx"] == "2") {
			   mini.getbyName("sbfp").setRequired(true);
			   setStatus(true);
	    } 
	    if(_datas["fplx"] == "1") {
	    	   mini.getbyName("sbfp").setRequired(true);
	    	   setStatus(false);
	    }
	    if(_datas["fplx"] == "" || _datas["fplx"] ==undefined) {
	    	   mini.getbyName("sbfp").setRequired(false);
	    	   setStatus(false);
	    }
	}
}

//回填供应商及明细数据
function setSupData(sbid){
	if(sbid){
		var searchParam = {"sbid" : sbid};
		var method = "mall.mdm.sup.get";
		itemLoader.doRequest(OmdUrl.mallmdm, method,searchParam, null, null, function(data) {
		 
			if (data && data.supplierbase) {
				var form = details1.form;
		        form.getField("sbid").setValue(data.supplierbase.sbid);
		        form.getField("sbid").setText(data.supplierbase.sbid);
		        form.getField("sbcname").setValue(data.supplierbase.sbcname);
		        form.getField("sbename").setValue(data.supplierbase.sbename);
		        form.getField("sbstatus").setValue(data.supplierbase.sbstatus);
		        form.getField("ppcode").setValue(data.supplierbase.ppcode);
		        form.getField("ppcode").setText(data.supplierbase.ppcode_name);
		        form.getField("oik").setValue(data.supplierbase.oik);
		        form.getField("sbdz").setValue(data.supplierbase.sbdz);
		        form.getField("mcid").setValue(data.supplierbase.mcid);
		        form.getField("mcid").setText(data.supplierbase.mcid_name);
		        form.getField("qyxz").setValue(data.supplierbase.qyxz);
		        form.getField("taxlevel").setValue(data.supplierbase.taxlevel);
		        form.getField("sbnature").setValue(data.supplierbase.sbnature);
		        form.getField("agentlevel").setValue(data.supplierbase.agentlevel);
		        form.getField("currency").setValue(data.supplierbase.currency);
		        form.getField("regcapital").setValue(data.supplierbase.regcapital);
		        form.getField("frdb").setValue(data.supplierbase.frdb);
		        form.getField("frid").setValue(data.supplierbase.frid);
		        form.getField("sbadd").setValue(data.supplierbase.sbadd);
		        form.getField("sbfp").setValue(data.supplierbase.sbfp);
		        form.getField("sbfpadd").setValue(data.supplierbase.sbfpadd);
		        form.getField("province").setValue(data.supplierbase.province);
		        form.getField("province").setText(data.supplierbase.bprovince_name);
		        form.getField("city").setValue(data.supplierbase.city);
		        form.getField("city").setText(data.supplierbase.bcity_name);
		        form.getField("sbeadd").setValue(data.supplierbase.sbeadd);
		        form.getField("frdbename").setValue(data.supplierbase.frdbename);
		        form.getField("phone").setValue(data.supplierbase.phone);
		        form.getField("sbwmid4").setValue(data.supplierbase.sbwmid4);
		        form.getField("sbwmid5").setValue(data.supplierbase.sbwmid5);
		        form.getField("taxno").setValue(data.supplierbase.taxno);
		        ////
		        form.getField("sbbank").setValue(data.supplierbase.sbbank);
		        form.getField("sbaccount").setValue(data.supplierbase.sbaccount);
		        form.getField("payee").setValue(data.supplierbase.payee);
		        form.getField("supid").setValue(data.supplierbase.supid);
		        form.getField("jyms").setValue(data.supplierbase.jyms);
		        form.getField("fplx").setValue(data.supplierbase.fplx);
		        form.getField("sbwmid1").setValue(data.supplierbase.sbwmid1);
		        form.getField("sbwmid2").setValue(data.supplierbase.sbwmid2);
		        form.getField("sbwmid3").setValue(data.supplierbase.sbwmid3);
		        form.getField("introductiondate").setValue(data.supplierbase.introductiondate);
		        form.getField("sbyt").setValue(data.supplierbase.sbyt);
		        form.getField("registerdate").setValue(data.supplierbase.registerdate);
		        form.getField("trademark").setValue(data.supplierbase.trademark);
		        form.getField("scope").setValue(data.supplierbase.scope);
		        form.getField("scale").setValue(data.supplierbase.scale);
		        form.getField("applicabletax").setValue(data.supplierbase.applicabletax);
		        form.getField("arrivaldays").setValue(data.supplierbase.arrivaldays);
		        form.getField("sbdhzq").setValue(data.supplierbase.sbdhzq);
		        ////
		        
		        if (data.supplierbase.supmkt) {
					for (var i = 0; i < data.supplierbase.supmkt.length; i++) {
						data.supplierbase.supmkt[i].ph_key = "";
						data.supplierbase.supmkt[i].modflag = "I";
						data.supplierbase.supmkt[i].browno = i;
					}
		        	bsupmkt.addRows(data.supplierbase.supmkt);
				}
		        if (data.supplierbase.suplinkman) {
		        	for (var i = 0; i < data.supplierbase.suplinkman.length; i++) {
						data.supplierbase.suplinkman[i].ph_key = "";
						data.supplierbase.suplinkman[i].modflag = "I";
						data.supplierbase.suplinkman[i].browno = i;
						data.supplierbase.suplinkman[i].lastmoder = getUserCode();
						data.supplierbase.suplinkman[i].lastmoddate = mini.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss");
		        	}
		        	bsuplinkman.addRows(data.supplierbase.suplinkman);
		        }
		        if (data.supplierbase.supplierqc) {
		        	for (var i = 0; i < data.supplierbase.supplierqc.length; i++) {
						data.supplierbase.supplierqc[i].ph_key = "";
						data.supplierbase.supplierqc[i].modflag = "I";
						data.supplierbase.supplierqc[i].browno = i;
						data.supplierbase.supplierqc[i].lastmoder = getUserCode();
						data.supplierbase.supplierqc[i].lastmoddate = mini.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss");
		        	}
		        	bsupplierqc.addRows(data.supplierbase.supplierqc);
		        }
		        if (data.supplierbase.supplierpp) {
		        	for (var i = 0; i < data.supplierbase.supplierpp.length; i++) {
						data.supplierbase.supplierpp[i].ph_key = "";
						data.supplierbase.supplierpp[i].modflag = "I";
						data.supplierbase.supplierpp[i].browno = i;
						data.supplierbase.supplierpp[i].lastmoder = getUserCode();
						data.supplierbase.supplierpp[i].lastmoddate = mini.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss");
		        	}
		        	bsupplierpp.addRows(data.supplierbase.supplierpp);
		        }
			}
		});
		
	
	}
}

OcmControl.toolbarFn.editDataBefore = function(){

   return {};
};

OcmControl.toolbarFn.delDataBefore = function(){

	 var form = details1.form;
	 var billsource = form.getField("billsource").getValue();
	 if (billsource == "01") {
		 mini.alert("不允许删除移动端的数据，请重新选择单据");
		 return;
	 }
  return {};
};

//新增按钮后事件
OcmControl.toolbarFn.addDataAfter = function(){
    var form = details1.form;

    form.getField("inputer").setValue(getUserCode());
    form.getField("inputer_name").setValue(getUserName());// 录入人
    form.getField("inputdate").setValue(new Date());// 录入日期
    mini.getbyName("sbid").set({"readOnly":false, "enabled":true});
    
};

//保存按钮前事件
OcmControl.toolbarFn.saveDataBefore = function(){
	var obj = {};
	var ismr = true;
	var count = 0;
	obj.lastmoder = getUserCode();
	obj.lastmoddate = mini.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss");
	 var form = details1.form;
	 
	    //必须入力check;
	    form.validate();
		if (form.isValid() == false) {
			mini.alert("请先输入表头必填项目");
			return;
		}
	var sbwmid1 = mini.getbyName("sbwmid1").value;
	var sbwmid2 = mini.getbyName("sbwmid2").value;
	var sbwmid3 = mini.getbyName("sbwmid3").value;
	var sbwmid4 = mini.getbyName("sbwmid4").value;
	var sbwmid5 = mini.getbyName("sbwmid5").value;
	if(sbwmid5=='N' && sbwmid4=='N'){
		mini.alert("至少选择一种【经营方式】!!!");
		return;
	}
	var detData = bsupplierqc.getData();
	for (var i = 0; i < detData.length; i++) {
		var sqtype = detData[i].sqtype;
		if (!detData[i].muid) {
			mini.alert("资质证明明细第" + (i + 1) + "行门店为空，请检查");
			return;
		}
		if (!sqtype) {
			mini.alert("资质证明明细第" + (i + 1) + "行资质类型为空，请检查");
			return;
		}
		
		if (!detData[i].sqno) {
			mini.alert("资质证明明细第" + (i + 1) + "行证件号码为空，请检查");
			return;
		}
		
		if (!detData[i].sqfzjg) {
			mini.alert("资质证明明细第" + (i + 1) + "行发证机关为空，请检查");
			return;
		}
		
		if (!detData[i].sqeffdate) {
			mini.alert("资质证明明细第" + (i + 1) + "行有效截止日期为空，请检查");
			return;
		}
		
		if (!detData[i].sqstartdate) {
			mini.alert("资质证明明细第" + (i + 1) + "行发证日期为空，请检查");
			return;
		}
		
		if (!detData[i].squrl) {
			var newrow = {};
			newrow.squrl = getSqurl();
			bsupplierqc.updateRow(detData[i],newrow);
		}
		
	}
	
	var _skman = bsuplinkman.getData();
	if (_skman.length > 0) {
		var md=[];
		for (var i = 0; i < _skman.length; i++) {
			if (!_skman[i].muid) {
				mini.alert("联系人明细第" + (i + 1) + "行门店为空，请检查");
				return;
			}
			if (!_skman[i].linkman) {
				mini.alert("联系人明细第" + (i + 1) + "行联系人为空，请检查");
				return;
			}
			if (_skman[i].mrlinkman == 'Y') {
				ismr = false;
				count ++;
			}
			if(md.length<=0){
				md.push({"muid":_skman[i].muid_name,"zcnt":1,"lxr_cnt":(_skman[i].mrlinkman == 'Y')?1:0});
			}else{
				var n =false;
				for(var j=0;j<md.length;j++){
					if(md[j].muid ==_skman[i].muid_name){
						md[j].zcnt =md[j].zcnt+1;
						if(_skman[i].mrlinkman == 'Y'){
							md[j].lxr_cnt =md[j].lxr_cnt+1;
						}
						n =true;
					}
				}
				if(n ==false){
					md.push({"muid":_skman[i].muid_name,"zcnt":1,"lxr_cnt":(_skman[i].mrlinkman == 'Y')?1:0});
				}
			}
			if (_skman[i].mrlinkman == 'Y') {
				ismr = false;
				count ++;
			}
		}
		for(var i=0;i<md.length;i++){
			if(md[i].lxr_cnt >1){
				mini.alert("门店【"+md[i].muid+"】默认的联系人只需要一个，请检查");
				return;
			}else if(md[i].lxr_cnt <1){
				mini.alert("门店【"+md[i].muid+"】需要一个默认的联系人，请检查");
				return;
			}
			
		}
	}
	obj.billtype=getBilltype(billmoduleid);
	if (bsupmkt) {
		obj.bsupmkt = bsupmkt.getChanges();
		setGridData(obj.bsupmkt);
	}
	if (bsuplinkman) {
		obj.bsuplinkman = bsuplinkman.getChanges();
		setGridData(obj.bsuplinkman);
	}
	if (bsupplierqc) {
		obj.bsupplierqc = bsupplierqc.getChanges();
		setGridData(obj.bsupplierqc);
	}
	if (bsupplierpp) {
		obj.bsupplierpp = bsupplierpp.getChanges();
		setGridData(obj.bsupplierpp);
	}
	return obj;
	
};

//保存按钮后事件
OcmControl.toolbarFn.saveDataAfter = function() {
	setBillData();
};

//审核按钮后事件
OcmControl.toolbarFn.auditDataAfter = function() {
	setBillData();
};

// 取消按钮后事件
OcmControl.toolbarFn.cancelDataAfter = function() {
	setBillData();
};

// 明细增行按钮前事件
OcmControl.toolbarFn.addRowBefore = function() {
	var form = details1.form;
	var sbid = form.getField("sbid").getValue();
	var obj = {
		"modflag" : "I",
		"sbid" : sbid
	};

	var tab = tabs2.getActiveTab();
	if (tab) {
		if (tab.name == "bsuplinkman" || tab.name == "bsupplierqc" || tab.name == "bsupplierpp") {
			obj.lastmoder = getUserCode();
			obj.lastmoddate = mini.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss"); 
		}
		var ismr = true;
		if(tab.name == "bsuplinkman"){
			var _data = bsuplinkman.getData();
			if (_data.length > 0){
				for( var i = 0; i < _data.length; i++){
					if(_data[i].mrlinkman == 'Y'){
						ismr = false;
					}
			    }
			} else {
				var ppcode = form.getField("ppcode").getValue();
				var brandlinkmans = getbrandlinkman(ppcode);
				if (brandlinkmans && brandlinkmans.length > 0) {
					addrowstosuplinkman(brandlinkmans);
					return;
				}
			}
			if (ismr) {
				obj.mrlinkman = 'Y';
			};
		  };
	}
	return obj;
};

//明细删除按钮前事件
OcmControl.toolbarFn.delRowBefore = function(){
	var obj={};
	var tabs2 = mini.get("tabs2");
	var tab = tabs2.getActiveTab();
	if (tab){
		if (tab.name =="bsupmkt") {
			var bsupmkt = mini.get("bsupmkt");
			var data  = bsupmkt.getData();
			var rows = bsupmkt.getSelected();
			if (data.length <= 1) {
				mini.alert("门店信息不能为空");
				return;
			};
		}
		if (tab.name =="bsuplinkman" || tab.name =="bsupplierqc") {
			var tabgrid = mini.get(tab.name);
			var rows = tabgrid.getSelecteds();
			if (tab.name == "bsupplierqc") {
				if (rows.length > 0) {
					delSqul(rows);
				}
			}
			if(rows.length > 0){
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if(row.modflag == "I"){
						var newrow ={flag :"D"};
						tabgrid.updateRow(row, newrow);
						tabgrid.removeRow(row);
					}else{
						var newrow ={modflag :"D"};
						tabgrid.updateRow(row, newrow);
						tabgrid.removeRow(row);
						
					}
				}
				return;
			}
		}
		if (tab.name =="bsupplierpp") {
			var tabid = mini.get(tab.name);
			var ppcode = mini.getbyName("ppcode"); // 获取门店
			var data  = bsupplierpp.getData();
			var rows = bsupplierpp.getSelected();
			if (rows.ppcode == ppcode.value) {
				mini.alert("单头主营品牌不能删除");
				return;
			}
			if(rows.length > 0){
	    		for ( var i = 0; i < rows.length; i++) {
	    			var row = rows[i];
	    			if(row.modflag == "I"){
	    				var newrow ={flag :"D"};
	    				tabid.updateRow(row, newrow);
	    				tabid.removeRow(row);
	    			}else{
	    				var newrow ={modflag :"D"};
	    				tabid.updateRow(row, newrow);
	    				tabid.removeRow(row);
	    				
	    			}
	    		}
	    		return;
	    	}
		}
	}
	return obj;
};

// 供应商编码点击
function onSupidClick(e) {
	var buttonEdit = e.sender;
	mini.open({
		url : encodeURI("/mall-business-ui/pages/common/gridbox-view.jsp?key=vendor2"
				+ "&token=" + token),
		title : "供应商编码",
		width : 600,
		height : $(window).height() * 0.8,
		onload : function() {
			var iframe = this.getIFrameEl();
			var data = {"searchParam":{"sbstatus" : {"$in" : "Y,M"}}};
			iframe.contentWindow.SetData(data);
		},
		ondestroy : function(data) {
			if (data != "close") {
				if (data.length > 0) {
					buttonEdit.setValue(data[0].sbid);
                    buttonEdit.setText("[" + data[0].sbid + "]" + data[0].sbcname);
                    buttonEdit.setIsValid(true);
                    
                    setSupData(data[0].sbid);
				}
			}
		}
	});
}

//供应商编码输入
function onSupidChange(e){

	var buttonEdit = e.sender;
	var text = buttonEdit.getText();
	if (text == null || text == "") {
		buttonEdit.setValue("");
	} else {
		var searchParam = {"sbstatus" : {"$in" : "Y,M"},"sbid":text};
		var method = "mss.supplier.supplierbase.search";
		itemLoader.doRequest(OmdUrl.mall, method, searchParam, null, null,
				function(data) {
					var data = data.supplierbase;
					if (data.length > 0) {
						buttonEdit.setValue(data[0].sbid);
						buttonEdit.setText(data[0].sbid);
	                    buttonEdit.setText("[" + data[0].sbcdoe + "]" + data[0].sbcname);
	                    
	                    setSupData(data[0].sbid);
					} else {
						mini.alert("供应商编码[" + text + "]不存在");
						buttonEdit.setValue("");
						buttonEdit.setText("");
					}
				}, null, null, false);
	}
}

function onCellEndEdit(e){
	var field = e.field;
    var row = e.row;
    var rows = bsuplinkman.getData();
    if (e.value == 'Y') {
    	if (field == "address") {
    		for (var i = 0; i < rows.length; i++) {
				if (rows[i].muid == row.muid && rows[i].address == e.value && rows[i]._id != row._id) {
					mini.alert("同门店只允许选择一个联系人快递地址！");
					bsuplinkman.updateRow(row,{"address":"N"});
					return;
					}
	    	}
	    };
	    if(field == "mrlinkman"){
    		for (var i = 0; i < rows.length; i++) {
    			if(rows.length>=2){
    				for (var j = i+1; j < rows.length; j++) {
    					if(rows[i].muid == rows[j].muid && rows[i].mrlinkman ==rows[j].mrlinkman){
    						mini.alert("同门店只允许选择一个默认联系人！");
    						bsuplinkman.updateRow(row,{"mrlinkman":"N"});
    						return;
    					}
//    					if ( rows[i].mrlinkman == e.value && rows[i]._id != row._id) {
//    						mini.alert("同门店只允许选择一个默认联系人！");
//    						bsuplinkman.updateRow(row,{"mrlinkman":"N"});
//    						return;
//    					}
        			}
    			}
	    	}
	    };
	}
}

//单元格修改
function onCellCommitEdit (e) {
    var row = e.row;
    var grid = e.sender;
    if(row.modflag == "N"){
    	var newRow = {"modflag":"M"};
        grid.updateRow(row,newRow);
    }
}

//单元格编辑前
function onCellbeginedit(e){
	var row = e.record;

	if(row.modflag == "D"){
		row.readOnly = true;
		row.Enabled = false;
		e.cancel = true;
	}else{
		row.readOnly = false;
		e.cancel = false;
	}
	
	var field = e.field;
	if (field == "issend") {
		if (!row.emailaddr){
			mini.alert("请先输入邮箱地址");
			e.cancel = true;
		}
	}
	if (field == "address") {
		if (!row.linkman){
			mini.alert("请先输入联系人");
			e.cancel = true;
			return;
		}
		if (!row.lmadd){
			mini.alert("请先输入联系地址");
			e.cancel = true;
			return;
		}
		if (!row.lmphone){
			mini.alert("请先输入联系人电话");
			e.cancel = true;
			return;
		}
		
		
	}
	return;
}

if (bsupmkt) {
	bsupmkt.on("cellcommitedit", onCellCommitEdit);
	bsupmkt.on("cellbeginedit", onCellbeginedit);
}
if (bsuplinkman) {
	bsuplinkman.on("cellendedit", onCellEndEdit);
	bsuplinkman.on("cellcommitedit", onCellCommitEdit);
	bsuplinkman.on("cellbeginedit", onCellbeginedit);
	
}
if (bsupplierqc) {
	bsupplierqc.on("cellcommitedit", onCellCommitEdit);
	bsupplierqc.on("cellbeginedit", onCellbeginedit);
}
if (bsupplierpp) {
	bsupplierpp.on("cellcommitedit", onCellCommitEdit);
	bsupplierpp.on("cellbeginedit", onCellbeginedit);
}

//上传图片
function upPhoto() {
	var form = details1.form;
	var billno = form.getField("billno").getValue();
	if (billno == "" || billno == undefined) {
		mini.alert("请先保存单据");
		return;
	}
	
	var rows = bsupplierqc.getSelecteds();
	if(rows.length != 1){
		mini.alert("请选择资质证明一行记录");
		return ;
	}
	var flag = true;
	var squrl;
	squrl = rows[0].squrl;
	/*var sqstatus = rows[0].sqstatus;
	if (sqstatus == "C") {
		mini.alert("资质审核已通过，不允许上传附近");
		return;
	}*/
	if (squrl == "" || squrl == undefined) {
		flag = false;
		squrl = getSqurl();
	}
	var billstatus = form.getField("billstatus").getValue();
	Future.Pub.addfile(squrl,billmoduleid,billstatus,function(data){
		if (data.returncode == "0"){
			mini.alert("上传成功！");
		}
	});
	
	if (!flag) {
		bsupplierqc.updateRow(rows[0],{"squrl":squrl,"issqurl":"1"});
	}
}

//检查数据
function checkQcDate(row){
	var form = details1.form;
	var billno = form.getField("billno").getValue();
	if (billno == "" || billno == undefined) {
		mini.alert("请先保存单据");
		return false;
	}
	if(!row.sqstatus || row.sqstatus == "C"){
		mini.alert("已经资质审核过，请重新选择");
		return false;
	}
	
	if(!row.muid_name || row.muid_name == ""){
		mini.alert("门店不能为空");
		return false;
	}
	if(!row.sqtype || row.sqtype == ""){
		mini.alert("资质类型不能为空");
		return false;
	}
	if(!row.sqno || row.sqno == ""){
		mini.alert("证件号码不能为空");
		return false;
	}
	if(!row.sqfzjg || row.sqfzjg == ""){
		mini.alert("发证机关不能为空");
		return false;
	}
	if(!row.sqeffdate || row.sqeffdate == ""){
		mini.alert("有效截止日期不能为空");
		return false;
	}
	if(!row.sqstartdate || row.sqstartdate == ""){
		mini.alert("发证日期不能为空");
		return false;
	}
	if (!row.ph_key) {
		mini.alert("请先保存商户资质证明");
		return false;
	}
	return true;
}

//资质类型值改变
function onSqtypeChange(e){
	var row = bsupplierqc.getSelected();
    var sqData = bsupplierqc.getData();
    var value = e.value;
    var editor = e.sender;
    for ( var i = 0; i < sqData.length; i++) {
		if (row._id !=sqData[i]._id &&  sqData[i].sqtype == value && sqData[i].muid == row.muid) {
			editor.setValue(row.sqtype);
			mini.alert("资质类型已添加");
			return;
		}
	}
}

// 有效截止日期输入
function onSqeffChange(e){
    var value = e.value;
    var editor = e.sender;
    var row = bsupplierqc.getSelected();
	var sqstartdate = row.sqstartdate;
	if(value != "" || sqstartdate != ""){
		value = mini.formatDate(value,"yyyy-MM-dd");
		if(value < sqstartdate){
			editor.setValue(row.sqeffdate);
			mini.alert("有效截止日期必须大于发证日期");
			return;
		}
	}
}

//发证日期输入
function onSqstartChange(e){
	var row = bsupplierqc.getSelected();
    var value = e.value;
    var editor = e.sender;
	var sqeffdate = row.sqeffdate;
	if(value != "" || sqeffdate != ""){
		value = mini.formatDate(value,"yyyy-MM-dd");
		if(sqeffdate < value){
			editor.setValue(row.sqstartdate);
			mini.alert("有效截止日期必须大于发证日期");
			return;
		}
	}
}

//证件号码输入
function onSqnoChange(e){
	var row = bsupplierqc.getSelected();
    var sqData = bsupplierqc.getData();
    var value = e.value;
    var editor = e.sender;
    for ( var i = 0; i < sqData.length; i++) {
		if (sqData[i].sqno == value) {
			editor.setValue(row.sqno);
			mini.alert("证件号码已添加");
			return;
		}
	}
    
    var searchParam = {"sqno" : value};
	var method = "mss.supplier.bsupplierbase.checkSqno";
	itemLoader.doRequest(OmdUrl.mall, method, searchParam, null, null,
			function(data) {
				var num = data.num;
				if (num > 0) {
					editor.setValue(row.sqno);
					mini.alert("证件号码已存在");
					return;
				}
			}, null, null, false);
}

function addPhoto(){
	mini.open({
		url : encodeURI("/mall-business-ui/pages/supplier/sqctemplet-view.jsp?token=" + token),
		title : "资质模板",
		width : 800,
		height : $(window).height()* 0.8,
		onload : function() {
			var iframe = this.getIFrameEl();
			var data = {};
			iframe.contentWindow.SetData(data);
		},
		ondestroy : function(data) {
			if (data != "close") {
				if (data.length > 0) {
					var bsupplierqcdata = bsupplierqc.getData();
					
					var form = details1.form;
					var sbid = form.getField("sbid").getValue();
					
					for ( var j = 0; j < data.length; j++) {
						var sqcdrow = data[j];
						var flag = false;
						for (var i = 0; i < bsupplierqcdata.length; i++){
							var bsupplierqcrow = bsupplierqcdata[i];
							if(sqcdrow.sqtype == bsupplierqcrow.sqtype){
								flag = true;
							}
						}
						if(flag == false){
							var newrow = {
								"modflag" : "I",
								"sbid" : sbid,
								"sqstatus":"N",
								"issqurl":"0"
							};
							newrow.lastmoder = getUserCode();
							newrow.lastmoddate = mini.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss");
							newrow.sqtype = sqcdrow.sqtype;
							bsupplierqc.addRow(newrow);
						}
						
					}
				}
			}
		}
	});
}

//生成行主键
function getSqurl() {
	var source = "";
	itemLoader.doRequest(OmdUrl.mall, "mall.common.genUniqueID", {}, null, null, function (_data) {
		source = _data.data;
	}, null, null, false);
	return source;
}

function isCheckSup(para) {
	var billno = "";
	itemLoader.doRequest(OmdUrl.mall, "mall.work.bsup.search", para, null, null, function(data) {
		if (data.bsupplierbase.length > 0) {
			billno = data.bsupplierbase[0].billno;
		}
	}, null, null, false);
	return billno;
}

function isSqurl(squrl) {
	var flag = false;
	var searchParam ={
	    	  billno : squrl,
			  billmoduleid :billmoduleid,
		  };
  var method = "serverutils.getEnclosure";
  itemLoader.doRequest(OmdUrl.mss, method, searchParam, null, null, function (data) {
	  	   if(data.length == "0"){
	  	   }
	  	   else {
	  		 flag = true;
	  	   }
	    },null, null, false);
  return flag;
}

function delSqul(data) {
	 var temp ={};
	 for (var i=0;i<data.length;i++) {
		 if (data[i].squrl != "" && data[i].squrl != undefined) {
			 temp.billno = data[i].squrl;
			 temp.billmoduleid = billmoduleid;
			 appendix.setAppendixData(temp);
			 appendix.dellAllfile();
		   }
	 }
}

function head_beforefunc_sbid(e) {
	if (!e.searchParam) {
		e.searchParam = {};
	}
	e.searchParam.sbstatus =  {"$in" : "Y,M"};
	e.searchParam.sbtype = '1';   //过滤掉写字楼
	e.searchParam.$or=[{sbwmid4:{"==":"Y"}},{sbwmid5:{"==":"Y"}}];
	return 0;
}

function head_itemchanged_sbid(e,data){
	var para = {};
	para.sbid = data[0].sbid;
	para.billstatus = "N";
	var billno = isCheckSup(para);
	if (billno) {
		mini.alert("商户["+para.sbid+"]存在未审核的变更单["+billno+"]，请检查");
		return -1; 
	}
	setSupData(data[0].sbid);
	
	mini.getbyName("sbid").setValue(data[0].sbid);
	mini.getbyName("sbid").setText(data[0].sbid);
	
	var buttonEdit = e.sender;
	buttonEdit.setIsValid(true);
	return -1;
}


function head_beforefunc_muid_detail (e) {
	var grid = e.sender.grid;
	if (!e.searchParam) {
		e.searchParam = {};
	}
	if (grid == bsuplinkman || grid == bsupplierqc) {
		
		var muidStr ="";
		var muidData = bsupmkt.getData();
		if(muidData.length == 0){
			alert("请先输入门店列表");
			return -1;
		}
		if(muidData != null && muidData.length > 0){
			for (var i = 0; i < muidData.length; i++) {
				muidStr = muidStr +"'"+ muidData[i].muid +  "',";
			}
		}
		if (muidStr.length > 0) {
			muidStr = muidStr.substring(0,muidStr.length-1);
			e.searchParam.muid = {"$in": muidStr};
		}
	}

	return 0;
}

function head_itemchanged_muid_detail(e,data) {
	var grid = e.sender.grid;
	var row = grid.getSelected();
	var griddata = grid.getData();
	if (grid == bsupmkt ) {
		for (var i = 0; i < griddata.length; i++){
			if( row._id != griddata[i]._id && griddata[i].muid == data[0].muid){
				if (grid == bsupmkt) {
					mini.alert("门店"+data[0].mucode +"已添加");
					return -1;
				} else  {
					if (griddata[i].sqtype == row.sqtype) {
						mini.alert("门店"+data[0].mucode +"已添加");
						return -1;
					}
				}
			}
		}
	}
	return 0;
};

function head_itemchanged_province(e,data){
	mini.getbyName("city").setValue("");
	mini.getbyName("city").setText("");
	return 0;
}


//明细品牌回填
function head_itemchanged_ppcodedet(e,data) {
	if (data != null) {
		var bsupplierpp = mini.get("bsupplierpp");
		var row = bsupplierpp.getSelected();
		if (data.length > 0) {
			// 不允许添加重复费用项目
			var boolean = false;
			var exitGood = "";
			var maxrow = 0;
			var exitDatas = bsupplierpp.getData();
			for (var j = 0; j < data.length; j++) {
				for (var i = 0; i < exitDatas.length; i++) {
					if (exitDatas[i].ppcode == data[j].ppcode) {
						exitGood = exitGood + "["
								+ data[j].ppcode + "],";
						boolean = true;
						break;
					}
				}
				if (!boolean) {
					var newrow = {
						ppcode : data[j].ppcode,
						ppcode_name : "[" + data[j].ppcode + "]" + data[j].ppcname,
						lastmoder : getUserCode(),
						lastmoddate : mini.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss"),
						};
						bsupplierpp.updateRow(row, newrow);
				} else {
					/* supsetdepositdet.rejectRecord(row); */
					var delrow = {
							flag : "D",
							};
							bsupplierpp.updateRow(row, delrow);
							bsupplierpp.removeRow(row);
					boolean = false;
				}

			}
			if (exitGood != "" && exitGood.length > 1) {
				mini.alert("明细中已有相同主营品牌:"
						+ exitGood.substring(0,
								exitGood.length - 1));
			}
		}
		
	}
	return 0;
}

function onTaxnoChange (e) {
	   var value = e.value;
	   if (e.value != "") {
		   if (isTaxno(value)) {
			   mini.alert("税号已被使用");
			   mini.getbyName("taxno").setValue("");
			   return;
		   }
	   }
	}

	function isTaxno (taxno) {
		var flag = false;
		var sbid =  mini.getbyName("sbid").getValue();
		var param = {};
		param.taxno = taxno;
		itemLoader.doRequest(OmdUrl.mall, "mss.supplier.supplierbase.search",param, null, null, function(data) {
			var supplierbase =data.supplierbase;
			if (supplierbase.length > 0) {
				if (supplierbase.length  ==  1) {
					if (supplierbase[0].sbid != sbid) {
						flag = true;
					}
				} else {
					flag = true;
				}
			}      
		}, null, null, false);
		return flag;
	}
	
	function onFplxChange (e) {
		   var value = e.value;
		   if (e.value == "2") {
			   mini.getbyName("sbfp").setRequired(true);
			   setStatus(true);
		   } 
		   if(e.value == "1") {
			   mini.getbyName("sbfp").setRequired(true);
			   setStatus(false);
		   }
		   if(e.value == "") {
			   mini.getbyName("sbfp").setRequired(false);
			   setStatus(false);
		   }
	}

	function setStatus(node){
		mini.getbyName("sbfpadd").setRequired(node);
		//mini.getbyName("taxno").setRequired(node);
		mini.getbyName("sbbank").setRequired(node);
		mini.getbyName("sbaccount").setRequired(node);
		mini.getbyName("frdb").setRequired(node);
		mini.getbyName("phone").setRequired(node);
	}
//修改纳税级别，带出对应适用税率
function ontaxlevelChange(e) {
	var value = e.value;
	var name = e.source.name;
	var label = e.source.label;
	for (i = 0; i < dict.TAXLEVEL.length; i++) {
		if (value == dict.TAXLEVEL[i].code) {
			mini.getbyName("applicabletax").setValue(dict.TAXLEVEL[i].dmin);
			break;
		}
	}
}

function getbrandlinkman(ppcode) {
	var searchParam = {
		ppcode: ppcode
	};
	var _data = [];
	itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.brand.get",
		searchParam, null, null, function (data) {
			_data = data.codebrand.brandlinkman;
		}, null, null, false);
	return _data;
}

function addrowstosuplinkman(datas) {
	var form = details1.form;
	var sbid = form.getField("sbid").getValue();
	for (var i = 0; i < datas.length; i++) {
		var newrow = {
			modflag: "I",
			sbid: sbid,
			lastmoder: getUserCode(),
			lastmoddate: mini.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss"),
			// mrlinkman : 'Y',
			muid: "",
			muid_name: "",
			linkman: datas[i].linkman,
			lmadd: datas[i].lmadd,
			lmphone: datas[i].lmphone,
			lmfax: datas[i].lmfax,
			emailaddr: datas[i].emailaddr,
			issend: datas[i].issend,
			address: datas[i].address
		};
		if (ismr == "1") { //为1时同步过滤的联系人为默认联系人
			newrow.mrlinkman = "Y";
		} else {
			newrow.mrlinkman = "N";
		}
		bsuplinkman.addRow(newrow);
	}
}

function onActionRenderer(e) {
	var grid = e.sender;
	var record = e.record;
	var uid = record._uid;
	var s = '<a class="New_Button" href="javascript:doAppendix(\'' + uid + '\')">附件</a>'
	return s;
};
function doAppendix(uid) {
	if (bsupplierqc) {
		var form = details1.form;
		var row = bsupplierqc.getRowByUID(uid);
		var flag = true;
		var squrl = "";
		if (!row.squrl) {
			flag = false;
			squrl = getSqurl();
		} else {
			squrl = row.squrl;
		}
		var sbstatus = form.getField("sbstatus").getValue();
		if (row.sqstatus == "C") {
			sbstatus = "Y";
		}
		Future.Pub.addfile(squrl, billmoduleid, sbstatus, function (data) {
			if (data.returncode == "0") {
				mini.alert("上传成功！");
			}
		});
		//重新提交资质，或者新增资质，资质状态为已提交
		bsupplierqc.updateRow(row, {"squrl": squrl, "sqstatus": "N"});
		if (mini.getbyName("ph_key").getValue()) {
			updateSqurl(row, squrl);
		}
	}
};
//更新商户资质审核状态
function updateSqurl(row, squrl) {
	var param = {};

	if (row.sbid == undefined || row.ph_key == undefined) return;
	param.ph_key = row.ph_key;
	param.squrl = squrl;
	itemLoader.doRequest(OmdUrl.mall, "mall.work.bsup.updateSqurl", param, null, null, function (data) {
	}, null, null, false);
}
//审核资质
function checkPhoto() {
	var rows = bsupplierqc.getSelecteds();
	if (rows.length == 0) {
		mini.alert("请选择资质证明一行记录");
		return;
	}
	var form = details1.form;
	var ph_keys = [];
	for (var i = 0; i < rows.length; i++) {
		var row = rows[i];
		if (!checkQcDate(row)) {
			return;
		}
		bsupplierqc.updateRow(rows[i], {"sqstatus": "C"});
		var phkey = {
			ph_key: row.ph_key
		};
		ph_keys.push(phkey);
	}
	updateSqstatus(ph_keys);
}

//更新商户资质审核状态
function updateSqstatus(ph_keys) {
	var param = {};
	param.ph_keys = ph_keys;
	itemLoader.doRequest(OmdUrl.mall, "mall.work.bsupqc.updateSqstatus", param, null, null, function (data) {
		if (data.msg) {
			mini.alert(data.msg);
		}
	}, null, null, false);
}