/**
 *  页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('supchargeconvert.view');
	// 定义一个对象用来配置界面
	var bill = {};
	var billmoduleid =getUrlParam("billmoduleid");
	if (billmoduleid == "" || billmoduleid == null) {
		billmoduleid = getUrlParam("modulecode");
	}
	app.modulecode = billmoduleid;
	var billtype=getBilltype(app.modulecode);
	// 把定义对象放到命名空间下
	ns.bill = bill;
	utils.billtype=billtype;

	//查询列表
	bill.supchargeconvertlist = {
		"type": "gridbox",
		"resources": OmdUrl.settle,
		"method": "mall.settle.supchargeconvert.search",
		"response": "supchargeconverthd",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段		
		"searchParam": {
			"billtype" : billtype,
			"contstyle" : "04",
			"order_field": "billno",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('supchargeconvertlist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 160,
			}, {
				field: "billstatus",
				type: "comboboxcolumn",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				textField:"name",
				valueField:"code",
				dictkey: 'SYSTEM_BILLSTATUS',
			}, {
				field: "muid",
				displayField : "muid_name",
				headerAlign: "center",
				header: "门店",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "muid",
					textName : "muid_name",
					responseName : "muid"
				},
				width: 160,
			}, {
				field: "sbid",
				displayField : "sbid_name",
				headerAlign: "center",
				header: "原租户",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "sbid",
					textName : "sbid_name",
					responseName : "sbid"
				},
				width: 200,
			}, {
				field: "newsbid",
				displayField : "newsbid_name",
				headerAlign: "center",
				header: "新租户",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "sbid",
					textName : "newsbid_name",
					responseName : "newsbid"
				},
				width: 200,
			}, {
				field: "contno",
				type: "TextBox",
				headerAlign: "center",
				header: "合同号",
			}, {
				field : "inputer_name",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				width: 160,
			}, {
				field : "inputdate",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				width: 160,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "memo",
				header : "备注",
				width : 180,
				allowSort : true,
				headerAlign : "center",
			}]
		}
	};

	//单据主表
	bill.supchargeconverthd = {
		"type": "formgrid",
		"resources": OmdUrl.settle,
		"name": 'supchargeconverthd',
		"method": "mall.settle.supchargeconvert.get",
		"response": "supchargeconverthd",
		"properties": {
			"id": utils.createid('supchargeconverthd')
		},
		items: [{
			"label": "ph_key：",
			"name": "ph_key",
			"type": "TextBox",
			"visible": false,
		}, {
			"label": "单据编号：",
			"name": "billno",
			"type": "TextBox",
			"readOnly": true,
			"visible": true,
		}, {
			"label": "单据类型：",
			"name": "billtype",
			"type": "TextBox",
			"defaultValue": billtype,
			visible: false,
			"readOnly": true,
		}, {
			"lable": "billmoduleid",
			"name": "billmoduleid",
			"type": "TextBox",
			"defaultValue": app.modulecode,
			"visible": false,
		}, {
			"label": "单据状态：",
			"name": "billstatus",
			"type": "ComboBox",
			dictkey: 'SYSTEM_BILLSTATUS',
			"readOnly": true,
			"defaultValue": "N",
		}, {
			"label" : "门店：",
			"name" : "muid",
			"defaultValue" : "",
			"required" : "true",
			type : "fut_popselect",//类型
			selectkey:"muid",//弹框类型
			textName :"muid_name", //文本显示字段
			"enabled" : true,
			beforefunc : "page.head_beforefunc",
			itemchangedfunc:"page.head_itemchangedfunc",
		}, {
			"label": "合同号：",
			"name": "contno",
			displayField : "contno",
			"type": "fut_popselect",
			"required": "true",
			selectkey: "bcontno",
			textName: "contno",
			allowInput: true,
			beforefunc : "page.head_beforefunc",
			itemchangedfunc:"page.head_itemchangedfunc",
		}, {
			"lable": "contstyle",
			"name": "contstyle",
			"type": "TextBox",
			"defaultValue": "04",
			"value" : "04",
			"visible": false,
		},{
			"label": "原租户：",
			"name": "sbid",
			"type": "fut_popselect",
			"readOnly": "true",
			selectkey: "sbid",
			textName: "sbid_name",
			allowInput: true,
		},{
			"label": "新租户：",
			"name": "newsbid",
			"type": "fut_popselect",
			"readOnly": "true",
			selectkey: "sbid",
			textName: "newsbid_name",
			allowInput: true,
			"style" : "display:block;float:none",
		},{
			"label": "备注：",
			"name": "memo",
			"type": "TextArea",
			"visible": true,
			"style": "width:90%",
		},{
			"label": "录入人：",
			"type": "TextBox",
			"name": "inputer_name",
			"readOnly": "true",
		}, {
			"label": "审核人：",
			"type": "TextBox",
			"name": "auditor_name",
			"readOnly": "true",
			"style" : "display:block;float:none",
		},  {
			"label": "录入日期：",
			"type": "DatePicker",
			"name": "inputdate",
			"format": "yyyy-MM-dd HH:mm:ss",
			"readOnly": "true",
		}, {
			"label": "审核日期：",
			"type": "DatePicker",
			"name": "auditdate",
			"format": "yyyy-MM-dd HH:mm:ss",
			"readOnly": "true",
			"style" : "display:block;float:none",
		}, {
			"label": "录入人编码",
			"type": "TextBox",
			"name": "inputer",
			"visible": false,
		}
		]
	}
	bill.supchargeconvertdet= {
		title: '单据明细',
		"type": "gridbox",
		name: 'supchargeconvertdet',
		"properties": {
			"id": utils.createid('supchargeconvertdet'),
			"multiSelect": "true",
			"allowCellEdit": "true",
			"allowCellSelect": "true",
			"editNextOnEnterKey": "true",
			"editNextRowCell": "true",
			"allowSortColumn": "false",
			"allowCellValid": true,
			"oncellbeginedit": "OcmControl.checkboxEditor",
			"columns": [{
				type: "checkcolumn",
				headerAlign: "center",
				readOnly: true,
				width: 30,
			}, {
				field: "browno",
				type : "indexcolumn",
				header: "行号",
				headerAlign: "center",
				readOnly : true,
			}, {
				field: "spid",
				displayField : "spid_name",
				header: "商铺",
				headerAlign: "center",
				width: 150,
				readOnly: true,
				editor:OcmControl.newControl('fut_popselectgrid'),
				editorSet: {
					selectkey:"zlcmfspid",
					textName :"spid_name",
				},
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"zlcmfspid"},
			}, {
				field: "cccode",
				displayField : "cccode_name",
				header: "费用编码",
				headerAlign: "center",
				width: 150,
				readOnly: true,
				editor:OcmControl.newControl('fut_popselectgrid'),
				editorSet: {
					compnentType : 'fut_popselect',
					selectkey : "contcccode",
					textName : "cccode_name",
					responseName : "cccode",
				},
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"contcccode"},
			}, {
				field : "feesdate",
				headerAlign : "center",
				header : "费用开始日期",
				allowSort : true,
				readOnly : true,
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				width : 80,
			},{
				field : "feeedate",
				headerAlign : "center",
				header : "费用结束日期",
				allowSort : true,
				readOnly : true,
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				width : 80,
			}, {
				field : "ysamount",
				header : "应收金额",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
				width : 80,
			}, {
				field : "recamount",
				header : "实收金额",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
				width : 80,
			},{
				field : "recdkamount",
				header : "实收抵扣",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
				visible : false,
				width : 80,
			}, {
				field : "preadjamount",
				header : "预调整金额",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
				visible : false,
				width : 80,
			},{
				field : "adjamount",
				header : "后调整金额",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
				visible : false,
				width : 80,
			},{
				field : "ysbalance",
				header : "应收余额",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
				width : 80,
			},{
				field : "payamount",
				header : "应付金额",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
				width : 80,
			},{
				field : "paidamount",
				header : "已付金额",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
				width : 80,
			},{
				field : "paydkamount",
				header : "实付抵扣",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
				visible : false,
				width : 80,
			},{
				field : "paybalance",
				header : "应付余额",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
				width : 80,
			}, {
				field : "ytamount",
				header : "应退金额",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
				width : 80,
			}, {
				field : "rtndkamount",
				header : "实退抵扣",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
				visible : false,
				width : 80,
			},{
				field : "confiscateamt",
				header : "押金罚没",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				visible :false,
				readOnly : true,
				width : 80,
			},{
				field : "rtnamount",
				header : "已退金额",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
				width : 80,
			}, {
				field : "ytbalance",
				header : "应退余额",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				readOnly : true,
			}]
		},
	};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData,btn.editData, btn.saveData,btn.separator, btn.delData,btn.searchData,
			btn.separator,btn.auditData]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.supchargeconverthd, // 单据主表
		billdetail: [bill.supchargeconvertdet], // 单据明细表
		billquerylist: bill.supchargeconvertlist, // 查询列表
		dettabpages: [bill.supchargeconvertdet], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()