/**
 *  页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('salemm.view');

	// 定义一个对象用来配置界面
	var bill = {};
	app.modulecode='600302';
	//var billtype=getBilltype(app.modulecode);
	var billtype='97';
	
	// 把定义对象放到命名空间下
	ns.bill = bill;

	utils.billtype=billtype;
	//查询列表
	bill.salemmlist = {
		"type": "gridbox",
		"resources": OmdUrl.mall,
		"method": "mss.salemm.salehd_mm.search",
		"response": "salehd_mm",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段		
		"searchParam": {
			"billmoduleid" : app.modulecode,
			"order_field": "billno",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('salemmlist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width : 150,
			}, {
				field: "billtype",
				type: "TextBox",
				headerAlign: "center",
				header: "单据类型",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLTYPE',
				width : 200,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
				width : 80,
			},{
				field: "city_name",
				type: "TextBox",
				headerAlign: "center",
				header: "城市名称",
				width : 200,
			},{
				field: "mkt_name",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				width : 150,
			},{
				field: "yymm",
				type: "TextBox",
				headerAlign: "center",
				header:"月份",
				align: "left",
			},{
				field: "amount",
				header : "金额合计",
				type: "TextBox",
				headerAlign: "center",
				numberFormat : "#,0.00",
				align : "right",
				width : 100,
			}, 
			{
				field : "inputer_name",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",				
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "left",
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "left",
			}, {
				field : "memo",
				header : "备注",
				width : 120,
				allowSort : true,
				headerAlign : "center",
			}]
		}
	};
	
	//单据主表
	bill.salehd_mm = {
		"type": "formgrid",
		"resources": OmdUrl.shans,
		"name": 'salehd_mm',
		"method": "shans.salemm.salehd_mm.get",
		"response": "salehd_mm",
		"properties": {
			"id": utils.createid('salehd_mm')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"visible": true,
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "ComboBox",
				"defaultValue": billtype,
				dictkey: 'BILLTYPE',
				"visible": true,
				"readOnly": true,
			}, {
				"lable": "billmoduleid",
				"name": "billmoduleid",
				"type": "TextBox",
				"defaultValue": app.modulecode,
				"visible": false,
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
			}, col.line, {
				"label": "城市：",
				"name": "cityid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "coderegion",
				textName: "city_name",
				allowInput: true,
			//	beforefunc : "page.head_beforefunc_muid",
			//	itemchangedfunc:"page.head_itemchangedfunc",
			}, {
				"label": "城市名称：",
				"name": "city_name",
				"type": "TextBox",
				readOnly: true,
				visible: false
			},{
				"label": "同业门店：",
				"name": "mktid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "tymkt",
				textName: "mkt_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_mktid",
				itemchangedfunc:"page.head_itemchangedfunc",
			}, {
				"label": "同业门店：",
				"name": "mkt_name",
				"type": "TextBox",
				readOnly: true,
				visible: false
			},{
				"label": "月份：",
				"name": "yymm",
				"type": "MonthPicker",
				"format" : "yyyyMM",
				"visible": true,
				"required": true,
				"value" : mini.formatDate(new Date(), "yyyyMM"),
				"defaultValue" : mini.formatDate(new Date(), "yyyyMM"),
			},
			{
				"label" : "金额合计：",
				"name": "amount", 
	            "type" : "Spinner",
	    		"format" : "n2",
	    	    "minValue" : "0",
	    	    "maxValue" : "99999999999999", 
	    	    "defaultValue" : "0",
	    	    "inputStyle" :"text-align:right;",
	    		"readOnly":true
			}, 
			{
			
				"label": "备注：",
				"name": "memo",
				"type": "TextBox",
				"visible": true,
				"style": "width:90%",
			},{
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"readOnly": "true",
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
			}, {
				"label": "取消人：",
				"type": "TextBox",
				"name": "canceler_name",
				"readOnly": "true",
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "取消日期：",
				"type": "DatePicker",
				"name": "canceldate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "录入人编码",
				"type": "TextBox",
				"name": "inputer",
				"visible": false,
			}
		]
	}
	//单据明细
	bill.saledet_mm = {
			title: '单据明细',
			"type": "gridbox",
			name: 'saledet_mm',
			"properties": {
				"id": utils.createid('saledet_mm'),
				"multiSelect": "true",
				"allowCellEdit": "true",
				"allowCellSelect": "true",
				"editNextOnEnterKey": "true",
				"editNextRowCell": "true",
				"allowSortColumn": "false",
				"allowCellValid": true,
				"sortMode": "client",
				//"showPager": true,
				"showSummaryRow": true,
				"oncellbeginedit": "OcmControl.checkboxEditor",
				"columns": [{
					type: "checkcolumn",
					name: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
				}, {
					type: "indexcolumn",
					name: "indexcolumn",
					header: "行号",
					headerAlign: "center",
					readOnly: true,
					width: "60px",
				}, {
					field: "rowno",
					headerAlign: "center",
					align: "center",
					header: "导入行号",
					dataType: "int",
					allowSort: true,
					readOnly: true,
					visible: false,	
				},{
					field: "ppcode",
					name: "ppcode",
					header: "品牌",
					headerAlign: "center",
					allowSort: true,
					required: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                displayField: "ppcode_name",
	                width: "150px",
	                editorSet: {
	                    selectkey: 'ppcode',
	                    multiSelect: false,
	                    beforefunc:"page.det_beforefunc_ppcode",
	                    },
	                }, {
					field: "ppcode_name",
					name: "ppcode_name",
					header: "品牌",
					headerAlign: "center",
					width: "150px",
					visible: false
				}, {
					field : "amount",
					name: "amount",
					header : "销售金额",
					width : 100,
					//vtype : "Spinner",
					allowSort : true,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
			    	editorSet:{
			    		format: "c2",
			    	},					
			        align: "right",
			        numberFormat : "c2",
				},{
					field : "num1",
					name: "num1",
					header : "销售坪效",
					width : 100,
					//vtype : "Spinner",
					allowSort : true,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
			    	editorSet:{
			    		format: "c2",
			    	},					
			        align: "right",
			        numberFormat : "c2",
				}, {
					field: "memo",
					name: "memo",
					header: "备注",
					allowSort : true,
					type: "TextBox",
					headerAlign: "center",
					width: "150px",
				}]
			},
		};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
			btn.separator,btn.auditData, btn.separator, btn.searchData,btn.cancelData
		]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.salehd_mm, // 单据主表
		billdetail: [bill.saledet_mm], // 单据明细表
		billquerylist: bill.salemmlist, // 查询列表
		dettabpages: [bill.saledet_mm], // 要放入明细TAB列表的组件
		defaultmoduleid: '600302', // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
