/**
 * 
 */
(function () {
    // 命名空间
    /** @namespace Future.salemm.out */
    var ns = Future.ns('salemm.out');
    var utils = Future.ns('utils');
    var validate = Future.ns('validate');
    var Salemm = function () {
    	Salemm.superclass.constructor.call(this);
        this.servicekey = 'mss';
        this.head_beforefunc_mktid = this.head_beforefunc_mktid.bind(this);
        this.head_itemchangedfunc = this.head_itemchangedfunc.bind(this);
    }
    var findcol = function (cols, col,value) {
        for (var i = 1; i < cols.length; i++) {
            var rtn = cols[i];
            if (rtn.name == col) {
                return rtn;
                break;
            }
        }
    }
    
    ns.Salemm = Salemm;
    
    Future.extend(ns.Salemm, Future.pub.Basebill, {
    
    	_initview: function () {
    		Salemm.superclass._initview.call(this);
        },
        initevent : function() {
        	Salemm.superclass.initevent.call(this);
			this.saledet_mm.on('cellcommitedit',this.detcellcommitedit, this);
		},

        head_beforefunc_mktid : function(e) {
			// 判断明细是否有数据,如果有数据，必须先删除了，再才能修改
			if (this.saledet_mm.data.length > 0) {
				mini.alert("明细已存在数据,请先删除后再修改门店");
				e.cancel = true;
				return -1;
			}
		},
		
		head_itemchangedfunc: function(e, data) {
			 var colname = e.sender.name;
	         if(colname=='mktid'){
	 			if (this.saledet_mm.data.length > 0) {
	 				mini.alert("明细已存在数据,请先删除后再修改门店");
	 				e.cancel = true;
	 				return -1;
	 			}
	         }
	         return 1;
	         
		},
		detcellcommitedit : function(e) {
            var muid = this.salehd_mm.form.getField('mktid').value;           
            var ym = this.salehd_mm.form.getField('yymm').value; 
            var fedate =  mini.formatDate(new Date(this.salehd_mm.form.getField('yymm').value),"yyyy-MM-dd"); 
			if (muid == undefined || muid == "") {
				mini.alert("请先选择门店");
				return -1;
			}
			
			if (e.field == 'amount'){
				var zamount = this.billhead.getValue('amount');
				if (zamount == null || zamount == ""){
					zamount = 0;
				}
				var count1 = this.accAdd(e.value,zamount);
				if (e.oldValue == null || e.oldValue == ""){
					e.oldValue = 0;
				}
				var count2 = this.accAdd(count1,- e.oldValue);
				var count3 = utils.priceConvert(count2,"0");
				//赋值表头付款合计金额	
				this.billhead.setValue('amount', count3);
			}
		},
		delTabsGridRowAfter:function(){
			var detData = this.saledet_mm.getData();
			var amount = 0;
			for(var i =0; i<detData.length;i++){
				var feeamount = detData[i].amount;
                amount = this.accAdd(amount,feeamount);
			}
			this.billhead.setValue('amount', amount);
			return 1; 
		 },
		saveDataBefore:function(){
			//保存前判断
        	if (this.saledet_mm.data.length < 1) {
				mini.alert("明细无数据,不能保存");
				return -1;
			}else{
				var detData = this.saledet_mm.getData();
				for(var i =0; i<detData.length;i++){
					var ppcode = detData[i].ppcode;
					var feeamount = detData[i].amount;
					if (ppcode == null || ppcode == ""){
						mini.alert("第"+(i+1)+"行品牌代码为空，请检查");
						return -1;
					}
					if (feeamount == null || feeamount == ""){
						mini.alert("第"+(i+1)+"行销售金额为空，请检查");
						return -1;
					}
				}
				return 1; 
			}				
        },
        initcontrol: function () {
        	Salemm.superclass.initcontrol.call(this);
        },
        checkValidate: function () {
            var isValid = Salemm.superclass.checkValidate.call(this);
            if (isValid == false) {
                return isValid;
            }
            return true;

        }
    });
})()
