mini.parse();
var gridbox1 = mini.get("gridbox1");// 单据列表
var details1 = mini.get("details1");// 单据明细
var tabs1 = mini.get("tabs1");
var tabs2 = mini.get("tabs2");
var bsupmkt = mini.get("bsupmkt");// 门店
var bsuplinkman = mini.get("bsuplinkman");// 联系人
var bsupplierqc = mini.get("bsupplierqc");// 资质证明
var bsupplierpp = mini.get("bsupplierpp");// 品牌
var photoPanel = mini.get("photoPanel");
var appendix = new mini['appendixcontrol'];
var token = getUrlParam("token");// token值

// tab页面切换的时候，需要绑定自定义控件的数据集
if (tabs1) {
	tabs1.on('activechanged', function(e) {
		// 重写了父类的按钮，必须根据规则来控制选择商品按钮的状态。如果页面不存在会自动查找基类中定义的规则
		var _toolbar = mini.get("config1_toolbar");
		var status = _toolbar.configStatus;
		_toolbar.changedStatus(status);

		if (e.tab.name == "details") {
			setBillData();
		}
	});
}

// 带入条件查询
function head_beforefunc(e) {
	var buttonEdit = e.sender;
	if (!e.searchParam) {
		e.searchParam = {};
	}
	var buttonEdit = e.sender;

	if (e.value != "undefined" && e.value != "") {
		e.searchParam.code = e.value;
	}
	// 根据品牌过滤经营种类
	if (buttonEdit.name == "mid") {
		var ppcode = mini.getbyName("ppcode"); // 获取品牌
		if (ppcode.value == "") {
			mini.alert("请先选择品牌");
			return -1;
		}
		e.searchParam.wherestr = "billno = (select billno from codebrand where ppcode ='"
				+ ppcode.value + "')";
	} else if (buttonEdit.name == "ppcode"){
		var sbyt222 =mini.getbyName("sbyt");
		var yt = mini.getbyName("sbyt").value; // 获取品牌 ppposition
		if(yt !=undefined && yt !=""){
			e.searchParam.wherestr = "ppcode in (select ppcode from codebrand where ppposition IN (SELECT mcode FROM manacat WHERE MID = '" + yt + "'))";
		}
	}else if (buttonEdit.name == "province") {
		e.searchParam.wherestr = "crclass = 1";

	} else if (buttonEdit.name == "city") {
		var province = mini.getbyName("province");
		if (province.getValue() == "") {
			mini.alert("请先选择省份");
			return -1;
		}
		e.searchParam.wherestr = " crpcode ='" + province.getValue() + "'";
	}
	return 0;
}

// 明细品牌回填
function head_itemchanged_yt(e, data) {
	var sbyt222 = mini.getbyName("sbyt");
	var sbyt = mini.getbyName("sbyt").value;
	if (data && data.length > 0) {// 说明没有清空
		// if(data && data[0].code !=undefined&& data[0].code!=sbyt){
		mini.getbyName("ppcode").setValue("");
		mini.getbyName("ppcode").setText("");
		// mini.getbyName("sbyt").setValue(data[0].code);
		// mini.getbyName("sbyt").setText("["+data[0].code+"]"+data[0].name);
		// }
	} else {
		if (sbyt != "") {
			mini.getbyName("ppcode").setValue("");
			mini.getbyName("ppcode").setText("");
		}
	}
	return 0;
}
// 单头品牌回填值
function head_itemchanged_ppcode(e, data) {
	if (data != null) {
		// 查询出原单明细
		var oldppcode = e.sender.value;
		supplierpp(data, oldppcode);
		if (mini.getbyName("mid") && data[0].mid && data[0].mid != "") {
			mini.getbyName("mid").setValue(data[0].mid);
			mini.getbyName("mid").setText(data[0].mid_name);
			mini.getbyName("sbdz").setValue(data[0].name);//店招
			var yt =mini.getbyName("sbyt").getValue();
			if(!yt){
				var jyyt =data[0].ppposition;
				if(jyyt !=undefined && jyyt !=""){
					var P_data = ppposition(jyyt);
					if (P_data) {
						mini.getbyName("sbyt").setValue(P_data[0].mid_);
						mini.getbyName("sbyt").setText(P_data[0].mid_name);
					}
				}
			}
		}
	}
	return 0;
}

//查询出主营业种
function ppposition(mcode) {
	var P_data;
	var searchParam = {
			"queryid" : "select_manacatyt",
			mcode : mcode
		};
		var method = "mss.work.report.query";
		itemLoader.doRequest(OmdUrl.mss, method, searchParam, null, null, 
				function(data) {
			P_data = data.report;
		}, null, null, false);
	if (P_data.length > 0) {
		return P_data;
	}
}
function head_itemchanged_ppcode_detail(e, data) {
	var row = bsupplierpp.getSelected();
	var newrow = {
		ppcode : data[0].code,
		ppcode_name : "[" + data[0].code + "]" + data[0].name
	};
	bsupplierpp.updateRow(row, newrow);
	return 0;
}

// 查询出原单明细
function supplierpp(data, oldppcode) {
	var bsupplierpp = mini.get("bsupplierpp");
	var form = details1.form;
	var tempsbid = form.getField("sbid").getValue();
	if (data.length > 0) {
		// 不允许添加重复费用项目
		var boolean = false;
		var exitGood = "";
		var maxrow = 0;
		var exitDatas = bsupplierpp.getData();
		for ( var j = 0; j < data.length; j++) {
			for ( var i = 0; i < exitDatas.length; i++) {
				if (exitDatas[i].ppcode == data[j].code) {
					exitGood = exitGood + "[" + data[j].code + "],";
					boolean = true;
					break;
				}
			}
			if (!boolean) {
				if (exitDatas.length >= 1) {
					for ( var l = 0; l < exitDatas.length; l++) {
						if (exitDatas[l].ppcode == oldppcode) {
							var oldrow = {
								sbid : tempsbid,
								ppcode : data[j].code,
								ppcode_name : "[" + data[j].code + "]"
										+ data[j].name,
								lastmoder : getUserCode(),
								lastmoddate : mini.formatDate(new Date(),
										"yyyy-MM-dd HH:mm:ss"),
								modflag : "M",
							}
							bsupplierpp.updateRow(exitDatas[l], oldrow);
						}

					}
				} else {
					var newrow = {
						sbid : tempsbid,
						ppcode : data[j].code,
						ppcode_name : "[" + data[j].code + "]" + data[j].name,
						lastmoder : getUserCode(),
						lastmoddate : mini.formatDate(new Date(),
								"yyyy-MM-dd HH:mm:ss"),
						modflag : "I",
					};
					bsupplierpp.addRow(newrow);
				}
			} else {
				/* supsetdepositdet.rejectRecord(row); */
				var uptdaterow = {
					modflag : "M",
				}
				bsupplierpp.updateRow(exitDatas[i], uptdaterow);
				boolean = false;
			}

		}
		if (exitGood != "" && exitGood.length > 1) {
			mini.alert("明细中已有相同主营品牌:"
					+ exitGood.substring(0, exitGood.length - 1));
		}
	}
}
function head_beforefunc_sbid(e) {
	if (!e.searchParam) {
		e.searchParam = {};
	}
	e.searchParam.sbstatus =  {"$in" : "Y,M"};
	e.searchParam.$or=[{sbwmid1:{"==":"Y"}},{sbwmid2:{"==":"Y"}},{sbwmid3:{"==":"Y"}},{sbwmid4:{"==":"Y"}}];
	return 0;
}
// 单头主营业种回填值
function head_itemchanged_mid(e, data) {
	if (data != null) {
		// 查询出原单明细
	}
	return 0;
}

// 自定义页面数据回填
function setBillData(flag) {
	var _details = mini.get("details1");
	var _datas = {};
	if (_details) {
		_datas = _details.config.data;
	}
	if (_datas && jQuery.isEmptyObject(_datas) == false) {
		var form = details1.form;

		// 供应商编码
		form.getField("supid").setText(
				"[" + _datas["sbcode"] + "]" + _datas["sbcname"]);

		// 商户编码
		//form.getField("sbcode").setText(_datas["sbcode"]);

		// 主营品牌
		if (_datas["ppcode"]) {
			form.getField("ppcode").setText(_datas["ppcode_name"]);
		}
		// 主营业种
		if (_datas["mid"]) {
			form.getField("mid").setText(_datas["mid_name"]);
		}
		// 省
		if (_datas["province"]) {
			form.getField("province").setText(_datas["province_name"]);
		}
		// 市
		if (_datas["city"]) {
			form.getField("city").setText(_datas["city_name"]);
		}

		if (_datas["fplx"] == "2") {
			mini.getbyName("sbfp").setRequired(true);
			setStatus(true);
		}
		if (_datas["fplx"] == "1") {
			mini.getbyName("sbfp").setRequired(true);
			setStatus(false);
		}
//		if (_datas["fplx"] == "" || _datas["fplx"] == undefined) {
//			mini.getbyName("sbfp").setRequired(false);
//			setStatus(false);
//		}
	}
}

// 回填供应商及明细数据
function setSupData(sbid,phk) {
	if (sbid) {
		var searchParam = {
			"sbid" : sbid,
			"ph_key":phk
		};
		var method = "mss.supplier.supplierfile.get";
		itemLoader
				.doRequest(OmdUrl.mall,method,searchParam,null,null,
						function(data) {
							if (data && data.supplierbase) {
								//基本信息
								var form = details1.form;
								form.getField("sbid").setValue(data.supplierbase.sbid);
								form.getField("sbcode").setValue(data.supplierbase.sbcode);
								form.getField("sbcode").setText(data.supplierbase.sbcode);
								form.getField("sbcname").setValue(data.supplierbase.sbcname);
								form.getField("sbename").setValue(data.supplierbase.sbename);
								form.getField("sbstatus").setValue(data.supplierbase.sbstatus);
								
								////
								form.getField("sbdz").setValue(data.supplierbase.sbdz);//
								form.getField("shbj").setValue(data.supplierbase.shbj);//
								form.getField("paymode").setValue(data.supplierbase.paymode);//
								form.getField("agentlevel").setValue(data.supplierbase.agentlevel);//
								form.getField("currency").setValue(data.supplierbase.currency);//
								form.getField("regcapital").setValue(data.supplierbase.regcapital);//
								form.getField("sbfp").setValue(data.supplierbase.sbfp);//
								form.getField("sbfpadd").setValue(data.supplierbase.sbfpadd);//
								form.getField("payee").setValue(data.supplierbase.payee);//
								form.getField("sbeadd").setValue(data.supplierbase.sbeadd);//
								form.getField("frdbename").setValue(data.supplierbase.frdbename);//
								form.getField("phone").setValue(data.supplierbase.phone);//
								form.getField("supid").setValue(data.supplierbase.supid);//
								////
								form.getField("oik").setValue(data.supplierbase.oik);
								form.getField("ppcode").setValue(data.supplierbase.ppcode);
								form.getField("ppcode").setText(data.supplierbase.ppcode_name);
								form.getField("mid").setValue(data.supplierbase.mid);
								form.getField("mid").setText(data.supplierbase.mid_name);
								form.getField("qyxz").setValue(data.supplierbase.qyxz);
								form.getField("taxlevel").setValue(data.supplierbase.taxlevel);
								form.getField("sbnature").setValue(data.supplierbase.sbnature);
								form.getField("frdb").setValue(data.supplierbase.frdb);
								form.getField("frid").setValue(data.supplierbase.frid);
								form.getField("sbadd").setValue(data.supplierbase.sbadd);
								form.getField("sbbank").setValue(data.supplierbase.sbbank);
								form.getField("sbaccount").setValue(data.supplierbase.sbaccount);
								form.getField("province").setValue(data.supplierbase.province);
								form.getField("province").setText(data.supplierbase.province_name);
								form.getField("city").setValue(data.supplierbase.city);
								form.getField("city").setText(data.supplierbase.city_name);
								form.getField("taxno").setValue(data.supplierbase.taxno);
								form.getField("jyms").setValue(data.supplierbase.jyms);
						        form.getField("fplx").setValue(data.supplierbase.fplx);
								form.getField("sbsubject").setValue(data.supplierbase.sbsubject);
								form.getField("sbwmid1").setValue(data.supplierbase.sbwmid1);
								form.getField("sbwmid2").setValue(data.supplierbase.sbwmid2);
								form.getField("sbwmid3").setValue(data.supplierbase.sbwmid3);
								form.getField("sbwmid4").setValue(data.supplierbase.sbwmid4);
								form.getField("sbwmid5").setValue(data.supplierbase.sbwmid5);
								form.getField("introductiondate").setValue(data.supplierbase.introductiondate);
								form.getField("sbyt").setValue(data.supplierbase.sbyt);
								form.getField("sbyt").setText(data.supplierbase.sbyt_name);
								form.getField("registerdate").setValue(data.supplierbase.registerdate);
								form.getField("trademark").setValue(data.supplierbase.trademark);
								form.getField("scope").setValue(data.supplierbase.scope);
								form.getField("scale").setValue(data.supplierbase.scale);
								form.getField("applicabletax").setValue(data.supplierbase.applicabletax);
								form.getField("arrivaldays").setValue(data.supplierbase.arrivaldays);
								form.getField("regcapital").setValue(data.supplierbase.regcapital);
														
								if (data.supplierbase.supmkt) {
									for ( var i = 0; i < data.supplierbase.supmkt.length; i++) {
										data.supplierbase.supmkt[i].flag ="I";
										data.supplierbase.supmkt[i].lastmoder = getUserCode();
										data.supplierbase.supmkt[i].lastmoddate = mini.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss");
										delete data.supplierbase.supmkt[i].ph_key;//删除属性
									}
									bsupmkt.setData([]);
									bsupmkt.addRows(data.supplierbase.supmkt);
								}
								if (data.supplierbase.suplinkman) {
									for ( var i = 0; i < data.supplierbase.suplinkman.length; i++) {
										data.supplierbase.suplinkman[i].flag ="I";
										data.supplierbase.suplinkman[i].lastmoder = getUserCode();
										data.supplierbase.suplinkman[i].lastmoddate = mini.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss");
										delete data.supplierbase.suplinkman[i].ph_key;//删除属性
									}
									bsuplinkman.setData([]);
									bsuplinkman.addRows(data.supplierbase.suplinkman);
									
								}
								if (data.supplierbase.supplierqc) {
									for ( var i = 0; i < data.supplierbase.supplierqc.length; i++) {
										data.supplierbase.supplierqc[i].flag ="I";
										data.supplierbase.supplierqc[i].lastmoder = getUserCode();
										data.supplierbase.supplierqc[i].lastmoddate = mini.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss");
										delete data.supplierbase.supplierqc[i].ph_key;//删除属性
									}
									bsupplierqc.setData([]);
									bsupplierqc.addRows(data.supplierbase.supplierqc);
								}
								if (data.supplierbase.supplierpp) {
									for ( var i = 0; i < data.supplierbase.supplierpp.length; i++) {
										data.supplierbase.supplierpp[i].flag ="I";
										data.supplierbase.supplierpp[i].lastmoder = getUserCode();
										data.supplierbase.supplierpp[i].lastmoddate = mini.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss");
										delete data.supplierbase.supplierpp[i].ph_key;//删除属性
									}
									bsupplierpp.setData([]);
									bsupplierpp.addRows(data.supplierbase.supplierpp);
								}
							}
						});
	}
}

OcmControl.toolbarFn.editDataBefore = function() {

	var form = details1.form;
	var billsource = form.getField("billsource").getValue();
	if (billsource == "01") {
		mini.alert("不允许修改移动端的数据，请重新选择单据");
		return;
	}
	return {};
};

OcmControl.toolbarFn.delDataBefore = function() {

	var form = details1.form;
	var billsource = form.getField("billsource").getValue();
	if (billsource == "01") {
		mini.alert("不允许删除移动端的数据，请重新选择单据");
		return;
	}
	return {};
};

// 新增按钮后事件
OcmControl.toolbarFn.addDataAfter = function() {
	var form = details1.form;

	form.getField("inputer").setValue(getUserCode());
	form.getField("inputer_name").setValue(getUserName());// 录入人
	form.getField("inputdate").setValue(new Date());// 录入日期
	mini.getbyName("sbcode").set({
		"readOnly" : false,
		"enabled" : true
	});

};

// 保存按钮前事件
OcmControl.toolbarFn.saveDataBefore = function() {
	var obj = {};
	var ismr = true;
	var count = 0;
	obj.lastmoder = getUserCode();
	obj.lastmoddate = mini.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss");
	var form = details1.form;

	// 必须入力check;
	form.validate();
	if (form.isValid() == false) {
		mini.alert("请先输入表头必填项目");
		return;
	}
	var sbwmid1 = mini.getbyName("sbwmid1").value;
	var sbwmid2 = mini.getbyName("sbwmid2").value;
	var sbwmid3 = mini.getbyName("sbwmid3").value;
	var sbwmid4 = mini.getbyName("sbwmid4").value;
	if(sbwmid1=='N' && sbwmid2=='N' && sbwmid3=='N' &&sbwmid4=='N'){
		mini.alert("至少选择一种【经营方式】!!!");
		return;
	}
	var detData = bsupplierqc.getData();
	for ( var i = 0; i < detData.length; i++) {
		var sqtype = detData[i].sqtype;
		if (!detData[i].muid) {
			mini.alert("资质证明明细第" + (i + 1) + "行门店为空，请检查");
			return;
		}
		if (!sqtype) {
			mini.alert("资质证明明细第" + (i + 1) + "行资质类型为空，请检查");
			return;
		}

		if (!detData[i].sqno) {
			mini.alert("资质证明明细第" + (i + 1) + "行证件号码为空，请检查");
			return;
		}

		if (!detData[i].sqfzjg) {
			mini.alert("资质证明明细第" + (i + 1) + "行发证机关为空，请检查");
			return;
		}

		if (!detData[i].sqeffdate) {
			mini.alert("资质证明明细第" + (i + 1) + "行有效截止日期为空，请检查");
			return;
		}

		if (!detData[i].sqstartdate) {
			mini.alert("资质证明明细第" + (i + 1) + "行发证日期为空，请检查");
			return;
		}

		if (!detData[i].squrl) {
			var newrow = {};
			newrow.squrl = getSqurl();
			bsupplierqc.updateRow(detData[i], newrow);
		}

	}

	var _skman = bsuplinkman.getData();
	if (_skman.length > 0) {
		var md=[];
		for ( var i = 0; i < _skman.length; i++) {
			if (!_skman[i].muid) {
				mini.alert("联系人明细第" + (i + 1) + "行门店为空，请检查");
				return;
			}
			if (!_skman[i].linkman) {
				mini.alert("联系人明细第" + (i + 1) + "行联系人为空，请检查");
				return;
			}
			if (_skman[i].mrlinkman == 'Y') {
				ismr = false;
				count++;
			}

			if(md.length<=0){
				md.push({"muid":_skman[i].muid_name,"zcnt":1,"lxr_cnt":(_skman[i].mrlinkman == 'Y')?1:0});
			}else{
				var n =false;
				for(var j=0;j<md.length;j++){
					if(md[j].muid ==_skman[i].muid_name){
						md[j].zcnt =md[j].zcnt+1;
						if(_skman[i].mrlinkman == 'Y'){
							md[j].lxr_cnt =md[j].lxr_cnt+1;
						}
						n =true;
					}
				}
				if(n ==false){
					md.push({"muid":_skman[i].muid_name,"zcnt":1,"lxr_cnt":(_skman[i].mrlinkman == 'Y')?1:0});
				}
			}
		}
		for(var i=0;i<md.length;i++){
			if(md[i].lxr_cnt >1){
				mini.alert("门店【"+md[i].muid+"】默认的联系人只需要一个，请检查");
				return;
			}else if(md[i].lxr_cnt <1){
				mini.alert("门店【"+md[i].muid+"】需要一个默认的联系人，请检查");
				return;
			}
		}
//		if (count > 1) {
////			mini.alert("默认的联系人只需要一个，请检查");
////			return;
//		}
//		if (ismr) {
//			mini.alert("需要一个默认的联系人，请检查");
//			return;
//		}
	}
	obj.billtype = getBilltype(billmoduleid);
	return obj;

};

// 保存按钮后事件
OcmControl.toolbarFn.saveDataAfter = function() {
	setBillData();
};

// 审核按钮后事件
OcmControl.toolbarFn.auditDataAfter = function() {
	setBillData();
};

// 取消按钮后事件
OcmControl.toolbarFn.cancelDataAfter = function() {
	setBillData();
};

// 明细增行按钮前事件
OcmControl.toolbarFn.addRowBefore = function() {
	var form = details1.form;
	var sbid = form.getField("sbid").getValue();
	var obj = {
		"modflag" : "I",
		"sbid" : sbid
	};

	var tab = tabs2.getActiveTab();
	if (tab) {
		if (tab.name == "bsuplinkman" || tab.name == "bsupplierqc"
				|| tab.name == "bsupplierpp") {
			obj.lastmoder = getUserCode();
			obj.lastmoddate = mini
					.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss");
		}
		var ismr = true;
		if (tab.name == "bsuplinkman") {
			var _data = bsuplinkman.getData();
			if (_data.length > 0) {
				for ( var i = 0; i < _data.length; i++) {
					if (_data[i].mrlinkman == 'Y') {
						ismr = false;
					}
				}
			}
//			if (ismr) {
//				obj.mrlinkman = 'Y';
//			};
		}
		;
	}
	return obj;
};

// 明细删除按钮前事件
OcmControl.toolbarFn.delRowBefore = function() {
	var obj = {};
	var tabs2 = mini.get("tabs2");
	var tab = tabs2.getActiveTab();
	if (tab) {
		if (tab.name == "bsupmkt") {
			var bsupmkt = mini.get("bsupmkt");
			var data = bsupmkt.getData();
			var rows = bsupmkt.getSelected();
			if (data.length <= 1) {
				mini.alert("门店信息不能为空");
				return;
			}
			;
		}
		if (tab.name == "bsuplinkman" || tab.name == "bsupplierqc") {
			var tabgrid = mini.get(tab.name);
			var rows = tabgrid.getSelecteds();
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (row.modflag == "I") {
						var newrow = {
							flag : "D"
						};
						tabgrid.updateRow(row, newrow);
						tabgrid.removeRow(row);
					} else {
						var newrow = {
							modflag : "D"
						};
						tabgrid.updateRow(row, newrow);
						tabgrid.removeRow(row);

					}
				}
				return;
			}
		}
		if (tab.name == "bsupplierpp") {
			var tabid = mini.get(tab.name);
			var ppcode = mini.getbyName("ppcode"); // 获取门店
			var data = bsupplierpp.getData();
			var rows = bsupplierpp.getSelected();
			if (rows.ppcode == ppcode.value) {
				mini.alert("单头主营品牌不能删除");
				return;
			}
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (row.modflag == "I") {
						var newrow = {
							flag : "D"
						};
						tabid.updateRow(row, newrow);
						tabid.removeRow(row);
					} else {
						var newrow = {
							modflag : "D"
						};
						tabid.updateRow(row, newrow);
						tabid.removeRow(row);

					}
				}
				return;
			}
		}
	}
	return obj;
};

// 供应商编码点击
function onSupidClick(e) {
	var buttonEdit = e.sender;
	var _url = "/mall-business-ui/pages/common/gridbox-view.jsp?key=vendor2"
		+ "&token=" + token;
	if (app.srvkey && app.srvkey != "")
	{
		_url = _url + "&srvkey="+ app.srvkey;
	}
	mini.open({
		url : encodeURI(_url),
		title : "供应商编码",
		width : 600,
		height : $(window).height() * 0.8,
		onload : function() {
			var iframe = this.getIFrameEl();
			var data = {
				"searchParam" : {
					"sbstatus" : {
						"$in" : "Y,M"
					}
				}
			};
			iframe.contentWindow.SetData(data);
		},
		ondestroy : function(data) {
			if (data != "close") {
				if (data.length > 0) {
					buttonEdit.setValue(data[0].sbid);
					buttonEdit.setText("[" + data[0].sbcode + "]"
							+ data[0].sbcname);
					buttonEdit.setIsValid(true);

					setSupData(data[0].sbid,data[0].ph_key);
				}
			}
		}
	});
}

// 供应商编码输入
function onSupidChange(e) {

	var buttonEdit = e.sender;
	var text = buttonEdit.getText();
	if (text == null || text == "") {
		buttonEdit.setValue("");
	} else {
		var searchParam = {
			"sbstatus" : {
				"$in" : "Y,M"
			},
			"sbcode" : text
		};
		var method = "mss.supplier.supplierbase.search";
		itemLoader.doRequest(OmdUrl.mall, method, searchParam, null, null,
				function(data) {
					var data = data.supplierbase;
					if (data.length > 0) {
						buttonEdit.setValue(data[0].sbid);
						buttonEdit.setText(data[0].sbcode);
						buttonEdit.setText("[" + data[0].sbcdoe + "]"
								+ data[0].sbcname);

						setSupData(data[0].sbid,data[0].ph_key);
					} else {
						mini.alert("供应商编码[" + text + "]不存在");
						buttonEdit.setValue("");
						buttonEdit.setText("");
					}
				}, null, null, false);
	}
}

// 品牌点击，
function onPpcodeClick(e) {
	var buttonEdit = e.sender;
	var _url = "/mall-business-ui/pages/common/gridbox-view.jsp?key=brand"
		+ "&token=" + token;
	if (app.srvkey && app.srvkey != "")
	{
		_url = _url + "&srvkey="+ app.srvkey;
	}
	mini.open({
		url : encodeURI(_url),
		title : "品牌",
		width : 600,
		height : $(window).height() * 0.8,
		onload : function() {
			var iframe = this.getIFrameEl();
			var data = {};
			iframe.contentWindow.SetData(data);
		},
		ondestroy : function(data) {
			if (data != "close") {
				if (data.length > 0) {
					if (buttonEdit.getValue() != data[0].code) {
						buttonEdit.setValue(data[0].code);
						buttonEdit.setText("[" + data[0].code + "]"
								+ data[0].name);
						buttonEdit.setIsValid(true);
					}
				}
			}
		}
	});
}

// 品牌输入，通过编码查询品牌
function onPpcodeChange(e) {
	var buttonEdit = e.sender;
	var text = buttonEdit.getText();
	if (text == null || text == "") {
		buttonEdit.setValue("");
	} else {
		var searchParam = {
			"code" : text
		};
		var method = "ocm.mdm.brand.search";
		itemLoader.doRequest(OmdUrl.mdm, method, searchParam, null, null,
				function(data) {
					var data = data.brand;
					if (data.length > 0) {
						buttonEdit.setValue(data[0].code);
						buttonEdit.setText("[" + data[0].code + "]"
								+ data[0].name);
					} else {
						mini.alert("品牌编码[" + text + "]不存在");
						buttonEdit.setValue("");
						buttonEdit.setText("");
					}
				}, null, null, false);
	}
}

// 主营业种点击，
function onMidClick(e) {
	var buttonEdit = e.sender;
	var _url = "/mall-business-ui/pages/common/gridbox-view.jsp?key=cat"
		+ "&token=" + token;
	if (app.srvkey && app.srvkey != "")
	{
		_url = _url + "&srvkey="+ app.srvkey;
	}
	mini.open({
		url : encodeURI(_url),
		title : "主营业种",
		width : 600,
		height : $(window).height() * 0.8,
		onload : function() {
			var iframe = this.getIFrameEl();
			var data = {};
			iframe.contentWindow.SetData(data);
		},
		ondestroy : function(data) {
			if (data != "close") {
				if (data.length > 0) {
					if (buttonEdit.getValue() != data[0].cid) {
						buttonEdit.setValue(data[0].cid);
						buttonEdit.setText("[" + data[0].code + "]"
								+ data[0].name);
					}
				}
			}
		}
	});
}

// 主营业种输入
function onMidChange(e) {
	var buttonEdit = e.sender;
	var text = buttonEdit.getText();
	if (text == null || text == "") {
		buttonEdit.setValue("");
	} else {
		var searchParam = {
			"code" : text
		};
		var method = "ocm.mdm.manacat.search";
		itemLoader.doRequest(OmdUrl.mdm, method, searchParam, null, null,
				function(data) {
					var data = data.category;
					if (data.length > 0) {
						buttonEdit.setValue(data[0].cid);
						buttonEdit.setText("[" + data[0].code + "]"
								+ data[0].name);
					} else {
						mini.alert("主营业种编码[" + text + "]不存在");
						buttonEdit.setValue("");
						buttonEdit.setText("");
					}
				}, null, null, false);
	}
}

// 省市点击，
function onProvinceClick(e) {
	var buttonEdit = e.sender;
	var form = details1.form;
	var _url = "/mall-business-ui/pages/common/gridbox-view.jsp?key=city"
		+ "&token=" + token;
	if (app.srvkey && app.srvkey != "")
	{
		_url = _url + "&srvkey="+ app.srvkey;
	}
	mini.open({
		url : encodeURI(_url),
		title : "省市",
		width : 600,
		height : $(window).height() * 0.8,
		onload : function() {
			var iframe = this.getIFrameEl();
			var data = {};
			if (buttonEdit.name == "province") {
				data = {
					"searchParam" : {
						"crclass" : "1"
					}
				};
			} else if (buttonEdit.name == "city") {
				var pro = form.getField("province").getValue();
				if (pro != null && pro != "") {
					data = {
						"searchParam" : {
							"crpcode" : pro
						}
					};
				}
			}
			iframe.contentWindow.SetData(data);
		},
		ondestroy : function(data) {
			if (data != "close") {
				if (data.length > 0) {
					if (buttonEdit.getValue() != data[0].crcode) {
						buttonEdit.setValue(data[0].crcode);
						buttonEdit.setText("[" + data[0].crcode + "]"
								+ data[0].crcname);

						if (buttonEdit.name == "province") {
							form.getField("city").setValue("");
							form.getField("city").setText("");
						}
					}
				}
			}
		}
	});
}

// 省市输入
function onProvinceChange(e) {
	var buttonEdit = e.sender;
	var form = details1.form;
	var text = buttonEdit.getText();
	if (text == null || text == "") {
		buttonEdit.setValue("");
	} else {
		var searchParam = {
			"crcode" : text
		};
		if (buttonEdit.name == "province") {
			searchParam.crclass = "1";
		} else if (buttonEdit.name == "city") {

			var pro = form.getField("province").getValue();
			if (pro != null && pro != "") {
				searchParam.crpcode = pro;
			}
		}
		var method = "ocm.mdm.region.search";
		itemLoader.doRequest(OmdUrl.mdm, method, searchParam, null, null,
				function(data) {
					var data = data.coderegion;
					if (data.length > 0) {
						buttonEdit.setValue(data[0].crcode);
						buttonEdit.setText("[" + data[0].crcode + "]"
								+ data[0].crcname);

						if (buttonEdit.name == "province") {
							form.getField("city").setValue("");
							form.getField("city").setText("");
						}
					} else {
						mini.alert("省市编码[" + text + "]不存在");
						buttonEdit.setValue("");
						buttonEdit.setText("");
					}
				}, null, null, false);
	}
}

// 门店点击
function onMuidClick(e) {
	var buttonEdit = e.sender;

	// 判断门店列表是否有值
	if (bsupmkt.getData().length == 0) {
		amini.lert("请先输入门店列表");
		return;
	}

	// 判断不同的tab页
	var tab = tabs2.getActiveTab();
	var tbody = tabs2.getTabBodyEl(tab);
	var gridid = $(tbody).find("div").attr("id");
	var grid = mini.get(gridid);
	var row = grid.getSelected();

	mini
			.open({
				url : encodeURI("/mall-business-ui/pages/common/gridbox-view.jsp?key=opermkt"
						+ "&token=" + token),
				title : "门店",
				width : 600,
				height : $(window).height() * 0.8,
				onload : function() {
					var iframe = this.getIFrameEl();
					var data = {};
					if (gridid == "bsuplinkman" || gridid == "bsupplierqc") {
						var muidStr = [];
						var muidData = bsupmkt.getData();
						if (muidData != null && muidData.length > 0) {
							for ( var i = 0; i < muidData.length; i++) {
								muidStr.push(muidData[i].muid);
							}
						}
						data = {
							"searchParam" : {
								"oid" : {
									"$in" : muidStr
								}
							}
						};
					}
					iframe.contentWindow.SetData(data);
				},
				ondestroy : function(data) {
					if (data != "close") {
						if (data.length > 0) {

							if (gridid == "bsupmkt") {
								var bsupmktdata = bsupmkt.getData();
								if (bsupmktdata.length > 0) {
									for ( var i = 0; i < bsupmktdata.length; i++) {
										var bsupmktrow = bsupmktdata[i];
										if (bsupmktrow.muid == data[0].oid) {
											mini.alert("门店已添加");
											return;
										}
									}
								}
							}

							buttonEdit.setValue(data[0].oid);
							buttonEdit.setText("[" + data[0].code + "]"
									+ data[0].name);
							var newrow = {
								muid : data[0].oid,
								muid_name : "[" + data[0].code + "]"
										+ data[0].name
							};
							grid.updateRow(row, newrow);
						}
					}
				}
			});
}

// 门店输入
function onMuidChange(e) {
	var buttonEdit = e.sender;
	var value = e.value;

	// 判断不同的tab页
	var tab = tabs2.getActiveTab();
	var tbody = tabs2.getTabBodyEl(tab);
	var gridid = $(tbody).find("div").attr("id");
	var grid = mini.get(gridid);
	var row = grid.getSelected();

	if (value == "") {
		buttonEdit.setValue("");
		buttonEdit.setText("");
		var newrow = {
			muid : "",
			muid_name : ""
		};
		grid.updateRow(row, newrow);
		return;
	}
	var method = "ocm.mdm.org.search";
	var searchParam = {
		"code" : value
	};

	if (gridid == "bsuplinkman" || gridid == "bsupplierqc") {
		var muidStr = [];
		var muidData = bsupmkt.getData();
		if (muidData != null && muidData.length > 0) {
			for ( var i = 0; i < muidData.length; i++) {
				muidStr.push(muidData[i].muid);
			}
		}
		searchParam.oid = {
			"$in" : muidStr
		};
	}

	itemLoader.doRequest(OmdUrl.mdm, method, searchParam, null, null, function(
			data) {
		var data = data.organization;
		if (data.length > 0) {
			var bsupmktdata = bsupmkt.getData();
			if (bsupmktdata.length > 0) {
				for ( var i = 0; i < bsupmktdata.length; i++) {
					var bsupmktrow = bsupmktdata[i];
					if (bsupmktrow.muid == data[0].oid) {
						mini.alert("门店已添加");
						buttonEdit.setText("");
						return;
					}
				}
			}

			buttonEdit.setValue(data[0].oid);
			buttonEdit.setText("[" + data[0].code + "]" + data[0].name);
			var newrow = {
				muid : data[0].oid,
				muid_name : "[" + data[0].code + "]" + data[0].name
			};
			grid.updateRow(row, newrow);
		} else {
			mini.alert("不存在输入的门店");
			buttonEdit.setValue("");
			buttonEdit.setText("");
			return;
		}
	}, null, null, false);
}

// 品牌点击
function onPpcodeClick(e) {
	var buttonEdit = e.sender;
	var row = bsupplierpp.getSelected();
	var _url = "/omp-business-ui/pages/common/gridbox-view.jsp?key=brand"
		+ "&token=" + token;
	if (app.srvkey && app.srvkey != "")
	{
		_url = _url + "&srvkey="+ app.srvkey;
	}
	mini.open({
		url : encodeURI(_url),
		title : "品牌",
		width : 600,
		height : $(window).height() * 0.8,
		onload : function() {
			var iframe = this.getIFrameEl();
			var data = {};
			iframe.contentWindow.SetData(data);
		},
		ondestroy : function(data) {
			if (data != "close") {
				if (data.length > 0) {
					var ppgriddata = bsupplierpp.getData();

					// 判断选择的品牌是否在列表中
					var isExist = false;
					for ( var j = 0; j < ppgriddata.length; j++) {
						if (data[0].code == ppgriddata[j].ppcode) {
							isExist = true;
							break;
						}
					}
					if (!isExist) {
						var newrow = {
							ppcode : data[0].code,
							ppcode_name : "[" + data[0].code + "]"
									+ data[0].name,
						};

						bsupplierpp.updateRow(row, newrow);
						buttonEdit.setText(newrow.ppcode_name);
						buttonEdit.setIsValid(true);

					} else {
						mini.alert("列表中品牌已经存在");
					}
				}
			}
		}
	});
}

// 品牌输入
function onPpcodeChange(e) {
	var row = bsupplierpp.getSelected();
	var ppgriddata = bsupplierpp.getData();
	var buttonEdit = e.sender;
	var text = buttonEdit.getText();
	if (text == null || text == "") {
		buttonEdit.setValue("");
		var newrow = {
			ppcode : "",
			ppcode_name : "",
		};
		bsupplierpp.updateRow(row, newrow);
	} else {
		var searchParam = {
			"code" : text
		};
		var method = "ocm.mdm.brand.search";
		itemLoader.doRequest(OmdUrl.mdm, method, searchParam, null, null,
				function(data) {
					var data = data.brand;
					if (data.length > 0) {
						for ( var i = 0; i < ppgriddata.length; i++) {
							if (ppgriddata[i].ppcode == data[0].code) {
								mini.alert("列表中品牌已经存在");
								buttonEdit.setText("");
								return;
							}
						}
						var newrow = {
							ppcode : data[0].code,
							ppcode_name : "[" + data[0].code + "]"
									+ data[0].name,
						};

						bsupplierpp.updateRow(row, newrow);
						buttonEdit.setText("[" + data[0].code + "]"
								+ data[0].name);
					} else {
						mini.alert("品牌编码[" + text + "]不存在");
						buttonEdit.setText(row.ppcode_name);
					}
				}, null, null, false);
	}
}

function onCellEndEdit(e) {
	var field = e.field;
	var row = e.row;
	var rows = bsuplinkman.getData();
	if (e.value == 'Y') {
		if (field == "address") {
			for ( var i = 0; i < rows.length; i++) {
				if (rows[i].muid == row.muid && rows[i].address == e.value
						&& rows[i]._id != row._id) {
					mini.alert("同门店只允许选择一个联系人快递地址！");
					bsuplinkman.updateRow(row, {
						"address" : "N"
					});
					return;
				}
			}
		}
		;
		if (field == "mrlinkman") {
			for ( var i = 0; i < rows.length; i++) {
				if (rows[i].mrlinkman == e.value && rows[i]._id != row._id) {
					mini.alert("同门店只允许选择一个默认联系人！");
					bsuplinkman.updateRow(row, {
						"mrlinkman" : "N"
					});
					return;
				}
			}
		}
		;
	}
}

// 单元格修改
function onCellCommitEdit(e) {
	var row = e.row;
	var grid = e.sender;
	if (row.modflag == "N") {
		var newRow = {
			"modflag" : "M"
		};
		grid.updateRow(row, newRow);
	}
}

// 单元格编辑前
function onCellbeginedit(e) {
	var row = e.record;

	if (row.modflag == "D") {
		row.readOnly = true;
		row.Enabled = false;
		e.cancel = true;
	} else {
		row.readOnly = false;
		e.cancel = false;
	}

	var field = e.field;
	if (field == "issend") {
		if (!row.emailaddr) {
			mini.alert("请先输入邮箱地址");
			e.cancel = true;
		}
	}
	if (field == "address") {
		if (!row.linkman) {
			mini.alert("请先输入联系人");
			e.cancel = true;
			return;
		}
		if (!row.lmadd) {
			mini.alert("请先输入联系地址");
			e.cancel = true;
			return;
		}
		if (!row.lmphone) {
			mini.alert("请先输入联系人电话");
			e.cancel = true;
			return;
		}

	}
	return;
}

if (bsupmkt) {
	bsupmkt.on("cellcommitedit", onCellCommitEdit);
	bsupmkt.on("cellbeginedit", onCellbeginedit);
}
if (bsuplinkman) {
	bsuplinkman.on("cellendedit", onCellEndEdit);
	bsuplinkman.on("cellcommitedit", onCellCommitEdit);
	bsuplinkman.on("cellbeginedit", onCellbeginedit);

}
if (bsupplierqc) {
	bsupplierqc.on("cellcommitedit", onCellCommitEdit);
	bsupplierqc.on("cellbeginedit", onCellbeginedit);
}
if (bsupplierpp) {
	bsupplierpp.on("cellcommitedit", onCellCommitEdit);
	bsupplierpp.on("cellbeginedit", onCellbeginedit);
}

// 上传图片
function upPhoto() {
	var form = details1.form;
	var billno = form.getField("billno").getValue();
	if (billno == "" || billno == undefined) {
		mini.alert("请先保存单据");
		return;
	}

	var rows = bsupplierqc.getSelecteds();
	if (rows.length != 1) {
		mini.alert("请选择资质证明一行记录");
		return;
	}
	var flag = true;
	var squrl;
	squrl = rows[0].squrl;
	/*
	 * var sqstatus = rows[0].sqstatus; if (sqstatus == "C") {
	 * mini.alert("资质审核已通过，不允许上传附近"); return; }
	 */
	if (squrl == "" || squrl == undefined) {
		flag = false;
		squrl = getSqurl();
	}
	var billstatus = form.getField("billstatus").getValue();
	Future.Pub.addfile(squrl, billmoduleid, billstatus, function(data) {
		if (data.returncode == "0") {
			mini.alert("上传成功！");
		}
	});

	if (!flag) {
		bsupplierqc.updateRow(rows[0], {
			"squrl" : squrl,
			"issqurl" : "1"
		});
	}
}
// 审核资质
function checkPhoto() {
	var rows = bsupplierqc.getSelecteds();
	if (rows.length == 0) {
		mini.alert("请选择资质证明一行记录");
		return;
	}

	for ( var i = 0; i < rows.length; i++) {
		var row = rows[i];
		if (!checkQcDate(row)) {
			return;
		}
		bsupplierqc.updateRow(rows[i], {
			"sqstatus" : "C"
		});

	}
	/*
	 * var form = details1.form; var billstatus =
	 * form.getField("billstatus").getValue(); if (billstatus == "Y") {
	 * saveSqul(); }
	 */
}

// 检查数据
function checkQcDate(row) {
	var form = details1.form;
	var billno = form.getField("billno").getValue();
	if (billno == "" || billno == undefined) {
		mini.alert("请先保存单据");
		return false;
	}
	if (!row.sqstatus || row.sqstatus == "C") {
		mini.alert("已经资质审核过，请重新选择");
		return false;
	}

	if (!row.muid_name || row.muid_name == "") {
		mini.alert("门店不能为空");
		return false;
	}
	if (!row.sqtype || row.sqtype == "") {
		mini.alert("资质类型不能为空");
		return false;
	}
	if (!row.sqno || row.sqno == "") {
		mini.alert("证件号码不能为空");
		return false;
	}
	if (!row.sqfzjg || row.sqfzjg == "") {
		mini.alert("发证机关不能为空");
		return false;
	}
	if (!row.sqeffdate || row.sqeffdate == "") {
		mini.alert("有效截止日期不能为空");
		return false;
	}
	if (!row.sqstartdate || row.sqstartdate == "") {
		mini.alert("发证日期不能为空");
		return false;
	}

	if (!row.squrl || row.squrl == "") {
		mini.alert("附件不能为空");
		return false;
	} else {
		if (!isSqurl(row.squrl)) {
			mini.alert("附件不能为空");
			return false;
		}
	}
	return true;
}

// 资质类型值改变
function onSqtypeChange(e) {
	var row = bsupplierqc.getSelected();
	var sqData = bsupplierqc.getData();
	var value = e.value;
	var editor = e.sender;
	for ( var i = 0; i < sqData.length; i++) {
		if (row._id != sqData[i]._id && sqData[i].sqtype == value
				&& sqData[i].muid == row.muid) {
			editor.setValue(row.sqtype);
			mini.alert("资质类型已添加");
			return;
		}
	}
}

// 有效截止日期输入
function onSqeffChange(e) {
	var value = e.value;
	var editor = e.sender;
	var row = bsupplierqc.getSelected();
	var sqstartdate = row.sqstartdate;
	if (value != "" || sqstartdate != "") {
		value = mini.formatDate(value, "yyyy-MM-dd");
		if (value < sqstartdate) {
			editor.setValue(row.sqeffdate);
			mini.alert("有效截止日期必须大于发证日期");
			return;
		}
	}
}

// 发证日期输入
function onSqstartChange(e) {
	var row = bsupplierqc.getSelected();
	var value = e.value;
	var editor = e.sender;
	var sqeffdate = row.sqeffdate;
	if (value != "" || sqeffdate != "") {
		value = mini.formatDate(value, "yyyy-MM-dd");
		if (sqeffdate < value) {
			editor.setValue(row.sqstartdate);
			mini.alert("有效截止日期必须大于发证日期");
			return;
		}
	}
}

// 证件号码输入
function onSqnoChange(e) {
	var row = bsupplierqc.getSelected();
	var sqData = bsupplierqc.getData();
	var value = e.value;
	var editor = e.sender;
	for ( var i = 0; i < sqData.length; i++) {
		if (sqData[i].sqno == value) {
			editor.setValue(row.sqno);
			mini.alert("证件号码已添加");
			return;
		}
	}

	var searchParam = {
		"sqno" : value
	};
	var method = "mss.supplier.bsupplierbase.checkSqno";
	itemLoader.doRequest(OmdUrl.mall, method, searchParam, null, null,
			function(data) {
				var num = data.num;
				if (num > 0) {
					editor.setValue(row.sqno);
					mini.alert("证件号码已存在");
					return;
				}
			}, null, null, false);
}

function addPhoto() {
	var _url = "/mall-business-ui/pages/supplier/sqctemplet-view.jsp?token="
		+ token;
	if (app.srvkey && app.srvkey != "")
	{
		_url = _url + "&srvkey="+ app.srvkey;
	}
	mini.open({
		url : encodeURI(_url),
		title : "资质模板",
		width : 800,
		height : $(window).height() * 0.8,
		onload : function() {
			var iframe = this.getIFrameEl();
			var data = {};
			iframe.contentWindow.SetData(data);
		},
		ondestroy : function(data) {
			if (data != "close") {
				if (data.length > 0) {
					var bsupplierqcdata = bsupplierqc.getData();

					var form = details1.form;
					var sbid = form.getField("sbid").getValue();

					for ( var j = 0; j < data.length; j++) {
						var sqcdrow = data[j];
						var flag = false;
						for ( var i = 0; i < bsupplierqcdata.length; i++) {
							var bsupplierqcrow = bsupplierqcdata[i];
							if (sqcdrow.sqtype == bsupplierqcrow.sqtype) {
								flag = true;
							}
						}
						if (flag == false) {
							var newrow = {
								"modflag" : "I",
								"sbid" : sbid,
								"sqstatus" : "N",
								"issqurl" : "0"
							};
							newrow.lastmoder = getUserCode();
							newrow.lastmoddate = mini.formatDate(new Date(),
									"yyyy-MM-dd HH:mm:ss");
							newrow.sqtype = sqcdrow.sqtype;
							bsupplierqc.addRow(newrow);
						}

					}
				}
			}
		}
	});
}

function getSqurl() {
	var source = "";
	itemLoader.doRequest(OmdUrl.mall, "mss.supplier.bsupplierbase.getSqurl",
			{}, null, null, function(data) {
				source = data.squrl;
			}, null, null, false);
	return source;
}

function isCheckSup(para) {
	var billno = "";
	itemLoader.doRequest(OmdUrl.mall, "mss.supplier.bsupplierbase.search",
			para, null, null, function(data) {
				if (data.bsupplierbase.length > 0) {
					billno = data.bsupplierbase[0].billno;
				}
			}, null, null, false);
	return billno;
}

function isSqurl(squrl) {
	var flag = false;
	var searchParam = {
		billno : squrl,
		billmoduleid : billmoduleid,
	};
	var method = "serverutils.getEnclosure";
	itemLoader.doRequest(OmdUrl.mss, method, searchParam, null, null, function(
			data) {
		if (data.length == "0") {
		} else {
			flag = true;
		}
	}, null, null, false);
	return flag;
}

function delSqul(data) {
	var temp = {};
	for ( var i = 0; i < data.length; i++) {
		if (data[i].squrl != "" && data[i].squrl != undefined) {
			temp.billno = data[i].squrl;
			temp.billmoduleid = billmoduleid;
			appendix.setAppendixData(temp);
			appendix.dellAllfile();
		}
	}
}

function head_itemchanged_sbid(e, data) {
	var para = {};
	para.sbcode = data[0].sbcode;
	para.billstatus = "N";
	var billno = isCheckSup(para);
	if (billno) {
		mini.alert("商户[" + para.sbcode + "]存在未审核的变更单[" + billno + "]，请检查");
		return -1;
	}
	setSupData(data[0].sbid,data[0].ph_key);

	mini.getbyName("sbcode").setValue(data[0].sbcode);
	mini.getbyName("sbcode").setText(data[0].sbcode);

	var buttonEdit = e.sender;
	buttonEdit.setIsValid(true);
	return -1;
}

function head_beforefunc_muid_detail(e) {
	var grid = e.sender.grid;
	if (!e.searchParam) {
		e.searchParam = {};
	}
	if (grid == bsuplinkman || grid == bsupplierqc) {

		var muidStr = "";
		var muidData = bsupmkt.getData();
		if (muidData.length == 0) {
			alert("请先输入门店列表");
			return -1;
		}
		if (muidData != null && muidData.length > 0) {
			for ( var i = 0; i < muidData.length; i++) {
				muidStr = muidStr + "'" + muidData[i].muid + "',";
			}
		}
		if (muidStr.length > 0) {
			muidStr = muidStr.substring(0, muidStr.length - 1);
			e.searchParam.wherestr = "muid in ( " + muidStr + ")";
		}
	}

	return 0;
}

function head_itemchanged_muid_detail(e, data) {
	var grid = e.sender.grid;
	var row = grid.getSelected();
	var griddata = grid.getData();
	if (grid == bsupmkt) {
		for ( var i = 0; i < griddata.length; i++) {
			if (row._id != griddata[i]._id && griddata[i].muid == data[0].muid) {
				if (grid == bsupmkt) {
					mini.alert("门店" + data[0].mucode + "已添加");
					return -1;
				} else {
					if (griddata[i].sqtype == row.sqtype) {
						mini.alert("门店" + data[0].mucode + "已添加");
						return -1;
					}
				}
			}
		}
	}
	return 0;
};

function head_itemchanged_province(e, data) {
	mini.getbyName("city").setValue("");
	mini.getbyName("city").setText("");
	return 0;
}

// 明细品牌回填
function head_itemchanged_ppcodedet(e, data) {
	if (data != null) {
		var bsupplierpp = mini.get("bsupplierpp");
		var row = bsupplierpp.getSelected();
		if (data.length > 0) {
			// 不允许添加重复费用项目
			var boolean = false;
			var exitGood = "";
			var maxrow = 0;
			var exitDatas = bsupplierpp.getData();
			for ( var j = 0; j < data.length; j++) {
				for ( var i = 0; i < exitDatas.length; i++) {
					if (exitDatas[i].ppcode == data[j].code) {
						exitGood = exitGood + "[" + data[j].code + "],";
						boolean = true;
						break;
					}
				}
				if (!boolean) {
					var newrow = {
						ppcode : data[j].code,
						ppcode_name : "[" + data[j].code + "]" + data[j].name,
						lastmoder : getUserCode(),
						lastmoddate : mini.formatDate(new Date(),
								"yyyy-MM-dd HH:mm:ss"),
					};
					bsupplierpp.updateRow(row, newrow);
				} else {
					/* supsetdepositdet.rejectRecord(row); */
					var delrow = {
						flag : "D",
					};
					bsupplierpp.updateRow(row, delrow);
					bsupplierpp.removeRow(row);
					boolean = false;
				}

			}
			if (exitGood != "" && exitGood.length > 1) {
				mini.alert("明细中已有相同主营品牌:"
						+ exitGood.substring(0, exitGood.length - 1));
			}
		}

	}
	return 0;
}

function onTaxnoChange(e) {
	var value = e.value;
	if (e.value != "") {
		if (isTaxno(value)) {
			mini.alert("税号已被使用");
			mini.getbyName("taxno").setValue("");
			return;
		}
	}
}

function isTaxno(taxno) {
	var flag = false;
	var sbcode = mini.getbyName("sbcode").getValue();
	var param = {};
	param.taxno = taxno;
	itemLoader.doRequest(OmdUrl.mall, "mss.supplier.supplierbase.search",
			param, null, null, function(data) {
				var supplierbase = data.supplierbase;
				if (supplierbase.length > 0) {
					if (supplierbase.length == 1) {
						if (supplierbase[0].sbcode != sbcode) {
							flag = true;
						}
					} else {
						flag = true;
					}
				}
			}, null, null, false);
	return flag;
}

function onFplxChange(e) {
	var value = e.value;
	if (e.value == "2") {
		mini.getbyName("sbfp").setRequired(true);
		setStatus(true);
	}
	if (e.value == "1") {
		mini.getbyName("sbfp").setRequired(true);
		setStatus(false);
	}
	if (e.value == "") {
		mini.getbyName("sbfp").setRequired(false);
		setStatus(false);
	}
}

function setStatus(node) {
	mini.getbyName("sbfpadd").setRequired(node);
	// mini.getbyName("taxno").setRequired(node);
	mini.getbyName("sbbank").setRequired(node);
	mini.getbyName("sbaccount").setRequired(node);
	mini.getbyName("frdb").setRequired(node);
	mini.getbyName("phone").setRequired(node);
}
// 纳税级别
function ontaxlevelChange(e) {
	var value = e.value;
	var name = e.source.name;
	var label = e.source.label;
	var wherestr = "";
	if (name == "taxlevel") {
		wherestr += " dictype = 'TAXLEVEL' and dcode='" + value + "'";
		var searchParam = {
			"wherestr" : wherestr,
			"queryid" : "select_dict"
		};
		var method = "mss.work.report.query";
		itemLoader.doRequest(OmdUrl.mall, method, searchParam, null, null,
				function(data) {
					var data = data.report;
					if (data.length > 0) {
						mini.getbyName("applicabletax").setValue(data[0].dmin);
					}
				}, null, null, false);
	}
};
