/**
 *  页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('supsetpayRefunds.view');

	// 定义一个对象用来配置界面
	var bill = {};
	var billtype = getBilltype(app.modulecode);
	
	// 把定义对象放到命名空间下
	ns.bill = bill;
	utils.billtype = billtype;
	// 字典数据初始化
 	var dicData = OcmControl.getDict("PAYMODE","code,name,pro1,ddvalue");
 	var temppaymode = [];
 	var tempdp = dicData.PAYMODE;
 	for (var i = 0;i < tempdp.length; i++){
 		if ((tempdp[i].pro1).indexOf('F') !=  -1) {    //支付方式参数pro1包含F的数据 
 			temppaymode.push(tempdp[i]);
			}
 	}
 	dicData.PAYMODE = temppaymode;
	//查询列表
	bill.supsetpaylist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.base.supsetpay.search",
		"response": "v_supsetpayhead",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段		
		"searchParam": {
			"billmoduleid" : app.modulecode,
			"order_field": "billno",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('supsetpaylist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 160,
			}, {
				field: "billstatus",
				type: "comboboxcolumn",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				textField:"name",
        	    valueField:"code",
				dictkey: 'BILLSTATUS',
			}, {
				field: "muid",
				displayField : "muid_name",
				headerAlign: "center",
				header: "门店",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "muid",
					textName : "muid_name",
					responseName : "muid"
				},
				width: 160,
			}, {
				field: "sbid",
				displayField : "sbid_name",
				headerAlign: "center",
				header: "商户",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "sbid",
					textName : "sbid_name",
					responseName : "sbid"
				},
				width: 200,
			}, {
				field: "contno",
				type: "TextBox",
				headerAlign: "center",
				header: "合同号",
			},{
				field: "wmid",
				type: "comboboxcolumn",
				headerAlign: "center",
				header: "经营方式",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'WMID',
			}, {
				field: "payment",
				type: "comboboxcolumn",
				headerAlign: "center",
				header: "支付方式",
				renderer: "OcmControl.dictRendererWithCode",
//				dictkey: 'PAYMODE',
				data : dicData.PAYMODE,
			}, {
				field: "money",
				type: "TextBox",
				headerAlign: "center",
				header: "已收金额",
				width: 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				enabledSearch : false,
			}, {
				field: "factpay",
				type: "TextBox",
				headerAlign: "center",
				header: "本次退款",
				width: 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				enabledSearch : false,
			}, {
				field: "moneyupper",
				type: "TextBox",
				headerAlign: "center",
				header: "本次退款大写",
				width: 200,
				enabledSearch : false,
			}, {
				field: "payee",
				type: "TextBox",
				headerAlign: "center",
				header: "收款人全称",
				width: 140,
			}, {
				field: "bank",
				type: "TextBox",
				headerAlign: "center",
				header: "开户银行",
				width: 140,
				enabledSearch : false,
			}, {
				field: "accntno",
				type: "TextBox",
				headerAlign: "center",
				header: "银行账号",
				width: 180,
			}, {
				field: "sgdate",
				header: "到账日期",
				type: "DatePicker",
				headerAlign: "center",
				dataType: "date",
				dateFormat: "yyyy-MM-dd",
				width: 150,
			},{
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			},{
				field : "inputer_name",
				header : "录入人",
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
				width : 180,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 180,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "memo",
				header : "备注",
				width : 120,
				allowSort : true,
				headerAlign : "center",
			}]
		}
	};
	
	//单据主表
	bill.supsetpayhead = {
		"type": "formgrid",
		"resources": OmdUrl.mss,
		"name": 'supsetpayhead',
		"method": "mss.base.supsetpay.get",
		"response": "v_supsetpayhead",
		"properties": {
			"id": utils.createid('supsetpayhead')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"visible": true,
				"style":"width:22.5%" 
			},{
				"label" : "手工单号：",
				"name" : "billsgno",
				"type" : "TextBox",
				"style":"width:22.5%"
			}, {
				"label": "类型：",
				"name": "billtype",
				"type": "ComboBox",
				"defaultValue": billtype,
				dictkey: 'BILLTYPE',
				"visible": false,
				"style":"width:22.5%"
			}, {
				"label": "单据类型：",
				"name": "billmoduleid",
				"type": "ComboBox",
				"defaultValue": app.modulecode,
				dictkey: 'BILLMODULEID',
				"readOnly": true,
				"style":"width:22.5%",
				"visible": false,
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
				"style":"width:22.5%",
				//"style" : "width:22.5%;display:block;float:none",
			}, {
				"label" : "门店：",
				"name" : "muid",
				"defaultValue" : "",
				"required" : "true",
				type : "fut_popselect",//类型
				selectkey:"muid",//弹框类型
				textName :"muid_name", //文本显示字段
				"enabled" : true,
				itemchangedfunc:"page.head_itemchangedfunc",
				"style":"width:22.5%"
			}, {
				"label": "商户：",
				"name": "sbid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "sbid",
				textName: "sbid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc",
				itemchangedfunc:"page.head_itemchangedfunc",
				"style":"width:22.5%"
			}, {
				"label": "合同号：",
				"name": "contno",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "contno",
				textName: "contno",
				allowInput: true,
				beforefunc : "page.head_beforefunc",
				itemchangedfunc:"page.head_itemchangedfunc",
				"style" : "width:22.5%;",
			}, {
				"label": "经营方式：",
				"name": "wmid",
				"type": "ComboBox",
				dictkey: 'WMID',
				"required": false,
				"readOnly": "true",
				"style" : "width:22.5%;",
			},{
				"label": "支付方式：",
				"name": "payment",
				"type": "ComboBox",
//				dictkey: 'PAYMODE',
				data : dicData.PAYMODE,
				"required": "true",
				"style" : "width:22.5%;",
			},{
				"label" : "已收金额：",
				"name" : "money",
				"type" : "NumButtonEdit",
				"format" : "c2",
				"defaultValue":0,
				"readOnly": "true",
				"style" : "width:22.5%;",
			},{
				"label" : "已退金额：",
				"name" : "feestore",
				"type" : "NumButtonEdit",
				"format" : "c2",
				"defaultValue":0,
				"readOnly": true,
				"style" : "width:22.5%;",
			},{
				"label" : "本次退款：",
				"name" : "factpay",
				"type" : "NumButtonEdit",
				"format" : "c2",
				"defaultValue":0,
				"readOnly": true,
				"style" : "width:22.5%;",
			}, {
				"label": "退款大写：",
				"type": "TextBox",
				"name": "moneyupper",
				"readOnly": true,
				"style" : "width:22.5%;",
			}, {
				"label": "收款人全称：",
				"type": "TextBox",
				"name": "payee",
				"required": "true",
				"style" : "width:22.5%;",
			}, {
				"label": "开户银行：",
				"type": "TextBox",
				"name": "bank",
				"required": "true",
				"style" : "width:22.5%;",
			}, {
				"label": "银行账号：",
				"type": "TextBox",
				"name": "accntno",
				"required": "true",
				"style" : "width:22.5%;",
			}, {
				"label": "到账日期：",
				"name": "sgdate",
				"type": "DatePicker",
				 required: true,
				 "style" : "width:22.5%;",
			}, {
				"label": "收据编码：",//billtype ==='39'?"收据编码：": "发票号码：",
				"name": "fpmemo",
				"type": "TextBox",
				"visible": true,
				"style": "width:22.5%",
			}, {
				"label": "备注：",
				"name": "memo",
				"type": "TextBox",
				"visible": true,
				"style": "width:67.5%",
			},{
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"readOnly": "true",
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
			}, {
				"label": "作废人：",
				"type": "TextBox",
				"name": "canceler_name",
				"readOnly": "true",
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "作废日期：",
				"type": "DatePicker",
				"name": "canceldate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "录入人编码",
				"type": "TextBox",
				"name": "inputer",
				"visible": false,
			}
		]
	}
	bill.supsetpaydet= {
			title: '单据明细',
			"type": "gridbox",
			name: 'supsetpaydet',
			"properties": {
				"id": utils.createid('supsetpaydet'),
				"multiSelect" : true,
				"allowCellEdit" : true,
				"allowCellSelect" : true,
				"editNextOnEnterKey" : true,
				"editNextRowCell" : true,
				"allowSortColumn" : false,
				"showColumnsMenu":true,
				"showSummaryRow":true,
				"oncellbeginedit" : "OcmControl.checkboxEditor",
				"oncellendedit" : 'OcmControl.datetimeFormate',
				"ondrawsummarycell" : onDrawSummaryCell,
				"columns": [{
					type: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
					width: 30,
				}, {
					field: "browno",
					type : "indexcolumn",
					header: "行号",
					headerAlign: "center",
				  	readOnly : true,
				}, {
					field: "setrowno",
					header: "行号",
					headerAlign: "center",
					visible : false,
				}, {
					field : "setbillno",
					name : "setbillno",
					header : "账单编号",
					headerAlign : "center",
					allowSort : true,
					readOnly : true,
					width : "160",
					visible:billtype ==='31'?false:true,
				}, {
					field : "spid",
					name : "spid",
					header : "商铺",
					headerAlign : "center",
					allowSort : true,
					editor : OcmControl.newControl('fut_popselectgrid'),
					displayField : "spid_name",
					width : "160",
					editorSet : {
						selectkey : 'spid',
					},
					readOnly : true,
				}, {
					field : "spid_name",
					name : "spid_name",
					header : "商铺名称",
					headerAlign : "center",
					width : "150",
					visible : false
				}, {
					field : "fktype",
					header : "类型",
					visible : false
				}, {
					field : "itemcode",
					name : "itemcode",
					header : "费用项目",
					headerAlign : "center",
					allowSort : true,
					editor : OcmControl.newControl('fut_popselectgrid'),
					displayField : "itemcode_name",
					width : "160",
					editorSet : {
						selectkey : 'cccode',
					},
					readOnly : true,
				}, {
					field : "manatype",
					name : "manatype",
					header : "经营主体",
					visible : false,
				}, {
					field : "startdate",
					name : "startdate",
					header : "开始日期",
					width : 100,
					allowSort : true,
					headerAlign : "center",
					align : "center",
					editor : OcmControl.newControl('DatePicker'),
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					editorSet : {
						format : "yyyy-MM-dd",
					},
					visible:billtype ==='31'?false:true,
					readOnly : true,
				}, {
					field : "enddate",
					name : "enddate",
					header : "结束日期",
					width : 100,
					allowSort : true,
					headerAlign : "center",
					align : "center",
					editor : OcmControl.newControl('DatePicker'),
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					editorSet : {
						format : "yyyy-MM-dd",
					},
					visible:billtype ==='31'?false:true,
					readOnly : true,
				}, {
					field : "amount",
					header : "已收金额",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true

				}, {
					field : "yfamount",
					header : "已退金额",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
					readOnly : true
				}, {
					field : "bcpay",
					name : "bcpay",
					header : "本次退款",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					defaultValue : "0",
					align : "right",
				},{
					field : "isstop",
					headerAlign : "center",
					header : "是否终止返还",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					defaultValue : "N",
					dictkey : 'GBISYJ',
					required: true,
					width : 100,
					visible: billtype ==='31'?false:true,
				},{
					field : "sclseq",
					header : "费用序号",
					visible : false,
				}]
			},
		};


	function onDrawSummaryCell(e) {
    	var rows = e.data;
		var amount = 0.00;
		var yfamount = 0.00;
		var bcpay = 0.00;
		
		if (rows.length > 0) {
			for ( var i = 0; i < rows.length; i++) {
				var row = rows[i];
				if (isNaN(row.bcpay) == false) {
					bcpay += parseFloat(row.bcpay);
				}
				if (isNaN(row.amount) == false) {
					amount += parseFloat(row.amount);
				}
				if (isNaN(row.yfamount) == false) {
					yfamount += parseFloat(row.yfamount);
				}
			}
		}

		if (e.field == "spid") {
			e.cellHtml = "<b>"+"合计: "+"</b>";
		}
		if (e.field == "yfamount") {
			e.cellHtml ="<b>"+ yfamount.toFixed(2)+"</b>";
		}
		if (e.field == "amount") {
			e.cellHtml = "<b>"+amount.toFixed(2)+"</b>";
		}
		if (e.field == "bcpay") {
			e.cellHtml ="<b>"+ bcpay.toFixed(2)+"</b>";
		}
		e.cellStyle = "text-align:right";
    }
	
	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData,btn.editData, btn.saveData, btn.delData,
			btn.separator,btn.auditData,btn.cancelData,btn.searchData,btn.printData,btn.separator,{
				'text' : '上传附件',
				'iconCls' : 'icon-upload',
				'name' : 'uploadData',
				billstatus: 'N',
				ibediting: 'N',
				tabindex: '1'
			}, {
				'text' : '下载附件',
				'iconCls' : 'icon-search',
				'name' : 'showPic',
				billstatus: 'N,Y',
				ibediting: 'N',
				tabindex: '1'
			}]
	}
	// 单据配置
	bill.billconfig = {
		billhead: bill.supsetpayhead, // 单据主表
		billdetail: [bill.supsetpaydet], // 单据明细表
		billquerylist: bill.supsetpaylist, // 查询列表
		dettabpages: [bill.supsetpaydet], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);
	

})()
