<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>商户余款转合同</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body style="_height:100%;_margin:0px;_padding:0px;">
	<div class="ocm-layout" config="formlayout" beforeload="beforeload" borderStyle="border:0px;" style="width:100%;height:100%;"></div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
	<script type="text/javascript">
		// 字典数据初始化
		var dicData = OcmControl.getDict("BILLSTATUS,billtype,BILLMODULEID,BILLSOURCE","code,name,ddvalue") || {};
		var moduleid=app.modulecode;
		var billtype=getBilltype(moduleid);
		// 页面布局配置
	  	var toolbar1 = {
			rule : { // 按钮可用规则 Y:已审核, N:录入, T:已取消
				'billstatus' : {
					'Y' : [ 'addData', 'cancelData' , 'searchData','printData','exportgoods','showPic'],
					'N' : [ 'addData', 'editData', 'auditData', 'delData', 'searchData', 'printData','importData','addFile','uploadData','showPic' ],
					'T' : [ 'addData', 'searchData', 'printData','exportgoods', 'auditData']
			    }
			},
			status : { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
				'N' : [ 'addData', 'saveData', 'searchData', 'importData', 'addFile','uploadData','showPic' ],
				'V' : [ 'addData', 'editData', 'auditData', 'delData', 'searchData', 'printData', 'importData' ],
				'E' : [ 'addData', 'saveData', 'delData','searchData', 'printData', 'importgoods', 'addFile','showPic'],
				'S' : [ 'addData', 'editData', 'auditData', 'delData', 'searchData', 'printData', 'importData' ],
				'A' : [ 'addData', 'cancelData', 'searchData','printData','exportgoods','showPic'],
				'C' : [ 'addData', 'searchData', 'printData','exportgoods','showPic'],
				'D' : [ 'addData', 'searchData', 'importgoods' ],
			},
			items : [ [ {
				'text' : '新增',
				'iconCls' : 'icon-add',
				'name' : 'addData'
			}, {
				'text' : '修改',
				'iconCls' : 'icon-edit',
				'name' : 'editData'
			}, {
				'text' : '保存',
				'iconCls' : 'icon-save',
				'name' : 'saveData'
			} ], [ {
				'text' : '审核',
				'iconCls' : 'icon-ok',
				'name' : 'auditData'
			},{
				'text' : '取消',
				'iconCls' : 'icon-no',
				'name' : 'cancelData',
			}], [ {
				'text' : '删除',
				'iconCls' : 'icon-remove',
				'name' : 'delData'
			}, {
				'text' : '查询',
				'iconCls' : 'icon-search',
				'name' : 'searchData'
			} ], [/*{
				'text': '导入',
				'iconCls': 'icon-upload',
				'name': 'importData',
				"enabled" : true,
			} {
				'text' : '上传附件',
				'iconCls' : 'icon-upload',
				'name' : 'uploadData',
				'onclick' : 'uploadData',
			}, {
				'text' : '下载附件',
				'iconCls' : 'icon-search',
				'name' : 'showPic',
				'onclick' : 'showPic',
			} */], [ {
				'text' : '打印',
				'iconCls' : 'icon-print',
				'name' : 'printData'
			} ] ]
		}
		
	  //单据列表
		var supyuecontlist = {             
	        "type": "gridbox",
	        "resources": OmdUrl.mss,
	        "method": "mss.supplier.supyuecont.search",
	        "response": "balancetoconthead",
	        "bindform": "layouttabs", // 绑定切换的TabsBox.name
	        "bindSearchParam": ["ph_key"], // 明细页面查询条件字段
	        "searchParam": {
	        "billtype": billtype,
	        "order_field": "billno",   //降序排列
	        "order_direction":"desc",
	        },
	        "properties": {
		        "id": "supyuecontlist",
		        "columns": [{
			        type: "indexcolumn",
			        header: "行号",
			        width : 60,
		        }, {
		        	field : "billno",
					headerAlign : "center",
					header : "单据编号",
					allowSort : true,
					width : 150,
		        },{
		        	field : "billstatus",
					headerAlign : "center",
					header : "单据状态",	
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.BILLSTATUS,
		        },{
					field : "sbid",
					displayField : "sbid_name",
					header : "商户",
					headerAlign : "center",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "sbid",
						textName : "sbid_name"
					},
					readOnly : true,
					width : 160,
				},{
					field : "oldmuid",
					displayField : "oldmuid_name",
					header : "原门店",
					headerAlign : "center",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "muid",
						textName : "muid_name"
					},
					readOnly : true,
					width : 160,
				},{
					field : "muid",
					displayField : "muid_name",
					header : "新门店",
					headerAlign : "center",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "muid",
						textName : "muid_name"
					},
					readOnly : true,
					width : 160,
				},{
					field : "oldcontno",
					headerAlign : "center",
					header : "原合同",
					allowSort : true,
					enabledSearch: true,
				},{
					field : "contno",
					headerAlign : "center",
					header : "新合同",
					allowSort : true,
					enabledSearch: true,
				},{
					field : "balance",
					headerAlign : "center",
					header : "金额",
					allowSort : true,
					enabledSearch: true,
				},{
					field : "totje",
					headerAlign : "center",
					header : "转出金额",
					allowSort : true,
					enabledSearch: true,
				},{
					field : "ye",
					headerAlign : "center",
					header : "余额",
					allowSort : true,
					enabledSearch: true,
				},{
		          	field: "inputer",
		          	header: "录入人",
		          	headerAlign : "center",
		          	allowSort: true,
		          	width: 150,
		          	displayField : "inputer_name",//文本字段
					editor:OcmControl.newControl('fut_popselect'),
					editorSet: {
					selectkey:"investigator",//查询key
					beforefunc:"head_beforefunc",
					},
				} ,{
					field : "inputer_name",
					headerAlign : "center",
					header : "录入人名称",
					allowSort : false,
					visible:false,
					enabledSearch: false,
				}, {
		          	field: "inputdate",
		          	dataType: "date",
		          	dateFormat: "yyyy-MM-dd HH:mm:ss",
		          	header: "录入日期",
		          	width: 150,
		          	allowSort: true,
				}, {
			        field: "auditor",
			        header: "审核人",
			        headerAlign : "center",
			        allowSort: true,
			        width: 150,
		          	displayField : "auditor_name",//文本字段
					editor:OcmControl.newControl('fut_popselect'),
					editorSet: {
					selectkey:"investigator",//查询key
					beforefunc:"head_beforefunc",
					},
				} ,{
					field : "auditor_name",
					headerAlign : "center",
					header : "审核人名称",
					allowSort : false,
					visible:false,
					enabledSearch: false,
				
		        }, {
		          	field: "auditdate",
		          	dataType: "date",
		          	dateFormat: "yyyy-MM-dd HH:mm:ss",
		          	header: "审核日期",
		          	width: 150,
		          	allowSort: true,
		        } , {
			        field: "cancelter",
			        header: "取消人",
			        headerAlign : "center",
			        allowSort: true,
			        width: 150,
		          	displayField : "canceler_name",//文本字段
					editor:OcmControl.newControl('fut_popselect'),
					editorSet: {
					selectkey:"investigator",//查询key
					beforefunc:"head_beforefunc",
					},
				} ,{
					field : "canceler_name",
					headerAlign : "center",
					header : "取消人名称",
					allowSort : false,
					visible:false,
					enabledSearch: false,
				
		        }, {
		          	field: "canceldate",
		          	dataType: "date",
		          	dateFormat: "yyyy-MM-dd HH:mm:ss",
		          	header: "取消日期",
		          	width: 150,
		          	allowSort: true,
		        } 
		        ]
	        },      
	      };
		
	  //单据头
	    var supyueconthead = {          
	        "type": "formgrid",
	        "resources": OmdUrl.mss,
	        "method": "mss.supplier.supyuecont.get",
	        "response": "balancetoconthead",
	        "properties": {
	          "id": "supyuecont",
	        },
	        items:[{
	        	"label": "ph_key",
	        	"type": "TextBox",
	          	"name": "ph_key",
	          	"readOnly": "true",
	          	"visible": false,
	        } , {
	          	"label": "单据编号：",
	          	"type": "TextBox",
	          	"id" : "billno",
	          	"name": "billno",
	          	"readOnly": "true",
	        } , {
				"label": "模块编号：",
				"name": "billmoduleid",
				"type": "TextBox",
				"defaultValue": moduleid,
				"visible": false
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "TextBox",
				"defaultValue": billtype,
				"visible": false
			},  {
	          	"label": "单据状态：",
	          	"type": "ComboBox",
	          	"name": "billstatus",
	          	"defaultValue": "N",
	          	"readOnly": "true",
	          	"data": dicData.BILLSTATUS,
	        } , {
				"label" : "商户名称：",
				"name" : "sbid",
				"required" : "true",
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey:"sbid",
				textName :"sbid_name",
				//itemchangedfunc:"head_itemchanged_ipcode", 
				allowInput : true,
			},{
				"label" : "原门店：",
				"name" : "oldmuid",
				"required" : "true",
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey:"muid",
				textName :"oldmuid_name",
				beforefunc:"head_beforefunc",
				
				allowInput : true,
			},{
				"label" : "原合同：",
				"name" : "oldcontno",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "contno",
				textName: "oldcontno",
				allowInput: true,
				beforefunc:"head_beforefunc",
				itemchangedfunc:"head_itemchanged_oldcontno", 
			},{
				"label" : "预存款费用项目：",
				"name" : "cccode",
				"type" : "fut_popselect",
				"required" : "true",
				"selectkey":"cccode_all",
				"textName" :"cccode_name",
				"beforefunc":"head_beforefunc",
				itemchangedfunc:"head_itemchanged_cccode", 
				//data : dicData.CHARGETYPE,
			},{
				"label" : "新门店：",
				"name" : "muid",
				"required" : "true",
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey:"muid",
				textName :"muid_name",
				beforefunc:"head_beforefunc",
				//itemchangedfunc:"head_itemchanged_ipcode", 
				allowInput : true,
			},{
				"label": "合同号：",
				"name": "contno",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "contno",
				textName: "contno",
				allowInput: true,
				beforefunc:"head_beforefunc",
				itemchangedfunc:"head_itemchanged_contno", 
			},{
				"label" : "金额：",
				"name" : "balance",
				"type" : "TextBox",
				"readOnly" : "true",
				"visible":true,
				"vtype": "float",
				numberFormat : "#,0.00",
				align : "right",
			} ,{
				"label" : "转出金额：",
				"name" : "totje",
				"type" : "TextBox",
				"visible":true,
				"vtype": "float",
				numberFormat : "#,0.00",
				align : "right",
				"onValuechanged" : "onZcamountChange",
			} ,{
				"label" : "余额：",
				"name" : "ye",
				"type" : "TextBox",
				"readOnly" : "true",
				"visible":true,
				"vtype": "float",
				numberFormat : "#,0.00",
				align : "right",
				"style" : "display:block;float:none",
			} ,{
				"label" : "备注：",
				"name" : "memo",
				"type" : "TextBox",
				"visible":true,
				"style": "width:90%",
				//"style" : "width:90%;display:block;float:none",
			} ,{
				"label" : "录入人：",
				"name" : "inputer",
				"type" : "TextBox",
				"visible" : "false",
				"readOnly" : "true",
				type : "fut_popselect",
				selectkey:"investigator",
				textName :"inputer_name",
				beforefunc:"head_beforefunc",
				allowSort : true,
				
			}, {
				"label" : "录入人姓名：",
				"name" : "inputer_name",
				"type" : "TextBox",
				"visible" : "false",
				"readOnly" : "true",
				"visible":false,
				
			} , {
	          	"label": "审核人：",
	          	"name": "auditor",
	          	"type" : "TextBox",
				"visible" : "false",
				"readOnly" : "true",
				//"style": "display:block;float:none",
				type : "fut_popselect",
				selectkey:"investigator",
				textName :"auditor_name",
				beforefunc:"head_beforefunc",
				allowSort : true,
	        }  ,{
				"label" : "审核人姓名：",
				"name" : "auditor_name",
				"type" : "TextBox",
				"visible" : "false",
				"readOnly" : "true",
				"visible":false,
				
			} ,{
				"label" : "取消人：",
				"name" : "canceler",
				"type" : "TextBox",
				"visible" : "false",
				"readOnly" : "true",
				"style": "display:block;float:none",
				type : "fut_popselect",
				selectkey:"investigator",
				textName :"canceler_name",
				beforefunc:"head_beforefunc",
				allowSort : true,
			}, {
				"label" : "取消人姓名：",
				"name" : "canceler_name",
				"type" : "TextBox",
				"visible" : "false",
				"readOnly" : "true",
				"visible":false,
			} , {
		        "label" : "录入日期：",
		        "type" : "DatePicker",
		        "name" : "inputdate",
		        "format" : "yyyy-MM-dd HH:mm:ss",
		        "defaultValue" : new Date(),
		        "readOnly" : "true",
		        "visible" :"false",
		    } , {
	            "label": "审核日期：",
	            "type": "DatePicker",
	            "name": "auditdate",
	            "format": "yyyy-MM-dd HH:mm:ss",
	            "readOnly": "true",
	            "visible" : "false",
	        },{
	            "label": "取消日期：",
	            "type": "DatePicker",
	            "name": "canceldate",
	            "format": "yyyy-MM-dd HH:mm:ss",
	            "readOnly": "true",
	            "visible" : "false",
	        },
			]
		  };
		//console.log(OmdUrl.mss);
		//console.log(supyueconthead.items);
		//console.log(detailtabs);
		
		//单据明细组成：单据头+单据明细tab
		var formDetail = {
			 "type" : "formgrid",
				"resources" : OmdUrl.mss,
				"method" : "mss.supplier.supyuecont.get",
				"response" : "balancetoconthead",
				"properties" : {
					"id" : "formDetail",
				},
				"items" : supyueconthead.items,
				//"tabs" : detailtabs,
		}; 
		
		
		//单据列表和单据明细
		var tabs1 = {
			properties : {
				"id" : "layouttabs"
			},
			items : [ {
				"title" : "单据列表",
				"name" : "ListGrid",
				"control" : supyuecontlist,
			} ,{
				"title" : "单据明细",
				"name" : "formDetail",
				"control" : formDetail,
			} ]
		};
		
		
		
		var formlayout = {
			"properties" : {
				"id" : "formlayout",
			},
			"toolbar":toolbar1,
			"tabs" : tabs1,

		};
		
	</script>

	<script src="supyuecont.js" type="text/javascript"></script>
	<style type="text/css">
	</style>
</body>
</html>