var utils = Future.ns('Future.utils');
var tabs = mini.get("tabs");
var gridbox1 = mini.get("gridbox1");
var _toolbar = mini.get("config_toolbar");

if (gridbox1.getAllowCellEdit()) {
	gridbox1.setAllowCellEdit(false);
}

if (_toolbar) {
	if (_toolbar["btn_config_ok"]) {
		_toolbar["btn_config_ok"].on("click", ok);
	}

	if (_toolbar["btn_config_cancel"]) {
		_toolbar["btn_config_cancel"].on("click", cancel);
	}
	
	getTreeData();
	
}

//选中节点
if (tabs) {
	tabs.on("nodeclick", function initData(e) {
		var node = tabs.getSelectedNode();// 获取选中的节点
		var mfid = node.mfid;
	     if (gridbox1.config.searchParam) {
	        gridbox1.config.searchParam.deptid = mfid;
	      }
	    gridbox1.load();
	});
}

function getTreeData(param) {
    var manaorg = getManaorgTree(param);
	var len = manaorg.length;
	for ( var i = 0; i < manaorg.length; i++) {
		manaorg[i].codename = "[" + manaorg[i].mfcode + "]"
		+ manaorg[i].mfcname;
	}
	
	if(!param){
		var root = {};
		root.mfid = "0";
		root.codename="机构部门树";
		manaorg.push(root);
	}
	tabs.loadList(manaorg, "mfid", "mfpid");
	tabs.expandAll();
}

function getManaorgTree(param) {
	 var manaorg = "";
	 var searchParam = {"queryid":"select_manaorginfo","order_field": "mfcode",};
	 var temp =  $.extend(true, searchParam, param);
	 var method = "mss.work.report.query";
	 itemLoader.doRequest(OmdUrl.mall, method,temp, null, null, function(data) {
		 	var data = data.report;
			if(data.length >0){
				manaorg = data;
			}
	 },null,null,false);
	 return manaorg;
}

function search() {
	var e = {};
	e.value = mini.get("searchcode").getValue();
	onSearchcodeChanged(e);
	clearGridbox1Data();
}

function onSearchcodeChanged(e) {
	var value = e.value;
	if(e.value == ""){
		getTreeData();
	}else{
		var searchParam = {};
		searchParam.paramstr = "( mfcode like '%"+value+"%' or mfcname like '%"+value+"%' or mfcode = '1' )"
		getTreeData(searchParam);
	}
}

function clearGridbox1Data() {	
	gridbox1.config.searchParam.deptid = "";
	gridbox1.setData([]);
}

function ok(){
	var selectrows = gridbox1.getSelecteds();
	if (selectrows.length == 0 ){
		mini.alert("请选择岗位！");
	}
	window.CloseOwnerWindow(selectrows);
}

function cancel(){
	window.CloseOwnerWindow("close");
}