var token = getUrlParam("token");// token值
var utils = Future.ns('Future.utils');
var tabs = mini.get("tabs");
var gridbox1 = mini.get("gridbox1");
var _toolbar = mini.get("config_toolbar");

if (_toolbar) {
	_toolbar.fromstatus = "S";
	initStatus();
	
	if (_toolbar["btn_config_editJobData"]) {
		_toolbar["btn_config_editJobData"].on("click", editData);
	}
	if (_toolbar["btn_config_addListData"]) {
		_toolbar["btn_config_addListData"].on("click", addListData);
	}
	if (_toolbar["btn_config_saveJobData"]) {
		_toolbar["btn_config_saveJobData"].on("click", saveData);
	}
	if (_toolbar["btn_config_delListData"]) {
		_toolbar["btn_config_delListData"].on("click", delListData);
	}
	if (_toolbar["btn_config_exportData"]) {
		_toolbar["btn_config_exportData"].on("click", exportData);
	}
	
	showgrid1Data();
	
}

if (gridbox1) {
	gridbox1.on("cellcommitedit", onCellCommitEdit);
	gridbox1.on("cellbeginedit", onCellBeginEdit);
}

function initStatus(flag) {
	if (!flag) {
		_toolbar.changedStatus(_toolbar.fromstatus);
	}
	if (_toolbar.fromstatus == "S") {
		if (gridbox1.getAllowCellEdit()) {
			gridbox1.setAllowCellEdit(false);
		}
    }else{
    	if (!gridbox1.getAllowCellEdit()) {
			gridbox1.setAllowCellEdit(true);
		}
    }
}

function editData() {
	_toolbar.fromstatus ="E";
	initStatus();
}

function addListData() {
	gridbox1.deselectAll(false);
	var row = {};
	row.sortno=gridbox1.getData().length;
	gridbox1.addRow(row);
	var data =  gridbox1.getData();
	gridbox1.setSelected(data[row.sortno])
	gridbox1.scrollIntoView ( data[row.sortno] )
	
	_toolbar.fromstatus ="E";
	initStatus();
}

function saveData() {
	var organizeregUpt = gridbox1.getChanges();
	for(var i=0;i<organizeregUpt.length;i++){
		if(organizeregUpt[i]._state == "added"){
			organizeregUpt[i].flag = "I";
		}else if(organizeregUpt[i]._state == "removed"){
			organizeregUpt[i].flag = "D";
		}else if(organizeregUpt[i]._state == "modified"){
			organizeregUpt[i].flag = "U";
		}
		//时间格式必须是yyyy/MM/dd
		organizeregUpt[i].validdate = mini.formatDate(mini.parseDate(organizeregUpt[i].validdate) ,'yyyy/MM/dd')
	}
	
	var obj = {};
	obj.organizereg = organizeregUpt;
	setGridData(obj.organizereg);
	
	utils.setMask(true, '保存');
	itemLoader.doRequest(OmdUrl.mall, "portal.mana.organizereg.saveOrganizeReg", obj, null, null,
			function(data) {
		  if (data.flag == "1") {
			  
			  _toolbar.fromstatus ="S";
			  initStatus();
			  mini.alert("保存成功!");
			  gridbox1.load();
		  }
		  utils.setMask();
		}, function (data) {
			 mini.alert(data);
			 utils.setMask();
		}, null, false);
}

function delListData() {
	var row = gridbox1.getSelected();
	if(!row){
		mini.alert("未选择注册行!");
		return;
	}
	var param = {mucode : row.orcode,queryid:"select_checkmucode"};
	var method = "mss.work.report.query";
	 itemLoader.doRequest(OmdUrl.mall, method,param, null, null, function(data) {
		 	var data = data.report;
			if(data[0].sum >0){
				mini.alert("门店编号已经被引用不能删除，请检查！");
			}else{
				gridbox1.removeRows(gridbox1.getSelecteds(),true);
				gridbox1.deselectAll(false);
			}
			
	 },null,null,false);
}

function exportData(){
	var _param = {};
	_param = {"queryid":"export_Organizereg",
			  "fields":"orcode:门店,validdate:有效期,license:序列号",
			  };
	var _baseUrl = OmdUrl.mall.replace("rest", "export");
	var _method = "mss.work.report.export";
	itemLoader.doExportExcel(_baseUrl, _method, _param);
}

function onCellBeginEdit(e){
	if(e.field == "orcode" && e.value){
		if(e.row._state && e.row._state=="added"){
			return;
		}
		e.cancel = true;
		return;
	}
}

function onCellCommitEdit(e){
	if(e.field == "license"){
		if (e.value.length != 24 ){
			mini.alert("注册码长度不对!");
			e.cancel = true;
			return;
		}
	}if(e.field == "validdate"){
		if (e.value && e.value != "" && e.oldValue && e.oldValue != ""){
			if(mini.formatDate(mini.parseDate(e.value),"yyyy/MM/dd") == mini.formatDate(mini.parseDate(e.oldValue),"yyyy/MM/dd")){
				e.cancel = true;
				return;
			}
		}
	}
	if(e.field == "orcode"){
		var data =  gridbox1.getData();
		for (var i=0;i<data.length;i++){
			if(e.value && data[i].orcode ==e.value){
				var _result = window.alert("第"+(i+1)+"行的[门店编码]与第"+(e.record.sortno+1)+"行的重复，请检查!");
				if(_result){
					e.cancel = true;
				}else{
					e.cancel = true;
				}
				//mini.alert("第"+(i+1)+"行的[门店编码]与第"+(e.record.sortno+1)+"行的重复，请检查!");
				return;
			}
		}
	}
	if(e.value != e.oldValue ){
		if(e.value.trim() != "" ){
			if( e.field != "validdate" ||(e.field == "validdate"  && (!e.oldValue || e.oldValue.trim() == "" || mini.parseDate(e.value) != mini.parseDate(e.oldValue) ) ) ){
				if((e.row.orcode || e.field == "orcode") && (e.row.validdate || e.field == "validdate") && (e.row.license || e.field == "license")){
					//检验注册码
					var param = {orcode : (e.field == "orcode" ? e.value : e.row.orcode) ,
							 	 validdate : mini.formatDate(mini.parseDate( (e.field == "validdate" ? e.value : e.row.validdate) ) ,'yyyy/MM/dd'),
							 	 license : (e.field == "license" ? e.value : e.row.license),
							 	};
					itemLoader.doRequest(OmdUrl.mall, "portal.mana.organizereg.checkregcode", param, null, null,
							function(data) {
						if (data.returncode != "0") {
							mini.alert("注册信息有误!");
							e.cancel = true;
							return;
						}
					}, function (data) {
						 mini.alert(data);
					}, null, false);
				}
				if(e.field == "orcode" && e.value){
					var param = {mucode : e.value,queryid:"select_tmanaunit"};
					var method = "mss.work.report.query";
					 itemLoader.doRequest(OmdUrl.mall, method,param, null, null, function(data) {
						 	var dat= data.report;
							if(dat&& dat.length>0 && dat[0].mucname){
								var row =gridbox1.getSelected();
								row.muname =dat[0].mucname;
								gridbox1.setSelected(row);
							}else{
								mini.alert("未查询到门店["+param.mucode+"]信息，请检查！");
								e.cancel = true;
								return;
							}
					 },null,null,false);
				}
			}
		}
	}else{
		e.cancel = true;
		return;
	}
}

function showgrid1Data(){
	gridbox1.load();
}