Future.Table.List.bcontmain = [ {
	type : "indexcolumn",
	header : "行号",
	readOnly : true,
	headerAlign : "center",
}, {
	field : "billno",
	header : "单据编号",
	allowSort : true,
	headerAlign : "center",
	width : 150,
}, {
	field : "contno",
	header : "合同编号",
	allowSort : true,
	headerAlign : "center",
	align : "left",
	width : 150,
}, {
	field : "billstatus",
	header : "单据状态",
	allowSort : true,
	headerAlign : "center",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'SYSTEM_BILLSTATUS',
	width : 100,
}, {
	field : "sbid",
	displayField : "sbid_name",
	header : "商户",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		beforefunc : "list_beforefunc_supmkt",
		selectkey : "supmkt",
		textName : "sbid_name",
		responseName : "sbid"
	},
	readOnly : true,
	width : 200,
	renderer:"onSbid",
}, {
	field : "muid",
	displayField : "muid_name",
	header : "合同门店",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "muid",
		textName : "muid_name",
		responseName : "muid"
	},
	readOnly : true,
	width : 200,
}, {
	field : "cmeffdate",
	header : "合同生效日期",
	type : "date",
	width : 100,
	allowSort : true,
	headerAlign : "center",
	align : "center",
	dataType : "date",
	dateFormat : "yyyy-MM-dd",
}, {
	field : "cmlapdate",
	header : "合同失效日期",
	type : "date",
	width : 100,
	allowSort : true,
	headerAlign : "center",
	align : "center",
	dataType : "date",
	dateFormat : "yyyy-MM-dd",
}, {
	field : "brandcounter",
	displayField : "bmname",
	header : "品牌专柜",
	headerAlign : "center",
	readOnly : true,
	visible : false,
	enabledSearch : false,
	width : 120,
}, {
	field : "ppcode",
	displayField : "ppcode_name",
	header : "品牌",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "ppcode",
		responseName : "ppcode",
		textName :"ppcode_name",
	},
	readOnly : true,
	width : 180,
},  {
	field : "mcid",
	displayField : "mcid_name",
	header : "经营种类",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "cat",
		responseName : "mcid",
		textName :"mcid_name",
	},
	readOnly : true,
	width : 180,
},{
	field : "wmid",
	header : "经营方式",
	type : "comboboxcolumn",
	headerAlign : "center",
	readOnly : true,
	textField : "name",
	valueField : "code",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'CONTRACT_WMID',
	enabledSearch : true,
	width : 100,
} ,{
	field : "manatype",
	header : "经营主体",
	type : "comboboxcolumn",
	headerAlign : "center",
	readOnly : true,
	textField : "name",
	valueField : "code",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'COMPANY',
	enabledSearch : true,
	width : 180,
} ,{
	field : "billsource",
	headerAlign : "center",
	header : "单据来源",
	type : "comboboxcolumn",  
	headerAlign : "center",
	textField:"name",
    valueField:"code" , 
    dictkey:"SYSTEM_BILLSOURCE",
	renderer: "OcmControl.dictRendererWithCode",
	enabledSearch : false,
	visible:false,
	readOnly : true,
}, {
	field : "cmtitle",
	header : "合同主体",
	headerAlign : "center",
	readOnly : true,
	enabledSearch : false,
	width : 150,
} ,{
	field : "contsgbh",
	header : "合同文本号",
	headerAlign : "center",
	allowSort : true,
	readOnly : true,
	width : 150,
} ,{
	field : "conttype",
	header : "合同类型",
	allowSort : true,
	headerAlign : "center",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'CONTRACT_CONTTYPE',
	width : 100,
}, {
	field : "bcontmanaframe:spid",
	header : "商铺",
	width : 120,
	allowSort : true,
	headerAlign : "center",
	enabledSearch : true,
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "zlcmfspid",
		textName :"spname",
	},
	visible : false,
}, {
	field : "bcontgoods:gbid",
	header : "商品编码",
	width : 120,
	allowSort : true,
	headerAlign : "center",
	enabledSearch : true, 
	visible : false,
}, {
	field : "inputer",
	header : "录入人",
	headerAlign : "center",
	readOnly : true,
	enabledSearch : true,
	visible:false,
	width : 100,
}, {
	field : "inputer_name",
	header : "录入人",
	headerAlign : "center",
	readOnly : true,
	enabledSearch : false,
	visible:false,
	width : 100,
}, {
	field : "inputdate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd HH:mm:ss", 
	header : "录入日期",
	width : 160,
	headerAlign : "center",
	visible:false,
}, {
	field : "auditor",
	header : "审核人",
	width : 100,
	headerAlign : "center",
	enabledSearch : true,
	visible:false,
}, {
	field : "auditor_name",
	header : "审核人",
	width : 100,
	headerAlign : "center",
	enabledSearch : false,
	visible:false,
}, {
	field : "auditdate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd HH:mm:ss",
	header : "审核日期",
	headerAlign : "center",
	width : 160,
	visible:false,
}, {
	field : "canceler",
	header : "作废人",
	width : 100,
	headerAlign : "center",
	enabledSearch : true,
	visible:false,
}, {
	field : "canceler_name",
	header : "作废人",
	width : 100,
	headerAlign : "center",
	enabledSearch : false,
	visible:false,
}, {
	field : "canceldate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd HH:mm:ss",
	header : "作废日期",
	headerAlign : "center",
	width : 160,
	visible:false,
}, {
	field : "ccdate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd",
	header : "撤场日期",
	headerAlign : "center",
	width : 140,
	enabledSearch : true,
	visible:false,
}, {
	field : "ccreason",
	header : "撤场原因",
	width : 100,
	headerAlign : "center",
	type : "comboboxcolumn",
	textField : "name",
	valueField : "code",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'CONTRACT_CCREASON',
	enabledSearch : true,
	visible:false,
}, {
	field : "memo",
	header : "备注",
	width : 100,
	headerAlign : "center",
	enabledSearch : true,
	visible:false,
}];

Future.Table.List.bcontmain2 = [{
	type : "indexcolumn",
	header : "行号",
	readOnly : true,
	headerAlign : "center",
}, {
	field : "billno",
	header : "单据编号",
	allowSort : true,
	headerAlign : "center",
	align : "left",
	width : 150,
},{
	field : "billstatus",
	header : "单据状态",
	allowSort : true,
	headerAlign : "center",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'SYSTEM_BILLSTATUS',
	width : 100,
}, {
	field : "contno",
	header : "合同编号",
	allowSort : true,
	headerAlign : "center",
	align : "left",
	width : 150,
}, {
	field : "sbid",
	displayField : "sbid_name",
	header : "供应商",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "supid",
		beforefunc : "head_beforefunc_sbid",
		textName : "sbid_name",
		responseName : "sbid"
	},
	readOnly : true,
	width : 200,
},{
	field : "bcontmanaframe:spid",
	header : "柜组",
	width : 120,
	allowSort : true,
	headerAlign : "center",
	enabledSearch : true,
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "selfspid",
		beforefunc:"head_beforefunc_selfspid_search",
		textName :"spname",
	},
	visible : false,
},{
	field : "muid",
	displayField : "muid_name",
	header : "合同门店",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "muid",
		textName : "muid_name",
		responseName : "muid"
	},
	readOnly : true,
	width : 200,
}, {
	field : "cmeffdate",
	header : "合同生效日期",
	type : "date",
	width : 100,
	allowSort : true,
	headerAlign : "center",
	align : "center",
	dataType : "date",
	dateFormat : "yyyy-MM-dd",
}, {
	field : "cmlapdate",
	header : "合同失效日期",
	type : "date",
	width : 100,
	allowSort : true,
	headerAlign : "center",
	align : "center",
	dataType : "date",
	dateFormat : "yyyy-MM-dd",
}, {
	field : "ccdate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd",
	header : "撤场日期",
	headerAlign : "center",
	width : 140,
	enabledSearch : true,
	visible:false,
}, {
	field : "brandcounter",
	displayField : "bmname",
	header : "品牌专柜",
	headerAlign : "center",
	readOnly : true,
	visible : false,
	enabledSearch : false,
	width : 120,
}, {
	field : "wmid",
	header : "经营方式",
	type : "comboboxcolumn",
	headerAlign : "center",
	readOnly : true,
	textField : "name",
	valueField : "code",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'CONTRACT_WMID',
	enabledSearch : true,
	width : 100,
} ,{
	field : "manatype",
	header : "经营主体",
	type : "comboboxcolumn",
	headerAlign : "center",
	readOnly : true,
	textField : "name",
	valueField : "code",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'COMPANY',
	enabledSearch : true,
	width : 180,
} ,{
	field : "ppcode",
	displayField : "ppcode_name",
	header : "品牌",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "ppcode",
		responseName : "code",
		textName :"ppcode_name",
	},
	readOnly : true,
	width : 180,
},  {
	field : "mcid",
	displayField : "mcid_name",
	header : "经营种类",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "cat",
		responseName : "mcid",
		textName :"mcid_name",
	},
	readOnly : true,
	width : 180,
},{
	field : "contsubject",
	header : "合同标的",
	headerAlign : "center",
	readOnly : true,
	enabledSearch : false,
	width : 150,
} ,{
	field : "contsgbh",
	header : "合同文本号",
	headerAlign : "center",
	readOnly : true,
	width : 150,
} ,{
	field : "conttype",
	header : "合同类型",
	allowSort : true,
	headerAlign : "center",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'CONTRACT_CONTTYPE',
	width : 100,
},{
	field : "inputer",
	header : "录入人",
	headerAlign : "center",
	readOnly : true,
	enabledSearch : true,
	visible:false,
	width : 100,
},{
	field : "inputer_name",
	header : "录入人",
	headerAlign : "center",
	readOnly : true,
	enabledSearch : false,
	visible:false,
	width : 100,
},{
	field : "inputdate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd HH:mm:ss", 
	header : "录入日期",
	width : 160,
	headerAlign : "center",
	visible:false,
}, {
	field : "auditor",
	header : "审核人",
	width : 100,
	headerAlign : "center",
	enabledSearch : true,
	visible:false,
}, {
	field : "auditor_name",
	header : "审核人",
	width : 100,
	headerAlign : "center",
	enabledSearch : false,
	visible:false,
}, {
	field : "auditdate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd HH:mm:ss",
	header : "审核日期",
	headerAlign : "center",
	width : 160,
	visible:false,
} , {
	field : "memo",
	header : "备注",
	width : 100,
	headerAlign : "center",
	enabledSearch : true,
	visible:false,
}];

Future.Table.List.bcontmain3 = [ {
	type : "indexcolumn",
	header : "行号",
	readOnly : true,
	headerAlign : "center",
}, {
	field : "contno",
	header : "合同编号",
	allowSort : true,
	headerAlign : "center",
	align : "left",
	width : 150,
}, {
	field : "contstatus",
	header : "单据状态",
	allowSort : true,
	headerAlign : "center",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'CONTRACT_CONTSTATUS',
	width : 100,
}, {
	field : "sbid",
	displayField : "sbid_name",
	header : "商户",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		beforefunc : "list_beforefunc_supmkt",
		selectkey : "supmkt",
		textName : "sbid_name",
		responseName : "sbid"
	},
	readOnly : true,
	width : 200,
	renderer:"onSbid",
}, {
	field : "muid",
	displayField : "muid_name",
	header : "合同门店",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "muid",
		textName : "muid_name",
		responseName : "muid"
	},
	readOnly : true,
	width : 200,
}, {
	field : "cmeffdate",
	header : "合同生效日期",
	type : "date",
	width : 100,
	allowSort : true,
	headerAlign : "center",
	align : "center",
	dataType : "date",
	dateFormat : "yyyy-MM-dd",
}, {
	field : "cmlapdate",
	header : "合同失效日期",
	type : "date",
	width : 100,
	allowSort : true,
	headerAlign : "center",
	align : "center",
	dataType : "date",
	dateFormat : "yyyy-MM-dd",
}, {
	field : "brandcounter",
	displayField : "bmname",
	header : "品牌专柜",
	headerAlign : "center",
	readOnly : true,
	visible : false,
	enabledSearch : false,
	width : 120,
}, {
	field : "ppcode",
	displayField : "ppcode_name",
	header : "品牌",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "ppcode",
		responseName : "ppcode",
		textName :"ppcode_name",
	},
	readOnly : true,
	width : 180,
},  {
	field : "mcid",
	displayField : "mcid_name",
	header : "经营种类",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "cat",
		responseName : "mcid",
		textName :"mcid_name",
	},
	readOnly : true,
	width : 180,
},{
	field : "wmid",
	header : "经营方式",
	type : "comboboxcolumn",
	headerAlign : "center",
	readOnly : true,
	textField : "name",
	valueField : "code",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'CONTRACT_WMID',
	visible : false,
	enabledSearch : false,
	width : 100,
} ,{
	field : "manatype",
	header : "经营主体",
	type : "comboboxcolumn",
	headerAlign : "center",
	readOnly : true,
	textField : "name",
	valueField : "code",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'COMPANY',
	enabledSearch : true,
	width : 180,
} ,{
	field : "billsource",
	headerAlign : "center",
	header : "单据来源",
	type : "comboboxcolumn",
	headerAlign : "center",
	textField:"name",
	valueField:"code" ,
	dictkey:"SYSTEM_BILLSOURCE",
	renderer: "OcmControl.dictRendererWithCode",
	enabledSearch : false,
	visible:false,
	readOnly : true,
}, {
	field : "cmtitle",
	header : "合同主体",
	headerAlign : "center",
	readOnly : true,
	enabledSearch : false,
	visible : false,
	width : 150,
} ,{
	field : "contsgbh",
	header : "合同文本号",
	headerAlign : "center",
	allowSort : true,
	readOnly : true,
	width : 150,
} ,{
	field : "conttype",
	header : "合同类型",
	allowSort : true,
	headerAlign : "center",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'CONTRACT_CONTTYPE',
	width : 100,
}, {
	field : "bcontmanaframe:spid",
	header : "商铺",
	width : 120,
	allowSort : true,
	headerAlign : "center",
	enabledSearch : true,
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "zlcmfspid",
		textName :"spid_name",
	},
	visible : false,
}, {
	field : "bcontgoods:gbid",
	header : "商品编码",
	width : 120,
	allowSort : true,
	headerAlign : "center",
	enabledSearch : true,
	visible : false,
}, {
	field : "inputer",
	header : "录入人",
	headerAlign : "center",
	readOnly : true,
	enabledSearch : false,
	visible:false,
	width : 100,
}, {
	field : "inputer_name",
	header : "录入人",
	headerAlign : "center",
	readOnly : true,
	enabledSearch : false,
	visible:false,
	width : 100,
}, {
	field : "inputdate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd HH:mm:ss",
	header : "录入日期",
	width : 160,
	headerAlign : "center",
	visible:false,
}, {
	field : "auditor",
	header : "审核人",
	width : 100,
	headerAlign : "center",
	enabledSearch : false,
	visible:false,
}, {
	field : "auditor_name",
	header : "审核人",
	width : 100,
	headerAlign : "center",
	enabledSearch : false,
	visible:false,
}, {
	field : "auditdate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd HH:mm:ss",
	header : "审核日期",
	headerAlign : "center",
	width : 160,
	visible:false,
}, {
	field : "ccdate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd",
	header : "撤场日期",
	headerAlign : "center",
	width : 140,
	enabledSearch : true,
	visible:false,
}, {
	field : "ccreason",
	header : "撤场原因",
	width : 100,
	headerAlign : "center",
	type : "comboboxcolumn",
	textField : "name",
	valueField : "code",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'CONTRACT_CCREASON',
	enabledSearch : true,
	visible:false,
}, {
	field : "memo",
	header : "备注",
	width : 100,
	headerAlign : "center",
	enabledSearch : true,
	visible:false,
}];

Future.Table.Head.bcontmain = [
	{
	"id" : "test",
	"label" : "单据信息",
	"type" : "fieldset",
	"items" :[{
		"label" : "ph_key：",
		"type" : "TextBox",
		"name" : "ph_key",
		"readOnly" : "true",
		"visible" : false,
	}, {
		"label" : "单据编号：",
		"name" : "billno",
		"type" : "TextBox",
		"readOnly" : true,
		"style" : "width:30%",
	}, {
		"label" : "单据类别：",
		"type" : "TextBox",
		"name" : "billmoduleid",
		"readOnly" : true,
		"visible" : false,
	}, {
		"label" : "单据状态：",
		"type" : "ComboBox",
		"name" : "billstatus",
		"readOnly" : true,
		"enabled" : "true",
		dictkey : 'SYSTEM_BILLSTATUS',
		"valueField" : "code",
		"textField" : "name",
		"defaultValue" : "N",
		"style" : "width:30%;display:block;float:none",
	}, {
		"label" : "单据来源：",
		"type" : "ComboBox",
		"name" : "billsource",
		"readOnly": "true",
		dictkey :"SYSTEM_BILLSOURCE",
		"defaultValue" : "02",
		"visible" : false,
	}, {
		"label" : "手工单号：",
		"name" : "billsgdh",
		"type" : "TextBox",
		"style" : "width:30%",
		"visible" : false,
	}, {
		"label" : "录入人编码",
		"type" : "TextBox",
		"name" : "inputer",
		"visible" : false,
	},{
		"label" : "是否长期",
		"type" : "TextBox",
		"name" : "iscq",
		"visible" : false,
		"defaultValue" : "N",
	},{
		"label" : "录入人：",
		"type" : "TextBox",
		"name" : "inputer_name",
		"readOnly" : "true",
	},{
		"label" : "录入日期：",
		"type" : "DatePicker",
		"name" : "inputdate",
		"format" : "yyyy-MM-dd HH:mm:ss",
		"readOnly" : "true",
		"style" : "width:30%;display:block;float:none"
	},{
		"label" : "审核人编码",
		"type" : "TextBox",
		"name" : "auditor",
		"visible" : false,
	},{
		"label" : "审核人：",
		"type" : "TextBox",
		"name" : "auditor_name",
		"readOnly" : "true",
	},{
		"label" : "审核日期：",
		"type" : "DatePicker",
		"name" : "auditdate",
		"format" : "yyyy-MM-dd HH:mm:ss",
		"readOnly" : "true",
		"style" : "width:30%;display:block;float:none"
	},{
		"label" : "取消人编码",
		"type" : "TextBox",
		"name" : "canceler",
		"visible" : false,
	},{
		"label" : "取消人：",
		"type" : "TextBox",
		"name" : "canceler_name",
		"readOnly" : "true",
		"visible" : false,
	},{
		"label" : "取消日期：",
		"type" : "DatePicker",
		"name" : "canceldate",
		"format" : "yyyy-MM-dd HH:mm:ss",
		"readOnly" : "true",
		"style" : "display:block;float:none",
		"visible" : false,
	}]
  },{
		"id" : "test2",
		"label" : "基本信息",
		"type" : "fieldset",
		"items" :[{
			"label" : "门店：",
			"type" : "ButtonEdit",
			"name" : "muid",
			"required" : "true",
			displayField : "muid_name",
			type : "fut_popselect",
			selectkey : "muid",
			textName : "muid_name",
			responseName : "muid",
			beforefunc : "head_beforefunc_muid",
			itemchangedfunc : "head_itemchanged_muid",
		}, {
			"label" : "<a class='New_Button' href='javascript:onSbidShow(2)'><u>商户：</u></a>",
			"type" : "ButtonEdit",
			"name" : "sbid",
			displayField : "sbid_name",
			"required" : true,
			type : "fut_popselect",
			selectkey : "supmkt",
			textName : "sbid_name",
			responseName : "sbid",
			beforefunc : "head_beforefunc_supmkt",
			itemchangedfunc : "head_itemchanged_supmkt",
			renderer:"onSbid",
		}, {
			"label" : "店招：",
			"type" : "TextBox",
			"name" : "sbdz",
			"style" : "width:30%"
		}, {
			"label" : "合同样式：",
			"type" : "ComboBox",
			"name" : "contstyle",
			dictkey : 'CONTRACT_CONTSTYLE',
   			"valueField" : "code",
   			"textField" : "name",
   			"defaultValue" : "02",
			"style" : "width:30%",
			"readOnly" : true,
			"visible" : false,
		}, {
			"label" : "合同号：",
			// "type" : "ButtonEdit",
			"type" : "TextBox",
			"name" : "contno",
			"readOnly" : true,
			// displayField : "contno",
			// type : "fut_popselect",
			// selectkey : "contno",
			// textName : "contno",
			// responseName : "contno",
			// beforefunc : "head_beforefunc_zlcontno",
			// itemchangedfunc : "head_itemchanged_zlcontno",
			"style" : "width:30%"
		}, {
			"label" : "主合同号：",
			"type" : "ButtonEdit",
			"name" : "mcontno",
			displayField : "mcontno",
			type : "fut_popselect",
			selectkey : "contno",
			textName : "mcontno",
			responseName : "mcontno",
			beforefunc : "head_beforefunc_maincontno",
			"style" : "width:30%",
			"readOnly" : true,
			"visible" : false,
		},{
			"label" : "合同状态：",
			displayField : "billstatus",
			"type" : "ComboBox",
			"name" : "contstatus",
			"readOnly" : true,
			"enabled" : "true",
			dictkey : 'CONTRACT_CONTSTATUS',
			"valueField" : "code",
			"textField" : "name",
			"defaultValue" : "N",
			"style" : "width:30%",
			"visible" : false,
		}, {
			"label" : "合同文本号：",
			"type" : "TextBox",
			"name" : "contsgbh",
			"style" : "width:30%"
		}, {
			"label" : "合同类型：",
			"type" : "ComboBox",
			"name" : "conttype",
			dictkey : 'CONTRACT_CONTTYPE',
			"style" : "width:30%",
			"required" : true,
		}, {
			"label" : "部门：",
			"type" : "ButtonEdit",
			"name" : "department",
			"required" : true,
			displayField : "mmfcname",
			type : "fut_popselect",
			selectkey : "mana",
			textName : "mmfcname",
			responseName : "mmfid",
			beforefunc : "head_beforefunc_mana",
			itemchangedfunc : "head_itemchanged_mana",
			"visible" : false,
		},{
			"text" : "是否代管：",
			"type" : "CheckBox",
			"name" : "isdg",
			"trueValue" : "Y",
			"falseValue" : "N",
			"defaultValue" : "N",
			"onValuechanged" : "onIsdgChange",
			"style" : "width:30%;",
			"visible" : false,
		},{
			"label" : "分成比例：",
			"type" : "NumButtonEdit",
			"name" : "fcbl",
			"format" : "p2",
			"defaultValue" : 0,
			"style" : "width:30%;",
			"prange" : true,
			"readOnly" : true,
			"visible" : false,
		},{
			"label" : "业主编码：",
			"type" : "ButtonEdit",
			"name" : "ownerid",
			displayField : "ownercname",
			type : "fut_popselect",
			selectkey : "owner",
			textName : "ownercname",
			responseName : "ownerid",
			// beforefunc : "head_beforefunc_owner",
			// itemchangedfunc : "head_itemchanged_owner",
			"style" : "width:30%;display:block;float:none",
			"readOnly" : true,
			"visible" : false,
		},{
			"label" : "经营方式：",
			"type" : "ComboBox",
			"name" : "wmid",
			"readOnly" : true,
			dictkey : 'CONTRACT_WMID',
			"style" : "width:30%",
			"defaultValue" : "5",
		},{
			"label" : "主营品牌：",
			"type" : "ButtonEdit",
			"name" : "ppcode",
			displayField : "ppcode_name",
			type : "fut_popselect",
			selectkey : "ppcode",
			textName : "ppcode_name",
			beforefunc : "head_beforefunc_ppcode",
			itemchangedfunc : "head_itemchanged_ppcode",
			"required" : true,
		},{
			"label" : "经营种类：",
			"type" : "ButtonEdit",
			"name" : "mcid",
			displayField : "mcid_name",
			type : "fut_popselect",
			selectkey : "cat",
			textName : "mcid_name",
			responseName : "mcid",
			beforefunc : "head_beforefunc_mcid",
			itemchangedfunc : "head_itemchanged_mcid",
			"style" : "width:30%;",
			"required" : true,
		},{
			"label" : "店铺号：",
			"type" : "TextBox",
			"name" : "dph",
			"onValuechanged" : "onDphChange",
			"visible":false,
		},{
			"label" : "分类：",
			"name" : "sort",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
			"label" : "大类：",
			"name" : "bigsort",
			type : "ComboBox",
			dictkey : 'BRAND_PPGRADE',
			"readOnly" : true,
			"visible":false,
		},{
			"label" : "合同主体：",
			"type" : "TextBox",
			"name" : "cmtitle",
			"style" : "width:90%;display:block;float:none"
		},{
			"label" : "生效日期：",
			"type" : "DatePicker",
			"name" : "cmeffdate",
			"format" : "yyyy-MM-dd",
			"required" : true,
			"onValuechanged" : "onFromSdateChange",
		},{
			"label" : "失效日期：",
			"type" : "DatePicker",
			"name" : "cmlapdate",
			"format" : "yyyy-MM-dd",
			"required" : true,
			"onValuechanged" : "onFromedateChange",
		},{
			"label" : "当前有效期：",
			"type" : "TextBox",
			"name" : "expirydate",
			"style" : "width:30%",
			"readOnly" : true,
		},{
			"label" : "签约人：",
			"type" : "TextBox",
			"name" : "signman",
			"style" : "width:30%",
		},{
			"label" : "签约日期：",
			"type" : "DatePicker",
			"name" : "signdate",
			"format" : "yyyy-MM-dd",
		},{
			"label" : "交付日期：",
			"type" : "DatePicker",
			"name" : "deliverydate",
			"format" : "yyyy-MM-dd",
			"onValuechanged" : "onDeliverydateChange",
		},{
			"label" : "装修开始日期：",
			"type" : "DatePicker",
			"name" : "zxqsrq",
			"format" : "yyyy-MM-dd",
		},{
			"label" : "装修结束日期：",
			"type" : "DatePicker",
			"name" : "zxjzrq",
			"format" : "yyyy-MM-dd",
		},{
			"label" : "开业日期：",
			"type" : "DatePicker",
			"name" : "opendate",
			"format" : "yyyy-MM-dd",
		},{
			"label" : "撤场原因：",
			"type" : "ComboBox",
			"name" : "ccreason",
			"readOnly" : true,
			dictkey : 'CONTRACT_CCREASON',
			"style" : "width:30%"
		},{
			"label" : "撤场日期：",
			"type" : "DatePicker",
			"name" : "ccdate",
			"format" : "yyyy-MM-dd",
			"readOnly" : true,
			"onValuechanged" : "onCcdateChange",
		},{
			"label" : "费用截止日期：",
			"type" : "DatePicker",
			"name" : "fyedate",
			"format" : "yyyy-MM-dd",
			"readOnly" : true,
			"visible" : false,
		},{
			"label" : "收款人：",
			"type" : "TextBox",
			"name" : "skr",
		},{
			"label" : "开户行：",
			"type" : "TextBox",
			"name" : "bank",
		},{
			"label" : "银行帐号：",
			"type" : "TextBox",
			"name" : "bankaccount",
		},{
			"label" : "合同税号：",
			"type" : "TextBox",
			"name" : "conttaxno",
			"visible" : false,
		},{
			"label" : "备注：",
			"type" : "TextBox",
			"name" : "memo",
			"style" : "width:90%;display:block;float:none"
		}]
	},{
		"id" : "test3",
		"label" : "结算条款",
		"type" : "fieldset",
		"items" :[{
			"label" : "结算组：",
			"type" : "ComboBox",
			"name" : "setgroupcode",
			dictkey : 'SETGROUPCODE',
			"style" : "width:30%",
			"required" : true,
			"defaultValue" : "02",
		}, {
			"label" : "结算方式：",
			"type" : "ComboBox",
			"name" : "setmode",
			dictkey : 'CONTRACT_SETMODE',
			"style" : "width:30%",
			"defaultValue" : "12",
			"visible" : false,
		}, {
			"label": "经营主体：",
			"name": "manatype",
			"type": "ComboBox",
			"required" : true,
			"enabled" : true,
			dictkey : 'COMPANY',
			"style" : "width:30%",
			"defaultValue" : "0",
		},{
			"label" : "结算标志：",
			"type" : "ComboBox",
			"name" : "setflag",
			dictkey : 'CONTRACT_SETFLAG',
			"style" : "width:30%",
			"required" : true,
			"defaultValue" : "Y",
		}, {
			"label" : "账单日：",
			"type" : "ComboBox",
			"name" : "settleday",
			dictkey : 'SETTLEDAY',
			"style" : "width:30%",
			"required" : true,
			"defaultValue" : "31",
		}, {
			"label" : "结算模式 ：",
			"type" : "ComboBox",
			"name" : "cycsqtype",
			"required" : true,
			dictkey : 'CONTRACT_CYCSQTYPE',
			"style" : "width:30%",
		}, {
			"label" : "租金收取月数：",
			"type" : "NumButtonEdit",
			"format" : "n0",
			"name" : "rentmons",
			"defaultValue" : 1,
			"style" : "width:30%;",
			"required" : true,
		}, {
			"label" : "保底方式：",
			"type" : "ComboBox",
			"name" : "bdmode",
			dictkey : 'CONTRACT_BDMODE',
			"style" : "width:30%",
			"required" : true,
			"visible" : false,
		} ,{
			"label" : "保底期限：",
			"type" : "ComboBox",
			"name" : "bdqx",
			dictkey : 'CONTRACT_BDQX',
			"style" : "width:30%",
			"defaultValue" : "3",
			"required" : true,
			 "visible" : false,
			 "onValuechanged" : "onBDqxChange",
		} , {
			"label" : "付款方式：",
			"type" : "ComboBox",
			"name" : "paycode",
			dictkey : 'CHARGE_PAYMODE',
			"style" : "width:30%",
			"defaultValue" : "5",
		}, {
			"label" : "收银方式 ：",
			"type" : "ComboBox",
			"name" : "syfs",
			dictkey : 'CONTRACT_SYFS',
			"style" : "width:30%",
			"required" : true,
		}, {
			"label" : "抽成销售额 ：",
			"type" : "ComboBox",
			"name" : "drawsales",
			dictkey : 'CONTRACT_DRAWSALES',
			"style" : "width:30%",
			"required" : true,
			"defaultValue" : "1",
		},{
			"label" : "滞纳金计算方式 ：",
			"type" : "ComboBox",
			"name" : "cetype",
			dictkey : 'CONTRACT_OFCTYPE',
			"style" : "width:30%",
			"defaultValue" : "1",
		},{
			"label" : "滞纳金计算模式：",
			"type" : "ComboBox",
			"name" : "znjmode",
			dictkey : 'CONTRACT_ZNJMODE',
			"required" : true,
			"style" : "width:30%",
			"defaultValue" : "1",
		}, {
			"label" : "滞纳金率：",
			"type" : "NumButtonEdit",
			"name" : "znjl",
			"format" : "p4",
			"defaultValue" : 0,
			"style" : "width:30%;",
			"prange" : true,
			"required" : true,
			"defaultValue" : "0.0020",
		},{
			"label" : "首期款缴款日期：",
			"type" : "DatePicker",
			"name" : "sqkjkr",
			"format" : "yyyy-MM-dd",
			"required" : true,
		}, {
			"label" : "缴款截止日：",
			"type" : "ComboBox",
			"name" : "jkqx",
			dictkey : 'SETTLEDAY',
			"style" : "width:30%",
			"required" : true,
			"defaultValue" : "20",
		}, {
			"label" : "宽限期：",
			"type" : "NumButtonEdit",
			"name" : "graceperiod",
			"format" : "n0",
			"defaultValue" : 0,
			"style" : "width:30%;",
			"prange" : false,
			"visible" : false,
		},]
	}];

Future.Table.Head.bcontmain2 = [{
	"id" : "test",
	"label" : "单据信息",
	"type" : "fieldset",
	"items" :[{
		"label" : "ph_key：",
		"type" : "TextBox",
		"name" : "ph_key",
		"readOnly" : "true",
		"visible" : false,
	},
	{
		"label" : "单据编号：",
		"name" : "billno",
		"type" : "TextBox",
		"readOnly" : true,
		"style" : "width:30%",
	},
	{
		"label" : "单据类别：",
		"type" : "ComboBox",
		"name" : "billmoduleid",
		"defaultValue" : billmoduleid,
		"readOnly" : true,
		"visible" : false,
	},{
		"label" : "单据类别：",
		"name" : "billtype",
		"type" : "TextBox",
		"readOnly" : true,
		"defaultValue" : billtype,
		"visible" : false,
		"style" : "width:30%",
	},
	{
		"label" : "单据状态：",
		"type" : "ComboBox",
		"name" : "billstatus",
		"readOnly" : true,
		"enabled" : "true",
		dictkey : 'SYSTEM_BILLSTATUS',
		"valueField" : "code",
		"textField" : "name",
		"defaultValue" : "N",
		"style" : "width:30%;display:block;float:none",
	},{
		"label" : "单据状态：",
		"type" : "ComboBox",
		"name" : "billflag",
		"readOnly" : true,
		"enabled" : "true",
		dictkey : 'SYSTEM_BILLSTATUS',
		"valueField" : "code",
		"textField" : "name",
		"defaultValue" : "N",
		"style" : "width:30%;display:block;float:none",
		"visible" : false,
	},{
		"label" : "单据来源：",
		"type" : "ComboBox",
		"name" : "billsource",
		"readOnly": "true",
		"defaultValue" : "02",
		"visible" : false,
	},
	{
		"label" : "手工单号：",
		"name" : "billsgdh",
		"type" : "TextBox",
		"style" : "width:30%",
		"visible" : false,
	},
	{
		"label" : "录入人编码",
		"type" : "TextBox",
		"name" : "inputer",
		"defaultValue" :getUserCode(),
		"visible" : false,
	},
	{
		"label" : "是否长期",
		"type" : "TextBox",
		"name" : "iscq",
		"visible" : false,
		"defaultValue" : "N",
	},
	{
		"label" : "录入人：",
		"type" : "TextBox",
		"name" : "inputer_name",
		"readOnly" : "true",
		"defaultValue" : getUserName(),
	},
	{
		"label" : "录入日期：",
		"type" : "DatePicker",
		"name" : "inputdate",
		"format" : "yyyy-MM-dd HH:mm:ss",
		"defaultValue" : new Date(),
		"readOnly" : "true",
		"style" : "width:30%;display:block;float:none"
	},{
		"label" : "审核人编码",
		"type" : "TextBox",
		"name" : "auditor",
		"visible" : false,
	},
	{
		"label" : "审核人：",
		"type" : "TextBox",
		"name" : "auditor_name",
		"readOnly" : "true",
	},
	{
		"label" : "审核日期：",
		"type" : "DatePicker",
		"name" : "auditdate",
		"format" : "yyyy-MM-dd HH:mm:ss",
		"readOnly" : "true",
		"style" : "width:30%;display:block;float:none"
	},
	{
		"label" : "取消人编码",
		"type" : "TextBox",
		"name" : "canceler",
		"visible" : false,
	},
	{
		"label" : "取消人：",
		"type" : "TextBox",
		"name" : "canceler_name",
		"readOnly" : "true",
		"visible" : false,
	},
	{
		"label" : "取消日期：",
		"type" : "DatePicker",
		"name" : "canceldate",
		"format" : "yyyy-MM-dd HH:mm:ss",
		"readOnly" : "true",
		"style" : "display:block;float:none",
		"visible" : false,
	}]
	},{
	"id" : "test1",
	"label" : "基本信息",
	"type" : "fieldset",
	"items" :[{
		"label" : "门店：",
		"name" : "muid",
		"type" : "ButtonEdit",
		"enabled" : true,
		"required" : true,
		"defaultValue" : "",
		type : "fut_popselect",
		displayField : "muid_name",
		selectkey:"muid",
		textName :"muname",
		responseName : "muid",
		"style" : "width:30%",
		beforefunc:"head_beforefunc",
		itemchangedfunc:"head_itemchanged_muid",
	},{
		"label" : "供应商：",
		"name" : "sbid",
		"type" : "ButtonEdit",
		"enabled" : true,
		"defaultValue" : "",
		type : "fut_popselect",
		displayField : "sbid_name",
		selectkey:"supid",
		textName :"sbid_name",
		"style" : "width:30%",
		"required" : true,
		beforefunc:"head_beforefunc",
		itemchangedfunc : "head_itemchanged_sbid",
	},{
		"label" : "合同类型：",
		"type" : "ComboBox",
		"name" : "conttype",
		dictkey : 'CONTRACT_CONTTYPE',
		"required" : true,
		"style" : "width:30%",
	},{
		"label" : "合同状态：",
		"type" : "ComboBox",
		"name" : "contstatus",
		"readOnly" : true,
		"enabled" : "true",
		dictkey : 'CONTRACT_CONTSTATUS',
		"defaultValue" : "N",
		"style" : "width:30%",
		"visible" : false,
	},{
		"label" : "经营方式：",
		"type" : "ComboBox",
		"name" : "wmid",
		dictkey : 'CONTRACT_WMID',
		"required" : true,
		"style" : "width:30%",
		"defaultValue" : "3",
		"onvaluechanged":"onChangeWmid",
	},{
		"label" : "主营品牌：",
		"type" : "ButtonEdit",
		"name" : "ppcode",
		displayField : "ppcode_name",
		type : "fut_popselect",
		selectkey : "supplierpp",
		textName : "ppcode_name",
		"required" : true,
	},{
		"label" : "经营种类：",
		"type" : "ButtonEdit",
		"name" : "mcid",
		displayField : "mcid_name",
		"required" : true,
		type : "fut_popselect",
		selectkey : "cat",
		textName : "mcid_name",
		responseName : "mcid",
		beforefunc : "head_beforefunc_mcid",
		itemchangedfunc : "head_itemchanged_mcid",
		"style" : "width:30%;"
	},{
		"label" : "合同样式：",
		"type" : "ComboBox",
		"name" : "contstyle",
		dictkey : 'CONTRACT_CONTSTYLE',
		"valueField" : "code",
		"textField" : "name",
		"defaultValue" : "01",
		"style" : "width:30%",
		"readOnly" : true,
		"visible" : false,
	},{
		"label" : "合同编号：",
		"type" : "TextBox",
		"name" : "contno",
	},{
		"label" : "生效日期：",
		"type" : "DatePicker",
		"name" : "cmeffdate",
		"format" : "yyyy-MM-dd",
		"required" : true,
		"onValuechanged" : "onFromSdateChange",
	},{
		"label" : "失效日期：",
		"type" : "DatePicker",
		"name" : "cmlapdate",
		"format" : "yyyy-MM-dd",
		"required" : true,
		"onValuechanged" : "onFromedateChange",
	},{
		"label" : "当前有效期：",
		"type" : "TextBox",
		"name" : "expirydate",
		"style" : "width:30%",
		"readOnly" : true,
		"visible" : false,
	},{
		"label" : "合同文本号：",
		"type" : "TextBox",
		"name" : "contsgbh",
		"style" : "width:30%"
	},{
		"label" : "合同标的：",
		"type" : "TextBox",
		"name" : "contsubject",
		"style" : "width:30%;display:block;float:none"
	},{
		"label" : "撤场日期：",
		"type" : "DatePicker",
		"name" : "ccdate",
		"format" : "yyyy-MM-dd",
		"readOnly" : true,
		"visible" : false,
	},{
		"label" : "备注：",
		"type" : "TextBox",
		"name" : "memo",
		"style" : "width:60%;display:block;float:none"
	}]
	},{
		"id" : "test4",
		"label" : "供货结算付款",
		"type" : "fieldset",
		"items" :[{
			"label" : "合同扣率：",
			"name" : "contrate",
			"type" : "NumButtonEdit",
			"defaultValue" : "0",
			"format":"p2",
			"style" : "width:30%",
		},{
			"label" : "经销结算方式：",
			"type" : "ComboBox",
			"name" : "setmode",
			dictkey: 'SELFCONTRACT_SETMODE',
			"style" : "width:30%",
			"defaultValue" : "1",
			"required" : true,
			"visible" : false,
		},{
			"label" : "开户行：",
			"type" : "TextBox",
			"name" : "bank",
		},{
			"label" : "银行帐号：",
			"type" : "TextBox",
			"name" : "bankaccount",
		},{
			"label" : "保底期限：",
			"type" : "ComboBox",
			"name" : "bdqx",
			dictkey : 'CONTRACT_BDQX',
			//"data" : dicData.CONTRACT_BDQX,
			"style" : "width:30%",
			"required" : true,
			"defaultValue" : "3",
		},{
			"label" : "保底方式：",
			"type" : "ComboBox",
			"name" : "bdmode",
			dictkey : 'CONTRACT_BDMODE',
			"required" : true,
			"defaultValue" : "1",
			"style" : "width:30%",
		},{
			"label" : "超额计算方式：",
			"type" : "ComboBox",
			"name" : "cetype",
			dictkey : 'CONTRACT_CETYPE',
			"required" : true,
			"defaultValue" : "1",
			"style" : "width:30%",
		},{
			"label" : "结算位置：",
			"type" : "ComboBox",
			"name" : "settleposition",
			"required" : true,
			"visible" : false,
		},{
			"label" : "结算组：",
			"type" : "ComboBox",
			"name" : "setgroupcode",
			dictkey : 'SETGROUPCODE',
			//"data" : dicData.SETGROUPCODE,
			"style" : "width:30%",
			"visible" : false,
			"defaultValue" : "01",
		},{
			"label" : "租金收取月数：",
			"type" : "NumButtonEdit",
			"format" : "n0",
			"name" : "rentmons",
			"defaultValue" : 1,
			"style" : "width:30%;",
			"visible" : false,
		},{
			"text" : "是否代管：",
			"type" : "CheckBox",
			"name" : "isdg",
			"trueValue" : "Y",
			"falseValue" : "N",
			"defaultValue" : "N",
			"style" : "width:30%;",
			"visible" : false,
		},{
			"label" : "结算标志：",
			"type" : "ComboBox",
			"name" : "setflag",
			dictkey : 'CONTRACT_SETFLAG',
			"required" : true,
			"defaultValue" : "Y",
			"style" : "width:30%;",
		},{
			"label" : "经营主体：",
			"type" : "ComboBox",
			"name" : "manatype",
			dictkey : 'COMPANY',
			"required" : true,
			"style" : "width:30%",
			"defaultValue" : "0",
		}]
	}];

Future.Table.Head.bcontmain3 = [
	{
		"id" : "test",
		"label" : "单据信息",
		"type" : "fieldset",
		"items" :[{
			"label" : "ph_key：",
			"type" : "TextBox",
			"name" : "ph_key",
			"readOnly" : "true",
			"visible" : false,
		}, {
			"label" : "单据编号：",
			"name" : "billno",
			"type" : "TextBox",
			"readOnly" : true,
			"style" : "width:30%",
		}, {
			"label" : "单据类别：",
			"type" : "TextBox",
			"name" : "billmoduleid",
			"readOnly" : true,
			"visible" : false,
		}, {
			"label" : "单据状态：",
			"type" : "ComboBox",
			"name" : "billstatus",
			"readOnly" : true,
			"enabled" : "true",
			dictkey : 'SYSTEM_BILLSTATUS',
			"valueField" : "code",
			"textField" : "name",
			"defaultValue" : "N",
			"style" : "width:30%;display:block;float:none",
		}, {
			"label" : "单据来源：",
			"type" : "ComboBox",
			"name" : "billsource",
			"readOnly": "true",
			dictkey :"SYSTEM_BILLSOURCE",
			"defaultValue" : "02",
			"visible" : false,
		}, {
			"label" : "手工单号：",
			"name" : "billsgdh",
			"type" : "TextBox",
			"style" : "width:30%",
			"visible" : false,
		}, {
			"label" : "录入人编码",
			"type" : "TextBox",
			"name" : "inputer",
			"visible" : false,
		},{
			"label" : "是否长期",
			"type" : "TextBox",
			"name" : "iscq",
			"visible" : false,
			"defaultValue" : "N",
		},{
			"label" : "录入人：",
			"type" : "TextBox",
			"name" : "inputer_name",
			"readOnly" : "true",
		},{
			"label" : "审核人编码",
			"type" : "TextBox",
			"name" : "auditor",
			"visible" : false,
		},{
			"label" : "审核人：",
			"type" : "TextBox",
			"name" : "auditor_name",
			"readOnly" : "true",
		},{
			"label" : "取消人编码",
			"type" : "TextBox",
			"name" : "canceler",
			"visible" : false,
		},{
			"label" : "作废人：",
			"type" : "TextBox",
			"name" : "canceler_name",
			"readOnly" : "true",
			"style" : "width:30%;display:block;float:none"
		},{
			"label" : "录入日期：",
			"type" : "DatePicker",
			"name" : "inputdate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
			"style" : "width:30%;"
		},{
			"label" : "审核日期：",
			"type" : "DatePicker",
			"name" : "auditdate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
			"style" : "width:30%;"
		},{
			"label" : "作废日期：",
			"type" : "DatePicker",
			"name" : "canceldate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
			"style" : "display:block;float:none",
		}]
	},{
		"id" : "test2",
		"label" : "基本信息",
		"type" : "fieldset",
		"items" :[{
			"label" : "门店：",
			"type" : "ButtonEdit",
			"name" : "muid",
			"required" : "true",
			displayField : "muid_name",
			type : "fut_popselect",
			selectkey : "muid",
			textName : "muid_name",
			responseName : "muid",
			beforefunc : "head_beforefunc_muid",
			itemchangedfunc : "head_itemchanged_muid",
		}, {
			"label" : "<a class='New_Button' href='javascript:onSbidShow(2)'><u>商户：</u></a>",
			"type" : "ButtonEdit",
			"name" : "sbid",
			displayField : "sbid_name",
			"required" : true,
			type : "fut_popselect",
			selectkey : "supmkt",
			textName : "sbid_name",
			responseName : "sbid",
			beforefunc : "head_beforefunc_supmkt",
			itemchangedfunc : "head_itemchanged_supmkt",
			renderer:"onSbid",
		}, {
			"label" : "店招：",
			"type" : "TextBox",
			"name" : "sbdz",
			"style" : "width:30%"
		}, {
			"label" : "合同样式：",
			"type" : "ComboBox",
			"name" : "contstyle",
			dictkey : 'CONTRACT_CONTSTYLE',
			"valueField" : "code",
			"textField" : "name",
			"defaultValue" : "02",
			"style" : "width:30%",
			"readOnly" : true,
			"visible" : false,
		}, {
			"label" : "合同号：",
			"type" : "ButtonEdit",
			"name" : "contno",
			"readOnly" : true,
			displayField : "contno",
			type : "fut_popselect",
			selectkey : "contno",
			textName : "contno",
			responseName : "contno",
			beforefunc : "head_beforefunc_zlcontno",
			itemchangedfunc : "head_itemchanged_zlcontno",
			"style" : "width:30%"
		}, {
			"label" : "主合同号：",
			"type" : "ButtonEdit",
			"name" : "mcontno",
			displayField : "mcontno",
			type : "fut_popselect",
			selectkey : "contno",
			textName : "mcontno",
			responseName : "mcontno",
			beforefunc : "head_beforefunc_maincontno",
			"style" : "width:30%",
			"readOnly" : true,
			"visible" : false,
		},{
			"label" : "合同状态：",
			displayField : "billstatus",
			"type" : "ComboBox",
			"name" : "contstatus",
			"readOnly" : true,
			"enabled" : "true",
			dictkey : 'CONTRACT_CONTSTATUS',
			"valueField" : "code",
			"textField" : "name",
			"defaultValue" : "N",
			"style" : "width:30%",
			"visible" : false,
		}, {
			"label" : "合同文本号：",
			"type" : "TextBox",
			"name" : "contsgbh",
			"style" : "width:30%"
		}, {
			"label" : "合同类型：",
			"type" : "ComboBox",
			"name" : "conttype",
			dictkey : 'CONTRACT_CONTTYPE',
			"style" : "width:30%",
			"required" : true,
		}, {
			"label" : "部门：",
			"type" : "ButtonEdit",
			"name" : "department",
			"required" : true,
			displayField : "mmfcname",
			type : "fut_popselect",
			selectkey : "mana",
			textName : "mmfcname",
			responseName : "mmfid",
			beforefunc : "head_beforefunc_mana",
			itemchangedfunc : "head_itemchanged_mana",
			"visible" : false,
		},{
			"text" : "是否代管：",
			"type" : "CheckBox",
			"name" : "isdg",
			"trueValue" : "Y",
			"falseValue" : "N",
			"defaultValue" : "N",
			"onValuechanged" : "onIsdgChange",
			"style" : "width:30%;",
			"visible" : false,
		},{
			"label" : "分成比例：",
			"type" : "NumButtonEdit",
			"name" : "fcbl",
			"format" : "p2",
			"defaultValue" : 0,
			"style" : "width:30%;",
			"prange" : true,
			"readOnly" : true,
			"visible" : false,
		},{
			"label" : "业主编码：",
			"type" : "ButtonEdit",
			"name" : "ownerid",
			displayField : "ownercname",
			type : "fut_popselect",
			selectkey : "owner",
			textName : "ownercname",
			responseName : "ownerid",
			// beforefunc : "head_beforefunc_owner",
			// itemchangedfunc : "head_itemchanged_owner",
			"style" : "width:30%;display:block;float:none",
			"readOnly" : true,
			"visible" : false,
		},{
			"label" : "经营方式：",
			"type" : "ComboBox",
			"name" : "wmid",
			"readOnly" : true,
			dictkey : 'CONTRACT_WMID',
			"style" : "width:30%",
			"defaultValue" : "5",
		},{
			"label" : "主营品牌：",
			"type" : "ButtonEdit",
			"name" : "ppcode",
			displayField : "ppcode_name",
			type : "fut_popselect",
			selectkey : "ppcode",
			textName : "ppcode_name",
			beforefunc : "head_beforefunc_ppcode",
			itemchangedfunc : "head_itemchanged_ppcode",
			"required" : true,
		},{
			"label" : "经营种类：",
			"type" : "ButtonEdit",
			"name" : "mcid",
			displayField : "mcid_name",
			type : "fut_popselect",
			selectkey : "cat",
			textName : "mcid_name",
			responseName : "mcid",
			beforefunc : "head_beforefunc_mcid",
			itemchangedfunc : "head_itemchanged_mcid",
			"style" : "width:30%;",
			"required" : true,
		},{
			"label" : "店铺号：",
			"type" : "TextBox",
			"name" : "dph",
			"onValuechanged" : "onDphChange",
			"visible":false,
		},{
			"label" : "分类：",
			"name" : "sort",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
			"label" : "大类：",
			"name" : "bigsort",
			type : "ComboBox",
			dictkey : 'BRAND_PPGRADE',
			"readOnly" : true,
			"visible":false,
		},{
			"label" : "合同主体：",
			"type" : "TextBox",
			"name" : "cmtitle",
			"style" : "width:90%;display:block;float:none"
		},{
			"label" : "生效日期：",
			"type" : "DatePicker",
			"name" : "cmeffdate",
			"format" : "yyyy-MM-dd",
			"required" : true,
			"onValuechanged" : "onFromSdateChange",
		},{
			"label" : "失效日期：",
			"type" : "DatePicker",
			"name" : "cmlapdate",
			"format" : "yyyy-MM-dd",
			"required" : true,
			"onValuechanged" : "onFromedateChange",
		},{
			"label" : "当前有效期：",
			"type" : "TextBox",
			"name" : "expirydate",
			"style" : "width:30%",
			"readOnly" : true,
		},{
			"label" : "签约人：",
			"type" : "TextBox",
			"name" : "signman",
			"style" : "width:30%",
		},{
			"label" : "签约日期：",
			"type" : "DatePicker",
			"name" : "signdate",
			"format" : "yyyy-MM-dd",
		},{
			"label" : "交付日期：",
			"type" : "DatePicker",
			"name" : "deliverydate",
			"format" : "yyyy-MM-dd",
			"onValuechanged" : "onDeliverydateChange",
		},{
			"label" : "装修开始日期：",
			"type" : "DatePicker",
			"name" : "zxqsrq",
			"format" : "yyyy-MM-dd",
		},{
			"label" : "装修结束日期：",
			"type" : "DatePicker",
			"name" : "zxjzrq",
			"format" : "yyyy-MM-dd",
		},{
			"label" : "开业日期：",
			"type" : "DatePicker",
			"name" : "opendate",
			"format" : "yyyy-MM-dd",
		},{
			"label" : "撤场原因：",
			"type" : "ComboBox",
			"name" : "ccreason",
			"readOnly" : true,
			dictkey : 'CONTRACT_CCREASON',
			"style" : "width:30%"
		},{
			"label" : "撤场日期：",
			"type" : "DatePicker",
			"name" : "ccdate",
			"format" : "yyyy-MM-dd",
			"readOnly" : true,
			"onValuechanged" : "onCcdateChange",
		},{
			"label" : "费用截止日期：",
			"type" : "DatePicker",
			"name" : "fyedate",
			"format" : "yyyy-MM-dd",
			"readOnly" : true,
			"visible" : false,
		},{
			"label" : "收款人：",
			"type" : "TextBox",
			"name" : "skr",
		},{
			"label" : "开户行：",
			"type" : "TextBox",
			"name" : "bank",
		},{
			"label" : "银行帐号：",
			"type" : "TextBox",
			"name" : "bankaccount",
		},{
			"label" : "合同税号：",
			"type" : "TextBox",
			"name" : "conttaxno",
			"visible" : false,
		},{
			"label" : "备注：",
			"type" : "TextBox",
			"name" : "memo",
			"style" : "width:90%;display:block;float:none"
		}]
	},{
		"id" : "test3",
		"label" : "结算条款",
		"type" : "fieldset",
		"items" :[{
			"label" : "结算组：",
			"type" : "ComboBox",
			"name" : "setgroupcode",
			dictkey : 'SETGROUPCODE',
			"style" : "width:30%",
			"required" : true,
			"defaultValue" : "02",
		}, {
			"label" : "结算方式：",
			"type" : "ComboBox",
			"name" : "setmode",
			dictkey : 'CONTRACT_SETMODE',
			"style" : "width:30%",
			"defaultValue" : "12",
			"visible" : false,
		}, {
			"label": "经营主体：",
			"name": "manatype",
			"type": "ComboBox",
			"required" : true,
			"enabled" : true,
			dictkey : 'COMPANY',
			"style" : "width:30%",
			"defaultValue" : "0",
		},{
			"label" : "结算标志：",
			"type" : "ComboBox",
			"name" : "setflag",
			dictkey : 'CONTRACT_SETFLAG',
			"style" : "width:30%",
			"required" : true,
			"defaultValue" : "Y",
		}, {
			"label" : "账单日：",
			"type" : "ComboBox",
			"name" : "settleday",
			dictkey : 'SETTLEDAY',
			"style" : "width:30%",
			"required" : true,
			"defaultValue" : "31",
		}, {
			"label" : "结算模式 ：",
			"type" : "ComboBox",
			"name" : "cycsqtype",
			"required" : true,
			dictkey : 'CONTRACT_CYCSQTYPE',
			"style" : "width:30%",
		}, {
			"label" : "租金收取月数：",
			"type" : "NumButtonEdit",
			"format" : "n0",
			"name" : "rentmons",
			"defaultValue" : 1,
			"style" : "width:30%;",
			"required" : true,
		}, {
			"label" : "保底方式：",
			"type" : "ComboBox",
			"name" : "bdmode",
			dictkey : 'CONTRACT_BDMODE',
			"style" : "width:30%",
			"required" : true,
			"visible" : false,
		} ,{
			"label" : "保底期限：",
			"type" : "ComboBox",
			"name" : "bdqx",
			dictkey : 'CONTRACT_BDQX',
			"style" : "width:30%",
			"defaultValue" : "3",
			"required" : true,
			"visible" : false,
			"onValuechanged" : "onBDqxChange",
		} , {
			"label" : "付款方式：",
			"type" : "ComboBox",
			"name" : "paycode",
			dictkey : 'CHARGE_PAYMODE',
			"style" : "width:30%",
			"defaultValue" : "5",
		}, {
			"label" : "收银方式 ：",
			"type" : "ComboBox",
			"name" : "syfs",
			dictkey : 'CONTRACT_SYFS',
			"style" : "width:30%",
			"required" : true,
		}, {
			"label" : "抽成销售额 ：",
			"type" : "ComboBox",
			"name" : "drawsales",
			dictkey : 'CONTRACT_DRAWSALES',
			"style" : "width:30%",
			"required" : true,
			"defaultValue" : "1",
		},{
			"label" : "滞纳金计算方式 ：",
			"type" : "ComboBox",
			"name" : "cetype",
			dictkey : 'CONTRACT_OFCTYPE',
			"style" : "width:30%",
			"defaultValue" : "1",
		},{
			"label" : "滞纳金计算模式：",
			"type" : "ComboBox",
			"name" : "znjmode",
			dictkey : 'CONTRACT_ZNJMODE',
			"required" : true,
			"style" : "width:30%",
			"defaultValue" : "1",
		}, {
			"label" : "滞纳金率：",
			"type" : "NumButtonEdit",
			"name" : "znjl",
			"format" : "p4",
			"defaultValue" : 0,
			"style" : "width:30%;",
			"prange" : true,
			"required" : true,
			"defaultValue" : "0.0020",
		},{
			"label" : "首期款缴款日期：",
			"type" : "DatePicker",
			"name" : "sqkjkr",
			"format" : "yyyy-MM-dd",
			"required" : true,
		}, {
			"label" : "缴款截止日：",
			"type" : "ComboBox",
			"name" : "jkqx",
			dictkey : 'SETTLEDAY',
			"style" : "width:30%",
			"required" : true,
			"defaultValue" : "20",
		}, {
			"label" : "宽限期：",
			"type" : "NumButtonEdit",
			"name" : "graceperiod",
			"format" : "n0",
			"defaultValue" : 0,
			"style" : "width:30%;",
			"prange" : false,
			"visible" : false,
		},]
	}];

Future.Table.Tab.bcontmain = [ {
	"title" : "商铺信息",
	"name" : "bcontmanaframe",
}, {
	"title" : "租金和抽成",
	"name" : "bcontbd",
}, {
	"title" : "固定周期性费用",
	"name" : "bcontcycfee",
},{
	"title" : "合同押金",
	"name" : "bcontdeposit",
}, {
	"title" : "其他费用",
	"name" : "bcontcharge",
}, {
	"title" : "帐期",
	"name" : "bcontterms",
	visible : false,
}, {
	"title" : "能源费单价定义",
	"name" : "bcontenergycost",
}, {
	"title" : "滞纳金例外定义",
	"name" : "bcontoverduefine",
}, {
	"title" : "商品信息",
	"name" : "bcontgoods",
}  ];
