Future.Table.List.bcontmaingm = [ {
	type : "indexcolumn",
	header : "行号",
	readOnly : true,
	headerAlign : "center",
}, {
	field : "billno",
	header : "单据编号",
	allowSort : true,
	headerAlign : "center",
	width : 150,
}, {
	field : "contno",
	header : "合同编号",
	allowSort : true,
	headerAlign : "center",
	align : "left",
	width : 100,
}, {
	field : "billstatus",
	header : "单据状态",
	allowSort : true,
	headerAlign : "center",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'SYSTEM_BILLSTATUS',
	width : 100,
}, {
	field : "sbid",
	displayField : "sbid_name",
	header : "商户",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "sbid",
		textName : "sbid_name",
		responseName : "sbid"
	},
	readOnly : true,
	width : 200,
	// renderer:"onSbid",
}, {
	field : "muid",
	displayField : "muid_name",
	header : "合同门店",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "muid",
		textName : "muid_name",
		responseName : "muid"
	},
	readOnly : true,
	width : 200,
}, {
	field : "brandcounter",
	displayField : "bmname",
	header : "品牌专柜",
	headerAlign : "center",
	readOnly : true,
	visible : false,
	enabledSearch : false,
	width : 120,
}, {
	field : "ppcode",
	displayField : "ppcode_name",
	header : "品牌",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "ppcode_name",
		textName : "ppcode_name",
		responseName : "ppcode"
	},
	readOnly : true,
	width : 180,
},  {
	field : "mcid",
	displayField : "mcid_name",
	header : "经营种类",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "cat",
		textName : "mcid_name",
		responseName : "mcid"
	},
	readOnly : true,
	width : 180,
}, {
	field : "sbdz",
	header : "店招",
	headerAlign : "center",
	readOnly : true,
	width : 150,
}, {
	field : "newsbid",
	displayField : "newsbid_name",
	header : "新商户",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "sbid",
		textName : "newsbid_name",
		responseName : "sbid"
	},
	readOnly : true,
	width : 200,
}, {
	field : "newsbdz",
	header : "新店招",
	headerAlign : "center",
	readOnly : true,
	width : 150,
}, {
	field : "cmeffdate",
	header : "生效日期",
	type : "date",
	width : 100,
	allowSort : true,
	headerAlign : "center",
	align : "center",
	dataType : "date",
	dateFormat : "yyyy-MM-dd",
}, {
	field : "cmlapdate",
	header : "失效日期",
	type : "date",
	width : 100,
	allowSort : true,
	headerAlign : "center",
	align : "center",
	dataType : "date",
	dateFormat : "yyyy-MM-dd",
} , {
	field : "inputer",
	header : "录入人",
	headerAlign : "center",
	readOnly : true,
	enabledSearch : true,
	visible:false,
	width : 100,
},{
	field : "inputer_name",
	header : "录入人",
	headerAlign : "center",
	readOnly : true,
	enabledSearch : false,
	visible:true,
	width : 100,
},{
	field : "inputdate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd HH:mm:ss", 
	header : "录入日期",
	width : 160,
	headerAlign : "center",
	visible:true,
}, {
	field : "auditor",
	header : "审核人",
	width : 100,
	headerAlign : "center",
	enabledSearch : true,
	visible:false,
}, {
	field : "auditor_name",
	header : "审核人",
	width : 100,
	headerAlign : "center",
	enabledSearch : false,
	visible:true,
}, {
	field : "auditdate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd HH:mm:ss",
	header : "审核日期",
	headerAlign : "center",
	width : 160,
	visible:true,
}];

Future.Table.Head.bcontmaingm = [ {
	"label" : "ph_key：",
	"type" : "TextBox",
	"name" : "ph_key",
	"readOnly" : "true",
	"visible" : false,
}, {
	"label" : "单据类型：",
	"type" : "TextBox",
	"name" : "billtype",
	"defaultValue" : "3",
	"visible":false
}, {
	"label" : "单据编号：",
	"name" : "billno",
	"type" : "TextBox",
	"readOnly" : true,
},{
	"label" : "数据来源：",
	"type" : "ComboBox",
	"name" : "billsource",
	dictkey : 'SYSTEM_BILLSOURCE',
	"defaultValue" : "02",
	"visible":false
}, {
	"label" : "单据类别：",
	"type" : "TextBox",
	"name" : "billmoduleid",
	"readOnly" : true,
	"visible":false
}, {
	"label" : "单据状态：",
	"type" : "ComboBox",
	"name" : "billstatus",
	"readOnly" : true,
	"enabled" : "true",
	dictkey : 'SYSTEM_BILLSTATUS',
	"valueField" : "code",
	"textField" : "name",
	"defaultValue" : "N",
}, {
	"label" : "门店：",
	"name" : "muid",
	"defaultValue" : "",
	"required" : "true",
	type : "fut_popselect",//类型
	selectkey:"muid",//弹框类型
	textName :"muid_name", //文本显示字段
	itemchangedfunc:"head_itemchanged_muid",
	"enabled" : true
},{
	"label" : "合同类型：",
	"type" : "ComboBox",
	"name" : "conttype",
	dictkey : 'CONTRACT_CONTTYPE',
	"readOnly" : true,
},{
	"label" : "合同号：",
	"name" : "contno",
	"required" : true,
	type : "fut_popselect",
	selectkey : "contno",
	textName : "contno",
	beforefunc : "head_beforefunc",
	itemchangedfunc : "head_itemchanged_contno",
},{
	"label" : "商户编码：",
	"type" : "TextBox",
	"name" : "sbid",
	"required" : true,
	type : "fut_popselect",
	selectkey : "sbid",
	textName :"sbid",
	"readOnly" : "true",
}, {
	"label" : "商户名称：",
	"type" : "TextBox",
	"name" : "sbcname",
	"readOnly" : "true",
}, {
	"label" : "店招：",
	"type" : "TextBox",
	"name" : "sbdz",
	"readOnly" : "true",
},{
	"label" : "主营品牌：",
	"name" : "ppcode",
	displayField : "ppcode_name",
	type : "fut_popselect",
	selectkey : "ppcode",
	textName : "ppcode_name",
	"readOnly" : true,
},{
	"label" : "经营种类：",
	"name" : "mcid",
	displayField : "mcid_name",
	type : "fut_popselect",
	selectkey : "cat",
	textName : "mcid_name",
	responseName : "mcid",
	"readOnly" : true,
	"style" : "display:block;float:none"
},{
	"label" : "新商户编码：",
	"name" : "newsbid",
	"required" : true,
	type : "fut_popselect",
	selectkey : "sbid",
	textName :"newsbid",
	beforefunc : "head_beforefunc",
	itemchangedfunc : "head_itemchanged_newsbid",
}, {
	"label" : "新商户名称：",
	"type" : "TextBox",
	"name" : "newsbcname",
	"readOnly" : "true",
},{
	"label" : "新店招：",
	"type" : "TextBox",
	"name" : "newsbdz",
	"style" : "display:block;float:none",
},{
	"label" : "生效日期：",
	"type" : "DatePicker",
	"name" : "cmeffdate",
	"format" : "yyyy-MM-dd",
	"readOnly" : true,
	"onValuechanged" : "onFromSdateChange",
},{
	"label" : "失效日期：",
	"type" : "DatePicker",
	"name" : "cmlapdate",
	"format" : "yyyy-MM-dd",
	"readOnly" : true,
	"onValuechanged" : "onFromedateChange",
},{
	"label" : "当前有效期：",
	"type" : "TextBox",
	"name" : "expirydate",
	"style" : "display:block;float:none",
	"readOnly" : true,
},{
	"label" : "变更说明：",
	"type" : "TextArea",
	"name" : "memo",
	"style" : "width:90%;display:block;float:none"
}, {
	"label" : "录入人编码",
	"type" : "TextBox",
	"name" : "inputer",
	"visible" : false,
}, {
	"label" : "录入人：",
	"type" : "TextBox",
	"name" : "inputer_name",
	"readOnly" : "true",
}, {
	"label" : "审核人：",
	"type" : "TextBox",
	"name" : "auditor_name",
	"readOnly" : "true",
	"style" : "display:block;float:none"
}, {
	"label" : "录入日期：",
	"type" : "DatePicker",
	"name" : "inputdate",
	"format" : "yyyy-MM-dd HH:mm:ss",
	"readOnly" : "true",
}, {
	"label" : "审核人编码",
	"type" : "TextBox",
	"name" : "auditor",
	"visible" : false,
}, {
	"label" : "审核日期：",
	"type" : "DatePicker",
	"name" : "auditdate",
	"format" : "yyyy-MM-dd HH:mm:ss",
	"readOnly" : "true",
	"style" : "display:block;float:none"
},{
	"label" : "单据生效日期：",
	"type" : "DatePicker",
	"name" : "effdate",
	"format" : "yyyy-MM-dd",
	"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
	"visible" : false,
} ];