Future.Table.List.bshopchghead = [{
    type: "indexcolumn",
    header: "行号",
    headerAlign: "center",
}, {
    field: "billno",
    header: "单号",
    allowSort: true,
    headerAlign: "center",
    width: 80,
    visible: true
}, {
    field: "billstatus",
    header: "单据状态",
    allowSort: true,
    headerAlign: "center",
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SYSTEM_BILLSTATUS',
    width: 60,
    visible: true
}, {
    field: "muid",
    header: "门店",
    width: 100,
    visible: false,
    enabledSearch: true,
    allowSort: true,
}, {
    field: "muid_name",
    header: "门店名称",
    width: 100,
    allowSort: true,
    enabledSearch: false,
    visible: true
}, {
    field: "spggtype",
    header: "商铺性质",
    allowSort: true,
    headerAlign: "center",
    editor: OcmControl.newControl('ComboBox'),
    type: "comboboxcolumn", //样式属性必须加
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: "SPGGTYPE",
    width: 60,
    visible: false
}, {
    field: "sylx",
    header: "商铺使用类型",
    allowSort: true,
    headerAlign: "center",
    width: 100,
    editor: OcmControl.newControl('ComboBox'),
    type: "comboboxcolumn", //样式属性必须加
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SHOP_SYLX',
    visible: true,
}, {
    field: "inputer_name",
    header: "录入人",
    width: 100,
    allowSort: true,
    headerAlign: "center",
}, {
    field: "inputdate",
    type: "date",
    dataType: "date",
    format: "yyyy-MM-dd",
    header: "录入日期",
    width: 100,
    allowSort: true,
    headerAlign: "center",
    align: "center",
}, {
    field: "auditor_name",
    header: "审核人",
    width: 100,
    allowSort: true,
    headerAlign: "center",
}, {
    field: "auditdate",
    type: "date",
    format: "yyyy-MM-dd",
    header: "审核日期",
    width: 100,
    dataType: "date",
    allowSort: true,
    headerAlign: "center",
    align: "center",
}];

Future.Table.Head.bshopchghead = [{
    "label": "ph_key：",
    "type": "TextBox",
    "name": "ph_key",
    "readOnly": "true",
    "visible": false,
}, {
    "label": "单据编号：",
    "name": "billno",
    "type": "TextBox",
    "required": "true",
    "readOnly": true,
    "visible": true,
}, {
    "label": "模块编号：",
    "name": "billmoduleid",
    "type": "TextBox",
    "required": "true",
    "readOnly": true,
    "visible": false,
    "defaultValue": "100501"
}, {
    "label": "单据状态：",
    "name": "billstatus",
    "type": "ComboBox",
    dictkey: 'SYSTEM_BILLSTATUS',
    "defaultValue": "N",
    "readOnly": true,
    "visible": true
}, {
    "label": "门店：",
    "name": "muid",
    type: "fut_popselect",
    selectkey: "muid",
    textName: "muid_name",
    "required": "true",
    beforefunc: "page.head_btnClickbefore",
    "allowInput": true
}, {
    "label": "门店名称：",
    "name": "muid_name",
    "type": "TextBox",
    "required": "true",
    "defaultValue": "",
    visible: false,
},
    /*
     * { "type" : "Separator", "style" : "clear: both;display: inline-block;width:
     * 90%;margin: 0.2em 0 0.6em;" },
     */
    {
        "label": "业主：",
        "type": "ButtonEdit",
        "name": "ownerid",
        displayField: "owner_name",
        type: "fut_popselect",
        selectkey: "owner",
        textName: "owner_name",
        responseName: "ownerid",
        beforefunc: "page.head_beforefunc_owner",
        // itemchangedfunc : "head_itemchanged_owner",
        "visible": false,
    }, {
        "label": "核算代码：",
        "name": "oik",
        "type": "TextBox",
        visible: false,
    }, {
        "label": "录入人：",
        "name": "inputer_name",
        "type": "TextBox",
        "readOnly": true,
        "visible": true,
    }, {
        "label": "录入人编码：",
        "type": "TextBox",
        "name": "inputer",
        "visible": false,
    }, {
        "label": "审核人：",
        "name": "auditor_name",
        "type": "TextBox",
        "readOnly": true,
        "visible": true,
        /*"style" : "display:block;float:none",*/
    }, {
        "label": "商铺性质：",
        "name": "spggtype",
        "type": "ComboBox",
        dictkey: "SPGGTYPE",
        "required": "true",
        "defaultValue": "S",
        "enabled": true,
        "width": "30%",
        onvaluechanged: "page.head_itemchanged_spggtype",
        "visible": false,
    }, {
        "label": "商铺使用类型：",
        "name": "sylx",
        "type": "ComboBox",
        dictkey: "SHOP_SYLX",
        "required": "true",
        "defaultValue": "02",
        "enabled": true,
        "width": "30%",
        onvaluechanged: "page.head_itemchanged_sylx",
    }, {
        "label": "录入日期：",
        "name": "inputdate",
        "type": "DatePicker",
        "readOnly": true,
        "format": "yyyy-MM-dd HH:mm:ss",
        "visible": true,
    },
    /*
     * { "type" : "Separator", "style" : "clear: both;display: inline-block;width:
     * 90%;margin: 0.2em 0 0.6em;" },
     */{
        "label": "审核日期：",
        "name": "auditdate",
        "type": "DatePicker",
        "readOnly": true,
        "format": "yyyy-MM-dd HH:mm:ss",
        "visible": true
    }];

Future.Table.List.bshopchghead2 = [{
    type: "indexcolumn",
    headerAlign: "center",
    header: "行号",
    width: 80,
}, {
    field: "billno",
    headerAlign: "center",
    header: "单据编号",
    allowSort: true,
    width: 160,
}, {
    field: "billsgno",
    headerAlign: "center",
    header: "手工编号",
    allowSort: true,
    width: 160,
}, {
    field: "billstatus",
    headerAlign: "center",
    header: "单据状态",
    width: 150,
    allowSort: true,
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SYSTEM_BILLSTATUS',
}, {
    field: "muid_name",
    header: "门店名称",
    width: 150,
    allowSort: true,
    headerAlign: "center",
    visible: false,
}, {
    field: "muid",
    header: "门店",
    displayField: "muid_name",
    width: 250,
    allowSort: true,
    headerAlign: "center",
    cdEdtCfg: {
        compnentType: 'fut_popselect',
        selectkey: "muid"
    }
}, {
    field: "createdate",
    headerAlign: "center",
    header: "单据生效日期",
    width: 150,
    allowSort: true,
    dataType: "date",
    dateFormat: "yyyy-MM-dd",
    visible: false,
}, {
    field: "effdate",
    headerAlign: "center",
    header: "单据生效日期",
    width: 150,
    allowSort: true,
    dataType: "date",
    dateFormat: "yyyy-MM-dd",
    visible: false,
}, {
    field: "spid",
    header: billtype === '17' ? '广告位编码' : (billtype === '14' ? '广告位编码' : (billtype === '42' ? '广告位编码' : '商铺编码')),
    width: 120,
    allowSort: true,
    headerAlign: "center",
    enabledSearch: billtype === '14' ? false : (billtype === '17' ? false : true), // 工具栏上查询按钮， false 为隐藏此字段的查询条件
    visible: false,
}, {
    field: "bshopchgdet:spid",
    header: billtype === '17' ? '广告位编码' : (billtype === '14' ? '广告位编码' : (billtype === '42' ? '广告位编码' : '商铺编码')),
    width: 120,
    allowSort: true,
    headerAlign: "center",
    enabledSearch: billtype === '14' ? true : (billtype === '17' ? true : false), // 工具栏上查询按钮， false 为隐藏此字段的查询条件
    visible: false,
}, {
    field: "newspid",
    header: "新商铺编码",
    required: true,
    allowSort: true,
    headerAlign: "center",
    visible: false,
    width: 160,
}, {
    field: "spmode",
    header: "商铺属性",
    allowSort: true,
    headerAlign: "center",
    width: 100,
    editor: OcmControl.newControl('ComboBox'),
    type: "comboboxcolumn", //样式属性必须加
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SHOP_SPMODE',
    visible: false,
}, {
    field: "spstatus",
    header: "商铺状态",
    width: 100,
    allowSort: true,
    headerAlign: "center",
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SHOP_SPSTATUS',
    // data : dictData.SHOP_SPSTATUS,
    visible: false,
}, {
    field: "sptype",
    header: "商铺类型",
    width: 100,
    allowSort: true,
    headerAlign: "center",
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: billtype === '17' ? 'GGTYPE' : (billtype === '14' ? 'GGTYPE' : (billtype === '42' ? 'GGTYPE' : 'SHOP_SPTYPE')),
    // data : dictData.SHOP_SPTYPE,
    visible: false,
}, {
    field: "region",
    header: "上级编码",
    /*displayField : "mmfcname",*/
    displayField: "region_name",
    width: 150,
    allowSort: true,
    headerAlign: "center",
    cdEdtCfg: {
        compnentType: 'fut_popselect',
        selectkey: "treeMmfidno",
    },
    visible: false,
}, {
    field: "ownerid",
    header: "业主",
    allowSort: true,
    headerAlign: "center",
    displayField: "owner_name",
    cdEdtCfg: {
        compnentType: 'fut_popselect',
        selectkey: "owner",
        responseName: "code"
    },
    width: 140,
    visible: false,
}, {
    field: "newspbuildarea",
    header: "新建筑面积",
    allowSort: true,
    headerAlign: "center",
    align: "right",
    visible: false,
    vtype: "double",
    numberFormat: "n2",
    width: 100,
}, {
    field: "newsplettarea",
    header: "新套内面积",
    allowSort: true,
    visible: false,
    align: "right",
    headerAlign: "center",
    vtype: "double",
    numberFormat: "n2",
    width: 100,
}, {
    field: "spggtype",
    header: "广告位类型",
    allowSort: true,
    headerAlign: "center",
    width: 100,
    editor: OcmControl.newControl('ComboBox'),
    type: "comboboxcolumn", //样式属性必须加
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SPGGTYPE',
    visible: false,
}, {
    field: "sylx",
    header: "使用类型",
    allowSort: true,
    headerAlign: "center",
    width: 100,
    editor: OcmControl.newControl('ComboBox'),
    type: "comboboxcolumn", //样式属性必须加
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SHOP_SYLX',
    visible: false,
}, {
    field: "media",
    header: "广告介质",
    allowSort: true,
    headerAlign: "center",
    width: 100,
    editor: OcmControl.newControl('ComboBox'),
    type: "comboboxcolumn", //样式属性必须加
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SHOP_MEDIA',
    visible: false,
}, {
    field: "poolrate",
    headerAlign: "center",
    header: "公摊率",
    allowSort: false,
    numberFormat: "p2",
    width: 100,
    "defaultValue": "0",
    readOnly: true,
    visible: false,
    enabledSearch: false,
}, {
    field: "poolcoeffi",
    headerAlign: "center",
    header: "公摊系数",
    allowSort: false,
    "defaultValue": "0",
    numberFormat: "p2",
    width: 100,
    readOnly: true,
    visible: false,
    enabledSearch: false,
}, {
    field: "memo",
    headerAlign: "center",
    header: "备注",
    allowSort: true,
    width: 250,
    visible: false,
}, {
    field: "inputer_name",
    header: "录入人",
    allowSort: true,
    enabledSearch: false
}, {
    field: "inputdate",
    dataType: "date",
    dateFormat: "yyyy-MM-dd HH:mm:ss",
    header: "录入日期",
    width: 180,
    allowSort: true,
}, {
    field: "auditor_name",
    header: "审核人",
    allowSort: true,
    enabledSearch: false
}, {
    field: "auditdate",
    dataType: "date",
    dateFormat: "yyyy-MM-dd HH:mm:ss",
    header: "审核日期",
    width: 180,
    allowSort: true,
}, {
    field: "inputer",
    header: "录入人",
    headerAlign: "center",
    visible: false,
    enabledSearch: true,
    allowSort: true,
}, {
    field: "auditor",
    header: "审核人",
    headerAlign: "center",
    visible: false,
    allowSort: true,
    enabledSearch: true
}];

Future.Table.Head.bshopchghead2 = [{
    "label": "ph_key：",
    "type": "TextBox",
    "name": "ph_key",
    "readOnly": "true",
    "visible": false,
}, {
    "label": "单据编号：",
    "id": "billno",
    "name": "billno",
    "type": "TextBox",
    "readOnly": true,
}, {
    "label": "手工编号：",
    "name": "billsgno",
    "type": "TextBox",
    "defaultValue": "",
    "style": billtype === '13' ? "display:block;float:none" : billtype === '14' ? "display:block;float:none" : "",
}, {
    "label": "单据类别：",
    "name": "billmoduleid",
    "type": "ComboBox",
    "defaultValue": billmoduleid,
    "readOnly": true,
    visible: false,
}, {
    "label": "单据状态：",
    "name": "billstatus",
    "type": "ComboBox",
    dictkey: 'SYSTEM_BILLSTATUS',
    "defaultValue": "N",
    "readOnly": true,
}, {
    "label": "门店：",
    "name": "muid",
    "required": "true",
    "defaultValue": "",
    type: "fut_popselect",
    selectkey: "muid",
    textName: "muid_name",
    beforefunc: "head_beforefunc",
    itemchangedfunc: "head_itemchanged_muid",
    allowSort: true,
    "style": billtype === '13' ? "display:block;float:none" : billtype === '14' ? "display:block;float:none" : "",
}, {
    "label": "门店名称：",
    "name": "muid_name",
    "type": "TextBox",
    "required": "true",
    "defaultValue": "",
    allowSort: true,
    visible: false,
}, {
    "label": billtype === '17' ? "广告位：" : (billtype === '42' ? "广告位：" : "商铺："),
    "name": "spid",
    "type": "ButtonEdit",
    "required": "true",
    "defaultValue": "",
    type: "fut_popselect",
    selectkey: billtype === '42' ? "spidgg" : "spid",
    textName: "spid_name",
    beforefunc: "head_beforefunc",
    itemchangedfunc: "head_itemchanged_head_spid",
    allowSort: true,
    visible: false,
},/*{
	"label" : "商铺：",
	"name" : "spcode",
	"type" : "TextBox",
	"visible" : false,
},*/ {
    "label": billtype === '17' ? "新广告位编码：" : "新商铺编码：",
    "type": "TextBox",
    "name": "newspid",
    "onValuechanged": "onSpidChanged",
    "required": "true",
    "visible": "true",
    "visible": billtype === '17' ? true : (billtype === '16' ? true : false),
}, {
    "label": billtype === '17' ? "新广告位名称：" : "新商铺名称：",
    "type": "TextBox",
    "name": "newspname",
    "visible": "true",
    "visible": billtype === '17' ? true : (billtype === '16' ? true : false),
}, {
    "label": billtype === '17' ? "广告位状态：" : (billtype === '14' ? "广告位状态：" : "商铺状态："),
    "name": "spstatus",
    "type": "ComboBox",
    dictkey: 'SHOP_SPSTATUS',
    // "data" : dictData.SHOP_SPSTATUS,
    "readOnly": true,
    visible: false,
}, {
    "label": "商铺类型：",
    "name": "sptype",
    "type": "ComboBox",
    dictkey: billtype === '17' ? 'GGTYPE' : (billtype === '14' ? 'GGTYPE' : (billtype === '42' ? 'GGTYPE' : 'SHOP_SPTYPE')),
    // "data" : dictData.SHOP_SPTYPE,
    "onclick": "head_check_details",
    "onValuechanged": "onSptypeChanged",
    "required": true,
    "readOnly": true,
    visible: false,
}, {
    "label": "商铺属性：",
    "name": "spmode",
    "type": "ComboBox",
    dictkey: 'SHOP_SPMODE',
    // "data" : dictData.SHOP_SPMODE,
    "required": true,
    "readOnly": true,
    visible: false,
}, {
    "label": "上级编码：",
    "name": "region",
    "required": "true",
    "type": "ButtonEdit",
    displayField: "region_name",
    allowSort: true,
    type: "fut_popselect",
    selectkey: "treeMmfidno",
    textName: "region_name",
    beforefunc: "head_beforefunc",
    itemchangedfunc: "head_itemchanged_mmfid",
    "readOnly": true,
    visible: false,
// "style": "display:block;float:none",
}, {
    "label": "上级编码名称：",
    "name": "region_name",
    "type": "TextBox",
    "required": "true",
    "defaultValue": "",
    allowSort: true,
    visible: false,
}, {
    "label": "业主：",
    "type": "ButtonEdit",
    "name": "ownerid",
    displayField: "owner_name",
    type: "fut_popselect",
    selectkey: "owner",
    textName: "owner_name",
    responseName: "ownerid",
    beforefunc: "head_beforefunc_owner",
    // itemchangedfunc : "head_itemchanged_owner",
    "readOnly": true,
    visible: false,
}, {
    "label": "单据生效日期：",
    "name": "createdate",
    "required": "true",
    "type": "DatePicker",
    "format": "yyyy-MM-dd",
    "value": mini.formatDate(new Date(), "yyyy-MM-dd"),
    "defaultValue": mini.formatDate(new Date(), "yyyy-MM-dd"),
    "onValuechanged": "createdatevalue",
    visible: false,
}, {
    "label": "单据生效日期：",
    // "name" : "createdate",
    "name": "effdate",
    "required": "true",
    "type": "DatePicker",
    "format": "yyyy-MM-dd",
    "value": mini.formatDate(new Date(), "yyyy-MM-dd"),
    /*"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),*/
    "onValuechanged": "createdatevalue2",
    visible: false,
}, {
    "label": "建筑面积：",
    "name": "spbuildarea",
    "required": "true",
    "type": "NumButtonEdit",
    "format": "n2",
    "onvaluechanged": "onSpbuildareaChanged",
    "readOnly": true,
    visible: false,
}, {
    "label": "新建筑面积：",
    "type": "TextBox",
    "name": "newspbuildarea",
    "required": "true",
    "type": "NumButtonEdit",
    "format": "n2",
    "onValuechanged": "getPoolrate",
    visible: false,
}, {
    "label": "公摊率：",
    "name": "poolrate",
    "type": "NumButtonEdit",
    "format": "p2",
    "defaultValue": "0",
    "readOnly": true,
    visible: false,
}, {
    "label": "公摊系数：",
    "name": "poolcoeffi",
    "type": "NumButtonEdit",
    "format": "p2",
    "defaultValue": "0",
    "readOnly": true,
    visible: false,
}, {
    "label": "套内面积：",
    "name": "splettarea",
    "required": "true",
    "type": "NumButtonEdit",
    "format": "n2",
    "onvaluechanged": "onSplettareaChanged",
    "readOnly": true,
    visible: false,
}, {
    "label": "新套内面积：",
    "name": "newsplettarea",
    "required": "true",
    "type": "NumButtonEdit",
    "format": "n2",
    "onValuechanged": "getPoolrate",
    "required": "true",
    visible: false,
},/*{
	"label" : "广告位类型：",
	"name" : "spggtype",
	"type" : "ComboBox",
	dictkey : 'SPGGTYPE',
	// "data" : dictData.SPGGTYPE,
	"readOnly" : true,
	visible : false,
},*/ {
    "label": "广告介质：",
    "name": "media",
    "type": "ComboBox",
    dictkey: 'SHOP_MEDIA',
    // "data" : dictData.SHOP_MEDIA,
    "readOnly": true,
    visible: false,
}, {
    "label": "尺寸cm²：",
    "name": "spec",
    "readOnly": true,
    "type": "TextBox",
    visible: false,
}, {
    "label": "面价：",
    "name": "faceprice",
    "type": "NumButtonEdit",
    "format": "c2",
    "onValuechanged": "facenumberCheck",
    "readOnly": true,
    visible: false,
}, {
    "label": "底价：",
    "name": "lowprice",
    "type": "NumButtonEdit",
    "format": "c2",
    "readOnly": true,
    "onValuechanged": "lownumberCheck",
    /*	"style" : billtype === '42'?"":(billtype === '17'?"":(billtype === '15'?"":"display:block;float:none")),*/
    visible: false,
}, {
    "label": "核算代码：",
    "name": "oik",
    "type": "TextBox",
    visible: false,
}, {
    "label": "商铺性质：",
    "name": "spggtype",
    "type": "ComboBox",
    dictkey: "SPGGTYPE",
    "required": "true",
    "defaultValue": "S",
    "enabled": true,
    "readOnly": false,
    beforefunc: "head_beforefunc",
    "onValuechanged": "head_itemchanged_spggtype",
    visible: billtype === '10' ? true : false,
}, {
    "label": "商铺使用类型：",
    "name": "sylx",
    "type": "ComboBox",
    dictkey: "SHOP_SYLX",
    "required": "true",
    "defaultValue": "02",
    "enabled": true,
    "readOnly": false,
    "onItemclick": "head_beforefunc",
    "onValuechanged": "head_itemchanged_sylx",
    visible: billtype === '10' ? true : false,
}, {
    "label": "备注：",
    "name": "memo",
    "type": "TextBox",
    "defaultValue": "",
    "style": "width:60%;display:block;float:none",
}, {
    "label": "录入人：",
    "name": "inputer_name",
    "type": "TextBox",
    "readOnly": true,
}, {
    "label": "录入人编码：",
    "type": "TextBox",
    "name": "inputer",
    "visible": false,
}, {
    "label": "审核人：",
    "name": "auditor_name",
    "type": "TextBox",
    "readOnly": true,
    "style": "display:block;float:none",
}, {
    "label": "录入日期：",
    "name": "inputdate",
    "type": "DatePicker",
    "readOnly": true,
    "format": "yyyy-MM-dd HH:mm:ss",
}, {
    "label": "审核日期：",
    "name": "auditdate",
    "type": "DatePicker",
    "readOnly": true,
    "format": "yyyy-MM-dd HH:mm:ss",
}, {
    "label": "模块号：",
    "name": "billtype",
    "type": "TextBox",
    "visible": false,
}];

Future.Table.List.bshopchghead4 = [{
    type: "indexcolumn",
    headerAlign: "center",
    header: "行号",
    width: 80,
}, {
    field: "billno",
    headerAlign: "center",
    header: "单据编号",
    allowSort: true,
    width: 160,
}, {
    field: "billsgno",
    headerAlign: "center",
    header: "手工编号",
    allowSort: true,
    width: 160,
}, {
    field: "billstatus",
    headerAlign: "center",
    header: "单据状态",
    width: 150,
    allowSort: true,
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SYSTEM_BILLSTATUS',
}, {
    field: "muid_name",
    header: "门店名称",
    width: 150,
    allowSort: true,
    headerAlign: "center",
    visible: false,
}, {
    field: "muid",
    header: "门店",
    displayField: "muid_name",
    width: 250,
    allowSort: true,
    headerAlign: "center",
    cdEdtCfg: {
        compnentType: 'fut_popselect',
        selectkey: "muid"
    }
}, {
    field: "createdate",
    headerAlign: "center",
    header: "单据生效日期",
    width: 150,
    allowSort: true,
    dataType: "date",
    dateFormat: "yyyy-MM-dd",
    visible: false,
}, {
    field: "effdate",
    headerAlign: "center",
    header: "单据生效日期",
    width: 150,
    allowSort: true,
    dataType: "date",
    dateFormat: "yyyy-MM-dd",
    visible: false,
}, {
    field: "spid",
    header: '单元编码',
    width: 120,
    allowSort: true,
    headerAlign: "center",
    enabledSearch: billtype === '177' ? false : (billtype === '179' ? false : true), // 工具栏上查询按钮， false 为隐藏此字段的查询条件
    visible: false,
}, {
    field: "bshopchgdet:spid",
    header: '单元编码',
    width: 120,
    allowSort: true,
    headerAlign: "center",
    enabledSearch: billtype === '177' ? true : (billtype === '179' ? true : false), // 工具栏上查询按钮， false 为隐藏此字段的查询条件
    visible: false,
}, {
    field: "newspid",
    header: "新单元编码",
    required: true,
    allowSort: true,
    headerAlign: "center",
    visible: false,
    width: 160,
}, {
    field: "spmode",
    header: "单元属性",
    allowSort: true,
    headerAlign: "center",
    width: 100,
    editor: OcmControl.newControl('ComboBox'),
    type: "comboboxcolumn", //样式属性必须加
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SHOP_SPSTATUS',
    //data : dictData.SHOP_SPSTATUS,
    visible: false,
}, {
    field: "spstatus",
    header: "单元状态",
    width: 100,
    allowSort: true,
    headerAlign: "center",
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SHOP_SPSTATUS',
    //data : dictData.SHOP_SPSTATUS,
    visible: false,
}, {
    field: "sptype",
    header: "单元类型",
    width: 100,
    allowSort: true,
    headerAlign: "center",
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SHOP_SPTYPE',
    //data : dictData.SHOP_SPTYPE,
    visible: false,
}, {
    field: "region",
    header: "物理位置",
    displayField: "region_name",
    width: 150,
    allowSort: true,
    headerAlign: "center",
    cdEdtCfg: {
        compnentType: 'fut_popselect',
        selectkey: "treeMmfidno",
    },
    visible: false,
}, {
    field: "ownerid",
    header: "业主",
    allowSort: true,
    headerAlign: "center",
    displayField: "owner_name",
    cdEdtCfg: {
        compnentType: 'fut_popselect',
        selectkey: "owner",
        responseName: "code"
    },
    width: 140,
    visible: false,
}, {
    field: "newspbuildarea",
    header: "新建筑面积",
    allowSort: true,
    headerAlign: "center",
    align: "right",
    visible: false,
    vtype: "double",
    numberFormat: "n2",
    width: 100,
}, {
    field: "newsplettarea",
    header: "新套内面积",
    allowSort: true,
    visible: false,
    align: "right",
    headerAlign: "center",
    vtype: "double",
    numberFormat: "n2",
    width: 100,
}, {
    field: "spggtype",
    header: "广告位类型",
    allowSort: true,
    headerAlign: "center",
    width: 100,
    editor: OcmControl.newControl('ComboBox'),
    type: "comboboxcolumn", //样式属性必须加
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SPGGTYPE',
    //data : SPGGTYPE,
    visible: false,
}, {
    field: "sylx",
    header: "使用类型",
    allowSort: true,
    headerAlign: "center",
    width: 100,
    editor: OcmControl.newControl('ComboBox'),
    type: "comboboxcolumn", //样式属性必须加
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SHOP_SYLX',
    //data : SPGGTYPE,
    visible: false,
}, {
    field: "media",
    header: "广告介质",
    allowSort: true,
    headerAlign: "center",
    width: 100,
    editor: OcmControl.newControl('ComboBox'),
    type: "comboboxcolumn", //样式属性必须加
    renderer: "OcmControl.dictRendererWithCode",
    dictkey: 'SHOP_MEDIA',
    //data : dictData.SHOP_MEDIA,
    visible: false,
}, {
    field: "poolrate",
    headerAlign: "center",
    header: "公摊率",
    allowSort: false,
    numberFormat: "p2",
    width: 100,
    "defaultValue": "0",
    readOnly: true,
    visible: false,
    enabledSearch: false,
}, {
    field: "poolcoeffi",
    headerAlign: "center",
    header: "公摊系数",
    allowSort: false,
    "defaultValue": "0",
    numberFormat: "p2",
    width: 100,
    readOnly: true,
    visible: false,
    enabledSearch: false,
}, {
    field: "memo",
    headerAlign: "center",
    header: "备注",
    allowSort: true,
    width: 250,
    visible: false,
}, {
    field: "inputer_name",
    header: "录入人",
    allowSort: true,
    enabledSearch: false
}, {
    field: "inputdate",
    dataType: "date",
    dateFormat: "yyyy-MM-dd HH:mm:ss",
    header: "录入日期",
    width: 180,
    allowSort: true,
}, {
    field: "auditor_name",
    header: "审核人",
    allowSort: true,
    enabledSearch: false
}, {
    field: "auditdate",
    dataType: "date",
    dateFormat: "yyyy-MM-dd HH:mm:ss",
    header: "审核日期",
    width: 180,
    allowSort: true,
}, {
    field: "inputer",
    header: "录入人",
    headerAlign: "center",
    visible: false,
    enabledSearch: true,
    allowSort: true,
}, {
    field: "auditor",
    header: "审核人",
    headerAlign: "center",
    visible: false,
    allowSort: true,
    enabledSearch: true
}];

Future.Table.Head.bshopchghead4 = [{
    "label": "ph_key：",
    "type": "TextBox",
    "name": "ph_key",
    "readOnly": "true",
    "visible": false,
}, {
    "label": "单据编号：",
    "id": "billno",
    "name": "billno",
    "type": "TextBox",
    "readOnly": true,
}, {
    "label": "手工编号：",
    "name": "billsgno",
    "type": "TextBox",
    "defaultValue": "",
    "style": billtype === '177' ? "display:block;float:none" : "",
}, {
    "label": "单据类别：",
    "name": "billmoduleid",
    "type": "ComboBox",
    "defaultValue": billmoduleid,
    "readOnly": true,
    visible: false,
}, {
    label: "billtype：",
    type: "ComboBox",
    name: "billtype",
    defaultValue: billtype,
    readOnly: "true",
    visible: false,
}, {
    "label": "单据状态：",
    "name": "billstatus",
    "type": "ComboBox",
    dictkey: 'SYSTEM_BILLSTATUS',
    "defaultValue": "N",
    "readOnly": true,
}, {
    "label": "门店：",
    "name": "muid",
    "required": "true",
    "defaultValue": "",
    type: "fut_popselect",
    selectkey: "muid",
    textName: "muid_name",
    beforefunc: "head_beforefunc",
    itemchangedfunc: "head_itemchanged_muid",
    allowSort: true,
    "style": billtype === '177' ? "display:block;float:none" : "",
}, {
    "label": "门店名称：",
    "name": "muid_name",
    "type": "TextBox",
    "required": "true",
    "defaultValue": "",
    allowSort: true,
    visible: false,
}, {
    "label": "单元：",
    "name": "spid",
    "type": "ButtonEdit",
    "required": "true",
    "defaultValue": "",
    type: "fut_popselect",
    selectkey: "unitspid",
    textName: "spid_name",
    beforefunc: "head_beforefunc",
    itemchangedfunc: "head_itemchanged_head_spid",
    allowSort: true,
    visible: false,
},/*{
	"label" : "单元：",
	"name" : "spcode",
	"type" : "TextBox",
	"visible" : false,
}, */{
    "label": "新单元编码：",
    "type": "TextBox",
    "name": "newspid",
    "onValuechanged": "onSpidChanged",
    "required": "true",
    "visible": "true",
    "visible": billtype === '179' ? true : false,
}, {
    "label": "新单元名称：",
    "type": "TextBox",
    "name": "newspname",
    "visible": "true",
    "visible": billtype === '179' ? true : false,
}, {
    "label": "单元状态：",
    "name": "spstatus",
    "type": "ComboBox",
    dictkey: 'SHOP_SPSTATUS',
    //"data" : dictData.SHOP_SPSTATUS,
    "readOnly": true,
    visible: false,
}, {
    "label": "单元类型：",
    "name": "sptype",
    "type": "ComboBox",
    dictkey: 'SHOP_SPTYPE',
    //"data" : billtype === '17' ? dictData.GGTYPE :(billtype === '14'?dictData.GGTYPE:(billtype === '42'?dictData.GGTYPE:SHOP_SPTYPE)),
    "onclick": "head_check_details",
    "onValuechanged": "onSptypeChanged",
    "required": true,
    "readOnly": true,
    visible: false,
}, {
    "label": "单元属性：",
    "name": "spmode",
    "type": "ComboBox",
    dictkey: 'SHOP_SPMODE',
    //"data" : dictData.SHOP_SPMODE,
    "required": true,
    "readOnly": true,
    visible: false,
}, {
    "label": "物理位置：",
    "name": "region",
    "required": "true",
    "type": "ButtonEdit",
    displayField: "region_name",
    allowSort: true,
    type: "fut_popselect",
    selectkey: "treeMmfidno",
    textName: "region_name",
    beforefunc: "head_beforefunc",
    itemchangedfunc: "head_itemchanged_mmfid",
    "readOnly": true,
    visible: false,
// "style": "display:block;float:none",
}, {
    "label": "物理位置名称：",
    "name": "region_name",
    "type": "TextBox",
    "required": "true",
    "defaultValue": "",
    allowSort: true,
    visible: false,
}, {
    "label": "业主：",
    "type": "ButtonEdit",
    "name": "ownerid",
    displayField: "owner_name",
    type: "fut_popselect",
    selectkey: "owner",
    textName: "owner_name",
    responseName: "ownerid",
    beforefunc: "head_beforefunc_owner",
    // itemchangedfunc : "head_itemchanged_owner",
    "readOnly": true,
    visible: false,
}, {
    "label": "单据生效日期：",
    "name": "createdate",
    "required": "true",
    "type": "DatePicker",
    "format": "yyyy-MM-dd",
    "value": mini.formatDate(new Date(), "yyyy-MM-dd"),
    "defaultValue": mini.formatDate(new Date(), "yyyy-MM-dd"),
    "onValuechanged": "createdatevalue",
    visible: false,
}, {
    "label": "单据生效日期：",
    // "name" : "createdate",
    "name": "effdate",
    "required": "true",
    "type": "DatePicker",
    "format": "yyyy-MM-dd",
    "value": mini.formatDate(new Date(), "yyyy-MM-dd"),
    /*"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),*/
    "onValuechanged": "createdatevalue2",
    visible: false,
}, {
    "label": "建筑面积：",
    "name": "spbuildarea",
    "required": "true",
    "type": "NumButtonEdit",
    "format": "n2",
    "onvaluechanged": "onSpbuildareaChanged",
    "readOnly": true,
    visible: false,
}, {
    "label": "新建筑面积：",
    "type": "TextBox",
    "name": "newspbuildarea",
    "required": "true",
    "type": "NumButtonEdit",
    "format": "n2",
    "onValuechanged": "getPoolrate",
    visible: false,
}, {
    "label": "公摊率：",
    "name": "poolrate",
    "type": "NumButtonEdit",
    "format": "p2",
    "defaultValue": "0",
    "readOnly": true,
    visible: false,
}, {
    "label": "公摊系数：",
    "name": "poolcoeffi",
    "type": "NumButtonEdit",
    "format": "p2",
    "defaultValue": "0",
    "readOnly": true,
    visible: false,
}, {
    "label": "套内面积：",
    "name": "splettarea",
    "required": "true",
    "type": "NumButtonEdit",
    "format": "n2",
    "onvaluechanged": "onSplettareaChanged",
    "readOnly": true,
    visible: false,
}, {
    "label": "新套内面积：",
    "name": "newsplettarea",
    "required": "true",
    "type": "NumButtonEdit",
    "format": "n2",
    "onValuechanged": "getPoolrate",
    "required": "true",
    visible: false,
},/*{
	"label" : "广告位类型：",
	"name" : "spggtype",
	"type" : "ComboBox",
	dictkey : 'SPGGTYPE',
	// "data" : dictData.SPGGTYPE,
	"readOnly" : true,
	visible : false,
},*/ {
    "label": "广告介质：",
    "name": "media",
    "type": "ComboBox",
    dictkey: 'SHOP_MEDIA',
    //"data" : dictData.SHOP_MEDIA,
    "readOnly": true,
    visible: false,
}, {
    "label": "尺寸cm²：",
    "name": "spec",
    "readOnly": true,
    "type": "TextBox",
    visible: false,
}, {
    "label": "面价：",
    "name": "faceprice",
    "type": "NumButtonEdit",
    "format": "c2",
    "onValuechanged": "facenumberCheck",
    "readOnly": true,
    visible: false,
}, {
    "label": "底价：",
    "name": "lowprice",
    "type": "NumButtonEdit",
    "format": "c2",
    "readOnly": true,
    "onValuechanged": "lownumberCheck",
    /*	"style" : billtype === '42'?"":(billtype === '17'?"":(billtype === '178'?"":"display:block;float:none")),*/
    visible: false,
}, {
    "label": "核算代码：",
    "name": "oik",
    "type": "TextBox",
    "style": "display:block;float:none",
    visible: false,
}, {
    "label": "单元性质：",
    "name": "spggtype",
    "type": "ComboBox",
    dictkey: 'SPGGTYPE',
    //"data" : SPGGTYPE,
    "required": "true",
    "defaultValue": "04",
    "enabled": true,
    "readOnly": false,
    /*itemchangedfunc:"head_itemchanged_spggtype",*/
    "onValuechanged": "head_itemchanged_spggtype",
    visible: false,
}, {
    "label": "单元使用类型：",
    "name": "sylx",
    "type": "ComboBox",
    dictkey: 'SHOP_SYLX',
    //"data" : SPGGTYPE,
    "required": "true",
    "defaultValue": "04",
    "enabled": true,
    "readOnly": false,
    /*itemchangedfunc:"head_itemchanged_spggtype",*/
    "onValuechanged": "head_itemchanged_sylx",
    visible: false,
}, {
    "label": "备注：",
    "name": "memo",
    "type": "TextBox",
    "defaultValue": "",
    "style": "width:60%;display:block;float:none",
}, {
    "label": "录入人：",
    "name": "inputer_name",
    "type": "TextBox",
    "readOnly": true,
}, {
    "label": "录入人编码：",
    "type": "TextBox",
    "name": "inputer",
    "visible": false,
}, {
    "label": "审核人：",
    "name": "auditor_name",
    "type": "TextBox",
    "readOnly": true,
    "style": "display:block;float:none",
}, {
    "label": "录入日期：",
    "name": "inputdate",
    "type": "DatePicker",
    "readOnly": true,
    "format": "yyyy-MM-dd HH:mm:ss",
}, {
    "label": "审核日期：",
    "name": "auditdate",
    "type": "DatePicker",
    "readOnly": true,
    "format": "yyyy-MM-dd HH:mm:ss",
}];