Future.Table.List.goodstaxchange = [ {
	type : "indexcolumn",
	header : "行号",
	headerAlign : "center",
}, {
	field : "billno",
	header : "单据编号",
	allowSort : true,
	headerAlign : "center",
	width : 140,
	enabledSearch : true,
	visible : true
}, {
	field : "billsgno",
	header : "手工单号",
	headerAlign : "center",
	width : 150,
	visible : false
}, {
	field : "billstatus",
	header : "单据状态",
	allowSort : true,
	headerAlign : "center",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'BILLSTATUS',
	width : 80,
	enabledSearch : true,
	visible : true
},{
	field : "muid",
	type : "TextBox",
	headerAlign : "center",
	header : "门店",
	editor : OcmControl.newControl('fut_popselectgrid'),
	displayField : "muid_name",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "muid",
		textName : "muid_name",
	},
	visible : true,
	enabledSearch : true,
	width : 160,
}, {
	field : "gbstartdate",
	header : "生效日期",
	headerAlign : "center",
	readOnly: true,
	visible:true,
	dataType : "date",
	dateFormat : "yyyy-MM-dd",
	width : 85,
},{
	field : "tztype",
	header : "调整类型",
	width : 100,
	allowSort : true,
	headerAlign : "center",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'TZTYPE',
},{
	field : "wmid",
	header : "经营方式",
	width : 90,
	allowSort : true,
	headerAlign : "center",
	renderer : "OcmControl.dictRendererWithCode",
	dictkey : 'WMID',
},{
	field : "sbid",
	type : "TextBox",
	headerAlign : "center",
	header : "供应商",
	editor : OcmControl.newControl('fut_popselectgrid'),
	displayField : "sbid_name",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "bhsbid",
		beforefunc : "list_beforefunc_sbid",
	},
	visible : false,
	enabledSearch : true,
	width : 150,
}, {
	field : "sbid_name",
	type : "TextBox",
	headerAlign : "center",
	header : "供应商",
	enabledSearch : false,
	width : 160,
	visible : true,
}, {
	field : "newjxtax",
	name : "newjxtax",
	headerAlign : "center",
	header : "新进项税率",
	type : "comboboxcolumn",
  	textField : "name",
  	valueField : "code",
  	editor : OcmControl.newControl('ComboBox'),
  	renderer: "OcmControl.dictRendererWithCode",
  	align : "center",
  	dictkey : 'JXTAXRATE',
	editorSet : {
		format : "p2",
	},
	numberFormat : "p2",
	align : "right",
	visible: true,
	width : 80,
}, {
	field : "newxxtax",
	name : "newxxtax",
	headerAlign : "center",
	header : "新销项税率",
	type : "comboboxcolumn",
  	textField : "name",
  	valueField : "code",
  	editor : OcmControl.newControl('ComboBox'),
  	renderer: "OcmControl.dictRendererWithCode",
  	align : "center",
  	dictkey : 'XXTAXRATE',
	editorSet : {
		format : "p2",
	},
	numberFormat : "p2",
	align : "right",
	visible: true,
	width : 80,
},{
	field : "newxftax",
	name : "newxftax",
	headerAlign : "center",
	header : "新消费税率",
	type : "comboboxcolumn",
  	textField : "name",
  	valueField : "code",
  	editor : OcmControl.newControl('ComboBox'),
  	renderer: "OcmControl.dictRendererWithCode",
  	align : "center",
  	dictkey : 'XFTAXRATE',
	editorSet : {
		format : "p2",
	},
	numberFormat : "p2",
	align : "right",
	visible: true,
	width : 80,
},{
	 header : "是否调整库存",
	 type : "checkboxcolumn",
	 field : "istzkc",
	 trueValue : "Y",
	 falseValue : "N",
	 readOnly : true,
	 enabled: false,
	 width: 80,
	 visible : false,
	 enabledSearch : false,
},{
	field : "kcbillno",
	header : "库存调整单",
	headerAlign : "center",
	width : 130,
	visible : false,
	enabledSearch : false,
},{
	field : "inputer",
	header : "录入人",
	width : 120,
	allowSort : true,
	headerAlign : "center",
	editor : OcmControl.newControl('fut_popselectgrid'),
	displayField : "inputer_name",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "user"
	}
}, {
	field : "inputer_name",
	header : "录入人",
	width : 120,
	allowSort : true,
	headerAlign : "center",
	visible : false,
	enabledSearch : false,
}, {
	field : "inputdate",
	type : "date",
	dataType : "date",
	format : "yyyy-MM-dd",
	header : "录入日期",
	width : 130,
	allowSort : true,
	headerAlign : "center",
	align : "center"
}, {
	field : "auditor",
	header : "审核人",
	width : 120,
	allowSort : true,
	headerAlign : "center",
	editor : OcmControl.newControl('fut_popselectgrid'),
	displayField : "auditor_name",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "user"
	}
}, {
	field : "auditor_name",
	header : "审核人",
	width : 120,
	allowSort : true,
	headerAlign : "center",
	visible : false,
	enabledSearch : false,
}, {
	field : "auditdate",
	type : "date",
	format : "yyyy-MM-dd",
	header : "审核日期",
	width : 130,
	dataType : "date",
	allowSort : true,
	headerAlign : "center",
	align : "center"
}, {
	field : "gbupdatedet:gbbarcode",
	headerAlign : "center",
	header : "商品",
	width : 180,
	visible : false,
	enabledSearch : true,
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "selfgbase",
		textName : "gbbarcode",
	},
}, {
	field : "gbupdatedet:spid",
	headerAlign : "center",
	header : "柜组",
	width : 180,
	visible : false,
	enabledSearch : true,
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "selfspid",
		textName : "spid_name",
		beforefunc : "list_beforefunc_spid",
	},
}, ];

Future.Table.Head.goodstaxchange = [ {
	"id" : "gb_bill",
	"label" : "单据信息",
	"type" : "fieldset",
	"visible" : true,
	"items" : [ {
		"label" : "ph_key：",
		"type" : "TextBox",
		"name" : "ph_key",
		"readOnly" : "true",
		"visible" : false,
	}, {
		"label" : "单据编号：",
		"name" : "billno",
		"type" : "TextBox",
		"required" : "true",
		"readOnly" : true,
		"visible" : true,
	}, {
		"label" : "单据类别：",
		"type" : "ComboBox",
		"name" : "billmoduleid",
		"readOnly" : "true",
		dictkey : 'BILLTYPE',
		"visible" : false,
	},{
		"label" : "单据类型：",
		"name" : "billtype",
		"defaultValue" : "150",
		"type" : "TextBox",
		"visible" : false,
	},{
		"label" : "单据状态：",
		"name" : "billstatus",
		"type" : "ComboBox",
		dictkey : 'BILLSTATUS',
		"defaultValue" : "N",
		"readOnly" : true,
		"visible" : true,
		/*"style" : "display:block;float:none",*/
	}, {
		"label" : "手工编号：",
		"name" : "billsgno",
		"type" : "TextBox",
		"readOnly" : false,
		/*"visible" : false,*/
	}, {
		"label" : "录入人：",
		"name" : "inputer_name",
		"type" : "TextBox",
		"readOnly" : true,
		"defaultValue" : app.username,
		"visible" : true,
	}, {
		"label" : "审核人：",
		"name" : "auditor_name",
		"type" : "TextBox",
		"readOnly" : true,
		"visible" : true,
		"style" : "display:block;float:none",
	}, {
		"label" : "录入日期：",
		"name" : "inputdate",
		"type" : "DatePicker",
		"readOnly" : true,
		"format" : "yyyy-MM-dd HH:mm:ss",
		"defaultValue" : new Date(),
		"visible" : true,
		
	}, {
		"label" : "审核日期：",
		"name" : "auditdate",
		"type" : "DatePicker",
		"readOnly" : true,
		"format" : "yyyy-MM-dd HH:mm:ss",
		"visible" : true,
		"style" : "display:block;float:none",
	} ]
}, {
	"id" : "gbupdatehead",
	"label" : "商品信息",
	"type" : "fieldset",
	"items" : [
	   {
		"label" : "门店：",
		"name" : "muid",
		type : "fut_popselect",
		selectkey : "muid",
		textName : "muid_name",
		"required" : "true",
		beforefunc : "head_beforefunc",
		itemchangedfunc : "head_itemchanged",
		"allowInput" : true,
		"readOnly" : false,
	}, {
		"label" : "门店编号：",
		"name" : "mucode",
		"type" : "TextBox",
		"required" : "true",
		"defaultValue" : "",
		visible : false,
	},{
		"label" : "门店名称：",
		"name" : "muid_name",
		"type" : "TextBox",
		"required" : "true",
		"defaultValue" : "",
		visible : false,
	},{
		"label": "生效日期：",
		"name": "gbstartdate",
		"type": "DatePicker",
		"format" : "yyyy-MM-dd",
		"required" : "true",
		"enabled" : true,
		"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
		"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
		"onValuechanged" : "onEffdateChange", 
	},{
		"label" : "调整类型：",
		"name" : "tztype",
		"type" : "ComboBox",
		"required" : "true",
		dictkey : 'TZTYPE',
		"defaultValue" : "4",
		"readOnly" : false,
		"onvaluechanged":"head_valuechanged",
		/*"showNullItem":false*/
	},{
		"label" : "经营方式：",
		"type" : "ComboBox",
		"name" : "wmid",
		dictkey : 'WMID',
		"style" : "width:30%",
		"defaultValue" : "1",
		"required" : "true",
		"onvaluechanged":"head_valuechanged",
	},{
		"label" : "供应商：",
		"name" : "sbid",
		type : "fut_popselect",
		selectkey : "bhsbid",
		textName : "sbid_name",
		beforefunc : "head_beforefunc",
		"allowInput" : true,
		"readOnly" : false,
	}, {
		"label" : "供应商编号：",
		"name" : "sbcode",
		"type" : "TextBox",
		"defaultValue" : "",
		visible : false,
	},{
		"label" : "供应商：",
		"name" : "sbid_name",
		"type" : "TextBox",
		"defaultValue" : "",
		visible : false,
	}, {
		"label" : "新进项税率：",
		"name" : "newjxtax",
		"type" : "ComboBox",
		 dictkey : 'JXTAXRATE',
		 align : "right",
		"onvaluechanged":"head_valuechanged",
		 allowSort : true,
	},{
		"label" : "新销项税率：",
		"name" : "newxstax",
		"type" : "ComboBox",
		 dictkey : 'XXTAXRATE',
		 align : "right",
		"onvaluechanged":"head_valuechanged",
		 allowSort : true,
	},{
		"label" : "新消费税率：",
		"name" : "newxftax",
		"type" : "ComboBox",
		 dictkey : 'XFTAXRATE',
		 align : "right",
		"onvaluechanged":"head_valuechanged",
		 allowSort : true,
	}, {
		"text" : "是否调整库存：",
		"name" : "istzkc",
		"type" : "CheckBox",
		"trueValue" : "Y",
		"falseValue" : "N",
		"defaultValue" : "Y",
		"visible" : false,
	},{
		"label" : "库存调整单：",
		"name" : "kcbillno",
		"type" : "TextBox",
		"readOnly" : true,
		"visible" : true,
	},{
		"label" : "生效状态：",
		"name" : "effflag",
		"type" : "TextBox",
		"readOnly" : true,
		"defaultValue" : "1",
		"visible" : false,
	}]
} ];
Future.Table.Tab.goodstaxchange = [ {
	"title" : "门店",
	"name" : "gbupdatedet",
} ];