Future.Table.List.supinvoicehd =  [ {
	type:"indexcolumn",
	headerAlign:"center",
	header:"行号",
	readOnly: true,
},{
	field: "billno",
	type:"TextBox",
	headerAlign:"center",
	header:"单据编号",
	width: "150",
},{
	field: "billsgno",
	type:"TextBox",
	headerAlign:"center",
	header:"手工单号",
	width: "150",
},{
	field: "billsource",
	type:"TextBox",
	headerAlign:"center",
	header:"数据来源",
	renderer: "OcmControl.dictRendererWithCode",
	dictkey : 'BILLSOURCE',
	visible : false,
},{
	field: "billstatus",
	type:"TextBox",
	headerAlign:"center",
	header:"单据状态",
	renderer: "OcmControl.dictRendererWithCode",
	dictkey : 'BILLFLAG',
},{
	field: "sihsupid",
	displayField : "sihsupid_name",
	type:"TextBox",
	headerAlign:"center",
	header:"供应商",
	width: "250",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "sbid",
		textName : "sihsupid_name",
	},
},{
	field: "sihmarket",
	displayField : "sihmarket_name",
	type:"TextBox",
	headerAlign:"center",
	header:"门店",
	width: "250",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "muid",
		textName : "sihmarket_name",
	},
},{
	field: "sihcode",
	type:"TextBox",
	headerAlign:"center",
	header:"发票代码",
	width: "250",
},{
	field: "sihid",
	type:"TextBox",
	headerAlign:"center",
	header:"发票号码",
	width: "250",
},{
	field: "invoicetype",
	type:"TextBox",
	headerAlign:"center",
	header:"发票类型",
	renderer: "OcmControl.dictRendererWithCode",
	dictkey : 'INVOICETYPE',
},{
	field: "sbfp",
	type:"TextBox",
	headerAlign:"center",
	header:"发票抬头",
	width: "250",
	enabledSearch : false,
	visible : false,
},{
	field: "sbfpadd",
	type:"TextBox",
	headerAlign:"center",
	header:"发票地址",
	width: "250",
	enabledSearch : false,
	visible : false,
},{
	field : "sihbhsje",
	headerAlign : "center",
	header : "不含税金额",
	numberFormat : "c2",
	align: "right",
	enabledSearch : false,
	width:148,
},{
	field : "sihtax",
	headerAlign : "center",
	header : "税率",
	numberFormat : "p2",
	align: "right",
	enabledSearch : false,
	width:148,
},{
	field : "sihhsje",
	headerAlign : "center",
	header : "含税金额",
	numberFormat : "c2",
	align: "right",
	value : "0",
	enabledSearch : false,
	width:148,
},{
	field : "sihse",
	headerAlign : "center",
	header : "税额",
	numberFormat : "c2",
	align: "right",
	enabledSearch : false,
	width:148,
},{
	field : "sihhsye",
	headerAlign : "center",
	header : "含税余额",
	numberFormat : "c2",
	enabledSearch : false,
	align: "right",
	width:148,
}, {
	field : "inputer",
	header : "录入人",
	headerAlign : "center",
	readOnly : true,
	enabledSearch : true,
	visible:false,
	width : 100,
},{
	field : "inputer_name",
	header : "录入人",
	headerAlign : "center",
	readOnly : true,
	enabledSearch : false,
	width : 100,
},{
	field : "inputdate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd HH:mm:ss", 
	header : "录入日期",
	width : 160,
	headerAlign : "center",
}, {
	field : "auditor",
	header : "审核人",
	width : 100,
	headerAlign : "center",
	enabledSearch : true,
	visible:false,
}, {
	field : "auditor_name",
	header : "审核人",
	width : 100,
	headerAlign : "center",
	enabledSearch : false,
}, {
	field : "auditdate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd HH:mm:ss",
	header : "审核日期",
	headerAlign : "center",
	width : 160,
}, {
	field : "canceler",
	header : "取消人",
	width : 100,
	headerAlign : "center",
	enabledSearch : true,
	visible:false,
},{
	field : "canceler_name",
	header : "取消人",
	width : 100,
	headerAlign : "center",
	enabledSearch : false,
}, {
	field : "canceldate",
	dataType : "date",
	dateFormat : "yyyy-MM-dd HH:mm:ss",
	header : "取消日期",
	headerAlign : "center",
	width : 160,
}];

Future.Table.Head.supinvoicehd = [  {
	"label" : "ph_key：",
	"name" : "ph_key",
	"type" : "TextBox",
	"visible":false,
},{
	"label" : "单据编号：",
	"type" : "TextBox",
	"name" : "billno",
	"readOnly" : "true",
},{
	"label" : "单据类别：",
	"type" : "ComboBox",
	"name" : "billmoduleid",
	dictkey : 'BILLMODULEID',
	"readOnly" : true,
	"visible":false,
},{
	"label" : "数据来源：",
	"type" : "ComboBox",
	"name" : "billsource",
	dictkey : 'BILLSOURCE',
	"defaultValue" : "02",
	"readOnly" : true,
	"visible":false,
},{
	"label" : "单据状态：",
	"name" : "billstatus",
	"type" : "ComboBox",
	"defaultValue":"N",
	dictkey : 'BILLFLAG',
	"readOnly": true,
},{
	"label" : "手工单号：",
	"name" : "billsgno",
	"type" : "TextBox",
}, {
	"label" : "门店：",
	displayField : "sihmarket_name",
	"name" : "sihmarket",
	"type" : "ButtonEdit",
	"defaultValue" : "",
	"required" : "true",
	type : "fut_popselect",//类型
	selectkey:"muid",//弹框类型
	textName :"sihmarket_name", //文本显示字段
	beforefunc:"head_beforefunc",
	itemchangedfunc:"head_itemchanged_muid",
},{
	"label" : "供应商：",
	"name" : "sihsupid",
	displayField : "sihsupid_name",
	"type" : "ButtonEdit",
	type : "fut_popselect",//类型
	selectkey:"sbid",//弹框类型
	textName :"sihsupid_name", //文本显示字段
	beforefunc:"head_beforefunc",
	itemchangedfunc:"head_itemchanged_sbid"
},{
	"label" : "供应商名称：",
	"type" : "TextBox",
	"name" : "sihsupid_name",
	"visible" : false,
},{
	"label" : "门店名称：",
	"type" : "TextBox",
	"name" : "sihmarket_name",
	"visible" : false,
},{
	"label" : "发票类型：",
	 "name" : "invoicetype",
	 "type" : "ComboBox", 
	dictkey : 'INVOICETYPE',
	"required" : "true",
	},{
	"label" : "发票代码：",
	"name" : "sihcode",
	"type" : "TextBox",
	"required" : "true",
},{
	"label" : "发票号码：",
	"name" : "sihid",
	"type" : "TextBox",
	"required" : "true",
	"onValuechanged":"onSihidChange",
},{
    "label" : "开票日期：",
    "type" : "DatePicker",
    "name" : "sihkpdate",
    "format" : "yyyy-MM-dd",
    "required" : "true",
    "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
    "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
    "style" : "width:30%"
 }, {
    "label" : "收票日期：",
    "type" : "DatePicker",
    "name" : "sihspdate",
    "format" : "yyyy-MM-dd",
    "required" : "true",
    "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
    "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
    "style" : "width:30%",
    "style" : "display:block;float:none",
 },{
	"label" : "不含税金额：",
	"name" : "sihbhsje",
	"type" : "NumButtonEdit",
	"format" : "c2",
	"defaultValue":0,
	"onValuechanged":"onSihbhsjeChange",
},{
	"label" : "含税金额：",
	"name" : "sihhsje",
	"type" : "NumButtonEdit",
	"format" : "c2",
	"defaultValue":0,
	"onValuechanged":"onSihhsjeChange",
},{
	"label" : "税率：",
	"name" : "sihtax",
	"type" : "ComboBox", 
	dictkey : 'TAXTYPE',
	"onValuechanged":"onSihtaxChange",
},{
	"label" : "含税余额：",
	"name" : "sihhsye",
	"type" : "NumButtonEdit",
	"format" : "c2",
	"defaultValue":0,
	"readOnly": true,
},{
	"label" : "税额：",
	"name" : "sihse",
	"type" : "NumButtonEdit",
	"format" : "c2",
	"defaultValue":0,
	"readOnly": true,
},{
	"label" : "发票抬头：",
	"type" : "TextBox",
	"name" : "sbfp",
	"readOnly": true,
	"visible" : false,
}, {
	"label" : "发票地址：",
	"type" : "TextBox",
	"name" : "sbfpadd",
	"readOnly": true,
	"style" : "width:60%; display:block;float:none",
	"visible" : false,
},{
	"label" : "物流单号：",
	"name" : "wldh",
	"type" : "TextBox",
	"readOnly": true,

},{
	"label" : "备注：",
	"name" : "sihmemo",
	"type" : "TextBox",
	"width" : "60%",
	"style": "display:block;float:none",
},{
	"label" : "录入人编码",
	"type" : "TextBox",
	"name" : "inputer",
	"visible" : false,
},{
	"label" : "录入人：",
	"type" : "TextBox",
	"name" : "inputer_name",
	"readOnly" : "true",
},{
	"label" : "审核人编码",
	"type" : "TextBox",
	"name" : "auditor",
	"visible" : false,
},{
	"label" : "审核人：",
	"type" : "TextBox",
	"name" : "auditor_name",
	"readOnly" : "true",
 },{
	"label" : "取消人编码",
	"type" : "TextBox",
	"name" : "canceler",
	"visible" : false,
},{
	"label" : "取消人：",
	"type" : "TextBox",
	"name" : "canceler_name",
	"readOnly" : "true", 
},{
	"label" : "录入日期：",
	"type" : "DatePicker",
	"name" : "inputdate",
	"format" : "yyyy-MM-dd HH:mm:ss",
	"readOnly" : "true",
},{
	"label" : "审核日期：",
	"type" : "DatePicker",
	"name" : "auditdate",
	"format" : "yyyy-MM-dd HH:mm:ss",
	"readOnly" : "true",
 },{
	"label" : "取消日期：",
	"type" : "DatePicker",
	"name" : "canceldate",
	"format" : "yyyy-MM-dd HH:mm:ss",
	"readOnly" : "true", 
} ];