Future.Table.List.tmanaunit = [ {
	type : "indexcolumn",
	headerAlign : "center",
	header : "行号",
	readOnly : true,
}, {
	field : "muid",
	header : "门店编码",
	allowSort : true,
	headerAlign : "center",
	width : 80,
	readOnly : true,
}, {
	field : "mucname",
	header : "中文名称",
	allowSort : true,
	headerAlign : "center",
	width : 180,
}, {
	field : "mucqname",
	header : "门店中文全称",
	allowSort : true,
	headerAlign : "center",
	width : 250,
}, {
	field : "muename",
	header : "英文名称",
	allowSort : true,
	headerAlign : "center",
	width : 200,
}, {
	field : "mustatus",
	header : "门店状态",
	allowSort : true,
	headerAlign : "center",
	width : 80,
	editor : OcmControl.newControl('ComboBox'),
	renderer : "OcmControl.dictRendererWithCode",
	valueField : "code",
	textField : "name",
	dictkey : 'MUSTATUS',
}, {
	field : "mutype",
	header : "零售业态",
	allowSort : true,
	headerAlign : "center",
	width : 100,
	editor : OcmControl.newControl('ComboBox'),
	renderer : "OcmControl.dictRendererWithCode",
	valueField : "code",
	textField : "name",
	dictkey : 'LSYT',
	visible:false
}, {
	field : "mubuildarea",
	header : "建筑面积",
	allowSort : true,
	align: "right",
    headerAlign : "center",
    vtype:"double",
	numberFormat : "#,##0.00",
	width : 80,
}, {
	field : "mubusarea",
	header : "营业面积",
	allowSort : true,
	align: "right",
    headerAlign : "center",
    vtype:"double",
	numberFormat : "#,##0.00",
	width : 80,
}, {
	field : "muusearea",
	header : "使用面积",
	allowSort : true,
	align: "right",
    headerAlign : "center",
    vtype:"double",
	numberFormat : "#,##0.00",
	width : 80,
}, {
	field : "mulettarea",
	header : "可租面积",
	allowSort : true,
	align: "right",
    headerAlign : "center",
    vtype:"double",
	numberFormat : "#,##0.00",
	width : 80,
}, {
	field : "muyopendate",
	header : "预开店日期",
	dataType: "date", 
	dateFormat: "yyyy-MM-dd",
	width : 100,
	allowSort : true,
	headerAlign : "center",
	align : "center",
	visible:false
}, {
	field : "muopendate",
	header : "开店日期",
	dataType: "date", 
	dateFormat: "yyyy-MM-dd",
	width : 100,
	allowSort : true,
	headerAlign : "center",
	align : "center",
}, {
	field : "muservergroup",
	displayField : "ssggroup_name",
	header : "服务器组",
	headerAlign : "center",
	cdEdtCfg : {
		compnentType : 'fut_popselect',
		selectkey : "servergroup",
		textName : "ssggroupname",
		responseName : "ssggroupname"
	},
	renderer : "OcmControl.dictRendererWithCode",
	valueField : "ssggroupid",
	textField : "ssggroupname",
	dictkey : 'servergroup',
	readOnly : true,
	width : 200,
},{
	field : "mucolsedate",
	header : "关店日期",
	dataType: "date", 
	dateFormat: "yyyy-MM-dd",
	width : 100,
	allowSort : true,
	headerAlign : "center",
	align : "center",
	visible:false
} ];

Future.Table.Head.tmanaunit = [ {
	"label" : "ph_key：",
	"name" : "ph_key",
	"type" : "TextBox",
	"visible" : false,
}, {
	"label" : "状态：",
	"name" : "billstatus",
	"defaultValue" : "N",
	"type" : "TextBox",
	"visible" : false,
}, {
	"label" : "门店编码：",
	"type" : "TextBox",
	"name" : "muid",
	"required" : "true",
	"onValuechanged" : "onMuidChanged",
	"style" : "width:22.5%"
}, {
	"label" : "中文名称：",
	"type" : "TextBox",
	"name" : "mucname",
	"onValuechanged" : "onMucnameChanged",
	"required" : "true",
	"style" : "width:22.5%"
}, {
	"label" : "英文名称：",
	"type" : "TextBox",
	"onValuechanged" : "onMuenameChanged",
	"name" : "muename",
	"style" : "width:22.5%"
}, {
	"label" : "门店状态：",
	"type" : "ComboBox",
	"name" : "mustatus",
	"valueField" : "code",
	"defaultValue" : "0",
	"readOnly" : "true",
	 dictkey : 'MUSTATUS',
	 "style" : "width:22.5%"
},{
	"label" : "省份：",
	"name" : "province",
	"type" : "ButtonEdit",
	allowSort : true,
	type : "fut_popselect",
	selectkey:"coderegion",
	textName :"province_name", 
	beforefunc:"head_beforefunc",
	itemchangedfunc:"head_itemchanged_province",
	"required" : "true",
	"style" : "width:22.5%"
},{
	"label" : "城市：",
	"name" : "city",
	"type" : "ButtonEdit",
	allowSort : true,
	type : "fut_popselect",
	selectkey:"coderegion",
	textName :"city_name", 
	beforefunc:"head_beforefunc",
	"required" : "true",
	"style" : "width:22.5%"
},{
	"label" : "上级编码：",
	"name" : "mupid",
	"type" : "ButtonEdit",
	allowSort : true,
	type : "fut_popselect",
	selectkey:"treemdmorg",
	textName :"mupid_name", 
	displayName :"mupid_name",
	itemchangedfunc : "head_itemchanged_mupid",
	"required" : "true",
	"style" : "width:22.5%"
}, {
	"label" : "门店电话：",
	"type" : "TextBox",
	"name" : "mdphone",
	"style" : "width:22.5%"
}, {
	"label" : "属卡前缀：",
	"type" : "TextBox",
	"name" : "muprefix",
	"style" : "width:22.5%"
}, {
	"label" : "零售业态：",
	"name" : "mutype",
	"type" : "ComboBox",
	"textField" : "name",
	"valueField" : "code",
	 dictkey : 'LSYT',
	"defaultValue" : "00",
	"style" : "width:22.5%",
	"visible":false
},{
	"label" : "预计开店日期：",
	"name" : "muyopendate",
	"type" : "DatePicker",
	"format" : "yyyy-MM-dd",
	"enabled" : true,
	"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
	"style" : "width:22.5%",
	"visible":false
},{
	"label" : "开店日期：",
	"name" : "muopendate",
	"type" : "DatePicker",
	"format" : "yyyy-MM-dd",
	"enabled" : true,
	"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
	"style" : "width:22.5%"
},{
	"label" : "关店日期：",
	"name" : "mucolsedate",
	"type" : "DatePicker",
	"format" : "yyyy-MM-dd",
	"enabled" : true,
	"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
	"style" : "width:22.5%",
	"visible":false
}, {
	"label" : "建筑面积：",
	"name" : "mubuildarea",
	"type" : "Spinner",
	"format" : "#,0.00",
	"vtype" : "float",
	"maxValue" : "100000000000",
	"inputStyle" : "text-align:right;",
	"style" : "width:22.5%"
}, {
	"label" : "使用面积：",
	"type" : "Spinner",
	"format" : "#,0.00",
	"vtype" : "float",
	"maxValue" : "100000000000",
	"inputStyle" : "text-align:right;",
	"name" : "muusearea",
	"style" : "width:22.5%"
}, {
	"label" : "可出租面积：",
	"type" : "Spinner",
	"format" : "#,0.00",
	"vtype" : "float",
	"maxValue" : "100000000000",
	"inputStyle" : "text-align:right;",
	"name" : "mulettarea",
	"style" : "width:22.5%"
}, {
	"label" : "营业面积：",
	"type" : "Spinner",
	"format" : "#,0.00",
	"vtype" : "float",
	"maxValue" : "100000000000",
	"inputStyle" : "text-align:right;",
	"name" : "mubusarea",
	"style" : "width:22.5%"
}, {
	"label" : "招商联系人：",
	"type" : "TextBox",
	"name" : "muser",
	"style" : "width:22.5%"
}, {
	"label" : "联系人英文名：",
	"type" : "TextBox",
	"name" : "muzser",
	"style" : "width:22.5%"
}, {
	"label" : "联系电话：",
	"type" : "TextBox",
	"name" : "muphone",
	"style" : "width:22.5%"
}, {
	"label" : "联系传真：",
	"type" : "TextBox",
	"name" : "mufox",
	"style" : "width:22.5%"
}, {
	"label" : "收款人中文名：",
	"type" : "TextBox",
	"name" : "muownercname",
	"style" : "width:22.5%"
}, {
	"label" : "收款人英文名：",
	"type" : "TextBox",
	"name" : "muownerename",
	"style" : "width:22.5%"
}, {
	"label" : "转账收款户名：",
	"type" : "TextBox",
	"name" : "jvaccountname",
	"style" : "width:22.5%"
}, {
	"label" : "转账收款帐号：",
	"type" : "TextBox",
	"name" : "jvaccount",
	"style" : "width:22.5%"
}, {
	"label" : "转账收款银行：",
	"type" : "TextBox",
	"name" : "jvbank",
	"style" : "width:22.5%"
}, {
	"label" : "税号：",
	"type" : "TextBox",
	"name" : "taxno",
	"style" : "width:22.5%"	
}, {
	"label" : "银联商户号：",
	"type" : "TextBox",
	"name" : "ylshh",
	"style" : "width:22.5%",
	"visible" : false,
}, {
	"label" : "支付宝商户号：",
	"type" : "TextBox",
	"name" : "zfbshh",
	"style" : "width:22.5%",
	"visible" : false,
}, {
	"label" : "微信商户号：",
	"type" : "TextBox",
	"name" : "wxshh",
	"style" : "width:22.5%",
	"visible" : false,
}, {
	"label" : "核算代码：",
	"type" : "TextBox",
	"name" : "hscode",
	"style" : "width:22.5%"
}, {
	"label" : "服务器组：",
	"name" : "muservergroup",
	"type" : "ButtonEdit",
	allowSort : true,
	type : "fut_popselect",
	selectkey:"servergroup",
	textName :"ssggroup_name",
	beforefunc:"head_beforefunc",
	"style" : "width:22.5%;display:block;float:none"
},{
	"label" : "门店中文全称：",
	"type" : "TextBox",
	"name" : "mucqname",
	"style" : "width:45%"
}, {
	"label" : "门店英文全称：",
	"type" : "TextBox",
	"name" : "mueqname",
	"style" : "width:45%"
}, {
	"label" : "门店中文地址：",
	"type" : "TextBox",
	"name" : "jvshophzcadd",
	"style" : "width:45%"
}, {
	"label" : "门店英文地址：",
	"type" : "TextBox",
	"name" : "jvshophzeadd",
	"style" : "width:45%"
}, {
	"label" : "合同签署中文名：",
	"type" : "TextBox",
	"name" : "muocname",
	"style" : "width:45%"
}, {
	"label" : "合同签署英文名：",
	"type" : "TextBox",
	"name" : "muoename",
	"style" : "width:45%"
}, {
	"label" : "账单打印“注”：",
	"type" : "TextBox",
	"name" : "printz",
	"style" : "width:90%"
}, {
	"label" : "账单打印“说明”：",
	"type" : "TextBox",
	"name" : "printsm",
	"style" : "width:90%"
}, {
	"label" : "返租账单打印'注'：",
	"type" : "TextBox",
	"name" : "lbprintz",
	"style" : "width:90%"
}, {
	"label" : "返租通知单'注1'：",
	"type" : "TextBox",
	"name" : "lbtzprintz1",
	"style" : "width:90%"
}, {
	"label" : "返租通知单'注2'：",
	"type" : "TextBox",
	"name" : "lbtzprintz2",
	"style" : "width:90%"
}, {
	"label" : "最后修改人：",
	"type" : "TextBox",
	"name" : "lastmoder",
	"visible" : false,
}, {
	"label" : "最后修改日期：",
	"type" : "DatePicker",
	"name" : "lastmoddate",
	"format" : "yyyy-MM-dd HH:mm:ss",
	"visible" : false,
},{
	"id" : "tmanasuplink",
	"label" : "商场邮箱配置信息",
	"type" : "fieldset",
	"style" : "width:90%",
	"items" :[{
		"label" : "邮箱发送地址：",
		"type" : "TextBox",
		"name" : "tmanasuplink:emailaddr",
		 "vtype": "email",
		 "emailErrorText":"请输入邮件格式"
	},{
		"label" : "邮箱登入密码：",
		"type" : "Password",
		"name" : "tmanasuplink:emailpasswd"
	},{
		"label" : "发件门店：",
		"type" : "TextBox",
		"name" : "tmanasuplink:linkname",
	},{
		"label" : "发件服务器地址：",
		"type" : "TextBox",
		"name" : "tmanasuplink:serveraddr"
	}]
}];


