if (!window.UserControl) window.UserControl = {};

UserControl.GridBox = function () {

    UserControl.GridBox.superclass.constructor.call(this);

    this.initComponents();
    this.bindEvents();

};

mini.extend(UserControl.GridBox, OcmControl.GridBox, {

    uiCls: 'uc-gridbox',

    initComponents: function () {
        var toolbar = '<div style="padding:5px;">'
        	+ '<div> &nbsp;&nbsp;&nbsp;合同：<input id="contno" class="mini-textbox" style="width:35%"/>'
        	+ '&nbsp;&nbsp;&nbsp;供应商：<input id="sbcodename" class="mini-textbox" style="width:35%"/>'
        	+ '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a name="search" class="mini-button" iconCls="icon-search">查询</a> </div>'
        	+ '<div> &nbsp;&nbsp;&nbsp;柜组：<input id="spcode" class="mini-textbox" style="width:35%"/>'
        	/*+ '&nbsp;&nbsp;&nbsp;主体：<input id="title" class="mini-textbox"/>'
        	+ '&nbsp;&nbsp;&nbsp;店招：<input id="sbdz" class="mini-textbox"/>'*/
        	+ '&nbsp;&nbsp;&nbsp;品&nbsp&nbsp&nbsp牌：<input id="ppcode" class="mini-textbox" style="width:35%"/>'
            + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a name="clear" class="mini-button" iconCls="icon-close">清空</a> </div>'
        + '</div>';
        var footer = '<div style="padding:5px;text-align:center;">'
            + '<a name="ok" class="mini-button" iconCls="icon-ok" style="margin-right:20px;">确定</a>'
            + ' <a name="cancel" class="mini-button" iconCls="icon-cancel" >取消</a>'
        + '</div>';

        this.set({
            showToolbar: true,
            toolbar: toolbar,
            showFooter: true,
            footer: footer,
            onbeforeload: this.pullData,
        });
    },
    bindEvents: function () {
        this.searchBtn = mini.getbyName('search', this);
        this.clearBtn = mini.getbyName('clear', this);

        this.okBtn = mini.getbyName('ok', this);
        this.cancelBtn = mini.getbyName('cancel', this);

        var that = this;
        
        var contno = mini.get("contno");
        var sbcodename = mini.get("sbcodename");
        var spcode = mini.get("spcode");
        var title = mini.get("title");
        var sbdz = mini.get("sbdz");
        var ppcode = mini.get("ppcode");
        
        this.searchBtn.on('click', function (e) {
        	if(contno.getValue() == ""){
        		delete that.config.searchParam[that.config.contno];
        	}else{
        		that.config.searchParam[that.config.contno] = contno.getValue();
        	}
        	if(sbcodename.getValue() == ""){
        		delete that.config.searchParam[that.config.sbcodename];
        	}else{
        		that.config.searchParam[that.config.sbcodename] = sbcodename.getValue();
        	}
        	if(spcode.getValue() == ""){
        		delete that.config.searchParam[that.config.spcode];
        	}else{
        		that.config.searchParam[that.config.spcode] = spcode.getValue();
        	}
        	/*if(title.getValue() == ""){
        		delete that.config.searchParam[that.config.title];
        	}else{
        		that.config.searchParam[that.config.title] = title.getValue();
        	}*/
        	if(ppcode.getValue() == ""){
        		delete that.config.searchParam[that.config.ppcode];
        	}else{
        		that.config.searchParam[that.config.ppcode] = ppcode.getValue();
        	}
        	/*if(sbdz.getValue() == ""){
        		delete that.config.searchParam[that.config.sbdz];
        	}else{
        		that.config.searchParam[that.config.sbdz] = sbdz.getValue();
        	}*/
        	that.getResources(that.config.searchParam);
        });
        
        this.clearBtn.on('click', function (e) {
        	contno.setValue("");
        	sbcodename.setValue("");
        	spcode.setValue("");
        	sbdz.setValue("");
        	ppcode.setValue("");
        	title.setValue("");
        });

        this.okBtn.on('click', function (e) {
            that.fire("okclick");
        });
        this.cancelBtn.on('click', function (e) {
        	window.CloseOwnerWindow("close");
            that.fire("cancelclick");
        });
    },

    getAttrs: function (el) {
        var attrs = UserControl.GridBox.superclass.getAttrs.call(this, el);
        mini._ParseString(el, attrs,
            ["onokclick", "oncancelclick","onrowdblclick"]
        );
        return attrs;
    },
    
    pullData: function(e) {
        e.cancel = true;
        var that = this;
        var billmoduleid;
        var source = [];
        var total = 0;
        var _data = that.config.data || that.data;
        if(e.data.pageIndex == "undefined" || e.data.pageIndex == null){
        	e.data.pageIndex = 0;
        }
        if (that.config.resources) {
          var searchParam = {
            'page_no': e.data.pageIndex + 1,
            'page_size': e.data.pageSize,
          };
          if (that.config.searchParam) {
            for (var _s in that.config.searchParam) {
            	if(that.config.response == "v_manaunit"){
                	if(_s == "billmoduleid"){
                		billmoduleid = that.config.searchParam[_s];
                		delete that.config.searchParam[_s];
                	} 		
            	}
              searchParam[_s] = that.config.searchParam[_s];
            }
          }
          if (e.data.sortField) {
            searchParam['order_field'] = e.data.sortField;
          };
          if (e.data.sortOrder) {
            searchParam['order_direction'] = e.data.sortOrder;
          };
          itemLoader.doRequest(that.config.resources, that.config.method, searchParam, null, null, function(data) {
        	console.log(data);
        	console.log(that.config.response);
            source = data[that.config.response];
            total = data['total_results'];
            if(that.config.response == "organization" && billmoduleid){         	
                	source.splice(0,1);
                	total = total -1;
            }    
           /* if(billmoduleid == "7003202" || billmoduleid == "7003201" ){
            	var newrow = {};
            	newrow[that.config.code] = "001";
            	newrow[that.config.name] = "卡中心";
            	source.splice(0,0,newrow);
            }*/
            if(that.config.addAll == true && e.data.pageIndex == 0){
            	var row = {};
            	row[that.config.code] = "ALL";
            	row[that.config.name] = "所有";
            	source.splice(0,0,row);
            }
          }, null, null, false);
        } else if (_data) {
          that.setShowPager(false);
          source = _data;
          total = _data.length;
        }
        that.clearRows(); //清除所有行
        that.set({
          data: source,
          totalCount: total,
          pageIndex: e.data.pageIndex,
          pageSize: e.data.pageSize
        });
      },
    

});

mini.regClass(UserControl.GridBox, "uc-gridbox");