/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.starter.config.ocmomp;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
public class ServletConfig {
    @Value(value="${spring.application.name}")
    String appendpoint;

    @ConditionalOnProperty(prefix="package", name={"type"}, havingValue="war")
    @Bean
    public FilterRegistrationBean jersey() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new ServletContainer());
        bean.addInitParameter("com.sun.jersey.spi.container.ContainerResponseFilters", "com.efuture.starter.config.ocmomp.OcpServletContainer");
        bean.addInitParameter("com.sun.jersey.config.property.packages", "com.efuture.ocp.common.rest");
        return bean;
    }

    @ConditionalOnExpression(value="!'${package.type:jar}'.equals('war')")
    @Bean
    @Order(value=1)
    public ServletRegistrationBean servletRegistrationBean() {
        ServletRegistrationBean jerseyServlet = new ServletRegistrationBean((Servlet)new ServletContainer(), new String[]{"/" + this.appendpoint + "/*"});
        jerseyServlet.addInitParameter("com.sun.jersey.spi.container.ContainerResponseFilters", "com.efuture.starter.config.ocmomp.OcpServletContainer");
        jerseyServlet.addInitParameter("com.sun.jersey.config.property.packages", "com.efuture.ocp.common.rest");
        jerseyServlet.setLoadOnStartup(1);
        return jerseyServlet;
    }
}

