/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.starter.nacos;

import com.alibaba.nacos.api.common.Constants;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.util.EnviromentUtil;
import com.efuture.ocp.common.util.NetworkUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.springframework.util.StringUtils;

public class NacosNaming {
    static NacosNaming reg;
    String server;
    String namespace;
    String svcname;
    String ip;
    int port;
    Properties prop;
    NamingService naming;

    public NacosNaming(String svr) throws Exception {
        this.server = svr;
        this.namespace = NacosNaming.getNamespace();
        this.svcname = NacosNaming.getSelfServiceName();
        this.ip = NetworkUtils.getLocalIP();
        this.port = Integer.parseInt(NetworkUtils.getLocalPort());
        this.prop = new Properties();
        this.prop.setProperty("serverAddr", this.server);
        this.prop.setProperty("namespace", this.namespace);
        NacosNaming.checkAuth(this.prop);
    }

    public static NacosNaming createNacosNaming(String svr) throws Exception {
        if (reg == null) {
            reg = new NacosNaming(svr);
        }
        return reg;
    }

    public static NacosNaming getNacosNaming() throws Exception {
        if (reg == null) {
            throw new Exception("Nacos Nameing Center not create ...");
        }
        return reg;
    }

    public static String getNamespace() {
        String name = EnviromentUtil.getProperty((String)"nacos.discovery.namespace");
        if (StringUtils.isEmpty((Object)name)) {
            name = EnviromentUtil.getProperty((String)"nacos.config.namespace", (String)"public");
        }
        return name;
    }

    public static String getSelfServiceName() {
        String name = EnviromentUtil.getProperty((String)"spring.application.name");
        boolean slice = "true".equalsIgnoreCase(EnviromentUtil.getProperty((String)"efuture.slice.enable"));
        if (slice) {
            name = name.replace("-webin", "-front");
        }
        return name;
    }

    private static void checkAuth(Properties prop) {
        boolean auth = (Boolean)EnviromentUtil.getEnv().getProperty("nacos.core.auth.enabled", Boolean.class, (Object)false);
        if (auth) {
            prop.setProperty("username", EnviromentUtil.getEnv().getProperty("nacos.discovery.username", EnviromentUtil.getProperty((String)"nacos.config.username")));
            prop.setProperty("password", EnviromentUtil.getEnv().getProperty("nacos.discovery.password", EnviromentUtil.getProperty((String)"nacos.config.password")));
        }
    }

    public void registerInstance() throws Exception {
        if (this.naming == null) {
            this.naming = NamingFactory.createNamingService((Properties)this.prop);
        }
        Instance instance = new Instance();
        instance.setIp(this.ip);
        instance.setPort(this.port);
        instance.setWeight(1.0);
        instance.setClusterName("DEFAULT");
        instance.addMetadata("version", ServiceVersion.getInstance().getVer());
        instance.addMetadata("startup.time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        instance.addMetadata("preserved.register.source", "SDK");
        instance.addMetadata("preserved.heart.beat.interval", EnviromentUtil.getProperty((String)"nacos.discovery.metadata.preserved.heart.beat.interval", (String)String.valueOf(Constants.DEFAULT_HEART_BEAT_INTERVAL)));
        instance.addMetadata("preserved.heart.beat.timeout", EnviromentUtil.getProperty((String)"nacos.discovery.metadata.preserved.heart.beat.timeout", (String)String.valueOf(Constants.DEFAULT_HEART_BEAT_TIMEOUT)));
        instance.addMetadata("preserved.ip.delete.timeout", EnviromentUtil.getProperty((String)"nacos.discovery.metadata.preserved.ip.delete.timeout", (String)String.valueOf(Constants.DEFAULT_IP_DELETE_TIMEOUT)));
        String name = EnviromentUtil.getProperty((String)"spring.application.name");
        String user = EnviromentUtil.getProperty((String)"spring.boot.admin.client.username");
        String pass = EnviromentUtil.getProperty((String)"spring.boot.admin.client.password");
        String path = EnviromentUtil.getProperty((String)"management.context-path");
        instance.addMetadata("service.path", "/" + name);
        if (StringUtils.isEmpty((Object)path)) {
            instance.addMetadata("management.context-path", "/" + name + "/montior");
            instance.addMetadata("health.path", "/" + name + "/health");
        } else {
            instance.addMetadata("management.context-path", path);
        }
        if (!StringUtils.isEmpty((Object)user)) {
            instance.addMetadata("user.name", user);
        }
        if (!StringUtils.isEmpty((Object)pass)) {
            instance.addMetadata("user.password", pass);
        }
        this.naming.registerInstance(this.svcname, "DEFAULT_GROUP", instance);
    }

    public void deregisterInstance() throws Exception {
        if (this.naming == null) {
            this.naming = NamingFactory.createNamingService((Properties)this.prop);
        }
        this.naming.deregisterInstance(this.svcname, this.ip, this.port);
    }

    public String selectOneHealthyInstance(String serviceName) throws NacosException {
        if (this.naming == null) {
            this.naming = NamingFactory.createNamingService((Properties)this.prop);
        }
        Instance inst = this.naming.selectOneHealthyInstance(serviceName);
        return "http://" + inst.getIp() + ":" + inst.getPort();
    }
}

