package com.efuture.starter.config.bean;

import com.efuture.ocp.common.cache.*;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(CacheProperties.class)
public class CacheConfiguration
{
    private CacheProperties properties;

    public CacheConfiguration(CacheProperties properties)
    {
        this.properties = properties;
    }
    public CacheConfig getCacheConfig()
    {
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setServerList(this.properties.getServerList());
        cacheConfig.setPoolsize(this.properties.getPoolsize());
        cacheConfig.setRcvbuf(this.properties.getRcvbuf());
        cacheConfig.setSndbuf(this.properties.getSndbuf());
        cacheConfig.setTimeout(this.properties.getTimeout());
        cacheConfig.setMerge(this.properties.getMerge());
        cacheConfig.setHeart(this.properties.isHeart());
        cacheConfig.setRebuild(this.properties.isRebuild());
        cacheConfig.setCachetime(this.properties.getCachetime());
        cacheConfig.setRedisHost(this.properties.getRedisHost());
        cacheConfig.setRedisPort(this.properties.getRedisPort());
        cacheConfig.setRedisMaxActive(this.properties.getRedisMaxActive());
        cacheConfig.setRedisMaxIdle(this.properties.getRedisMaxIdle());
        cacheConfig.setRedisMaxWait(this.properties.getRedisMaxWait());
        cacheConfig.setRedisTimeout(this.properties.getRedisTimeout());
        cacheConfig.setRedisTestOnBorrow(this.properties.isRedisTestOnBorrow());
        cacheConfig.setRedisPassword(this.properties.getRedisPassword());
        cacheConfig.setRedisDatabase(this.properties.getRedisDatabase());
        cacheConfig.setRedisNodes( this.properties.getRedisNodes() );
        cacheConfig.setRedisMaster( this.properties.getRedisMaster() );
        return cacheConfig;
    }

    @Bean(name = "CacheUtils")
    @ConditionalOnMissingBean(name = "CacheUtils")
    public CacheUtils CacheUtils()
    {
        // 默认Redis单实例
        if (CacheUtils.CacheType.MEMCACHED.equalsIgnoreCase(this.properties.getCacheType())) {
            CacheUtilsMemcached cacheUtils = new CacheUtilsMemcached();
            cacheUtils.setConfig(getCacheConfig());
            return cacheUtils;
        }
        else if (CacheUtils.CacheType.INMEMORY.equalsIgnoreCase(this.properties.getCacheType())) {
            CacheUtilsInMemory cacheUtils = new CacheUtilsInMemory();
            //cacheUtils.setConfig( cacheConfig );
            return cacheUtils;
        }
        else if (CacheUtils.CacheType.REDIS_SENTINEL.equalsIgnoreCase(this.properties.getCacheType())) {
            CacheUtilsRedisSentinel cacheUtils = new CacheUtilsRedisSentinel();
            cacheUtils.setConfig(getCacheConfig());
            return cacheUtils;
        }
        else if (CacheUtils.CacheType.REDIS_CLUSTER.equalsIgnoreCase(this.properties.getCacheType())) {
            CacheUtilsRedisCluster cacheUtils = new CacheUtilsRedisCluster();
            cacheUtils.setConfig(getCacheConfig());
            return cacheUtils;
        }
        else {
            CacheUtilsRediscached cacheUtils = new CacheUtilsRediscached();
            cacheUtils.setConfig(getCacheConfig());
            return cacheUtils;
        }
    }

    @Bean(name = "CacheInMemory")
    @ConditionalOnMissingBean(name = "CacheInMemory")
    public CacheUtils CacheInMemory()
    {
        CacheUtilsInMemory cacheUtils = new CacheUtilsInMemory();
        return cacheUtils;
    }

    @Bean(name = "CacheInMemoryObject")
    @ConditionalOnMissingBean(name = "CacheInMemoryObject")
    public CacheUtils CacheInMemoryObject()
    {
        CacheUtilsInMemoryObject cacheUtils = new CacheUtilsInMemoryObject();
        return cacheUtils;
    }

    @Bean(name = "CacheRedis")
    @ConditionalOnMissingBean(name = "CacheRedis")
    public CacheUtilsRediscached CacheRedis()
    {
        CacheUtilsRediscached cacheUtils = new CacheUtilsRediscached();
        cacheUtils.setConfig(getCacheConfig());
        return cacheUtils;
    }
}
