package com.efuture.starter.config.boot;

import com.efuture.ocp.common.rest.userinterface.CloudPortalSessionInit;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.common.user.UserServiceCloudPortal;
import com.efuture.ocp.user.UserService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;

@Configuration
public class SystemDatarangeConfig
{
    /**
     * <bean id="UserServerSrv" class="com.efuture.ocp.common.user.UserServiceCloudPortal" />
     * <bean id="initSession_cloud" class="com.efuture.ocp.common.rest.useinterface.CloudPortalSessionInit" />
     * <bean id="UserDataRangeSrv" class="com.efuture.ocp.common.user.UserDataRangeSrv">
     * <property name="openrange" value="false" />
     * <property name="portalkey" value="cloud" />
     * </bean>
     */
    @Value("${efuture.portal.openrange:false}")
    private boolean OPENRANGE;
    @Value("${efuture.portal.portalkey:cloud}")
    private String PORTALKEY;
    @Value("${efuture.portal.rangeurl:}")
    private String RANGEURL;

    @Bean(name = "UserServerSrv_cloud")
    public UserServiceCloudPortal UserServerSrv_cloud()
    {
        UserServiceCloudPortal us = new UserServiceCloudPortal();
        us.setServiceUrl( RANGEURL );
        return us;
    }

    @Bean(name = "UserServerSrv_congou")
    public HttpInvokerProxyFactoryBean UserServerSrv_congou()
    {
        HttpInvokerProxyFactoryBean httpInvoker = new HttpInvokerProxyFactoryBean();
        httpInvoker.setServiceUrl( RANGEURL );
        httpInvoker.setServiceInterface( UserService.class );
        return httpInvoker;
    }

    @Bean(name = "initSession_cloud")
    public CloudPortalSessionInit initSession_cloud()
    {
        return new CloudPortalSessionInit();
    }

    @Bean(name = "UserDataRangeSrv")
    public UserDataRangeSrv UserDataRangeSrv()
    {
        UserDataRangeSrv uds = new UserDataRangeSrv();
        UserDataRangeSrv.setOpenrange( OPENRANGE );
        UserDataRangeSrv.setPortalkey( PORTALKEY );
        return uds;
    }

}
