/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.billservice;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.BillAbstractHeadBean;
import com.efuture.ocp.common.billservice.BillCommonService;
import com.efuture.ocp.common.component.MasterSlaveComponent;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.StorageUtils;
import com.efuture.omd.storage.FMybatisTemplate;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class BillCommonServiceImpl<T extends BillAbstractHeadBean>
extends MasterSlaveComponent<T>
implements BillCommonService {
    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ServiceResponse applybillno(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"moduleid"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "moduleid");
        }
        String ruleid = jsonparam.getString("ruleid");
        if (StringUtils.isEmpty((Object)ruleid)) {
            ruleid = "billno";
        }
        int num = 1;
        if (jsonparam.containsKey((Object)"count")) {
            num = jsonparam.getInteger("count");
        }
        JSONObject json = new JSONObject();
        if (num > 1) {
            json.put(ruleid, this.doApplyBillNoBatch(session.getEnt_id(), ruleid, jsonparam.getString("moduleid"), jsonparam.getString("type"), jsonparam.getString("level"), num));
        } else {
            json.put(ruleid, (Object)this.doApplyBillNo(session.getEnt_id(), ruleid, jsonparam.getString("moduleid"), jsonparam.getString("type"), jsonparam.getString("level")));
        }
        return ServiceResponse.buildSuccess(json);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String doApplyBillNo(long ent_id, String ruleid, String moduleid, String type, String level) {
        List<String> list = this.doApplyBillNoBatch(ent_id, ruleid, moduleid, type, level, 1);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<String> doApplyBillNoBatch(long ent_id, String ruleid, String moduleid, String type, String level, int num) {
        ArrayList<String> billnolist = new ArrayList<String>();
        FMybatisTemplate storage = null;
        try {
            String[] ruledefs;
            storage = this.getStorageOperations(FMybatisTemplate.class);
            String globrule = "globrule";
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("ruleid").is((Object)ruleid);
            Query query = new Query(criteria);
            Map map = storage.selectOne(query, globrule);
            if (map == null) {
                criteria = Criteria.where((String)"ent_id").is((Object)0).and("ruleid").is((Object)ruleid);
                query = new Query(criteria);
                map = storage.selectOne(query, globrule);
            }
            if (map == null || StringUtils.isEmpty(map.get("ruledef"))) {
                throw new ServiceException("10003", "{0} {1} [{2}] does not exist", "globrule", "ruleid", ruleid);
            }
            SimpleDateFormat datefmt = new SimpleDateFormat("yyMMdd");
            StringBuffer sb = new StringBuffer();
            int daylen = 0;
            for (String def : ruledefs = map.get("ruledef").toString().split("\\|")) {
                if ("#SEQ".equalsIgnoreCase(def)) continue;
                if ("#DAY".equalsIgnoreCase(def)) {
                    daylen = 6;
                    continue;
                }
                if ("#MON".equalsIgnoreCase(def)) {
                    daylen = 4;
                    continue;
                }
                if ("#MODULEID".equalsIgnoreCase(def)) {
                    sb.append(moduleid);
                    continue;
                }
                sb.append(def);
            }
            int seqlen = Integer.parseInt(map.get("rulesyslen").toString()) - sb.length() - daylen;
            if (num <= 0) {
                num = 1;
            }
            String globruledet = "globruledet";
            long seqno = 1L;
            String datestr = datefmt.format(new Date());
            if (daylen > 0) {
                datestr = datestr.substring(0, daylen);
            }
            String rulestr = sb.length() > 0 ? sb.toString() : moduleid;
            criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("ruleid").is((Object)ruleid).and("ruletypestr").is((Object)rulestr);
            query = new Query(criteria);
            Update upt = new Update();
            upt.set("ruleid", (Object)ruleid);
            if (storage.update(query, upt, globruledet) <= 0) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("ent_id", ent_id);
                data.put("ruleid", ruleid);
                data.put("ruletypestr", rulestr);
                data.put("rulecurseqno", seqno + (long)(num - 1));
                data.put("ruletypeday", datestr);
                storage.insert(data, globruledet);
            } else {
                map = storage.selectOne(query, globruledet);
                seqno = daylen > 0 && !datestr.equals(map.get("ruletypeday")) ? 1L : Long.parseLong(map.get("rulecurseqno").toString()) + 1L;
                upt = new Update();
                upt.set("rulecurseqno", (Object)(seqno + (long)(num - 1)));
                upt.set("ruletypeday", (Object)datestr);
                storage.update(query, upt, globruledet);
            }
            for (int i = 0; i < num; ++i) {
                sb.delete(0, sb.length());
                for (String def : ruledefs) {
                    if ("#SEQ".equalsIgnoreCase(def)) {
                        int len = seqlen - String.valueOf(seqno).length();
                        if (len < 0) {
                            throw new ServiceException("10000", "seqno [{0}] length is max [{1}]", seqno, seqlen);
                        }
                        if (len > 0) {
                            sb.append("00000000000000000000".substring(0, len));
                        }
                        sb.append(seqno);
                        continue;
                    }
                    if ("#DAY".equalsIgnoreCase(def) || "#MON".equalsIgnoreCase(def)) {
                        sb.append(datestr);
                        continue;
                    }
                    if ("#MODULEID".equalsIgnoreCase(def)) {
                        sb.append(moduleid);
                        continue;
                    }
                    sb.append(def);
                }
                billnolist.add(sb.toString());
                ++seqno;
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
        return billnolist;
    }

    protected String getBillNoRuleID(String billmoduleid) {
        return "billno";
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public long doAdd(AbstractEntityBean bean, String id, String ... uniques) throws Exception {
        if (bean instanceof BillAbstractHeadBean) {
            BillAbstractHeadBean bill = (BillAbstractHeadBean)bean;
            if (StringUtils.isEmpty((Object)bill.getBillno()) && !StringUtils.isEmpty((Object)bill.getBillmoduleid())) {
                String ruleid = this.getBillNoRuleID(bill.getBillmoduleid());
                String billno = SpringBeanFactory.getBean("bill.common", BillCommonServiceImpl.class).doApplyBillNo(bill.getEnt_id(), ruleid, bill.getBillmoduleid(), null, null);
                bill.setBillno(billno);
            }
            if (StringUtils.isEmpty((Object)bill.getBillsgno())) {
                bill.setBillsgno(bill.getBillno());
            }
            bill.setInputdate(new Date());
            bill.setLastmodby(bill.getInputer());
            bill.setLastmodby_name(bill.getInputer_name());
        }
        return super.doAdd(bean, id, uniques);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Object doDelete(AbstractEntityBean bean, String id, String ... keys) throws Exception {
        BillAbstractHeadBean bill;
        BillAbstractHeadBean oribill;
        if (bean instanceof BillAbstractHeadBean && !"N".equalsIgnoreCase((oribill = this.checkBillStatus(bill = (BillAbstractHeadBean)bean)).getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5f55\u5165\u72b6\u6001\u7684\u5355\u636e,\u4e0d\u80fd\u5220\u9664!", oribill.getBillno());
        }
        return super.doDelete(bean, id, keys);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Object doUpdate(AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) throws Exception {
        BillAbstractHeadBean bill;
        BillAbstractHeadBean oribill;
        if (bean instanceof BillAbstractHeadBean && !"N".equalsIgnoreCase((oribill = this.checkBillStatus(bill = (BillAbstractHeadBean)bean)).getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5f55\u5165\u72b6\u6001\u7684\u5355\u636e,\u4e0d\u80fd\u4fee\u6539!", oribill.getBillno());
        }
        return super.doUpdate(bean, keys, id, uniques);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    protected BillAbstractHeadBean checkBillStatus(BillAbstractHeadBean bill) throws Exception {
        HashSet<String> keys = new HashSet<String>();
        keys.add("billno");
        super.doUpdate(bill, keys, "billno", new String[0]);
        JSONObject json = new JSONObject();
        json.put("fields", (Object)"*");
        json.put("ent_id", (Object)bill.getEnt_id());
        json.put("billno", (Object)bill.getBillno());
        BillAbstractHeadBean oribill = (BillAbstractHeadBean)this.doSearchOne(json, this.getBeanClass());
        if (oribill == null) {
            throw new ServiceException("10003", "{0} {1} [{2}] does not exist", MessageSourceHelper.getMessage(bill.fetchAnnotationTableName(), bill.getLang(), new Object[0]), "billno", bill.getBillno());
        }
        return oribill;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billaudit(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        boolean force = false;
        if (jsonparam.containsKey((Object)"force")) {
            force = jsonparam.getBoolean("force");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        bean.initUpdateMember(session);
        Object auditdata = this.doBillAudit(bean, session, force);
        JSONObject json = new JSONObject();
        if (!force && auditdata != null) {
            json.put("data", auditdata);
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u5ba1\u6838\u4e0d\u6210\u529f,\u9700\u518d\u6b21\u786e\u8ba4!"));
        } else {
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u5ba1\u6838\u6210\u529f!"));
        }
        return ServiceResponse.buildSuccess(json);
    }

    protected Set<String> beforeBillAudit(BillAbstractHeadBean bill) throws Exception {
        if ("WAITTING".equalsIgnoreCase(bill.getBillsgno())) {
            bill.setBillstatus("W");
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object doBillAudit(BillAbstractHeadBean bill, ServiceSession session, boolean force) throws Exception {
        BillAbstractHeadBean oribill = this.checkBillStatus(bill);
        if ("Y".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u5df2\u5ba1\u6838,\u4e0d\u80fd\u91cd\u590d\u5ba1\u6838!", oribill.getBillno());
        }
        if (!"N".equalsIgnoreCase(oribill.getBillstatus())) {
            if ("W".equalsIgnoreCase(oribill.getBillstatus()) && !"asyncaudit".equalsIgnoreCase(bill.getBillsgno())) {
                throw new ServiceException("10000", "[{0}]\u5355\u636e\u5df2\u5ba1\u6838,\u4e0d\u80fd\u91cd\u590d\u5ba1\u6838!", oribill.getBillno());
            }
            if (!"W".equalsIgnoreCase(oribill.getBillstatus()) || !"asyncaudit".equalsIgnoreCase(bill.getBillsgno())) {
                throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5f85\u5ba1\u6838\u5355\u636e,\u4e0d\u80fd\u5ba1\u6838!", oribill.getBillno());
            }
        }
        bill.setBillmoduleid(oribill.getBillmoduleid());
        bill.setBillstatus(null);
        Set<String> keys = this.beforeBillAudit(bill);
        if (StringUtils.isEmpty((Object)bill.getBillstatus()) || "N".equalsIgnoreCase(bill.getBillstatus())) {
            bill.setBillstatus("Y");
        }
        if (StringUtils.isEmpty((Object)bill.getAuditor()) && session != null) {
            bill.setAuditor(session.getUser_code());
        }
        if (StringUtils.isEmpty((Object)bill.getAuditor_name()) && session != null) {
            bill.setAuditor_name("[" + session.getUser_code() + "]" + session.getUser_name());
        }
        bill.setAuditdate(new Date());
        bill.setLastmodby(bill.getAuditor());
        bill.setLastmodby_name(bill.getAuditor_name());
        if (keys == null) {
            keys = new HashSet<String>();
        }
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        keys.add("auditor");
        keys.add("auditor_name");
        keys.add("auditdate");
        super.doUpdate(bill, keys, "billno", new String[0]);
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billcancel(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        boolean force = false;
        if (jsonparam.containsKey((Object)"force")) {
            force = jsonparam.getBoolean("force");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        bean.initUpdateMember(session);
        Object canceldata = this.doBillCancel(bean, session, force);
        JSONObject json = new JSONObject();
        if (!force && canceldata != null) {
            json.put("data", canceldata);
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u53d6\u6d88\u4e0d\u6210\u529f,\u9700\u518d\u6b21\u786e\u8ba4!"));
        } else {
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u53d6\u6d88\u6210\u529f!"));
        }
        return ServiceResponse.buildSuccess(json);
    }

    protected Set<String> beforeBillCancel(BillAbstractHeadBean bill) throws Exception {
        if ("WAITTING".equalsIgnoreCase(bill.getBillsgno())) {
            bill.setBillstatus("W");
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object doBillCancel(BillAbstractHeadBean bill, ServiceSession session, boolean force) throws Exception {
        BillAbstractHeadBean oribill = this.checkBillStatus(bill);
        if ("C".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u5df2\u53d6\u6d88,\u4e0d\u80fd\u91cd\u590d\u53d6\u6d88!", oribill.getBillno());
        }
        if (!"Y".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5df2\u5ba1\u6838\u5355\u636e,\u4e0d\u80fd\u53d6\u6d88!", oribill.getBillno());
        }
        bill.setBillmoduleid(oribill.getBillmoduleid());
        bill.setBillstatus(null);
        Set<String> keys = this.beforeBillCancel(bill);
        if (StringUtils.isEmpty((Object)bill.getBillstatus()) || "Y".equalsIgnoreCase(bill.getBillstatus())) {
            bill.setBillstatus("C");
        }
        if (StringUtils.isEmpty((Object)bill.getCanceler()) && session != null) {
            bill.setCanceler(session.getUser_code());
        }
        if (StringUtils.isEmpty((Object)bill.getCanceler_name()) && session != null) {
            bill.setCanceler_name("[" + session.getUser_code() + "]" + session.getUser_name());
        }
        bill.setCanceldate(new Date());
        bill.setLastmodby(bill.getCanceler());
        bill.setLastmodby_name(bill.getCanceler_name());
        if (keys == null) {
            keys = new HashSet<String>();
        }
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        keys.add("canceler");
        keys.add("canceler_name");
        keys.add("canceldate");
        super.doUpdate(bill, keys, "billno", new String[0]);
        return null;
    }

    @Override
    protected List<?> doGet(JSONObject jsonparam, Class<?> objClass, StringBuffer total) throws Exception {
        if (!(jsonparam == null || StringUtils.isEmpty((Object)jsonparam.getString("mktid")) && StringUtils.isEmpty((Object)jsonparam.getString("chid")))) {
            JSONObject json;
            Field mktfld = AbstractEntityBean.fetchDeclaredField(objClass, "billmktdetail");
            Field chlfld = AbstractEntityBean.fetchDeclaredField(objClass, "billchanneldetail");
            if (mktfld != null && !StringUtils.isEmpty((Object)jsonparam.get((Object)"mktid"))) {
                Object mktobj = jsonparam.get((Object)"mktid");
                jsonparam.remove((Object)"mktid");
                if (mktobj instanceof JSONObject) {
                    jsonparam.put("billmktdetail:mktid", mktobj);
                } else {
                    json = new JSONObject();
                    json.put("$in", (Object)(mktobj + ",%"));
                    jsonparam.put("billmktdetail:mktid", (Object)json);
                }
            }
            if (chlfld != null && !StringUtils.isEmpty((Object)jsonparam.get((Object)"chid"))) {
                Object chlobj = jsonparam.get((Object)"chid");
                jsonparam.remove((Object)"chid");
                if (chlobj instanceof JSONObject) {
                    jsonparam.put("billchanneldetail:chid", chlobj);
                } else {
                    json = new JSONObject();
                    json.put("$in", (Object)(chlobj + ",%"));
                    jsonparam.put("billchanneldetail:chid", (Object)json);
                }
            }
        }
        return super.doGet(jsonparam, objClass, total);
    }

    public static interface BillStatus {
        public static final String NEW = "N";
        public static final String AUDIT = "Y";
        public static final String CANCEL = "C";
        public static final String WAIT = "W";
        public static final String EXEC = "T";
    }
}

