/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.rest.ServiceMethodReflect;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.Utils;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.springframework.util.StringUtils;

@Path(value="/")
public class ServiceRestReflect {
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;
    private static ServiceMethodReflect rcm = new ServiceMethodReflect();

    @GET
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/")
    public String test(@QueryParam(value="status") String status) {
        String uri = this.request.getRequestURI();
        if (uri.startsWith("/") || uri.startsWith("\\")) {
            uri = uri.substring(1);
        }
        if (uri.endsWith("/") || uri.endsWith("\\")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if ("check".equalsIgnoreCase(status)) {
            return uri + " success";
        }
        ServiceVersion sv = ServiceVersion.getInstance();
        if ("openlog".equalsIgnoreCase(status)) {
            sv.setLogstatus(true);
        }
        if ("closelog".equalsIgnoreCase(status)) {
            sv.setLogstatus(false);
        }
        return uri + " version " + sv.getVer() + " (LogStatus: " + (sv.isLogstatus() ? "Y" : "N") + ")";
    }

    private String addQueryParamToJsonParam(ServiceSession session, String param, String ... ignores) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] openkey = new String[]{"token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature"};
        String[] ss = null;
        if (session != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
            ss = new String[openkey.length + s.length];
            for (i = 0; i < openkey.length; ++i) {
                ss[i] = openkey[i];
            }
            for (i = 0; i < s.length; ++i) {
                ss[openkey.length + i] = s[i];
            }
        } else {
            ss = openkey;
        }
        Enumeration e = this.request.getParameterNames();
        while (e.hasMoreElements()) {
            String[] values;
            String key = (String)e.nextElement();
            if (Utils.stringArrayContainsKey(ignores, key, true) || (values = this.request.getParameterValues(key)) == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            if (ss != null && Utils.stringArrayContainsKey(ss, key, true)) {
                if ("ent_id".equalsIgnoreCase(key)) {
                    session.setEnt_id(Long.parseLong(value));
                }
                if ("user_id".equalsIgnoreCase(key)) {
                    session.setUser_id(Long.parseLong(value));
                }
                if ("user_code".equalsIgnoreCase(key)) {
                    session.setUser_code(value);
                }
                if ("user_name".equalsIgnoreCase(key)) {
                    session.setUser_name(value);
                }
                if ("locale".equalsIgnoreCase(key)) {
                    session.setLocale(value);
                }
                if (!"debug_status".equalsIgnoreCase(key)) continue;
                session.setDebug_status(value);
                continue;
            }
            if (value.startsWith("{") && value.endsWith("}") || value.startsWith("[") && value.endsWith("]")) {
                try {
                    map.put(key, JSON.parse((String)value));
                }
                catch (Exception ex) {
                    map.put(key, value);
                }
                continue;
            }
            map.put(key, value);
        }
        if (map != null && map.size() > 0) {
            JSONObject jsonparam = null;
            if (StringUtils.isEmpty((Object)param)) {
                jsonparam = new JSONObject();
            } else {
                try {
                    jsonparam = JSON.parseObject((String)param);
                }
                catch (Exception ex) {
                    return param;
                }
            }
            for (String key : map.keySet()) {
                if (jsonparam.containsKey((Object)key)) continue;
                jsonparam.put(key, map.get(key));
            }
            param = jsonparam.toJSONString();
        }
        return param;
    }

    private boolean isEffective(String remoteAddr) {
        return null != remoteAddr && !"".equals(remoteAddr.trim()) && !"unknown".equalsIgnoreCase(remoteAddr.trim());
    }

    private String getRemoteAddr() {
        try {
            String remoteAddr = this.request.getHeader("X-Forwarded-For");
            if (this.isEffective(remoteAddr) && remoteAddr.indexOf(",") > -1) {
                String[] array;
                for (String element : array = remoteAddr.split(",")) {
                    if (!this.isEffective(element)) continue;
                    remoteAddr = element;
                    break;
                }
            }
            if (!this.isEffective(remoteAddr)) {
                remoteAddr = this.request.getHeader("X-Real-IP");
            }
            if (!this.isEffective(remoteAddr)) {
                remoteAddr = this.request.getRemoteAddr();
            }
            if (remoteAddr != null && remoteAddr.indexOf(".") > 0) {
                return remoteAddr;
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest")
    public String callRestService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String result = null;
        String remoteaddr = "";
        long logkey = 0L;
        long start_time = System.currentTimeMillis();
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("REQUEST  : ");
                sb.append(postparam);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            if (retdata instanceof ServiceResponse) {
                ServiceResponse response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
            }
            result = retdata == null ? "" : (retdata instanceof String ? (String)retdata : JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata)));
            String string = result;
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return string;
        }
        finally {
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                sb.append("RESPONSE : ");
                sb.append(result);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest")
    public String callRestServiceByGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param) {
        return this.callRestService(method, session, param, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/import")
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"multipart/form-data"})
    public String callImportService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, FormDataMultiPart form) {
        String string;
        ArrayList<FileImportObject> list = new ArrayList<FileImportObject>();
        try {
            Object parts;
            Map mapFormData = form.getFields();
            Set sets = mapFormData.keySet();
            for (String key : sets) {
                parts = (List)mapFormData.get(key);
                for (int i = 0; i < parts.size(); ++i) {
                    FormDataBodyPart part = (FormDataBodyPart)parts.get(i);
                    String filename = part.getContentDisposition().getFileName();
                    System.out.println(key + ":" + filename);
                    if (StringUtils.isEmpty((Object)filename)) continue;
                    FileImportObject fio = new FileImportObject();
                    fio.setFilename(filename);
                    fio.setStream((InputStream)part.getValueAs(InputStream.class));
                    fio.setServletrequest(this.request);
                    list.add(fio);
                }
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethodForListParam(method, sessionobj, param = this.addQueryParamToJsonParam(sessionobj, param, "method", "session", "param"), list);
            if (retdata == null) {
                parts = "";
                return parts;
            }
            if (retdata instanceof String) {
                parts = (String)retdata;
                return parts;
            }
            parts = JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
            return parts;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return string;
        }
        finally {
            for (FileImportObject fio : list) {
                try {
                    InputStream in = fio.getStream();
                    if (in == null) continue;
                    in.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/export")
    public Response callExportService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata), (String)"text/plain;charset=UTF-8").build();
            }
            if (StringUtils.isEmpty((Object)filename)) {
                filename = "export.xls";
            }
            Response.ResponseBuilder builder = Response.ok((Object)retdata);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, filename));
            if (retdata instanceof String) {
                this.response.setCharacterEncoding("UTF-8");
                builder.type("application/ms-excel");
            } else {
                builder.type("application/octet-stream");
            }
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/export")
    public Response callExportServiceByGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        return this.callExportService(method, session, param, null, filename, headers);
    }
}

