/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.WebPathUtils;
import com.google.code.yanf4j.core.impl.StandardSocketOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.exception.MemcachedException;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class CacheUtilsMemcached
extends CacheUtils {
    private MemcachedClientBuilder builder = null;
    private MemcachedClient memcachedClient = null;
    private boolean reBuild = false;
    private String cfgFile = null;
    private int cachetime = -1;
    public Logger logger = Logger.getLogger(CacheUtilsMemcached.class);

    public CacheUtilsMemcached() {
        this(null);
    }

    public CacheUtilsMemcached(String config) {
        this(config, -1);
    }

    public CacheUtilsMemcached(String config, int cachetime) {
        this.cfgFile = config;
        this.cachetime = cachetime;
    }

    @Override
    public String putData(String key, Object object, int timeout) {
        if (this.memcachedClient == null) {
            try {
                this.CreateBuilder();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            if (timeout < 0) {
                timeout = this.cachetime > 0 ? this.cachetime : 0;
            }
            this.memcachedClient.set(key, timeout, object);
            return key;
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            if (this.reBuild) {
                this.logger.warn((Object)"memcached Client ReBuild!!!!!!!!!!!");
                this.builder = null;
                this.memcachedClient = null;
            }
            return null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
        catch (MemcachedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getData(String key) {
        if (this.memcachedClient == null) {
            try {
                this.CreateBuilder();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        Object result = null;
        try {
            result = this.memcachedClient.get(key);
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            if (this.reBuild) {
                this.logger.warn((Object)"memcached Client ReBuild!!!!!!!!!!!");
                this.builder = null;
                this.memcachedClient = null;
            }
            return null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
        catch (MemcachedException e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    @Override
    public boolean deleteData(String key) {
        if (this.memcachedClient == null) {
            try {
                this.CreateBuilder();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            this.memcachedClient.delete(key);
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            if (this.reBuild) {
                this.logger.warn((Object)"memcached Client ReBuild!!!!!!!!!!!");
                this.builder = null;
                this.memcachedClient = null;
            }
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        catch (MemcachedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized MemcachedClient CreateBuilder() throws FileNotFoundException, IOException {
        if (this.memcachedClient != null) {
            return this.memcachedClient;
        }
        String ini = null;
        ini = StringUtils.isEmpty((Object)this.cfgFile) ? WebPathUtils.getWebRootClassPath() + "/memcached.ini" : (this.cfgFile.startsWith("\\") || this.cfgFile.startsWith("/") ? WebPathUtils.getWebRootClassPath() + this.cfgFile : this.cfgFile);
        String serverList = "localhost:11211";
        int iPoolSize = 10;
        int iTimeOut = 5000;
        int iMerge = 150;
        boolean bHeart = true;
        int iRcvBuf = 32;
        int iSndBuf = 16;
        File input = new File(ini);
        this.logger.info((Object)("memcached.ini path:" + ini));
        if (input.exists()) {
            String re;
            String sHeart;
            String sMerge;
            String sTimeOut;
            String sSndBuf;
            String sRcvBuf;
            String sPoolSize;
            FileInputStream is = new FileInputStream(input);
            Properties p = new Properties();
            p.load(is);
            ((InputStream)is).close();
            String sServer = p.getProperty("server");
            if (sServer != null) {
                sServer = sServer.replaceAll(";", " ");
                serverList = sServer.trim();
            }
            if ((sPoolSize = p.getProperty("poolsize")) != null) {
                iPoolSize = Integer.parseInt(sPoolSize);
            }
            if ((sRcvBuf = p.getProperty("rcvbuf")) != null) {
                iRcvBuf = Integer.parseInt(sRcvBuf);
            }
            if ((sSndBuf = p.getProperty("sndbuf")) != null) {
                iSndBuf = Integer.parseInt(sSndBuf);
            }
            if ((sTimeOut = p.getProperty("timeout")) != null) {
                iTimeOut = Integer.parseInt(sTimeOut);
            }
            if ((sMerge = p.getProperty("merge")) != null) {
                iMerge = Integer.parseInt(sMerge);
            }
            if ((sHeart = p.getProperty("heart")) != null) {
                boolean bl = bHeart = sHeart == null || !sHeart.equalsIgnoreCase("false");
            }
            if ((re = p.getProperty("rebuild")) != null) {
                this.reBuild = re != null && re.equalsIgnoreCase("true");
            }
            this.logger.info((Object)("memcached server:" + serverList));
            this.builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)serverList));
            this.builder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
            this.builder.setConnectionPoolSize(iPoolSize);
        } else {
            this.logger.warn((Object)"memcached.ini not exits!");
            this.builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)"localhost:11211"));
            this.builder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
            this.builder.setConnectionPoolSize(2);
            System.out.println("memcached server-\u5730\u5740:localhost:11211");
        }
        this.builder.setSocketOption(StandardSocketOption.SO_RCVBUF, (Object)(iRcvBuf * 1024));
        this.builder.setSocketOption(StandardSocketOption.SO_SNDBUF, (Object)(iSndBuf * 1024));
        this.builder.setSocketOption(StandardSocketOption.TCP_NODELAY, (Object)false);
        this.memcachedClient = this.builder.build();
        this.memcachedClient.setOpTimeout((long)iTimeOut);
        if (iMerge <= 0) {
            this.memcachedClient.setOptimizeMergeBuffer(false);
        }
        if (iMerge > 0) {
            this.memcachedClient.setMergeFactor(iMerge);
        }
        this.memcachedClient.setEnableHeartBeat(bHeart);
        return this.memcachedClient;
    }
}

