/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.exception.ServiceException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    public static JSONArray XLStoJSONArray(InputStream is, String flds, long maxrow) throws Exception {
        JSONArray array = new JSONArray();
        String[] fields = null;
        if (!StringUtils.isEmpty((CharSequence)flds)) {
            fields = flds.split(",");
        }
        HSSFWorkbook hssfWorkbook = new HSSFWorkbook(is);
        for (int numSheet = 0; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
            HSSFRow hssfRow;
            HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
            if (hssfSheet == null) continue;
            if (fields == null && hssfSheet.getLastRowNum() >= 1 && (hssfRow = hssfSheet.getRow(0)) != null) {
                fields = new String[hssfRow.getLastCellNum()];
                for (int i = 0; i < fields.length; ++i) {
                    HSSFCell xh = hssfRow.getCell(i);
                    fields[i] = xh.getStringCellValue();
                }
            }
            for (int rowNum = 1; rowNum < hssfSheet.getLastRowNum() + 1; ++rowNum) {
                HSSFRow hssfRow2 = hssfSheet.getRow(rowNum);
                if (hssfRow2 == null) continue;
                JSONObject json = new JSONObject();
                int celcount = fields != null ? fields.length : (int)hssfRow2.getLastCellNum();
                for (int celNum = 0; celNum < celcount; ++celNum) {
                    String colkey = fields != null ? fields[celNum] : String.valueOf(celNum);
                    HSSFCell xh = hssfRow2.getCell(celNum);
                    if (xh == null) {
                        json.put(colkey, (Object)"");
                        continue;
                    }
                    if (xh.getCellType() == 4) {
                        json.put(colkey, (Object)xh.getBooleanCellValue());
                        continue;
                    }
                    if (xh.getCellType() == 0) {
                        json.put(colkey, (Object)xh.getNumericCellValue());
                        continue;
                    }
                    if (xh.getCellType() == 3) {
                        json.put(colkey, (Object)"");
                        continue;
                    }
                    json.put(colkey, (Object)xh.getStringCellValue());
                }
                array.add((Object)json);
            }
        }
        if (maxrow > 0L && (long)array.size() >= maxrow) {
            throw new ServiceException("10000", "limit rows {0},excel rows {1}", maxrow, array.size());
        }
        return array;
    }

    public static JSONArray XLSXtoJSONArray(InputStream is, String flds, long maxrow) throws Exception {
        JSONArray array = new JSONArray();
        String[] fields = null;
        if (!StringUtils.isEmpty((CharSequence)flds)) {
            fields = flds.split(",");
        }
        XSSFWorkbook hssfWorkbook = new XSSFWorkbook(is);
        for (int numSheet = 0; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
            XSSFRow hssfRow;
            XSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
            if (hssfSheet == null) continue;
            if (fields == null && hssfSheet.getLastRowNum() >= 1 && (hssfRow = hssfSheet.getRow(0)) != null) {
                fields = new String[hssfRow.getLastCellNum()];
                for (int i = 0; i < fields.length; ++i) {
                    XSSFCell xh = hssfRow.getCell(i);
                    fields[i] = xh.getStringCellValue();
                }
            }
            for (int rowNum = 1; rowNum < hssfSheet.getLastRowNum() + 1; ++rowNum) {
                XSSFRow hssfRow2 = hssfSheet.getRow(rowNum);
                if (hssfRow2 == null) continue;
                JSONObject json = new JSONObject();
                int celcount = fields != null ? fields.length : (int)hssfRow2.getLastCellNum();
                for (int celNum = 0; celNum < celcount; ++celNum) {
                    String colkey = fields != null ? fields[celNum] : String.valueOf(celNum);
                    XSSFCell xh = hssfRow2.getCell(celNum);
                    if (xh == null) {
                        json.put(colkey, (Object)"");
                        continue;
                    }
                    if (xh.getCellType() == 4) {
                        json.put(colkey, (Object)xh.getBooleanCellValue());
                        continue;
                    }
                    if (xh.getCellType() == 0) {
                        json.put(colkey, (Object)xh.getNumericCellValue());
                        continue;
                    }
                    if (xh.getCellType() == 3) {
                        json.put(colkey, (Object)"");
                        continue;
                    }
                    json.put(colkey, (Object)xh.getStringCellValue());
                }
                array.add((Object)json);
            }
        }
        if (maxrow > 0L && (long)array.size() >= maxrow) {
            throw new ServiceException("10000", "limit rows {0},excel rows {1}", maxrow, array.size());
        }
        return array;
    }
}

