/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.util.RestClientFactory;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.WebPathUtils;
import com.efuture.omd.storage.FStorageOperations;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

public class RestClientUtils {
    public ObjectPool<Client> pool;
    private String cfgFile;
    private Map<String, Object> clientProperties;
    private Properties cfgProperties;
    public Logger logger = Logger.getLogger(RestClientUtils.class);

    public RestClientUtils() {
        this(null);
    }

    public RestClientUtils(String config) {
        this(0, 0L, config);
    }

    public RestClientUtils(int poolSize, long maxWait, String config) {
        GenericObjectPoolConfig poolcfg = new GenericObjectPoolConfig();
        if (poolSize > 0) {
            poolcfg.setMaxTotal(poolSize);
            poolcfg.setMaxIdle(poolSize);
            poolcfg.setMinIdle(poolSize >= 2 ? poolSize / 2 : poolSize);
        }
        if (maxWait > 0L) {
            poolcfg.setMaxWaitMillis(maxWait);
        }
        this.pool = new GenericObjectPool((PooledObjectFactory)new RestClientFactory(), poolcfg);
        this.cfgFile = config;
        this.initConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfig() {
        if (!StringUtils.isEmpty((Object)this.cfgFile) && this.cfgFile.startsWith("DB:")) {
            FStorageOperations storage = null;
            try {
                Query query;
                List list;
                storage = SpringBeanFactory.getBean("StorageOperation", FStorageOperations.class);
                String[] ss = this.cfgFile.substring(3).split("\\|");
                String table = ss[0].trim();
                Criteria criteria = new Criteria();
                if (ss.length > 1) {
                    ss = ss[1].split(",");
                    for (int i = 0; i < ss.length; ++i) {
                        String[] cond = ss[i].split("=");
                        String key = cond[0].trim();
                        String val = cond[1].trim();
                        criteria = criteria.and(key).is((Object)val);
                    }
                }
                if ((list = storage.select(query = new Query(criteria), table)) != null && list.size() > 0) {
                    this.cfgProperties = new Properties();
                    for (Map map : list) {
                        this.cfgProperties.setProperty((String)map.get("key"), (String)map.get("val"));
                    }
                }
            }
            finally {
                if (storage != null) {
                    storage.destroy();
                }
            }
            return;
        }
        String ini = null;
        ini = StringUtils.isEmpty((Object)this.cfgFile) ? WebPathUtils.getWebRootClassPath() + "/restservice.ini" : (this.cfgFile.startsWith("\\") || this.cfgFile.startsWith("/") ? WebPathUtils.getWebRootClassPath() + this.cfgFile : this.cfgFile);
        try {
            this.logger.info((Object)("restservice.ini path:" + ini));
            File input = new File(ini);
            if (input.exists()) {
                FileInputStream is = new FileInputStream(input);
                this.cfgProperties = new Properties();
                this.cfgProperties.load(is);
                ((InputStream)is).close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Map<String, Object> getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(Map<String, Object> clientProp) {
        this.clientProperties = clientProp;
    }

    public String queryServiceURI(String method) {
        if (this.cfgProperties == null) {
            return null;
        }
        String servicePath = "";
        String curservice = method;
        while (!StringUtils.isEmpty((Object)curservice)) {
            int n;
            Enumeration<?> names;
            String url = this.cfgProperties.getProperty(curservice);
            if (url != null && !url.equals("")) {
                servicePath = url;
                break;
            }
            if (curservice.equals("*")) break;
            boolean matches = false;
            if (!curservice.endsWith(".*") && (names = this.cfgProperties.propertyNames()) != null) {
                do {
                    String name;
                    if ((name = (String)names.nextElement()).endsWith(".*") || name.indexOf("*") <= 0) continue;
                    String prefix = name.substring(0, name.indexOf("*"));
                    String suffix = name.substring(name.indexOf("*") + 1);
                    if (StringUtils.isEmpty((Object)prefix) || !curservice.startsWith(prefix) || StringUtils.isEmpty((Object)suffix) || !curservice.endsWith(suffix)) continue;
                    matches = true;
                    servicePath = this.cfgProperties.getProperty(name);
                    break;
                } while (names.hasMoreElements());
            }
            if (matches) break;
            if (curservice.endsWith(".*")) {
                curservice = curservice.substring(0, curservice.lastIndexOf("."));
            }
            if ((n = curservice.lastIndexOf(".")) > 0) {
                curservice = curservice.substring(0, n) + ".*";
                continue;
            }
            curservice = "*";
        }
        return servicePath;
    }

    public Object sendRequest(Object session, String method, Object param, requestCallback callback) throws Exception {
        return this.sendRequest(session, method, param, callback, null);
    }

    private void initClientProperties(Client client) {
        if (this.clientProperties == null) {
            return;
        }
        for (String key : this.clientProperties.keySet()) {
            if ("followRedirects".equalsIgnoreCase(key)) {
                client.setFollowRedirects(Boolean.valueOf("true".equalsIgnoreCase(this.clientProperties.get(key).toString())));
                continue;
            }
            if ("readTimeout".equalsIgnoreCase(key)) {
                client.setReadTimeout(Integer.valueOf(Integer.parseInt(this.clientProperties.get(key).toString())));
                continue;
            }
            if ("connectTimeout".equalsIgnoreCase(key)) {
                client.setConnectTimeout(Integer.valueOf(Integer.parseInt(this.clientProperties.get(key).toString())));
                continue;
            }
            if (!"chunkedEncodingSize".equalsIgnoreCase(key)) continue;
            client.setChunkedEncodingSize(Integer.valueOf(Integer.parseInt(this.clientProperties.get(key).toString())));
        }
    }

    /*
     * Loose catch block
     */
    public Object sendRequest(Object session, String method, Object param, requestCallback callback, String traceprex) throws Exception {
        Object object;
        long borro_time;
        long start_time;
        String url;
        Client client;
        block29: {
            client = null;
            url = null;
            start_time = 0L;
            borro_time = 0L;
            if (method.toLowerCase().startsWith("http")) {
                url = method;
            } else {
                url = this.queryServiceURI(method);
                if (StringUtils.isEmpty((Object)url)) {
                    throw new Exception("can't find method service url");
                }
            }
            ServiceSession ss = null;
            if (session != null && session instanceof ServiceSession) {
                ss = (ServiceSession)session;
            }
            if (session != null && session instanceof Long) {
                ss = new ServiceSession();
                ss.setEnt_id((Long)session);
            }
            if (url.indexOf("{ent_id}") > 0 && ss != null) {
                url = url.replace("{ent_id}", String.valueOf(ss.getEnt_id()));
            }
            if (url.indexOf("{user_id}") > 0 && ss != null) {
                url = url.replace("{user_id}", String.valueOf(ss.getUser_id()));
            }
            if (url.indexOf("{user_code}") > 0 && ss != null) {
                url = url.replace("{user_code}", ss.getUser_code());
            }
            if (url.indexOf("{user_name}") > 0 && ss != null) {
                url = url.replace("{user_name}", ss.getUser_name());
            }
            if (url.indexOf("{locale}") > 0 && ss != null) {
                url = url.replace("{locale}", ss.getLocale());
            }
            if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
                start_time = System.currentTimeMillis();
            }
            client = (Client)this.pool.borrowObject();
            this.initClientProperties(client);
            if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
                borro_time = System.currentTimeMillis();
            }
            object = callback.onSend(url, client, param);
            if (client == null) break block29;
            try {
                this.pool.returnObject((Object)client);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
            StringBuffer sb = new StringBuffer();
            sb.append("[" + traceprex + "]: ");
            sb.append(method + " , ");
            sb.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
            sb.append("BORROWS: " + (borro_time - start_time) + " ms , ");
            sb.append("REQUEST: " + param);
            this.logger.info((Object)sb.toString());
        }
        return object;
        catch (Exception ex) {
            block30: {
                Object object2;
                block31: {
                    try {
                        Throwable e = ex;
                        if (ex instanceof ClientHandlerException) {
                            e = ex.getCause();
                        }
                        if (e == null || !(e instanceof SocketException) || !"Connection reset".equalsIgnoreCase(e.getMessage())) break block30;
                        StringBuffer sb = new StringBuffer();
                        sb.append("[" + ex.getMessage() + "]: ");
                        sb.append(method + " , ");
                        sb.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
                        sb.append("BORROWS: " + (borro_time - start_time) + " ms , ");
                        this.logger.info((Object)sb.toString());
                        if (client != null) {
                            this.pool.invalidateObject((Object)client);
                        }
                        client = (Client)this.pool.borrowObject();
                        this.initClientProperties(client);
                        object2 = callback.onSend(url, client, param);
                        if (client == null) break block31;
                    }
                    catch (Throwable throwable) {
                        if (client != null) {
                            try {
                                this.pool.returnObject(client);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
                            StringBuffer sb2 = new StringBuffer();
                            sb2.append("[" + traceprex + "]: ");
                            sb2.append(method + " , ");
                            sb2.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
                            sb2.append("BORROWS: " + (borro_time - start_time) + " ms , ");
                            sb2.append("REQUEST: " + param);
                            this.logger.info((Object)sb2.toString());
                        }
                        throw throwable;
                    }
                    try {
                        this.pool.returnObject((Object)client);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ServiceVersion.getInstance().isLogstatus() && !StringUtils.isEmpty((Object)traceprex)) {
                    StringBuffer sb3 = new StringBuffer();
                    sb3.append("[" + traceprex + "]: ");
                    sb3.append(method + " , ");
                    sb3.append("ELAPSED: " + (System.currentTimeMillis() - start_time) + " ms , ");
                    sb3.append("BORROWS: " + (borro_time - start_time) + " ms , ");
                    sb3.append("REQUEST: " + param);
                    this.logger.info((Object)sb3.toString());
                }
                return object2;
            }
            throw ex;
        }
    }

    public ServiceResponse sendRequest(Object session, String method, Object param) throws Exception {
        return this.sendRequest(session, method, param, "");
    }

    public ServiceResponse sendRequest(Object session, String method, Object param, String traceprex) throws Exception {
        Object result = RestClientUtils.getRestUtils().sendRequest(session, method, param, new requestCallback(){

            @Override
            public Object onSend(String url, Client client, Object param) {
                WebResource webResource = client.resource(url);
                MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
                return webResource.queryParams((MultivaluedMap)queryParams).post(String.class, param);
            }
        }, traceprex);
        ServiceResponse response = null;
        if (result != null) {
            JSONObject json = JSON.parseObject((String)((String)result));
            response = (ServiceResponse)JSON.toJavaObject((JSON)json, ServiceResponse.class);
        }
        if (response == null) {
            throw new RuntimeException((String)result);
        }
        if (!"0".equals(response.getReturncode())) {
            throw new RuntimeException((String)response.getData());
        }
        return response;
    }

    public static RestClientUtils getRestUtils() {
        return SpringBeanFactory.getBean("RestUtils", RestClientUtils.class);
    }

    public static interface requestCallback {
        public Object onSend(String var1, Client var2, Object var3) throws Exception;
    }
}

