/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.data.annotation.Transient;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

public class StorageUtils {
    public static Update createUpdateFormJSON(JSONObject json) throws IllegalArgumentException, IllegalAccessException {
        Update upt = new Update();
        Set keys = json.keySet();
        for (String key : keys) {
            upt.set(key, json.get((Object)key));
        }
        return upt;
    }

    public static Update createUpdateFormBean(Object bean, Set<String> keys) throws IllegalArgumentException, IllegalAccessException {
        Update upt = new Update();
        for (String key : keys) {
            Field fld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), key);
            if (fld == null || fld.getAnnotation(Transient.class) != null) continue;
            upt.set(key, fld.get(bean));
        }
        return upt;
    }

    public static Query createQueryFormJson(JSONObject json, Class<?> cl) {
        return StorageUtils.createQueryFormJson(json, cl, true);
    }

    public static Query createQueryFormJson(JSONObject json, Class<?> cl, boolean mustpage) {
        if (cl != null) {
            StorageUtils.convertBeanJSON(json, cl);
        }
        ArrayList<Criteria> criteria = new ArrayList<Criteria>();
        Set keys = json.keySet();
        for (String key : keys) {
            if (StorageUtils.isSpecialParamKey(key)) continue;
            Object o = json.get((Object)key);
            if ("$and".equalsIgnoreCase(key) || "$or".equalsIgnoreCase(key)) {
                ArrayList<Criteria> clst = new ArrayList<Criteria>();
                if (o instanceof JSONObject) {
                    JSONObject jo = (JSONObject)o;
                    Set ks = jo.keySet();
                    for (String k : ks) {
                        Criteria c = StorageUtils.buildCriteria(k, jo.get((Object)k), cl);
                        if (c == null) continue;
                        clst.add(c);
                    }
                } else if (o instanceof JSONArray) {
                    JSONArray ja = (JSONArray)o;
                    for (int i = 0; i < ja.size(); ++i) {
                        Object oo = ja.get(i);
                        if (!(oo instanceof JSONObject)) continue;
                        JSONObject jo = (JSONObject)oo;
                        Set ks = jo.keySet();
                        for (String k : ks) {
                            Criteria c = StorageUtils.buildCriteria(k, jo.get((Object)k), cl);
                            if (c == null) continue;
                            clst.add(c);
                        }
                    }
                }
                if (clst.size() <= 0) continue;
                Criteria[] c = new Criteria[clst.size()];
                if ("$and".equalsIgnoreCase(key)) {
                    criteria.add(new Criteria().andOperator(clst.toArray(c)));
                    continue;
                }
                criteria.add(new Criteria().orOperator(clst.toArray(c)));
                continue;
            }
            Criteria c = StorageUtils.buildCriteria(key, o, cl);
            if (c == null) continue;
            criteria.add(c);
        }
        Query quy = new Query();
        if (criteria.size() > 0) {
            Criteria c = (Criteria)criteria.get(0);
            if (criteria.size() > 1) {
                Criteria[] cc = new Criteria[criteria.size() - 1];
                for (int i = 1; i < criteria.size(); ++i) {
                    cc[i - 1] = (Criteria)criteria.get(i);
                }
                c.andOperator(cc);
            }
            quy.addCriteria(c);
        }
        return StorageUtils.buildQueryFormJson(quy, json, mustpage, AbstractEntityBean.fetchSelectField(cl, new HashMap<String, String>()));
    }

    public static Criteria buildCriteria(String key, Object o, Class<?> cl) {
        if (StringUtils.isEmpty((Object)o)) {
            Criteria c = new Criteria().orOperator(new Criteria[]{Criteria.where((String)key).exists(false), Criteria.where((String)key).is((Object)"")});
            return c;
        }
        if (o instanceof String && !StringUtils.isEmpty((Object)o)) {
            if (StorageUtils.isExactMatchKey(key)) {
                if (((String)o).indexOf(",") > 0) {
                    String[] ss = ((String)o).split(",");
                    return Criteria.where((String)key).in((Object[])ss);
                }
                return Criteria.where((String)key).is(o);
            }
            return Criteria.where((String)key).regex(String.valueOf(o));
        }
        if (o instanceof JSONArray) {
            JSONArray ja = (JSONArray)o;
            Object[] oos = new Object[ja.size()];
            for (int i = 0; i < ja.size(); ++i) {
                Object oo = ja.get(i);
                if (cl != null) {
                    oo = StorageUtils.convertBeanField(oo, cl, key);
                }
                oos[i] = oo;
            }
            return Criteria.where((String)key).in(oos);
        }
        if (o instanceof JSONObject) {
            ArrayList<Criteria> criteria = new ArrayList<Criteria>();
            Set sets = ((JSONObject)o).keySet();
            for (String s : sets) {
                Object oo = ((JSONObject)o).get((Object)s);
                if ("$in".equalsIgnoreCase(s) || "in".equalsIgnoreCase(s) || "$nin".equalsIgnoreCase(s) || "notin".equalsIgnoreCase(s)) {
                    Object[] oos = null;
                    if (oo instanceof JSONArray) {
                        JSONArray ja = (JSONArray)oo;
                        oos = new Object[ja.size()];
                        for (int i = 0; i < ja.size(); ++i) {
                            Object obj = ja.get(i);
                            if (cl != null) {
                                obj = StorageUtils.convertBeanField(obj, cl, key);
                            }
                            oos[i] = obj;
                        }
                    } else {
                        String ss = oo.toString();
                        oos = ss.startsWith("(") && ss.endsWith(")") ? new String[]{ss} : ss.split(",");
                    }
                    if ("$in".equalsIgnoreCase(s) || "in".equalsIgnoreCase(s)) {
                        criteria.add(Criteria.where((String)key).in(oos));
                        continue;
                    }
                    criteria.add(Criteria.where((String)key).nin(oos));
                    continue;
                }
                if (cl != null) {
                    oo = StorageUtils.convertBeanField(oo, cl, key);
                }
                if ("$is".equalsIgnoreCase(s) || "==".equalsIgnoreCase(s) || "=".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).is(oo));
                    continue;
                }
                if ("$ne".equalsIgnoreCase(s) || "<>".equalsIgnoreCase(s) || "!=".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).ne(oo));
                    continue;
                }
                if ("like".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).regex(String.valueOf(oo)));
                    continue;
                }
                if ("$gt".equalsIgnoreCase(s) || ">".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).gt(oo));
                    continue;
                }
                if ("$gte".equalsIgnoreCase(s) || ">=".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).gte(oo));
                    continue;
                }
                if ("$lt".equalsIgnoreCase(s) || "<".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).lt(oo));
                    continue;
                }
                if (!"$lte".equalsIgnoreCase(s) && !"<=".equalsIgnoreCase(s)) continue;
                criteria.add(Criteria.where((String)key).lte(oo));
            }
            if (criteria.size() > 0) {
                Criteria[] c = new Criteria[criteria.size()];
                return new Criteria().andOperator(criteria.toArray(c));
            }
        } else {
            return Criteria.where((String)key).is(o);
        }
        return null;
    }

    public static Query buildQueryFormJson(Query quy, JSONObject json, boolean mustpage, Map<String, String> validflds) {
        org.springframework.data.mongodb.core.query.Field flds;
        if (!StringUtils.isEmpty((Object)json.get((Object)"fields"))) {
            flds = quy.fields();
            String[] ss = json.getString("fields").split(",");
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i] == null || StringUtils.isEmpty((Object)ss[i].trim())) continue;
                if (validflds != null && validflds.size() > 0) {
                    if ("*".equals(ss[i].trim())) {
                        for (String key : validflds.keySet()) {
                            flds.include(validflds.get(key));
                        }
                        continue;
                    }
                    if (!validflds.containsKey(ss[i].trim())) continue;
                    flds.include(validflds.get(ss[i].trim()));
                    continue;
                }
                flds.include(ss[i].trim());
            }
        } else if (validflds != null && validflds.size() > 0) {
            flds = quy.fields();
            for (String key : validflds.keySet()) {
                flds.include(validflds.get(key));
            }
        }
        int pageno = -1;
        int pagesize = 40;
        Sort order = null;
        if (mustpage) {
            pageno = 1;
        }
        if (json.containsKey((Object)"page_no") && !StringUtils.isEmpty((Object)json.get((Object)"page_no")) && (pageno = json.getInteger("page_no").intValue()) <= 0) {
            pageno = 1;
        }
        if (json.containsKey((Object)"page_size") && !StringUtils.isEmpty((Object)json.get((Object)"page_size"))) {
            pagesize = json.getInteger("page_size");
            if (pagesize <= 0) {
                pagesize = 40;
            }
            if (pagesize > 9999) {
                pagesize = 9999;
            }
        }
        if (json.containsKey((Object)"order_field") && !StringUtils.isEmpty((Object)json.get((Object)"order_field"))) {
            if (json.containsKey((Object)"order_direction") && !StringUtils.isEmpty((Object)json.get((Object)"order_direction"))) {
                String[] dirs = json.getString("order_direction").split(",");
                String[] flds2 = json.getString("order_field").split(",");
                ArrayList<Sort.Order> lst = new ArrayList<Sort.Order>();
                for (int i = 0; i < flds2.length; ++i) {
                    if (i < dirs.length) {
                        lst.add(new Sort.Order(Sort.Direction.fromString((String)dirs[i]), flds2[i].trim()));
                        continue;
                    }
                    lst.add(new Sort.Order(flds2[i].trim()));
                }
                order = new Sort(lst);
            } else {
                order = new Sort(json.getString("order_field").split(","));
            }
        }
        if (pageno >= 1) {
            quy.with((Pageable)new PageRequest(pageno - 1, pagesize, order));
        } else if (order != null) {
            quy.with(order);
        }
        return quy;
    }

    private static boolean isExactMatchKey(String key) {
        return !key.endsWith("name");
    }

    private static boolean isSpecialParamKey(String key) {
        if (key.equalsIgnoreCase("fields")) {
            return true;
        }
        if (key.equalsIgnoreCase("page_no")) {
            return true;
        }
        if (key.equalsIgnoreCase("page_size")) {
            return true;
        }
        if (key.equalsIgnoreCase("order_field")) {
            return true;
        }
        if (key.equalsIgnoreCase("order_direction")) {
            return true;
        }
        return key.indexOf(":") > 0;
    }

    public static String parseChildParamKeyFields(String param, String key) {
        int startp = param.indexOf(key + ":");
        if (startp < 0) {
            return null;
        }
        String s = null;
        int endp = param.indexOf(",", startp += (key + ":").length());
        s = endp > 0 ? param.substring(startp, endp) : param.substring(startp);
        return s.replace("|", ",");
    }

    public static Map<String, Object> parseChildParamKey(JSONObject json, String key) {
        HashMap<String, Object> map = null;
        Set sets = json.keySet();
        for (String param : sets) {
            int startp;
            if (!param.startsWith(key + ":")) continue;
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            if ((startp = param.indexOf(key + ":")) < 0) {
                return null;
            }
            String s = null;
            int endp = param.indexOf(",", startp += (key + ":").length());
            s = endp > 0 ? param.substring(startp, endp) : param.substring(startp);
            map.put(s, json.get((Object)param));
        }
        return map;
    }

    public static JSONArray convertBeanJSON(JSONArray jsonarray, Class<?> cl) {
        for (int i = 0; i < jsonarray.size(); ++i) {
            Object value = jsonarray.get(i);
            if (!(value instanceof JSONObject)) continue;
            jsonarray.set(i, (Object)StorageUtils.convertBeanJSON((JSONObject)value, cl));
        }
        return jsonarray;
    }

    public static <T> T parseBeanObject(String text, Class<T> clazz) {
        JSONObject json = JSON.parseObject((String)text);
        return StorageUtils.parseBeanObject(json, clazz);
    }

    public static <T> T parseBeanObject(JSONObject json, Class<T> clazz) {
        json = StorageUtils.convertBeanJSON(json, clazz);
        return (T)JSON.toJavaObject((JSON)json, clazz);
    }

    public static <T> T toJavaObject(Object obj, Class<T> entityClass) {
        return (T)TypeUtils.cast((Object)obj, entityClass, (ParserConfig)ParserConfig.getGlobalInstance());
    }

    private static JSONObject convertBeanJSON(JSONObject jsonparam, Class<?> cl) {
        try {
            Set keys = jsonparam.keySet();
            for (String key : keys) {
                Object oo;
                Object o;
                if (StorageUtils.isSpecialParamKey(key) || (o = jsonparam.get((Object)key)).equals(oo = StorageUtils.convertBeanField(o, cl, key))) continue;
                jsonparam.put(key, oo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonparam;
    }

    private static Object convertBeanField(Object obj, Class<?> cl, String key) {
        String type2;
        Field fld = AbstractEntityBean.fetchDeclaredField(cl, key);
        if (fld == null) {
            return obj;
        }
        if (!StorageUtils.isSimpleType(obj)) {
            return obj;
        }
        Object o = obj;
        String type1 = o.getClass().getName().toLowerCase();
        if (type1.lastIndexOf(".") > 0) {
            type1 = type1.substring(type1.lastIndexOf(".") + 1);
        }
        if ((type2 = fld.getType().getName().toLowerCase()).lastIndexOf(".") > 0) {
            type2 = type2.substring(type2.lastIndexOf(".") + 1);
        }
        if (!type1.startsWith(type2)) {
            try {
                if (type2.contains("long")) {
                    o = StringUtils.isEmpty((Object)o) ? 0L : Long.parseLong(o.toString());
                } else if (type2.contains("int")) {
                    o = StringUtils.isEmpty((Object)o) ? 0 : Integer.parseInt(o.toString());
                } else if (type2.contains("float")) {
                    o = Float.valueOf(StringUtils.isEmpty((Object)o) ? 0.0f : Float.parseFloat(o.toString()));
                } else if (type2.contains("double")) {
                    o = StringUtils.isEmpty((Object)o) ? 0.0 : Double.parseDouble(o.toString());
                } else if (type2.contains("short")) {
                    o = StringUtils.isEmpty((Object)o) ? (short)0 : Short.parseShort(o.toString());
                } else if (type2.contains("boolean")) {
                    if (!(o instanceof Boolean)) {
                        o = StringUtils.isEmpty((Object)o) ? Boolean.valueOf(false) : Boolean.valueOf("true".equalsIgnoreCase(o.toString()) || "Y".equalsIgnoreCase(o.toString()));
                    }
                } else if (type2.contains("date")) {
                    if (StringUtils.isEmpty((Object)o)) {
                        o = null;
                    } else {
                        String s = o.toString();
                        if (s.indexOf("-") > 0 || s.indexOf("/") > 0) {
                            if (s.endsWith("Z")) {
                                s = s.replace("T", " ").replace("Z", "");
                            }
                            s = s.replace("/", "-");
                            SimpleDateFormat format = null;
                            format = s.length() <= 10 ? new SimpleDateFormat("yyyy-MM-dd") : (s.length() <= 19 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
                            o = format.parse(s);
                        } else {
                            o = new Date(Long.parseLong(s));
                        }
                    }
                } else if (type2.contains("string")) {
                    o = String.valueOf(o);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return o;
    }

    private static boolean isSimpleType(Object o) {
        if (o instanceof JSONObject) {
            return false;
        }
        return !(o instanceof JSONArray);
    }
}

