/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;

public class WebPathUtils {
    public static File getClassFile(Class<?> clazz) {
        URL path = clazz.getResource(clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1) + ".classs");
        if (path == null) {
            String name = clazz.getName().replaceAll("[.]", "/");
            path = clazz.getResource("/" + name + ".class");
        }
        return new File(path.getFile());
    }

    public static String getClassFilePath(Class<?> clazz) {
        try {
            return URLDecoder.decode(WebPathUtils.getClassFile(clazz).getAbsolutePath(), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static File getClassPathFile(Class<?> clazz) {
        File file = WebPathUtils.getClassFile(clazz);
        int count = clazz.getName().split("[.]").length;
        for (int i = 0; i < count; ++i) {
            file = file.getParentFile();
        }
        if (file.getName().toUpperCase().endsWith(".JAR!")) {
            file = file.getParentFile();
        }
        return file;
    }

    public static String getClassPath(Class<?> clazz) {
        try {
            return URLDecoder.decode(WebPathUtils.getClassPathFile(clazz).getAbsolutePath(), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getWebRootClassPath() {
        return WebPathUtils.getWebRootPath() + "/WEB-INF/classes";
    }

    public static String getWebRootPath() {
        String result = WebPathUtils.class.getResource("WebPathUtils.class").toString();
        int index = result.indexOf("WEB-INF");
        if (index == -1) {
            index = result.indexOf("bin");
        }
        if (index == -1) {
            return System.getProperty("user.dir");
        }
        if ((result = result.substring(0, index)).startsWith("jar")) {
            result = result.substring(10);
        } else if (result.startsWith("wsjar:")) {
            result = result.substring(12);
        } else if (result.startsWith("\\vfszip:\\")) {
            result = result.substring(9);
        } else if (result.startsWith("file")) {
            result = result.substring(6);
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        if (!result.startsWith("/") && !result.startsWith("\\")) {
            result = "/" + result;
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(WebPathUtils.getClassFilePath(WebPathUtils.class));
        System.out.println(WebPathUtils.getClassPath(WebPathUtils.class));
        System.out.println(WebPathUtils.getWebRootPath());
    }
}

