/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.rpc.netcom;

import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.rpc.codec.RpcRequest;
import com.xxl.job.core.rpc.codec.RpcResponse;
import com.xxl.job.core.rpc.netcom.jetty.server.JettyServer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.reflect.FastClass;
import org.springframework.cglib.reflect.FastMethod;

public class NetComServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(NetComServerFactory.class);
    JettyServer server = new JettyServer();
    private static Map<String, Object> serviceMap = new HashMap<String, Object>();
    private static String accessToken;

    public void start(int port, String preferredNetwork, String ip, String appName, String jobName) throws Exception {
        this.server.start(port, preferredNetwork, ip, appName, jobName);
    }

    public void destroy() {
        this.server.destroy();
    }

    public static void putService(Class<?> iface, Object serviceBean) {
        serviceMap.put(iface.getName(), serviceBean);
    }

    public static void setAccessToken(String accessToken) {
        NetComServerFactory.accessToken = accessToken;
    }

    public static RpcResponse invokeService(RpcRequest request, Object serviceBean) {
        if (serviceBean == null) {
            serviceBean = serviceMap.get(request.getClassName());
        }
        if (serviceBean == null) {
            // empty if block
        }
        RpcResponse response = new RpcResponse();
        if (System.currentTimeMillis() - request.getCreateMillisTime() > 180000L) {
            response.setResult(new ReturnT(500, "The timestamp difference between admin and executor exceeds the limit."));
            return response;
        }
        if (accessToken != null && accessToken.trim().length() > 0 && !accessToken.trim().equals(request.getAccessToken())) {
            response.setResult(new ReturnT(500, "The access token[" + request.getAccessToken() + "] is wrong."));
            return response;
        }
        try {
            Class<?> serviceClass = serviceBean.getClass();
            String methodName = request.getMethodName();
            Class[] parameterTypes = request.getParameterTypes();
            Object[] parameters = request.getParameters();
            FastClass serviceFastClass = FastClass.create(serviceClass);
            FastMethod serviceFastMethod = serviceFastClass.getMethod(methodName, parameterTypes);
            Object result = serviceFastMethod.invoke(serviceBean, parameters);
            response.setResult(result);
        }
        catch (Throwable t) {
            t.printStackTrace();
            response.setError(t.getMessage());
        }
        return response;
    }
}

