/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class IpUtil {
    private static final Logger logger = LoggerFactory.getLogger(IpUtil.class);
    private static final String ANYHOST = "0.0.0.0";
    private static final String LOCALHOST = "127.0.0.1";
    public static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static volatile InetAddress LOCAL_ADDRESS = null;

    private static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && !LOCALHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    private static InetAddress getFirstValidAddress(String preferredNetwork) {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (IpUtil.isValidAddress(localAddress)) {
                String localAddrStr = localAddress.toString();
                if (StringUtils.isEmpty((Object)preferredNetwork)) {
                    return localAddress;
                }
                if (localAddrStr.startsWith(preferredNetwork)) {
                    return localAddress;
                }
            }
        }
        catch (Throwable e) {
            logger.error("Failed to retriving ip address, " + e.getMessage(), e);
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    try {
                        NetworkInterface network = interfaces.nextElement();
                        Enumeration<InetAddress> addresses = network.getInetAddresses();
                        if (addresses == null) continue;
                        while (addresses.hasMoreElements()) {
                            try {
                                InetAddress address = addresses.nextElement();
                                if (!IpUtil.isValidAddress(address)) continue;
                                String networkAddrStr = address.toString();
                                if (StringUtils.isEmpty((Object)preferredNetwork)) {
                                    return address;
                                }
                                if (!networkAddrStr.startsWith(preferredNetwork)) continue;
                                return address;
                            }
                            catch (Throwable e) {
                                logger.error("Failed to retriving ip address, " + e.getMessage(), e);
                            }
                        }
                    }
                    catch (Throwable e) {
                        logger.error("Failed to retriving ip address, " + e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.error("Failed to retriving ip address, " + e.getMessage(), e);
        }
        logger.error("Could not get local host ip address, will use 127.0.0.1 instead.");
        return localAddress;
    }

    private static InetAddress getAddress(String preferredNetwork) {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = IpUtil.getFirstValidAddress(preferredNetwork);
        return localAddress;
    }

    public static String getIp(String preferredNetwork) {
        InetAddress address = IpUtil.getAddress(preferredNetwork);
        if (address == null) {
            return null;
        }
        return address.getHostAddress();
    }

    public static String getIpPort(String preferredNetwork, int port) {
        String ip = IpUtil.getIp(preferredNetwork);
        if (ip == null) {
            return null;
        }
        return ip.concat(":").concat(String.valueOf(port));
    }

    public static void main(String[] args) throws UnknownHostException {
        System.out.println(IpUtil.getIp(null));
        System.out.println(IpUtil.getIpPort(null, 8080));
        System.out.println(IpUtil.getIp("172.17"));
        System.out.println(IpUtil.getIpPort("172.17", 8080));
    }
}

