/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.product.component.JDBCCompomentServiceImpl;
import com.product.model.AbstractEntityBean;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.SpringContext;
import com.product.util.TypeUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.StringUtils;

public class MasterSlaveComponentServiceImpl<X> {
    public String[] slaveServiceNames;
    final Class<X> masterClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), MasterSlaveComponentServiceImpl.class);

    public String[] getSlaveServiceNames() {
        return this.slaveServiceNames;
    }

    public MasterSlaveComponentServiceImpl(String[] slaveServiceNames) {
        this.slaveServiceNames = slaveServiceNames;
    }

    public ServiceResponse query(ServiceSession session, JSONObject jsonparam) throws Exception {
        Class masterBean = GenericTypeResolver.resolveTypeArgument(this.masterClass, JDBCCompomentServiceImpl.class);
        Method masterQueryMethod = this.masterClass.getMethod("onQuery", ServiceSession.class, JSONObject.class);
        Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
        Object data = masterQueryMethod.invoke(masterServiceObj, session, jsonparam);
        return (ServiceResponse)data;
    }

    public ServiceResponse view(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject respdata = new JSONObject();
        respdata.put(this.getCollectionName(this.masterClass), this.viewWithBean(session, jsonparam));
        return ServiceResponse.buildSuccess((Object)respdata);
    }

    public <T> T viewWithBean(ServiceSession session, JSONObject jsonparam) throws Exception {
        Class masterBean = GenericTypeResolver.resolveTypeArgument(this.masterClass, JDBCCompomentServiceImpl.class);
        Method masterQueryMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class);
        Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
        Object data = masterQueryMethod.invoke(masterServiceObj, session, jsonparam);
        if (!StringUtils.isEmpty((Object)data)) {
            String[] masterSlaveFields = this.getMasterSlaveFields(masterBean);
            Map<String, Class<?>> flds = this.getSlaveBean(masterBean);
            for (String slaveService : this.slaveServiceNames) {
                Class<?> slaveClass = this.getServiceBean(slaveService);
                String slaveCollectionName = this.getCollectionName(slaveClass);
                Class<?> clazz = flds.get(slaveCollectionName);
                if (StringUtils.isEmpty(clazz)) continue;
                String[] masterSlaveFields_slave = this.getMasterSlaveFields(clazz);
                JSONObject slaveparam = new JSONObject();
                for (int i = 0; i < masterSlaveFields_slave.length; ++i) {
                    String field = masterSlaveFields_slave[i];
                    slaveparam.put(field, MasterSlaveComponentServiceImpl.getFieldValue(masterBean, data, masterSlaveFields[i]));
                }
                Method slaveQueryMethod = slaveClass.getMethod("dataQuery", ServiceSession.class, JSONObject.class);
                Object slaveServiceObj = SpringContext.getBean(slaveClass, (Object[])new Object[0]);
                Object list = slaveQueryMethod.invoke(slaveServiceObj, session, slaveparam);
                MasterSlaveComponentServiceImpl.setFieldValue(masterBean, data, slaveCollectionName, list);
            }
        }
        return (T)TypeUtils.castToJavaBean((Object)data, (Class)masterBean);
    }

    public ServiceResponse delete(ServiceSession session, JSONObject jsonparam) throws Exception {
        Class masterBean = GenericTypeResolver.resolveTypeArgument(this.masterClass, JDBCCompomentServiceImpl.class);
        Method masterViewMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class);
        Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
        Object data = masterViewMethod.invoke(masterServiceObj, session, jsonparam);
        try {
            String[] masterSlaveFields = this.getMasterSlaveFields(masterBean);
            Map<String, Class<?>> flds = this.getSlaveBean(masterBean);
            for (String slaveService : this.slaveServiceNames) {
                Class<?> slaveClass = this.getServiceBean(slaveService);
                String slaveCollectionName = this.getCollectionName(slaveClass);
                Class<?> clazz = flds.get(slaveCollectionName);
                if (StringUtils.isEmpty(clazz)) continue;
                String[] masterSlaveFields_slave = this.getMasterSlaveFields(clazz);
                JSONObject slaveparam = new JSONObject();
                for (int i = 0; i < masterSlaveFields_slave.length; ++i) {
                    String field = masterSlaveFields_slave[i];
                    slaveparam.put(field, MasterSlaveComponentServiceImpl.getFieldValue(masterBean, data, masterSlaveFields[i]));
                }
                Method slaveDeleteMethod = slaveClass.getMethod("onDelete", ServiceSession.class, JSONObject.class);
                Object slaveServiceObj = SpringContext.getBean(slaveClass, (Object[])new Object[0]);
                slaveDeleteMethod.invoke(slaveServiceObj, session, slaveparam);
            }
        }
        catch (Exception masterSlaveFields) {
            // empty catch block
        }
        Method masterDeleteMethod = this.masterClass.getMethod("onDelete", ServiceSession.class, JSONObject.class);
        Object object = masterDeleteMethod.invoke(masterServiceObj, session, jsonparam);
        return (ServiceResponse)object;
    }

    public ServiceResponse insert(ServiceSession session, JSONObject jsonparam) throws Exception {
        Class masterBean = GenericTypeResolver.resolveTypeArgument(this.masterClass, JDBCCompomentServiceImpl.class);
        Method masterSaveMethod = this.masterClass.getMethod("onInsert", ServiceSession.class, JSONObject.class);
        Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
        Object data = masterSaveMethod.invoke(masterServiceObj, session, jsonparam);
        String masterCollectionName = this.getCollectionName(this.masterClass);
        Method masterViewMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class);
        Object masterData = masterViewMethod.invoke(masterServiceObj, session, jsonparam);
        String[] masterSlaveFields = this.getMasterSlaveFields(masterBean);
        Map<String, Class<?>> flds = this.getSlaveBean(masterBean);
        for (String slaveService : this.slaveServiceNames) {
            Class<?> slaveClass = this.getServiceBean(slaveService);
            String slaveCollectionName = this.getCollectionName(slaveClass);
            Class<?> clazz = flds.get(slaveCollectionName);
            if (StringUtils.isEmpty(clazz)) continue;
            String[] masterSlaveFields_slave = this.getMasterSlaveFields(clazz);
            Object slave = null;
            slave = jsonparam.containsKey((Object)masterCollectionName) ? jsonparam.getJSONObject(masterCollectionName).get((Object)slaveCollectionName) : jsonparam.get((Object)slaveCollectionName);
            Method slaveSaveMethod = slaveClass.getMethod("onInsert", ServiceSession.class, JSONObject.class);
            Object slaveServiceObj = SpringContext.getBean(slaveClass, (Object[])new Object[0]);
            if (slave == null || !(slave instanceof List)) continue;
            JSONArray paramsArray = (JSONArray)slave;
            for (int i = 0; i < paramsArray.size(); ++i) {
                JSONObject params = paramsArray.getJSONObject(i);
                for (int j = 0; j < masterSlaveFields_slave.length; ++j) {
                    String field = masterSlaveFields_slave[j];
                    if (params.containsKey((Object)field) || !StringUtils.isEmpty((Object)params.get((Object)field))) continue;
                    params.put(field, MasterSlaveComponentServiceImpl.getFieldValue(masterBean, masterData, masterSlaveFields[j]));
                }
            }
            JSONObject slaveparam = new JSONObject();
            slaveparam.put(slaveCollectionName, slave);
            slaveSaveMethod.invoke(slaveServiceObj, session, slaveparam);
        }
        return (ServiceResponse)data;
    }

    public ServiceResponse save(ServiceSession session, JSONObject jsonparam) throws Exception {
        Class masterBean = GenericTypeResolver.resolveTypeArgument(this.masterClass, JDBCCompomentServiceImpl.class);
        Method masterSaveMethod = this.masterClass.getMethod("onSave", ServiceSession.class, JSONObject.class);
        Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
        Object data = masterSaveMethod.invoke(masterServiceObj, session, jsonparam);
        String masterCollectionName = this.getCollectionName(this.masterClass);
        Method masterViewMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class);
        Object masterData = masterViewMethod.invoke(masterServiceObj, session, jsonparam);
        String[] masterSlaveFields = this.getMasterSlaveFields(masterBean);
        Map<String, Class<?>> flds = this.getSlaveBean(masterBean);
        for (String slaveService : this.slaveServiceNames) {
            Class<?> slaveClass = this.getServiceBean(slaveService);
            String slaveCollectionName = this.getCollectionName(slaveClass);
            Class<?> clazz = flds.get(slaveCollectionName);
            if (StringUtils.isEmpty(clazz)) continue;
            String[] masterSlaveFields_slave = this.getMasterSlaveFields(clazz);
            Object slave = null;
            slave = jsonparam.containsKey((Object)masterCollectionName) ? jsonparam.getJSONObject(masterCollectionName).get((Object)slaveCollectionName) : jsonparam.get((Object)slaveCollectionName);
            Method slaveSaveMethod = slaveClass.getMethod("onSave", ServiceSession.class, JSONObject.class);
            Object slaveServiceObj = SpringContext.getBean(slaveClass, (Object[])new Object[0]);
            if (slave == null || !(slave instanceof List)) continue;
            JSONArray paramsArray = (JSONArray)slave;
            for (int i = 0; i < paramsArray.size(); ++i) {
                JSONObject params = paramsArray.getJSONObject(i);
                for (int j = 0; j < masterSlaveFields_slave.length; ++j) {
                    String field = masterSlaveFields_slave[j];
                    if (params.containsKey((Object)field) || !StringUtils.isEmpty((Object)params.get((Object)field))) continue;
                    params.put(field, MasterSlaveComponentServiceImpl.getFieldValue(masterBean, masterData, masterSlaveFields[j]));
                }
            }
            JSONObject slaveparam = new JSONObject();
            slaveparam.put(slaveCollectionName, slave);
            slaveSaveMethod.invoke(slaveServiceObj, session, slaveparam);
        }
        return (ServiceResponse)data;
    }

    protected Map<String, Class<?>> getSlaveBean(Class<?> masterClazz) throws Exception {
        HashMap map = new HashMap();
        Field[] fields = masterClazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String[] slavekey;
            ParameterizedType parameterizedType;
            Field fld;
            Field field = fields[i];
            Type type = field.getGenericType();
            if (!(type instanceof ParameterizedType) || (fld = this.getMasterSlaveField((Class)(type = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()[0]))) == null || StringUtils.isEmpty((Object)(slavekey = (String[])fld.get(null)))) continue;
            map.put(field.getName(), (Class)type);
        }
        return map;
    }

    protected Field getMasterSlaveField(Class<?> cl) {
        return AbstractEntityBean.fetchDeclaredField(cl, (String)"MASTER_SLAVE_KEY");
    }

    protected String[] getMasterSlaveFields(Class<?> cl) throws Exception {
        Field fld = this.getMasterSlaveField(cl);
        return (String[])fld.get(null);
    }

    public Class<?> getServiceBean(String serviceName) throws Exception {
        Class<?> c = Class.forName(this.masterClass.getPackage().getName() + "." + serviceName);
        return c;
    }

    public String getCollectionName(Class<?> Clazz) throws Exception {
        Method method = Clazz.getMethod("getCollectionName", new Class[0]);
        Object obj = SpringContext.getBean(Clazz, (Object[])new Object[0]);
        String collectionName = (String)method.invoke(obj, new Object[0]);
        return collectionName;
    }

    public static Object getFieldValue(Class clazz, Object bean, String col) throws Exception {
        PropertyDescriptor pd = new PropertyDescriptor(col, clazz);
        Method getMethod = pd.getReadMethod();
        Object o1 = getMethod.invoke(bean, new Object[0]);
        return o1;
    }

    public static void setFieldValue(Class clazz, Object bean, String col, Object object) throws Exception {
        PropertyDescriptor pd = new PropertyDescriptor(col, clazz);
        Method getMethod = pd.getWriteMethod();
        getMethod.invoke(bean, object);
    }
}

