/*
 * Decompiled with CFR 0.152.
 */
package com.product.config;

import com.product.rest.interceptor.CustomClientHttpRequestInterceptor;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(name={"service.deploy.mode"}, havingValue="tomcat")
@AutoConfigureAfter(value={RestTemplate.class})
public class RestConfig {
    @Autowired
    ConfigurableEnvironment environment;
    @Autowired
    RestTemplate restTemplate;

    @Bean
    public void addRestInterceptor() {
        List interceptors = this.restTemplate.getInterceptors();
        if (interceptors == null) {
            this.restTemplate.getInterceptors().add(new CustomClientHttpRequestInterceptor(this.environment));
        }
        interceptors.add(new CustomClientHttpRequestInterceptor(this.environment));
    }
}

