/*
 * Decompiled with CFR 0.152.
 */
package com.product.config.redis;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.StringUtils;

public class RedisLockHelper {
    private static final String DELIMITER = "|";
    private static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newScheduledThreadPool(10);
    private final StringRedisTemplate stringRedisTemplate;

    public boolean lock(String lockKey, String uuid, long timeout, TimeUnit unit) {
        long milliseconds = Expiration.from((long)timeout, (TimeUnit)unit).getExpirationTimeInMilliseconds();
        boolean success = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)(System.currentTimeMillis() + milliseconds + DELIMITER + uuid));
        if (success) {
            this.stringRedisTemplate.expire((Object)lockKey, timeout, unit);
        } else {
            String oldVal = (String)this.stringRedisTemplate.opsForValue().get((Object)lockKey);
            String[] oldValues = oldVal.split(Pattern.quote(DELIMITER));
            if (Long.parseLong(oldValues[0]) + unit.toSeconds(1L) <= System.currentTimeMillis()) {
                this.stringRedisTemplate.opsForValue().set((Object)lockKey, (Object)(System.currentTimeMillis() + milliseconds + DELIMITER + uuid));
                this.stringRedisTemplate.expire((Object)lockKey, timeout, unit);
                return true;
            }
        }
        return success;
    }

    public void unlock(String lockKey, String value) {
        this.unlock(lockKey, value, 0L, TimeUnit.MILLISECONDS);
    }

    private void unlock(String lockKey, String uuid, long delayTime, TimeUnit unit) {
        if (StringUtils.isEmpty((Object)lockKey)) {
            return;
        }
        if (delayTime <= 0L) {
            this.doUnlock(lockKey, uuid);
        } else {
            EXECUTOR_SERVICE.schedule(() -> this.doUnlock(lockKey, uuid), delayTime, unit);
        }
    }

    private void doUnlock(String lockKey, String uuid) {
        String val = (String)this.stringRedisTemplate.opsForValue().get((Object)lockKey);
        String[] values = val.split(Pattern.quote(DELIMITER));
        if (values.length <= 0) {
            return;
        }
        if (uuid.equals(values[1])) {
            this.stringRedisTemplate.delete((Object)lockKey);
        }
    }

    public RedisLockHelper(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

