/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.filter;

import com.alibaba.fastjson.JSONObject;
import com.product.model.ServiceSession;
import com.product.storage.filter.FtSqlSource;
import com.product.storage.filter.service.AnalyzeRequestHandler;
import com.product.util.SpringContext;
import com.shiji.core.util.ExtensionLoader;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class DataRangeExecutorWrapper
implements Interceptor {
    @Autowired
    private ExtensionLoader loader;
    private static Logger sqlLog = LoggerFactory.getLogger(DataRangeExecutorWrapper.class);
    private String dbType;

    public Object intercept(Invocation invocation) throws Throwable {
        if (SpringContext.getActiveProfile().equals("local") || SpringContext.getActiveProfile().equals("test")) {
            return invocation.proceed();
        }
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        if (invocation.getArgs()[1] instanceof Map) {
            Map parameter = (Map)invocation.getArgs()[1];
            if (parameter.get("servicesession") != null) {
                ServiceSession serviceSession = (ServiceSession)parameter.get("servicesession");
                BoundSql boundSql = mappedStatement.getBoundSql((Object)parameter);
                String sql = boundSql.getSql();
                try {
                    sqlLog.info("parse start ==>" + System.currentTimeMillis());
                    String newSql = this.onSQLAnalyzeRequest(sql, serviceSession);
                    sqlLog.info("parse end ==>" + System.currentTimeMillis());
                    FtSqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql.toString(), boundSql);
                    MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, sqlSource);
                    invocation.getArgs()[0] = newMs;
                }
                catch (Exception e) {
                    invocation.getArgs()[0] = mappedStatement;
                    sqlLog.error("unresovled sql:" + sql);
                    sqlLog.error(e.getMessage(), e.getCause());
                }
            } else {
                sqlLog.error("not standard sql" + mappedStatement.getBoundSql(invocation.getArgs()[1]));
            }
        } else {
            sqlLog.error("not standard sql" + mappedStatement.getBoundSql(invocation.getArgs()[1]));
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.dbType = properties.getProperty("dbType");
        if (this.dbType == null || this.dbType.equals("")) {
            this.dbType = "mysql";
        }
    }

    public String onSQLAnalyzeRequest(String statementSQL, ServiceSession serviceSession) {
        JSONObject paramsObject = new JSONObject();
        AnalyzeRequestHandler arHandler = (AnalyzeRequestHandler)this.loader.with(AnalyzeRequestHandler.class).queryFirst((Map)paramsObject, true);
        return arHandler.onAnalyzeRequest(statementSQL, serviceSession);
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        builder.keyProperty(ms.getKeyProperties() == null ? null : ms.getKeyProperties()[0]);
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }
}

