/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.filter.component;

import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.efuture.redis.BaseJedisConnectionFactory;
import com.product.component.AuthorityBaseServiceImpl;
import com.product.model.ServiceSession;
import com.product.storage.filter.component.MySQLAnalyzeHandler;
import com.product.storage.filter.service.AnalyzeRequestHandler;
import com.product.util.SpringBeanFactory;
import com.product.util.SpringContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class DefaultAnalyzeRequestHandler
extends MySQLAnalyzeHandler
implements AnalyzeRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultAnalyzeRequestHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> getDataRangeTable(ServiceSession serviceSession, String tableName) {
        log.info("datarange start ==>" + System.currentTimeMillis());
        HashMap<String, List<String>> columnMap = new HashMap<String, List<String>>();
        try (Jedis jedis = ((BaseJedisConnectionFactory)SpringContext.getBean((String)"jedisConnectionFactory", BaseJedisConnectionFactory.class)).getJedis();){
            Set tidSets = jedis.zrange("datarangetableref", 0L, -1L);
            if (tidSets != null && tidSets.size() > 0) {
                Pipeline pipeline = jedis.pipelined();
                ArrayList<Response> list = new ArrayList<Response>();
                for (String rid : tidSets) {
                    list.add(pipeline.hmget("datarangetableref:" + rid, new String[]{"tableName", "type", "columnName"}));
                }
                pipeline.sync();
                for (Response resp : list) {
                    List tableList = (List)resp.get();
                    if (!((String)tableList.get(0)).toLowerCase().equals(tableName.toLowerCase().replaceAll("`", ""))) continue;
                    List<Object> valList = new ArrayList();
                    String type = (String)tableList.get(1);
                    if (type.equals("1")) {
                        valList = this.getDataRangeShop(serviceSession);
                    } else if (type.equals("2")) {
                        valList = this.getDataRangeOrg(serviceSession);
                    } else if (type.equals("3")) {
                        valList = this.getDataRangeCategory(serviceSession);
                    } else if (type.equals("4")) {
                        valList = this.getDataRangeBusiCompany(serviceSession);
                    } else if (type.equals("5")) {
                        valList = this.getDataRangeShopcode(serviceSession);
                    }
                    if (valList.size() <= 0) continue;
                    columnMap.put((String)tableList.get(2), (List<String>)valList);
                }
            }
        }
        log.info("datarange end ==>" + System.currentTimeMillis());
        return columnMap;
    }

    private List<String> getDataRangeCategory(ServiceSession serviceSession) {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = (AuthorityBaseServiceImpl)SpringBeanFactory.getBean("authorityBaseServiceImpl");
        return authorityBaseServiceImpl.getDataRangeCategory(serviceSession);
    }

    private List<String> getDataRangeShop(ServiceSession serviceSession) {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = (AuthorityBaseServiceImpl)SpringBeanFactory.getBean("authorityBaseServiceImpl");
        return authorityBaseServiceImpl.getDataRangeShop(serviceSession);
    }

    private List<String> getDataRangeShopcode(ServiceSession serviceSession) {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = (AuthorityBaseServiceImpl)SpringBeanFactory.getBean("authorityBaseServiceImpl");
        return authorityBaseServiceImpl.getDataRangeShopCode(serviceSession);
    }

    private List<String> getDataRangeOrg(ServiceSession serviceSession) {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = (AuthorityBaseServiceImpl)SpringBeanFactory.getBean("authorityBaseServiceImpl");
        return authorityBaseServiceImpl.getDataRangeOrg(serviceSession);
    }

    private List<String> getDataRangeBusiCompany(ServiceSession serviceSession) {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = (AuthorityBaseServiceImpl)SpringBeanFactory.getBean("authorityBaseServiceImpl");
        return authorityBaseServiceImpl.getDataRangeBusiCompany(serviceSession);
    }

    @Override
    public String onAnalyzeRequest(String statementSQL, final ServiceSession serviceSession) {
        log.info("\u89e3\u6790\u5f00\u59cb:sql=" + statementSQL);
        try {
            MySqlStatementParser parser = new MySqlStatementParser(statementSQL);
            SQLStatement statement = parser.parseStatement();
            StringBuffer buffer = new StringBuffer();
            MySqlOutputVisitor myVisitor = new MySqlOutputVisitor(buffer){

                public boolean visit(SQLExprTableSource x) {
                    String tableName = x.toString();
                    log.info("\u89e3\u6790\u51fa\u8868:table=" + tableName);
                    if (!StringUtils.isEmpty((Object)tableName)) {
                        Map rowPolicy = DefaultAnalyzeRequestHandler.this.getDataRangeTable(serviceSession, tableName);
                        SQLObject tableParent = x.getParent();
                        if (tableParent instanceof MySqlSelectQueryBlock) {
                            DefaultAnalyzeRequestHandler.this.onQueryBlockPolicy((SQLSelectQueryBlock)((MySqlSelectQueryBlock)tableParent), tableName, x.getAlias(), rowPolicy);
                        } else if (tableParent instanceof SQLJoinTableSource) {
                            DefaultAnalyzeRequestHandler.this.onMySQLJoinTablePolicy((SQLJoinTableSource)tableParent, tableName, x.getAlias(), rowPolicy);
                        }
                    }
                    return super.visit(x);
                }

                public boolean visit(MySqlSelectQueryBlock x) {
                    x.getFrom().setParent((SQLObject)x);
                    return super.visit(x);
                }

                public void endVisit(MySqlSelectQueryBlock x) {
                    log.info("===>\u89e3\u6790\u5b8c\u6210");
                }
            };
            statement.accept((SQLASTVisitor)myVisitor);
            log.info("\u89e3\u6790\u5b8c\u6210 newsql=" + buffer);
            return buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(String.format("\u89e3\u6790\u5f02\u5e38:%1$s\r\n", e.getMessage() + ""));
            return statementSQL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String onAnalyzeRequest(String statementSQL, final Map<String, Map<String, List<String>>> dataPolicy) {
        final StringBuffer buflogger = new StringBuffer();
        buflogger.append(String.format("\u89e3\u6790SQL:%1$s\r\n", statementSQL));
        try {
            MySqlStatementParser parser = new MySqlStatementParser(statementSQL);
            SQLStatement statement = parser.parseStatement();
            StringBuffer buffer = new StringBuffer();
            MySqlOutputVisitor myVisitor = new MySqlOutputVisitor(buffer){

                public boolean visit(SQLExprTableSource x) {
                    String tableName = x.toString();
                    buflogger.append(String.format("\u89e3\u6790\u51fa\u8868:%1$s\r\n", tableName));
                    if (!StringUtils.isEmpty((Object)tableName) && dataPolicy.containsKey(tableName.toLowerCase())) {
                        Map rowPolicy = (Map)dataPolicy.get(tableName.toLowerCase());
                        SQLObject tableParent = x.getParent();
                        if (tableParent instanceof MySqlSelectQueryBlock) {
                            DefaultAnalyzeRequestHandler.this.onQueryBlockPolicy((SQLSelectQueryBlock)((MySqlSelectQueryBlock)tableParent), tableName, x.getAlias(), rowPolicy);
                        } else if (tableParent instanceof SQLJoinTableSource) {
                            DefaultAnalyzeRequestHandler.this.onMySQLJoinTablePolicy((SQLJoinTableSource)tableParent, tableName, x.getAlias(), rowPolicy);
                        }
                    }
                    return super.visit(x);
                }

                public boolean visit(MySqlSelectQueryBlock x) {
                    x.getFrom().setParent((SQLObject)x);
                    return super.visit(x);
                }

                public void endVisit(MySqlSelectQueryBlock x) {
                    log.info("===>\u89e3\u6790\u5b8c\u6210");
                }
            };
            statement.accept((SQLASTVisitor)myVisitor);
            String string = buffer.toString();
            return string;
        }
        catch (Exception e) {
            buflogger.append(String.format("\u89e3\u6790\u5f02\u5e38:%1$s\r\n", e.getMessage() + ""));
            System.out.println(e.getCause() + "");
            e.printStackTrace();
            String string = statementSQL;
            return string;
        }
        finally {
            System.out.println("\u6267\u884c\u89e3\u6790:" + buflogger.toString());
        }
    }
}

