/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.template;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.parser.ParserConfig;
import com.product.model.ServiceSession;
import com.product.storage.mybatis.ReflectUtil;
import com.product.storage.mybatis.SqlDbSession;
import com.product.storage.parser.QueryExtractor;
import com.product.storage.parser.QueryInsertExtractor;
import com.product.storage.parser.QueryRemoveExtractor;
import com.product.storage.parser.QuerySelectExtractor;
import com.product.storage.parser.QueryUpdateExtractor;
import com.product.storage.strategy.MySqlSessionTemplate;
import com.product.storage.strategy.SqlSessionTemplate;
import com.product.storage.template.FStorageLogger;
import com.product.storage.template.FStorageOperations;
import com.product.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class FMybatisTemplate
implements FStorageOperations {
    private MySqlSessionTemplate sqlTemplate;
    private ExecutorType executorType;
    private final int lostAffect = -2147482646;
    private QueryExtractor.DBTYPE dbType = QueryExtractor.DBTYPE.MYSQL;
    private String chartset = null;
    private final String SQL_SELECT = "mybatis.sql.select";
    private final String SQL_INSERT = "mybatis.sql.insert";
    private final String SQL_UPDATE = "mybatis.sql.update";
    private final String SQL_DELETE = "mybatis.sql.delete";
    private FStorageLogger logger = new FStorageLogger();

    public void setSqlTemplate(MySqlSessionTemplate sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    public static String getMyCatTag(int mycatState) {
        if (mycatState == 1) {
            return "/*#mycat:db_type=master*/";
        }
        if (mycatState == 2) {
            return "/*#mycat:db_type=slave*/";
        }
        return "";
    }

    public FMybatisTemplate(SqlSessionFactory sqlSessionFactory) {
        this(sqlSessionFactory, sqlSessionFactory.getConfiguration().getDefaultExecutorType(), null);
    }

    public FMybatisTemplate(SqlSessionFactory sqlSessionFactory, String characterSet) {
        this(sqlSessionFactory, sqlSessionFactory.getConfiguration().getDefaultExecutorType());
    }

    public FMybatisTemplate(SqlSessionFactory sqlSessionFactory, ExecutorType executorType) {
        this(sqlSessionFactory, executorType, null);
    }

    public FMybatisTemplate(SqlSessionFactory sqlSessionFactory, ExecutorType executorType, String characterSet) {
        this.executorType = executorType;
        this.sqlTemplate = new MySqlSessionTemplate(sqlSessionFactory, ExecutorType.SIMPLE);
        this.dbType = this.getDBType();
        this.chartset = characterSet;
    }

    public void onSetContext(ServiceSession session) {
        this.sqlTemplate.onSetContext(session);
    }

    public SqlSessionTemplate getSqlSessionTemplate() {
        return this.sqlTemplate;
    }

    public SqlDbSession getSqlDbSession() {
        SqlDbSession dbSession = new SqlDbSession(this.sqlTemplate, this.executorType);
        return dbSession;
    }

    public static String makeFullSqlStatement(String nameSpace, String sqlId) {
        if (org.springframework.util.StringUtils.isEmpty((Object)sqlId)) {
            return nameSpace;
        }
        return nameSpace + "." + sqlId;
    }

    @Override
    public void destroy() {
    }

    @Override
    public <T> T selectOne(Query query, Class<T> entityClass, int mycatState) {
        return this.selectOne(query, entityClass, this.fetchAnnotationTableName(entityClass), mycatState);
    }

    @Override
    public <T> T selectOne(Query query, Class<T> entityClass, String tableName, int mycatState) {
        QuerySelectExtractor extractor = new QuerySelectExtractor(tableName, query, FMybatisTemplate.getMyCatTag(mycatState));
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        return this.toJavaObject(this.sqlTemplate.selectOne("mybatis.sql.select", this.convertChartsetSQL(sql)), entityClass);
    }

    @Override
    public Map<String, Object> selectOne(Query query, String tableName, int mycatState) {
        QuerySelectExtractor extractor = new QuerySelectExtractor(tableName, query, FMybatisTemplate.getMyCatTag(mycatState));
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        return (Map)this.sqlTemplate.selectOne("mybatis.sql.select", this.convertChartsetSQL(sql));
    }

    public <T> List<T> select(Query query, Class<T> entityClass, int mycatState) {
        return this.select(query, entityClass, this.fetchAnnotationTableName(entityClass), mycatState);
    }

    public <T> List<T> select(Query query, Class<T> entityClass, String tableName, int mycatState) {
        QuerySelectExtractor extractor = new QuerySelectExtractor(tableName, query, FMybatisTemplate.getMyCatTag(mycatState));
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        if (query != null && (query.getLimit() > 0 || query.getSkip() > 0L) && this.dbType != QueryExtractor.DBTYPE.MYSQL) {
            long offset = query.getSkip() > 0L ? query.getSkip() : 0L;
            int limit = query.getLimit() > 0 ? query.getLimit() : Integer.MAX_VALUE;
            RowBounds rowBounds = new RowBounds(Math.toIntExact(offset), limit);
            return this.toJavaObjectList(this.sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(sql), rowBounds), entityClass);
        }
        return this.toJavaObjectList(this.sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(sql)), entityClass);
    }

    public List<Map<String, Object>> select(Query query, String tableName, int mycatState) {
        QuerySelectExtractor extractor = new QuerySelectExtractor(tableName, query, FMybatisTemplate.getMyCatTag(mycatState));
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        if (query != null && (query.getLimit() > 0 || query.getSkip() > 0L) && this.dbType != QueryExtractor.DBTYPE.MYSQL) {
            long offset = query.getSkip() > 0L ? query.getSkip() : 0L;
            int limit = query.getLimit() > 0 ? query.getLimit() : Integer.MAX_VALUE;
            RowBounds rowBounds = new RowBounds(Math.toIntExact(offset), limit);
            return this.sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(sql), rowBounds);
        }
        return this.sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(sql));
    }

    @Override
    public long count(Query query, Class<?> entityClass, int mycatState) {
        return this.count(query, this.fetchAnnotationTableName(entityClass), mycatState);
    }

    @Override
    public long count(Query query, String tableName, int mycatState) {
        int oldlimit = 0;
        long oldskip = 0L;
        if (query != null) {
            oldlimit = query.getLimit();
            oldskip = query.getSkip();
            query.limit(0);
            query.skip(0L);
        }
        QuerySelectExtractor extractor = new QuerySelectExtractor(tableName, query, FMybatisTemplate.getMyCatTag(mycatState));
        String sql = extractor.getQueryForSQL(this.dbType);
        sql = String.format("%1$s%2$s", FMybatisTemplate.getMyCatTag(mycatState), "select count(1) as total from " + StringUtils.substringAfter((String)sql, (String)"FROM"));
        this.logger.logSQLQuery(sql);
        if (oldlimit > 0) {
            query.limit(oldlimit);
        }
        if (oldskip > 0L) {
            query.skip(oldskip);
        }
        List results = this.sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(sql));
        Map map = (Map)results.get(0);
        long total = TypeUtils.castToLong(map.get("total"));
        return total;
    }

    @Override
    public void insert(Object objectToSave, int mycatState) {
        this.insert(objectToSave, this.fetchAnnotationTableName(objectToSave.getClass()), mycatState);
    }

    @Override
    public int insert(Object objectToSave, String tableName, int mycatState) {
        QueryInsertExtractor extractor = new QueryInsertExtractor(tableName, this.toDbObject(objectToSave), FMybatisTemplate.getMyCatTag(mycatState));
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        return this.sqlTemplate.insert("mybatis.sql.insert", this.convertChartsetSQL(sql));
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, Class<?> entityClass, int mycatState) {
        for (Object object : batchToSave) {
            this.insert(object, mycatState);
        }
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, String tableName, int mycatState) {
        for (Object object : batchToSave) {
            this.insert(object, tableName, mycatState);
        }
    }

    @Override
    public void insertAll(Collection<? extends Object> objectsToSave, int mycatState) {
        for (Object object : objectsToSave) {
            this.insert(object, mycatState);
        }
    }

    @Override
    public int updateOrInsert(Query query, Update update, Class<?> entityClass, int mycatState) {
        return this.updateOrInsert(query, update, entityClass, this.fetchAnnotationTableName(entityClass), mycatState);
    }

    @Override
    public int updateOrInsert(Query query, Update update, String tableName, int mycatState) {
        return this.updateOrInsert(query, update, null, tableName, mycatState);
    }

    @Override
    public int updateOrInsert(Query query, Update update, Class<?> entityClass, String tableName, int mycatState) {
        int n = this.update(query, update, tableName, mycatState);
        if (n <= 0) {
            this.insert(update, tableName, mycatState);
        }
        return n;
    }

    @Override
    public int update(Query query, Update update, Class<?> entityClass, int mycatState) {
        return this.update(query, update, entityClass, this.fetchAnnotationTableName(entityClass), mycatState);
    }

    @Override
    public int update(Query query, Update update, String tableName, int mycatState) {
        return this.update(query, update, null, tableName, mycatState);
    }

    @Override
    public int update(Query query, Update update, Class<?> entityClass, String tableName, int mycatState) {
        QueryUpdateExtractor extractor = new QueryUpdateExtractor(tableName, query, update, FMybatisTemplate.getMyCatTag(mycatState));
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        int n = this.sqlTemplate.update("mybatis.sql.update", this.convertChartsetSQL(sql));
        if (n == -2147482646) {
            return 1;
        }
        return n;
    }

    @Override
    public int delete(Object object, int mycatState) {
        return this.delete(object, this.fetchAnnotationTableName(object.getClass()), mycatState);
    }

    @Override
    public int delete(Object object, String tableName, int mycatState) {
        Criteria criteria = null;
        Field fld = this.fetchDeclaredField(object.getClass(), "ID_KEY");
        if (fld != null) {
            try {
                String idkey = fld.get(null).toString();
                fld = this.fetchDeclaredField(object.getClass(), idkey);
                if (fld != null) {
                    criteria = Criteria.where((String)idkey).is(fld.get(object));
                }
            }
            catch (Exception idkey) {
                // empty catch block
            }
        }
        if (criteria == null) {
            criteria = new Criteria();
            org.bson.Document dbDoc = this.toDbObject(object);
            Set keys = dbDoc.keySet();
            for (String key : keys) {
                Object obj = dbDoc.get((Object)key);
                if (org.springframework.util.StringUtils.isEmpty((Object)obj)) continue;
                criteria = criteria.and(key).is(obj);
            }
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return this.delete(query, tableName, mycatState);
    }

    @Override
    public int delete(Query query, Class<?> entityClass, int mycatState) {
        return this.delete(query, entityClass, this.fetchAnnotationTableName(entityClass), mycatState);
    }

    @Override
    public int delete(Query query, Class<?> entityClass, String tableName, int mycatState) {
        return this.delete(query, tableName, mycatState);
    }

    @Override
    public int delete(Query query, String tableName, int mycatState) {
        QueryRemoveExtractor extractor = new QueryRemoveExtractor(tableName, query, FMybatisTemplate.getMyCatTag(mycatState));
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        int n = this.sqlTemplate.delete("mybatis.sql.delete", this.convertChartsetSQL(sql));
        if (n == -2147482646) {
            return 1;
        }
        return n;
    }

    private String fetchAnnotationTableName(Class<?> cl) {
        Annotation[] annos;
        for (Annotation ann : annos = cl.getAnnotations()) {
            if (!(ann instanceof Document)) continue;
            return ((Document)ann).collection();
        }
        String name = cl.getName();
        return (name = name.substring(name.lastIndexOf(".") + 1).toLowerCase()).endsWith("bean") ? name.substring(0, name.length() - 4) : name;
    }

    private Field fetchDeclaredField(Class<?> classDefine, String fieldName) {
        Field field;
        block2: {
            field = null;
            try {
                field = classDefine.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                if (classDefine.getSuperclass() == null) break block2;
                return this.fetchDeclaredField(classDefine.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    private StringBuffer fetchAllDeclaredField(Class<?> classDefine, StringBuffer sb) {
        Field[] flds;
        for (Field fld : flds = classDefine.getDeclaredFields()) {
            Annotation[] annos;
            if (Modifier.isStatic(fld.getModifiers())) continue;
            String fldname = fld.getName();
            boolean istransient = false;
            for (Annotation ann : annos = fld.getAnnotations()) {
                if (ann instanceof Transient) {
                    istransient = true;
                    break;
                }
                if (!(ann instanceof org.springframework.data.mongodb.core.mapping.Field)) continue;
                fldname = ((org.springframework.data.mongodb.core.mapping.Field)ann).value();
            }
            if (istransient) continue;
            sb.append(fldname + ",");
        }
        if (classDefine.getSuperclass() != null) {
            this.fetchAllDeclaredField(classDefine.getSuperclass(), sb);
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    private <T> org.bson.Document toDbObject(T objectToSave) {
        if (!(objectToSave instanceof String)) {
            org.bson.Document dbDoc = new org.bson.Document();
            if (objectToSave instanceof Map) {
                Map map = (Map)objectToSave;
                Set keys = map.keySet();
                for (String key : keys) {
                    dbDoc.put(key, map.get(key));
                }
            } else {
                String[] flds;
                if (objectToSave instanceof Update) {
                    Update update = (Update)objectToSave;
                    for (String str : update.getUpdateObject().keySet()) {
                        Object value = update.getUpdateObject().get((Object)str);
                        Map map = (Map)value;
                        Set keys = map.keySet();
                        for (String key : keys) {
                            dbDoc.put(key, map.get(key));
                        }
                    }
                    return dbDoc;
                }
                Class<?> clz = objectToSave.getClass();
                StringBuffer sb = new StringBuffer();
                this.fetchAllDeclaredField(clz, sb);
                for (String s : flds = sb.toString().split(",")) {
                    Method getMethod;
                    String getMethodName = "get" + s.substring(0, 1).toUpperCase() + s.substring(1);
                    try {
                        getMethod = clz.getDeclaredMethod(getMethodName, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            getMethod = clz.getSuperclass().getDeclaredMethod(getMethodName, new Class[0]);
                        }
                        catch (Exception ex) {
                            getMethod = null;
                        }
                    }
                    if (getMethod == null) continue;
                    try {
                        Object val = getMethod.invoke(objectToSave, new Object[0]);
                        if (val == null) continue;
                        dbDoc.put(s, val);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return dbDoc;
        }
        return org.bson.Document.parse((String)((String)objectToSave));
    }

    public <T> T toJavaObject(Object obj, Class<T> entityClass) {
        return (T)TypeUtils.cast((Object)obj, entityClass, (ParserConfig)ParserConfig.getGlobalInstance());
    }

    public <T> List<T> toJavaObjectList(List<?> objlist, Class<T> entityClass) {
        ArrayList<T> list = new ArrayList<T>();
        for (Object obj : objlist) {
            list.add(this.toJavaObject(obj, entityClass));
        }
        return list;
    }

    private QueryExtractor.DBTYPE getDBType() {
        String type = "";
        DataSource dataSource = this.sqlTemplate.getConfiguration().getEnvironment().getDataSource();
        type = dataSource instanceof DruidDataSource ? ((String)ReflectUtil.getFieldValue(dataSource, "jdbcUrl")).toLowerCase() : ((String)ReflectUtil.getFieldValue(dataSource, "jdbcUrl")).toLowerCase();
        int first = type.indexOf(":");
        if ("mysql".equalsIgnoreCase(type = type.substring(first + 1, type.indexOf(":", first + 1)))) {
            return QueryExtractor.DBTYPE.MYSQL;
        }
        if ("oracle".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.ORACLE;
        }
        if ("sqlserver".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.SQLSERVER;
        }
        if ("postgresql".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.POSTGRESQL;
        }
        if ("db2".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.DB2;
        }
        if ("h2".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.H2;
        }
        if ("derby".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.DERBY;
        }
        if ("sqlite".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.SQLITE;
        }
        if ("sysbase".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.SYSBASE;
        }
        return QueryExtractor.DBTYPE.OTHERSQL;
    }

    private String convertChartsetSQL(String sql) {
        if (org.springframework.util.StringUtils.isEmpty((Object)this.chartset)) {
            return sql;
        }
        try {
            String s = new String(sql.getBytes("GBK"), this.chartset);
            return s;
        }
        catch (Exception ex) {
            return sql;
        }
    }

    @Override
    public <T> T selectOne(Query query, Class<T> entityClass) {
        return this.selectOne(query, entityClass, 0);
    }

    @Override
    public <T> T selectOne(Query query, Class<T> entityClass, String tableName) {
        return this.selectOne(query, entityClass, tableName, 0);
    }

    @Override
    public Map<String, Object> selectOne(Query query, String tableName) {
        return this.selectOne(query, tableName, 0);
    }

    @Override
    public <T> List<T> select(Query query, Class<T> entityClass) {
        return this.select(query, entityClass, 0);
    }

    @Override
    public <T> List<T> select(Query query, Class<T> entityClass, String tableName) {
        return this.select(query, entityClass, tableName, 0);
    }

    @Override
    public List<Map<String, Object>> select(Query query, String tableName) {
        return this.select(query, tableName, 0);
    }

    @Override
    public long count(Query query, Class<?> entityClass) {
        return this.count(query, entityClass, 0);
    }

    @Override
    public long count(Query query, String tableName) {
        return this.count(query, tableName, 0);
    }

    @Override
    public void insert(Object objectToSave) {
        this.insert(objectToSave, 0);
    }

    @Override
    public int insert(Object objectToSave, String tableName) {
        return this.insert(objectToSave, tableName, 0);
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, Class<?> entityClass) {
        this.insert(batchToSave, entityClass, 0);
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, String tableName) {
        this.insert(batchToSave, tableName, 0);
    }

    @Override
    public void insertAll(Collection<? extends Object> objectsToSave) {
        this.insertAll(objectsToSave, 0);
    }

    @Override
    public int updateOrInsert(Query query, Update update, Class<?> entityClass) {
        return this.updateOrInsert(query, update, entityClass, 0);
    }

    @Override
    public int updateOrInsert(Query query, Update update, String tableName) {
        return this.updateOrInsert(query, update, tableName, 0);
    }

    @Override
    public int updateOrInsert(Query query, Update update, Class<?> entityClass, String tableName) {
        return this.updateOrInsert(query, update, entityClass, tableName, 0);
    }

    @Override
    public int update(Query query, Update update, Class<?> entityClass) {
        return this.update(query, update, entityClass, 0);
    }

    @Override
    public int update(Query query, Update update, String tableName) {
        return this.update(query, update, tableName, 0);
    }

    @Override
    public int update(Query query, Update update, Class<?> entityClass, String tableName) {
        return this.update(query, update, entityClass, tableName, 0);
    }

    @Override
    public int delete(Object object) {
        return this.delete(object, 0);
    }

    @Override
    public int delete(Object object, String tableName) {
        return this.delete(object, tableName, 0);
    }

    @Override
    public int delete(Query query, Class<?> entityClass) {
        return this.delete(query, entityClass, 0);
    }

    @Override
    public int delete(Query query, Class<?> entityClass, String tableName) {
        return this.delete(query, entityClass, tableName, 0);
    }

    @Override
    public int delete(Query query, String tableName) {
        return this.delete(query, tableName, 0);
    }
}

