/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.product.util.ReleaseObject;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class DumpMsg {
    public static void dump(String filename, String message) {
        DumpMsg.dump(filename, message, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(String filename, String message, boolean append) {
        FileOutputStream fileWriter = null;
        DataOutputStream dataWriter = null;
        BufferedWriter bufferWriter = null;
        try {
            File file = new File(filename);
            fileWriter = new FileOutputStream(file, append);
            dataWriter = new DataOutputStream(fileWriter);
            bufferWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)dataWriter, "UTF-8"));
            bufferWriter.write(message);
        }
        catch (Exception e) {
            try {
                System.out.println(String.format("on dump file [%1$s] error:%2$s", filename, e.getMessage()));
            }
            catch (Throwable throwable) {
                ReleaseObject.release(bufferWriter);
                ReleaseObject.release(dataWriter);
                ReleaseObject.release(fileWriter);
                throw throwable;
            }
            ReleaseObject.release(bufferWriter);
            ReleaseObject.release(dataWriter);
            ReleaseObject.release(fileWriter);
        }
        ReleaseObject.release(bufferWriter);
        ReleaseObject.release(dataWriter);
        ReleaseObject.release(fileWriter);
    }

    public static void printStack(Log logger, String tagName, String message) {
        DumpMsg.printStack(logger, tagName, message, null);
    }

    public static void printStack(Log logger, String tagName, String message, String successful) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        printWriter.print(String.format("%1$s\r\n", message));
        boolean first = true;
        for (StackTraceElement traceElement : elements) {
            if (!traceElement.getClassName().startsWith("java.lang.Thread") && !traceElement.getClassName().startsWith("com.product.component.BaseAnnotationService")) {
                first = false;
            }
            if (!(first || traceElement.getClassName().startsWith("org.springframework") || traceElement.getClassName().startsWith("sun.reflect") || traceElement.getClassName().startsWith("java.lang") || traceElement.getClassName().startsWith("org.junit") || traceElement.getClassName().startsWith("org.eclipse"))) {
                printWriter.println("\tat " + traceElement);
            }
            if (!StringUtils.isEmpty((Object)successful) && traceElement.getClassName().startsWith(successful)) break;
        }
        String outMessage = String.format("%1$s error:--->%2$s", tagName, stringWriter.toString());
        logger.debug((Object)outMessage);
        printWriter.close();
        try {
            stringWriter.close();
        }
        catch (Exception e) {
            logger.debug((Object)String.format("%1$s error CloseException:--->%2$s", tagName, e.getMessage()));
        }
    }

    public static void printStack(Logger logger, String tagName, String message) {
        DumpMsg.printStack(logger, tagName, message, null);
    }

    public static void printStack(Logger logger, String tagName, String message, String successful) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        printWriter.print(String.format("%1$s\r\n", message));
        boolean first = true;
        for (StackTraceElement traceElement : elements) {
            if (!traceElement.getClassName().startsWith("java.lang.Thread") && !traceElement.getClassName().startsWith("com.product.component.BaseAnnotationService")) {
                first = false;
            }
            if (!(first || traceElement.getClassName().startsWith("org.springframework") || traceElement.getClassName().startsWith("sun.reflect") || traceElement.getClassName().startsWith("java.lang") || traceElement.getClassName().startsWith("org.junit") || traceElement.getClassName().startsWith("org.eclipse"))) {
                printWriter.println("\tat " + traceElement);
            }
            if (!StringUtils.isEmpty((Object)successful) && traceElement.getClassName().startsWith(successful)) break;
        }
        String outMessage = String.format("%1$s error:--->%2$s", tagName, stringWriter.toString());
        logger.debug(outMessage);
        printWriter.close();
        try {
            stringWriter.close();
        }
        catch (Exception e) {
            logger.debug(String.format("%1$s error CloseException:--->%2$s", tagName, e.getMessage()));
        }
    }

    public static void printStack(Logger logger, String tagName, Exception ex, String message) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ex.printStackTrace(printWriter);
        message = StringUtils.isEmpty((Object)message) ? ex.getMessage() : String.format("%1$s -> %2$s", message, ex.getMessage());
        logger.debug(String.format("%1$s error msg:--->%2$s", tagName, message));
        logger.debug(String.format("%1$s error detail:--->%2$s", tagName, stringWriter.toString()));
        printWriter.close();
        try {
            stringWriter.close();
        }
        catch (Exception e) {
            logger.debug(String.format("%1$s error CloseException:--->%2$s", tagName, e.getMessage()));
        }
    }
}

