/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.sysmonitor;

import com.efuture.sysmonitor.SigarUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Swap;
import org.hyperic.sigar.Who;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigarMonitor {
    private static final Logger Log = LoggerFactory.getLogger(SigarMonitor.class);

    public static void main(String[] args) {
        try {
            SigarMonitor.cpu();
            Log.info("----------------------------------");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private static void property() throws UnknownHostException {
        Runtime r = Runtime.getRuntime();
        Properties props = System.getProperties();
        InetAddress addr = InetAddress.getLocalHost();
        String ip = addr.getHostAddress();
        Map<String, String> map = System.getenv();
        String userName = map.get("USERNAME");
        String computerName = map.get("COMPUTERNAME");
        String userDomain = map.get("USERDOMAIN");
        Log.info("\u7528\u6237\u540d:    " + userName);
        Log.info("\u8ba1\u7b97\u673a\u540d:    " + computerName);
        Log.info("\u8ba1\u7b97\u673a\u57df\u540d:    " + userDomain);
        Log.info("\u672c\u5730ip\u5730\u5740:    " + ip);
        Log.info("\u672c\u5730\u4e3b\u673a\u540d:    " + addr.getHostName());
        Log.info("JVM\u53ef\u4ee5\u4f7f\u7528\u7684\u603b\u5185\u5b58:    " + r.totalMemory());
        Log.info("JVM\u53ef\u4ee5\u4f7f\u7528\u7684\u5269\u4f59\u5185\u5b58:    " + r.freeMemory());
        Log.info("JVM\u53ef\u4ee5\u4f7f\u7528\u7684\u5904\u7406\u5668\u4e2a\u6570:    " + r.availableProcessors());
        Log.info("Java\u7684\u8fd0\u884c\u73af\u5883\u7248\u672c\uff1a    " + props.getProperty("java.version"));
        Log.info("Java\u7684\u8fd0\u884c\u73af\u5883\u4f9b\u5e94\u5546\uff1a    " + props.getProperty("java.vendor"));
        Log.info("Java\u4f9b\u5e94\u5546\u7684URL\uff1a    " + props.getProperty("java.vendor.url"));
        Log.info("Java\u7684\u5b89\u88c5\u8def\u5f84\uff1a    " + props.getProperty("java.home"));
        Log.info("Java\u7684\u865a\u62df\u673a\u89c4\u8303\u7248\u672c\uff1a    " + props.getProperty("java.vm.specification.version"));
        Log.info("Java\u7684\u865a\u62df\u673a\u89c4\u8303\u4f9b\u5e94\u5546\uff1a    " + props.getProperty("java.vm.specification.vendor"));
        Log.info("Java\u7684\u865a\u62df\u673a\u89c4\u8303\u540d\u79f0\uff1a    " + props.getProperty("java.vm.specification.name"));
        Log.info("Java\u7684\u865a\u62df\u673a\u5b9e\u73b0\u7248\u672c\uff1a    " + props.getProperty("java.vm.version"));
        Log.info("Java\u7684\u865a\u62df\u673a\u5b9e\u73b0\u4f9b\u5e94\u5546\uff1a    " + props.getProperty("java.vm.vendor"));
        Log.info("Java\u7684\u865a\u62df\u673a\u5b9e\u73b0\u540d\u79f0\uff1a    " + props.getProperty("java.vm.name"));
        Log.info("Java\u8fd0\u884c\u65f6\u73af\u5883\u89c4\u8303\u7248\u672c\uff1a    " + props.getProperty("java.specification.version"));
        Log.info("Java\u8fd0\u884c\u65f6\u73af\u5883\u89c4\u8303\u4f9b\u5e94\u5546\uff1a    " + props.getProperty("java.specification.vender"));
        Log.info("Java\u8fd0\u884c\u65f6\u73af\u5883\u89c4\u8303\u540d\u79f0\uff1a    " + props.getProperty("java.specification.name"));
        Log.info("Java\u7684\u7c7b\u683c\u5f0f\u7248\u672c\u53f7\uff1a    " + props.getProperty("java.class.version"));
        Log.info("Java\u7684\u7c7b\u8def\u5f84\uff1a    " + props.getProperty("java.class.path"));
        Log.info("\u52a0\u8f7d\u5e93\u65f6\u641c\u7d22\u7684\u8def\u5f84\u5217\u8868\uff1a    " + props.getProperty("java.library.path"));
        Log.info("\u9ed8\u8ba4\u7684\u4e34\u65f6\u6587\u4ef6\u8def\u5f84\uff1a    " + props.getProperty("java.io.tmpdir"));
        Log.info("\u4e00\u4e2a\u6216\u591a\u4e2a\u6269\u5c55\u76ee\u5f55\u7684\u8def\u5f84\uff1a    " + props.getProperty("java.ext.dirs"));
        Log.info("\u64cd\u4f5c\u7cfb\u7edf\u7684\u540d\u79f0\uff1a    " + props.getProperty("os.name"));
        Log.info("\u64cd\u4f5c\u7cfb\u7edf\u7684\u6784\u67b6\uff1a    " + props.getProperty("os.arch"));
        Log.info("\u64cd\u4f5c\u7cfb\u7edf\u7684\u7248\u672c\uff1a    " + props.getProperty("os.version"));
        Log.info("\u6587\u4ef6\u5206\u9694\u7b26\uff1a    " + props.getProperty("file.separator"));
        Log.info("\u8def\u5f84\u5206\u9694\u7b26\uff1a    " + props.getProperty("path.separator"));
        Log.info("\u884c\u5206\u9694\u7b26\uff1a    " + props.getProperty("line.separator"));
        Log.info("\u7528\u6237\u7684\u8d26\u6237\u540d\u79f0\uff1a    " + props.getProperty("user.name"));
        Log.info("\u7528\u6237\u7684\u4e3b\u76ee\u5f55\uff1a    " + props.getProperty("user.home"));
        Log.info("\u7528\u6237\u7684\u5f53\u524d\u5de5\u4f5c\u76ee\u5f55\uff1a    " + props.getProperty("user.dir"));
    }

    public static void memory() throws SigarException {
        try {
            Sigar sigar = SigarUtils.initSigar();
            Mem mem = sigar.getMem();
            Log.info("physical memory total:    " + mem.getTotal() / 1024L / 1024L + "MB");
            Log.info("physical memory used:    " + mem.getUsed() / 1024L / 1024L + "MB");
            Log.info("physical memery free:    " + mem.getFree() / 1024L / 1024L + "MB");
            Swap swap = sigar.getSwap();
            Log.info("swap memory total:    " + swap.getTotal() / 1024L / 1024L + "MB");
            Log.info("swap memory used:    " + swap.getUsed() / 1024L / 1024L + "MB");
            Log.info("swap memory free:    " + swap.getFree() / 1024L / 1024L + "MB");
        }
        catch (SigarException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            Log.error(e.getMessage(), e);
        }
    }

    public static void cpu() {
        try {
            Sigar sigar = SigarUtils.initSigar();
            CpuInfo[] infos = sigar.getCpuInfoList();
            Log.info("cpu total info  " + sigar.getCpu());
            Log.info("cpu total percentage " + sigar.getCpuPerc());
            CpuPerc[] cpuList = null;
            cpuList = sigar.getCpuPercList();
            for (int i = 0; i < infos.length; ++i) {
                CpuInfo info = infos[i];
                Log.info("it is " + (i + 1) + "\u5757CPU info-->");
                Log.info("CPU\u7684total MHz:    " + info.getMhz());
                SigarMonitor.printCpuPerc(cpuList[i]);
            }
        }
        catch (SigarException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            Log.error(e.getMessage(), e);
        }
    }

    private static void printCpuPerc(CpuPerc cpu) {
        Log.info("cpu user percentage:    " + CpuPerc.format((double)cpu.getUser()));
        Log.info("cpu system percentage:    " + CpuPerc.format((double)cpu.getSys()));
        Log.info("cpu wait percentage:    " + CpuPerc.format((double)cpu.getWait()));
        Log.info("cpu error percentage:    " + CpuPerc.format((double)cpu.getNice()));
        Log.info("cpu idle percentage:    " + CpuPerc.format((double)cpu.getIdle()));
        Log.info("cpu used percentage:    " + CpuPerc.format((double)cpu.getCombined()));
    }

    private static void os() {
        OperatingSystem OS = OperatingSystem.getInstance();
        Log.info("\u64cd\u4f5c\u7cfb\u7edf:    " + OS.getArch());
        Log.info("\u64cd\u4f5c\u7cfb\u7edfCpuEndian():    " + OS.getCpuEndian());
        Log.info("\u64cd\u4f5c\u7cfb\u7edfDataModel():    " + OS.getDataModel());
        Log.info("\u64cd\u4f5c\u7cfb\u7edf\u7684\u63cf\u8ff0:    " + OS.getDescription());
        Log.info("\u64cd\u4f5c\u7cfb\u7edf\u7684\u5356\u4e3b:    " + OS.getVendor());
        Log.info("\u64cd\u4f5c\u7cfb\u7edf\u7684\u5356\u4e3b\u540d:    " + OS.getVendorCodeName());
        Log.info("\u64cd\u4f5c\u7cfb\u7edf\u540d\u79f0:    " + OS.getVendorName());
        Log.info("\u64cd\u4f5c\u7cfb\u7edf\u5356\u4e3b\u7c7b\u578b:    " + OS.getVendorVersion());
        Log.info("\u64cd\u4f5c\u7cfb\u7edf\u7684\u7248\u672c\u53f7:    " + OS.getVersion());
    }

    private static void who() throws SigarException {
        Sigar sigar = new Sigar();
        Who[] who = sigar.getWhoList();
        if (who != null && who.length > 0) {
            for (int i = 0; i < who.length; ++i) {
                Who _who = who[i];
                Log.info("\u7528\u6237\u63a7\u5236\u53f0:    " + _who.getDevice());
                Log.info("\u7528\u6237host:    " + _who.getHost());
                Log.info("\u5f53\u524d\u7cfb\u7edf\u8fdb\u7a0b\u8868\u4e2d\u7684\u7528\u6237\u540d:    " + _who.getUser());
            }
        }
    }

    private static void file() throws Exception {
        Sigar sigar = new Sigar();
        FileSystem[] fslist = sigar.getFileSystemList();
        for (int i = 0; i < fslist.length; ++i) {
            Log.info("\u5206\u533a\u7684\u76d8\u7b26\u540d\u79f0" + i);
            FileSystem fs = fslist[i];
            Log.info("\u76d8\u7b26\u540d\u79f0:    " + fs.getDevName());
            Log.info("\u76d8\u7b26\u8def\u5f84:    " + fs.getDirName());
            Log.info("\u76d8\u7b26\u6807\u5fd7:    " + fs.getFlags());
            Log.info("\u76d8\u7b26\u7c7b\u578b:    " + fs.getSysTypeName());
            Log.info("\u76d8\u7b26\u7c7b\u578b\u540d:    " + fs.getTypeName());
            Log.info("\u76d8\u7b26\u6587\u4ef6\u7cfb\u7edf\u7c7b\u578b:    " + fs.getType());
            FileSystemUsage usage = null;
            usage = sigar.getFileSystemUsage(fs.getDirName());
            switch (fs.getType()) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    Log.info(fs.getDevName() + "\u603b\u5927\u5c0f:    " + usage.getTotal() + "KB");
                    Log.info(fs.getDevName() + "\u5269\u4f59\u5927\u5c0f:    " + usage.getFree() + "KB");
                    Log.info(fs.getDevName() + "\u53ef\u7528\u5927\u5c0f:    " + usage.getAvail() + "KB");
                    Log.info(fs.getDevName() + "\u5df2\u7ecf\u4f7f\u7528\u91cf:    " + usage.getUsed() + "KB");
                    double usePercent = usage.getUsePercent() * 100.0;
                    Log.info(fs.getDevName() + "\u8d44\u6e90\u7684\u5229\u7528\u7387:    " + usePercent + "%");
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
            Log.info(fs.getDevName() + "\u8bfb\u51fa\uff1a    " + usage.getDiskReads());
            Log.info(fs.getDevName() + "\u5199\u5165\uff1a    " + usage.getDiskWrites());
        }
    }

    private static void net() throws Exception {
        Sigar sigar = new Sigar();
        String[] ifNames = sigar.getNetInterfaceList();
        for (int i = 0; i < ifNames.length; ++i) {
            String name = ifNames[i];
            NetInterfaceConfig ifconfig = sigar.getNetInterfaceConfig(name);
            Log.info("\u7f51\u7edc\u8bbe\u5907\u540d:    " + name);
            Log.info("IP\u5730\u5740:    " + ifconfig.getAddress());
            Log.info("\u5b50\u7f51\u63a9\u7801:    " + ifconfig.getNetmask());
            if ((ifconfig.getFlags() & 1L) <= 0L) {
                Log.info("!IFF_UP...skipping getNetInterfaceStat");
                continue;
            }
            NetInterfaceStat ifstat = sigar.getNetInterfaceStat(name);
            Log.info(name + "\u63a5\u6536\u7684\u603b\u5305\u88f9\u6570:" + ifstat.getRxPackets());
            Log.info(name + "\u53d1\u9001\u7684\u603b\u5305\u88f9\u6570:" + ifstat.getTxPackets());
            Log.info(name + "\u63a5\u6536\u5230\u7684\u603b\u5b57\u8282\u6570:" + ifstat.getRxBytes());
            Log.info(name + "\u53d1\u9001\u7684\u603b\u5b57\u8282\u6570:" + ifstat.getTxBytes());
            Log.info(name + "\u63a5\u6536\u5230\u7684\u9519\u8bef\u5305\u6570:" + ifstat.getRxErrors());
            Log.info(name + "\u53d1\u9001\u6570\u636e\u5305\u65f6\u7684\u9519\u8bef\u6570:" + ifstat.getTxErrors());
            Log.info(name + "\u63a5\u6536\u65f6\u4e22\u5f03\u7684\u5305\u6570:" + ifstat.getRxDropped());
            Log.info(name + "\u53d1\u9001\u65f6\u4e22\u5f03\u7684\u5305\u6570:" + ifstat.getTxDropped());
        }
    }

    private static void ethernet() throws SigarException {
        Sigar sigar = null;
        sigar = new Sigar();
        String[] ifaces = sigar.getNetInterfaceList();
        for (int i = 0; i < ifaces.length; ++i) {
            NetInterfaceConfig cfg = sigar.getNetInterfaceConfig(ifaces[i]);
            if ("127.0.0.1".equals(cfg.getAddress()) || (cfg.getFlags() & 8L) != 0L || "00:00:00:00:00:00".equals(cfg.getHwaddr())) continue;
            Log.info(cfg.getName() + "IP\u5730\u5740:" + cfg.getAddress());
            Log.info(cfg.getName() + "\u7f51\u5173\u5e7f\u64ad\u5730\u5740:" + cfg.getBroadcast());
            Log.info(cfg.getName() + "\u7f51\u5361MAC\u5730\u5740:" + cfg.getHwaddr());
            Log.info(cfg.getName() + "\u5b50\u7f51\u63a9\u7801:" + cfg.getNetmask());
            Log.info(cfg.getName() + "\u7f51\u5361\u63cf\u8ff0\u4fe1\u606f:" + cfg.getDescription());
            Log.info(cfg.getName() + "\u7f51\u5361\u7c7b\u578b" + cfg.getType());
        }
    }
}

