/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.sysmonitor;

import com.efuture.sysmonitor.SigarMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysMonitorUtils {
    private static final Logger Log = LoggerFactory.getLogger(SysMonitorUtils.class);

    public static void main(String[] args) {
        SysMonitorUtils.logRedisInfo("", "");
        SysMonitorUtils.logSystemInfo();
    }

    public static void logSystemInfo() {
        long startTime = System.currentTimeMillis();
        try {
            long vmFree = 0L;
            long vmUse = 0L;
            long vmTotal = 0L;
            long vmMax = 0L;
            int byteToMb = 0x100000;
            Runtime rt = Runtime.getRuntime();
            vmTotal = rt.totalMemory() / (long)byteToMb;
            vmFree = rt.freeMemory() / (long)byteToMb;
            vmMax = rt.maxMemory() / (long)byteToMb;
            vmUse = vmTotal - vmFree;
            Log.info(">>>>>>>>>> SystemInfo =======================");
            String OS = System.getProperty("os.name").toLowerCase();
            Log.info("OS version\uff1a" + OS);
            int totalThread = 0;
            ThreadGroup parentThread = Thread.currentThread().getThreadGroup();
            while (parentThread.getParent() != null) {
                totalThread = parentThread.activeCount();
                parentThread = parentThread.getParent();
            }
            Log.info("Total threads:" + totalThread);
            Log.info("JVM used memory\uff1a" + vmUse + " MB");
            Log.info("JVM remain memory\uff1a" + vmFree + " MB");
            Log.info("JVM total memory\uff1a" + vmTotal + " MB");
            Log.info("JVM can use max memory\uff1a" + vmMax + " MB");
            if (OS.indexOf("win") >= 0) {
                SigarMonitor.memory();
                Log.info(" ");
                SigarMonitor.cpu();
            } else {
                long freeRam = SysMonitorUtils.getOSMemory("getFreePhysicalMemorySize", "\u672a\u83b7\u53d6\u5230\u5185\u5b58\u7edf\u8ba1\u60c5\u51b5");
                Log.info("OS remain memory\uff1a" + freeRam + " MB");
                OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
                double cpu = osMxBean.getSystemLoadAverage();
                Log.info("OS cpu load\uff1a" + freeRam + " MB");
            }
            long endTime = System.currentTimeMillis();
            Log.info("Spent time is:\u3010{}\u3011", (Object)(endTime - startTime));
            Log.info("<<<<<<<<<<===================================");
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            Log.error(e.getMessage(), e);
        }
    }

    public static void logRedisInfo(String redisInfo, String slowlog) {
        long startTime = System.currentTimeMillis();
        Log.info(">>>>>>>>>> RedisInfo =======================");
        Log.info(redisInfo);
        Log.info(slowlog);
        long endTime = System.currentTimeMillis();
        Log.info("Spent time is:\u3010{}\u3011", (Object)(endTime - startTime));
        Log.info("<<<<<<<<<<===================================");
        Log.info("                                             ");
    }

    private static long getOSMemory(String methodName, String warning) {
        long ram = 0L;
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Method m = operatingSystemMXBean.getClass().getDeclaredMethod(methodName, new Class[0]);
            m.setAccessible(true);
            Object value = m.invoke((Object)operatingSystemMXBean, new Object[0]);
            if (value != null) {
                ram = Long.valueOf(value.toString()) / 1024L / 1024L;
            } else {
                Log.error(warning);
                ram = 1024L;
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        return ram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exeCmd(String cmd1, String cmd2, String cmd3) throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(cmd1);
        cmds.add(cmd2);
        cmds.add(cmd3);
        ProcessBuilder processBuilder = new ProcessBuilder(cmds);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        StringBuilder result = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
                Log.info(processBuilder.command().toString() + " --->: " + line);
            }
        }
        catch (IOException e) {
            Log.error("failed to read output from process", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        process.waitFor();
        int exit = process.exitValue();
        if (exit != 0) {
            throw new IOException("failed to execute:" + processBuilder.command() + " with result:" + result);
        }
        return "1";
    }
}

