/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component;

import com.easy.DataFrame;
import java.util.LinkedHashSet;

public class Comparison {
    public static final <V> DataFrame<String> compare(DataFrame<V> df1, DataFrame<V> df2) {
        LinkedHashSet<Object> rows = new LinkedHashSet<Object>();
        rows.addAll(df1.index());
        rows.addAll(df2.index());
        LinkedHashSet<Object> cols = new LinkedHashSet<Object>();
        cols.addAll(df1.columns());
        cols.addAll(df2.columns());
        DataFrame<V> left = df1.reshape(rows, cols);
        DataFrame<V> right = df2.reshape(rows, cols);
        DataFrame<String> comp = new DataFrame<String>(rows, cols);
        for (int c = 0; c < left.size(); ++c) {
            for (int r = 0; r < left.length(); ++r) {
                V lval = left.get(r, c);
                V rval = right.get(r, c);
                if (lval == null && rval == null) {
                    comp.set(r, c, "");
                    continue;
                }
                if (lval != null && lval.equals(rval)) {
                    comp.set(r, c, String.valueOf(lval));
                    continue;
                }
                if (lval == null) {
                    comp.set(r, c, String.valueOf(rval));
                    continue;
                }
                if (rval == null) {
                    comp.set(r, c, String.valueOf(lval));
                    continue;
                }
                comp.set(r, c, String.format("%s | %s", lval, rval));
            }
        }
        return comp;
    }
}

