/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component;

import com.easy.DataFrame;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Views {

    public static class FillNaFunction<V>
    implements DataFrame.Function<V, V> {
        private final V fill;

        public FillNaFunction(V fill) {
            this.fill = fill;
        }

        @Override
        public V apply(V value) {
            return value == null ? this.fill : value;
        }
    }

    public static class FlatView<V>
    extends AbstractList<V> {
        private final DataFrame<V> df;

        public FlatView(DataFrame<V> df) {
            this.df = df;
        }

        @Override
        public V get(int index) {
            return this.df.get(index % this.df.length(), index / this.df.length());
        }

        @Override
        public int size() {
            return this.df.size() * this.df.length();
        }
    }

    public static class TransformedSeriesView<V, U>
    extends AbstractList<U> {
        protected final DataFrame<V> df;
        protected final int index;
        protected final boolean transpose;
        protected final DataFrame.Function<V, U> transform;

        public TransformedSeriesView(DataFrame<V> df, DataFrame.Function<V, U> transform, int index, boolean transpose) {
            this.df = df;
            this.transform = transform;
            this.index = index;
            this.transpose = transpose;
        }

        @Override
        public U get(int index) {
            V value = this.transpose ? this.df.get(index, this.index) : this.df.get(this.index, index);
            return this.transform.apply(value);
        }

        @Override
        public int size() {
            return this.transpose ? this.df.length() : this.df.size();
        }
    }

    public static class TransformedView<V, U>
    extends AbstractList<List<U>> {
        protected final DataFrame<V> df;
        protected final DataFrame.Function<V, U> transform;
        protected final boolean transpose;

        public TransformedView(DataFrame<V> df, DataFrame.Function<V, U> transform, boolean transpose) {
            this.df = df;
            this.transform = transform;
            this.transpose = transpose;
        }

        @Override
        public List<U> get(int index) {
            return new TransformedSeriesView<V, U>(this.df, this.transform, index, !this.transpose);
        }

        @Override
        public int size() {
            return this.transpose ? this.df.length() : this.df.size();
        }
    }

    public static class SeriesMapView<V>
    extends AbstractMap<Object, V> {
        private final DataFrame<V> df;
        private final int index;
        private final boolean transpose;

        public SeriesMapView(DataFrame<V> df, int index, boolean transpose) {
            this.df = df;
            this.index = index;
            this.transpose = transpose;
        }

        @Override
        public Set<Map.Entry<Object, V>> entrySet() {
            return new AbstractSet<Map.Entry<Object, V>>(){

                @Override
                public Iterator<Map.Entry<Object, V>> iterator() {
                    Set<Object> names = transpose ? df.index() : df.columns();
                    final Iterator<Object> it = names.iterator();
                    return new Iterator<Map.Entry<Object, V>>(){
                        int value = 0;

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public Map.Entry<Object, V> next() {
                            final Object key = it.next();
                            final int value = this.value++;
                            return new Map.Entry<Object, V>(){

                                @Override
                                public Object getKey() {
                                    return key;
                                }

                                @Override
                                public V getValue() {
                                    return transpose ? df.get(value, index) : df.get(index, value);
                                }

                                @Override
                                public V setValue(V value2) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return transpose ? df.length() : df.size();
                }
            };
        }
    }

    public static class MapView<V>
    extends AbstractList<Map<Object, V>> {
        private final DataFrame<V> df;
        private final boolean transpose;

        public MapView(DataFrame<V> df, boolean transpose) {
            this.df = df;
            this.transpose = transpose;
        }

        @Override
        public Map<Object, V> get(int index) {
            return new SeriesMapView<V>(this.df, index, !this.transpose);
        }

        @Override
        public int size() {
            return this.transpose ? this.df.length() : this.df.size();
        }
    }

    public static class SeriesListView<V>
    extends AbstractList<V> {
        private final DataFrame<V> df;
        private final int index;
        private final boolean transpose;

        public SeriesListView(DataFrame<V> df, int index, boolean transpose) {
            this.df = df;
            this.index = index;
            this.transpose = transpose;
        }

        @Override
        public V get(int index) {
            return this.transpose ? this.df.get(index, this.index) : this.df.get(this.index, index);
        }

        @Override
        public int size() {
            return this.transpose ? this.df.length() : this.df.size();
        }
    }

    public static class ListView<V>
    extends AbstractList<List<V>> {
        private final DataFrame<V> df;
        private final boolean transpose;

        public ListView(DataFrame<V> df, boolean transpose) {
            this.df = df;
            this.transpose = transpose;
        }

        @Override
        public List<V> get(int index) {
            return new SeriesListView<V>(this.df, index, !this.transpose);
        }

        @Override
        public int size() {
            return this.transpose ? this.df.length() : this.df.size();
        }
    }
}

