/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Traceer {
    protected static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static Traceer service;
    private Map<String, Long> traceMap = new ConcurrentHashMap<String, Long>();

    private static synchronized void init() {
        if (service == null) {
            service = new Traceer();
        }
    }

    public static Traceer getInstance() {
        if (service == null) {
            Traceer.init();
        }
        return service;
    }

    public void addTrace(String name) {
        this.traceMap.put(name, System.currentTimeMillis());
    }

    public String endTrace(String name) {
        Long endTime = System.currentTimeMillis();
        if (!this.traceMap.containsKey(name)) {
            return String.format("\u672a\u627e\u5230\u8ddf\u8e2a\u5173\u952e\u5b57:%1$s", name);
        }
        Long startTime = this.traceMap.get(name);
        return String.format("start:%1$s end:%2$s elapsed:%3$d", dateFormat.format(new Date(startTime)), dateFormat.format(new Date(endTime)), endTime - startTime);
    }
}

