/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component.utils.field.convert;

import com.easy.component.utils.field.convert.BooleanConvert;
import com.easy.component.utils.field.convert.DateConvert;
import com.easy.component.utils.field.convert.IntegerConvert;
import com.easy.component.utils.field.convert.ObjectConvert;
import java.lang.reflect.Field;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FieldTypeConvert {
    protected static final Logger logger = LoggerFactory.getLogger(FieldTypeConvert.class);
    private Field field;

    protected abstract void onSetValue(Field var1, Object var2, Object var3) throws Exception;

    public static FieldTypeConvert Create(Field field) {
        FieldTypeConvert response = null;
        Class<?> fieldType = field.getType();
        response = fieldType.equals(java.sql.Date.class) || fieldType.equals(Date.class) ? new DateConvert(field) : (fieldType.equals(Integer.class) ? new IntegerConvert(field) : (fieldType.equals(Boolean.class) ? new BooleanConvert(field) : new ObjectConvert(field)));
        logger.debug(String.format("FieldSet:%1$s to %2$s", field.getName(), fieldType.getTypeName()));
        return response;
    }

    public FieldTypeConvert(Field field) {
        this.field = field;
    }

    public void onSetValue(Object source, Object value) throws Exception {
        if (value != null) {
            this.onSetValue(this.field, source, value);
        }
    }
}

